/*
 * Decompiled with CFR 0.152.
 */
package morphee.geodesic;

import dv.DV;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.List;
import mathematics.Maths;
import morphee.MorphoFilterMarker;
import morphee.StructuringElement;
import morphee.StructuringElement3D;

public class UnderBuild
implements MorphoFilterMarker {
    private BufferedImage marker = null;
    private int[] pMem = null;
    private int k;
    private final ImageFeatures IF = new ImageFeatures();

    public BufferedImage Filter(BufferedImage reference, int nbCPU, BufferedImage marker) {
        BufferedImage result = new BufferedImage(reference.getWidth(), reference.getHeight(), reference.getType());
        this.Filter(reference, marker, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage reference, BufferedImage marker, BufferedImage result, int nbCPU) {
        this.Marker(marker);
        this.Filter(reference, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage reference, BufferedImage result, int nbCPU) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)reference, (BufferedImage)this.marker)) {
            throw new IllegalArgumentException("Dimensions or type of reference and marker are different.");
        }
        int Neighborhood = 8;
        int height = reference.getHeight();
        int width = reference.getWidth();
        int size = width * height;
        ImageNew.Copy((BufferedImage)this.marker, (BufferedImage)result);
        int maxi = (int)this.IF.Maximum(result);
        if (this.pMem == null || this.pMem.length != maxi + (size << 1)) {
            this.pMem = new int[maxi + (size << 1)];
        }
        int pBackward = maxi;
        int pForward = pBackward + size;
        for (int i2 = -maxi; i2 < 0; ++i2) {
            this.pMem[pBackward + i2] = i2;
        }
        switch (reference.getType()) {
            case 12: {
                int valueMask;
                WritableRaster wr = reference.getRaster();
                WritableRaster wrres = result.getRaster();
                int Ind = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (wrres.getSample(x, y, 0) > 0) {
                            this.pMem[pBackward + Ind] = valueMask = -wrres.getSample(x, y, 0);
                            this.pMem[pForward + Ind] = this.pMem[pBackward + valueMask];
                            this.pMem[pBackward + valueMask] = Ind;
                            if (this.pMem[pForward + Ind] >= 0) {
                                this.pMem[pBackward + this.pMem[pForward + Ind]] = Ind;
                            }
                        }
                        ++x;
                        ++Ind;
                    }
                }
                for (int level = -maxi; level < 0; ++level) {
                    int currentPixel = this.pMem[pBackward + level];
                    while (currentPixel >= 0) {
                        int Ind2;
                        this.pMem[pBackward + level] = this.pMem[pForward + currentPixel];
                        this.pMem[pBackward + currentPixel] = level;
                        int X = Maths.Modulo((int)currentPixel, (int)width);
                        int Y = (Maths.Modulo((int)currentPixel, (int)size) - X) / width;
                        this.k = 0;
                        while (this.k < 8 && (Ind2 = this.GetNeighborPixel(X, Y, 8, width, height)) != -1) {
                            int valueRec;
                            int IndX = Ind2 % width;
                            int IndY = Ind2 / width;
                            valueMask = wrres.getSample(IndX, IndY, 0);
                            int n = valueRec = wrres.getSample(currentPixel % width, currentPixel / width, 0) < wr.getSample(IndX, IndY, 0) ? wrres.getSample(currentPixel % width, currentPixel / width, 0) : wr.getSample(IndX, IndY, 0);
                            if (valueMask < valueRec) {
                                if (valueMask != 0) {
                                    if (this.pMem[pBackward + Ind2] >= 0) {
                                        this.pMem[pForward + this.pMem[pBackward + Ind2]] = this.pMem[pForward + Ind2];
                                    } else {
                                        this.pMem[pBackward + this.pMem[pBackward + Ind2]] = this.pMem[pForward + Ind2];
                                    }
                                    if (this.pMem[pForward + Ind2] >= 0) {
                                        this.pMem[pBackward + this.pMem[pForward + Ind2]] = this.pMem[pBackward + Ind2];
                                    }
                                }
                                wrres.setSample(IndX, IndY, 0, valueRec);
                                this.pMem[pBackward + Ind2] = -valueRec;
                                this.pMem[pForward + Ind2] = this.pMem[pBackward - valueRec];
                                this.pMem[pBackward - valueRec] = Ind2;
                                if (this.pMem[pForward + Ind2] >= 0) {
                                    this.pMem[pBackward + this.pMem[pForward + Ind2]] = Ind2;
                                }
                            }
                            ++this.k;
                        }
                        currentPixel = this.pMem[pBackward + level];
                    }
                }
                wrres = null;
                wr = null;
                break;
            }
            case 10: {
                int valueMask;
                byte[] bytebufferin = ((DataBufferByte)reference.getRaster().getDataBuffer()).getData();
                byte[] bytebufferout = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                for (int Ind = bytebufferin.length - 1; Ind >= 0; --Ind) {
                    if ((bytebufferout[Ind] & 0xFF) <= 0) continue;
                    this.pMem[pBackward + Ind] = valueMask = -(bytebufferout[Ind] & 0xFF);
                    this.pMem[pForward + Ind] = this.pMem[pBackward + valueMask];
                    this.pMem[pBackward + valueMask] = Ind;
                    if (this.pMem[pForward + Ind] < 0) continue;
                    this.pMem[pBackward + this.pMem[pForward + Ind]] = Ind;
                }
                for (int level = -maxi; level < 0; ++level) {
                    int currentPixel = this.pMem[pBackward + level];
                    while (currentPixel >= 0) {
                        int Ind;
                        this.pMem[pBackward + level] = this.pMem[pForward + currentPixel];
                        this.pMem[pBackward + currentPixel] = level;
                        int X = Maths.Modulo((int)currentPixel, (int)width);
                        int Y = (Maths.Modulo((int)currentPixel, (int)size) - X) / width;
                        this.k = 0;
                        while (this.k < 8 && (Ind = this.GetNeighborPixel(X, Y, 8, width, height)) != -1) {
                            int valueRec;
                            valueMask = bytebufferout[Ind] & 0xFF;
                            int n = valueRec = (bytebufferout[currentPixel] & 0xFF) < (bytebufferin[Ind] & 0xFF) ? bytebufferout[currentPixel] & 0xFF : bytebufferin[Ind] & 0xFF;
                            if (valueMask < valueRec) {
                                if (valueMask != 0) {
                                    if (this.pMem[pBackward + Ind] >= 0) {
                                        this.pMem[pForward + this.pMem[pBackward + Ind]] = this.pMem[pForward + Ind];
                                    } else {
                                        this.pMem[pBackward + this.pMem[pBackward + Ind]] = this.pMem[pForward + Ind];
                                    }
                                    if (this.pMem[pForward + Ind] >= 0) {
                                        this.pMem[pBackward + this.pMem[pForward + Ind]] = this.pMem[pBackward + Ind];
                                    }
                                }
                                bytebufferout[Ind] = (byte)valueRec;
                                this.pMem[pBackward + Ind] = -valueRec;
                                this.pMem[pForward + Ind] = this.pMem[pBackward - valueRec];
                                this.pMem[pBackward - valueRec] = Ind;
                                if (this.pMem[pForward + Ind] >= 0) {
                                    this.pMem[pBackward + this.pMem[pForward + Ind]] = Ind;
                                }
                            }
                            ++this.k;
                        }
                        currentPixel = this.pMem[pBackward + level];
                    }
                }
                break;
            }
            case 11: {
                int valueMask;
                short[] shortbufferin = ((DataBufferUShort)reference.getRaster().getDataBuffer()).getData();
                short[] shortbufferout = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                for (int Ind = shortbufferin.length - 1; Ind >= 0; --Ind) {
                    if ((shortbufferout[Ind] & 0xFFFF) <= 0) continue;
                    this.pMem[pBackward + Ind] = valueMask = -(shortbufferout[Ind] & 0xFFFF);
                    this.pMem[pForward + Ind] = this.pMem[pBackward + valueMask];
                    this.pMem[pBackward + valueMask] = Ind;
                    if (this.pMem[pForward + Ind] < 0) continue;
                    this.pMem[pBackward + this.pMem[pForward + Ind]] = Ind;
                }
                for (int level = -maxi; level < 0; ++level) {
                    int currentPixel = this.pMem[pBackward + level];
                    while (currentPixel >= 0) {
                        int Ind;
                        this.pMem[pBackward + level] = this.pMem[pForward + currentPixel];
                        this.pMem[pBackward + currentPixel] = level;
                        int X = Maths.Modulo((int)currentPixel, (int)width);
                        int Y = (Maths.Modulo((int)currentPixel, (int)size) - X) / width;
                        this.k = 0;
                        while (this.k < 8 && (Ind = this.GetNeighborPixel(X, Y, 8, width, height)) != -1) {
                            int valueRec;
                            valueMask = shortbufferout[Ind] & 0xFFFF;
                            int n = valueRec = (shortbufferout[currentPixel] & 0xFFFF) < (shortbufferin[Ind] & 0xFFFF) ? shortbufferout[currentPixel] & 0xFFFF : shortbufferin[Ind] & 0xFFFF;
                            if (valueMask < valueRec) {
                                if (valueMask != 0) {
                                    if (this.pMem[pBackward + Ind] >= 0) {
                                        this.pMem[pForward + this.pMem[pBackward + Ind]] = this.pMem[pForward + Ind];
                                    } else {
                                        this.pMem[pBackward + this.pMem[pBackward + Ind]] = this.pMem[pForward + Ind];
                                    }
                                    if (this.pMem[pForward + Ind] >= 0) {
                                        this.pMem[pBackward + this.pMem[pForward + Ind]] = this.pMem[pBackward + Ind];
                                    }
                                }
                                shortbufferout[Ind] = (short)valueRec;
                                this.pMem[pBackward + Ind] = -valueRec;
                                this.pMem[pForward + Ind] = this.pMem[pBackward - valueRec];
                                this.pMem[pBackward - valueRec] = Ind;
                                if (this.pMem[pForward + Ind] >= 0) {
                                    this.pMem[pBackward + this.pMem[pForward + Ind]] = Ind;
                                }
                            }
                            ++this.k;
                        }
                        currentPixel = this.pMem[pBackward + level];
                    }
                }
                break;
            }
            case 0: {
                switch (reference.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int valueMask;
                        int[] intbufferin = ((DataBufferInt)reference.getRaster().getDataBuffer()).getData();
                        int[] intbufferout = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
                        for (int Ind = intbufferin.length - 1; Ind >= 0; --Ind) {
                            if (0 >= intbufferout[Ind]) continue;
                            this.pMem[pBackward + Ind] = valueMask = -intbufferout[Ind];
                            this.pMem[pForward + Ind] = this.pMem[pBackward + valueMask];
                            this.pMem[pBackward + valueMask] = Ind;
                            if (this.pMem[pForward + Ind] < 0) continue;
                            this.pMem[pBackward + this.pMem[pForward + Ind]] = Ind;
                        }
                        for (int level = -maxi; level < 0; ++level) {
                            int currentPixel = this.pMem[pBackward + level];
                            while (currentPixel >= 0) {
                                int Ind;
                                this.pMem[pBackward + level] = this.pMem[pForward + currentPixel];
                                this.pMem[pBackward + currentPixel] = level;
                                int X = Maths.Modulo((int)currentPixel, (int)width);
                                int Y = (Maths.Modulo((int)currentPixel, (int)size) - X) / width;
                                this.k = 0;
                                while (this.k < 8 && (Ind = this.GetNeighborPixel(X, Y, 8, width, height)) != -1) {
                                    int valueRec;
                                    valueMask = intbufferout[Ind];
                                    int n = valueRec = intbufferout[currentPixel] < intbufferin[Ind] ? intbufferout[currentPixel] : intbufferin[Ind];
                                    if (valueMask < valueRec) {
                                        if (valueMask != 0) {
                                            if (this.pMem[pBackward + Ind] >= 0) {
                                                this.pMem[pForward + this.pMem[pBackward + Ind]] = this.pMem[pForward + Ind];
                                            } else {
                                                this.pMem[pBackward + this.pMem[pBackward + Ind]] = this.pMem[pForward + Ind];
                                            }
                                            if (this.pMem[pForward + Ind] >= 0) {
                                                this.pMem[pBackward + this.pMem[pForward + Ind]] = this.pMem[pBackward + Ind];
                                            }
                                        }
                                        intbufferout[Ind] = valueRec;
                                        this.pMem[pBackward + Ind] = -valueRec;
                                        this.pMem[pForward + Ind] = this.pMem[pBackward - valueRec];
                                        this.pMem[pBackward - valueRec] = Ind;
                                        if (this.pMem[pForward + Ind] >= 0) {
                                            this.pMem[pBackward + this.pMem[pForward + Ind]] = Ind;
                                        }
                                    }
                                    ++this.k;
                                }
                                currentPixel = this.pMem[pBackward + level];
                            }
                        }
                        break;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    private int GetNeighborPixel(int X, int Y, int Neighborhood, int W, int H) {
        block10: do {
            switch (this.k) {
                case 0: {
                    if (Y <= 0) break;
                    return X + (Y - 1) * W;
                }
                case 1: {
                    if (X <= 0) break;
                    return X - 1 + Y * W;
                }
                case 2: {
                    if (X >= W - 1) break;
                    return X + 1 + Y * W;
                }
                case 3: {
                    if (Y >= H - 1) break;
                    return X + (Y + 1) * W;
                }
                case 4: {
                    if (X <= 0 || Y <= 0) continue block10;
                    return X - 1 + (Y - 1) * W;
                }
                case 5: {
                    if (X >= W - 1 || Y <= 0) continue block10;
                    return X + 1 + (Y - 1) * W;
                }
                case 6: {
                    if (X <= 0 || Y >= H - 1) continue block10;
                    return X - 1 + (Y + 1) * W;
                }
                case 7: {
                    if (X >= W - 1 || Y >= H - 1) continue block10;
                    return X + 1 + (Y + 1) * W;
                }
            }
        } while (++this.k < Neighborhood);
        return -1;
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
    }

    public void Marker(BufferedImage marker) {
        this.marker = null;
        this.marker = marker;
    }

    public BufferedImage Marker() {
        return this.marker;
    }

    public void Marker(DV Marker2) {
        throw new Error("Method not implemented (yet).");
    }

    public DV Marker3D() {
        throw new Error("Method not implemented (yet).");
    }

    public StructuringElement getStructuringElement() {
        return null;
    }

    public void setStructuringElement(StructuringElement SE) {
    }

    public void Parameters(Object ... parameters) {
    }

    public List<Object> Parameters() {
        return null;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public MorphoFilterMarker Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

