/*
 * Decompiled with CFR 0.152.
 */
package morphee.geodesic;

import dv.DV;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.util.ArrayList;
import java.util.List;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import morphee.geodesic.UnderBuild;
import morphee.segmentation.minmax.Maxima;

public class HmaximaExtended
implements MorphoFilter {
    private int H = 1;
    private BufferedImage imh;
    private UnderBuild rec = new UnderBuild();
    public Maxima maxima = new Maxima();

    public HmaximaExtended() {
    }

    public HmaximaExtended(int H) {
        this.H = H;
    }

    public void Kill() {
        this.imh = null;
        this.rec.Kill();
        this.rec = null;
    }

    public BufferedImage Filter(BufferedImage reference, int H, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)reference);
        this.Filter(reference, H, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage reference, int H, BufferedImage result, int nbCPU) {
        this.H = H;
        this.Filter(reference, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage reference, BufferedImage result, int nbCPU) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)reference, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images reference and result have different dimensions.");
        }
        if (this.imh == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)reference, (BufferedImage)this.imh)) {
            this.imh = ImageNew.Same((BufferedImage)reference);
        }
        ImageArithmetic.Subtract(reference, this.H, this.imh, 0, 0);
        this.rec.Filter(reference, this.imh, result, nbCPU);
        this.maxima.Filter(this.imh, 0, true);
        int[] labels = this.maxima.Labels();
        switch (reference.getType()) {
            case 10: {
                byte[] bbref = ((DataBufferByte)reference.getRaster().getDataBuffer()).getData();
                byte[] bbh = ((DataBufferByte)this.imh.getRaster().getDataBuffer()).getData();
                byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < bbref.length; ++x) {
                    bbh[x] = labels[x] != 0 && (bbref[x] & 0xFF) - (bbres[x] & 0xFF) == this.H ? bbref[x] : (byte)0;
                }
                bbres = null;
                bbh = null;
                bbref = null;
                break;
            }
            case 11: {
                short[] sbref = ((DataBufferUShort)reference.getRaster().getDataBuffer()).getData();
                short[] sbh = ((DataBufferUShort)this.imh.getRaster().getDataBuffer()).getData();
                short[] sbres = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < sbref.length; ++x) {
                    sbh[x] = labels[x] != 0 && (sbref[x] & 0xFFFF) - (sbres[x] & 0xFFFF) == this.H ? sbref[x] : (short)0;
                }
                sbres = null;
                sbh = null;
                sbref = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.rec.Filter(reference, this.imh, result, nbCPU);
    }

    public StructuringElement getStructuringElement() {
        return null;
    }

    public void setStructuringElement(StructuringElement ES) {
    }

    public DV Filter(DV source, int nbCPU) {
        throw new UnsupportedOperationException("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new UnsupportedOperationException("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new UnsupportedOperationException("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new UnsupportedOperationException("Empty method, not implemented (yet)");
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.H = (Integer)parameters[0];
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(this.H);
        return params;
    }

    public int BorderEffectSizeX() {
        return 0;
    }

    public int BorderEffectSizeY() {
        return 0;
    }

    public int BorderEffectSizeZ() {
        return 0;
    }

    public MorphoFilter Clone() {
        return new HmaximaExtended(this.H);
    }
}

