/*
 * Decompiled with CFR 0.152.
 */
package morphee.geodesic;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import morphee.MorphoFilterMarker;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import morphee.geodesic.Dilation;
import processing.filters.Invert;

public class Erosion
implements MorphoFilterMarker {
    protected Invert complementary = new Invert();
    protected Dilation dilation = new Dilation();
    private BufferedImage marker;
    private BufferedImage comp;
    private BufferedImage dilated;

    public BufferedImage Filter(BufferedImage reference, BufferedImage marker, StructuringElement SE, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)reference);
        this.Filter(reference, marker, result, SE, nbCPU);
        return result;
    }

    public void Filter(BufferedImage reference, BufferedImage marker, BufferedImage result, StructuringElement SE, int nbCPU) {
        this.Parameters(marker, SE);
        this.Filter(reference, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage reference, BufferedImage result, int nbCPU) {
        if (this.marker == null) {
            throw new IllegalArgumentException("Any marker define.");
        }
        if (this.comp == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)reference, (BufferedImage)this.comp)) {
            this.comp = ImageNew.Same((BufferedImage)reference);
            this.dilated = ImageNew.Same((BufferedImage)reference);
        }
        this.complementary.Filter(reference, this.comp, 1);
        this.dilation.Filter(this.comp, this.dilated, nbCPU);
        this.complementary.Filter(this.dilated, result, 0);
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
    }

    public void Marker(BufferedImage marker) {
        if (this.marker == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)marker, (BufferedImage)this.marker)) {
            this.marker = this.complementary.Filter(marker, 1);
        } else {
            this.complementary.Filter(marker, this.marker, 1);
        }
        this.dilation.Marker(this.marker);
    }

    public BufferedImage Marker() {
        return this.marker;
    }

    public void Marker(DV Marker2) {
        throw new Error("Method not implemented (yet).");
    }

    public DV Marker3D() {
        throw new Error("Method not implemented (yet).");
    }

    public StructuringElement getStructuringElement() {
        return this.dilation.getStructuringElement();
    }

    public void setStructuringElement(StructuringElement ES) {
        this.dilation.setStructuringElement(ES);
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("Exactly 2 parameters required.");
        }
        this.Marker((BufferedImage)parameters[0]);
        this.setStructuringElement((StructuringElement)parameters[1]);
    }

    public List<Object> Parameters() {
        ArrayList<Object> parameters = new ArrayList<Object>(2);
        parameters.add(this.marker);
        parameters.add(this.dilation.Parameters().get(1));
        return parameters;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public MorphoFilterMarker Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

