/*
 * Decompiled with CFR 0.152.
 */
package morphee.geodesic;

import dv.DV;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.List;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import morphee.geodesic.Reconstruction;
import processing.filters.Invert;

public class CloseHoleRec
implements MorphoFilter {
    protected Reconstruction rec = new Reconstruction();
    protected Invert invert = new Invert();
    protected BufferedImage Z = null;
    protected BufferedImage complement = null;
    private BufferedImage temp = null;

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage reference, BufferedImage result, int nbCPU) {
        if (ImageTools.isColored((BufferedImage)reference)) {
            throw new IllegalArgumentException("Colored image not supported.");
        }
        int width = reference.getWidth();
        int height = reference.getHeight();
        if (this.Z == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)reference, (BufferedImage)this.Z)) {
            this.Z = null;
            this.Z = ImageNew.Same((BufferedImage)reference);
            this.complement = null;
            this.complement = ImageNew.Same((BufferedImage)reference);
            this.temp = null;
            this.temp = ImageNew.Same((BufferedImage)reference);
        } else {
            ImageDrawer.Border(this.Z, 255, 1);
        }
        this.invert.Filter(reference, this.complement, 0);
        WritableRaster wrc = this.complement.getRaster();
        WritableRaster wrz = this.Z.getRaster();
        for (int y = 0; y < height; ++y) {
            wrz.setSample(0, y, 0, wrc.getSample(0, y, 0));
            wrz.setSample(width - 1, y, 0, wrc.getSample(width - 1, y, 0));
        }
        for (int x = 1; x < width - 1; ++x) {
            wrz.setSample(x, 0, 0, wrc.getSample(x, 0, 0));
            wrz.setSample(x, height - 1, 0, wrc.getSample(x, height - 1, 0));
        }
        this.rec.Filter(this.complement, this.Z, this.temp, nbCPU);
        this.invert.Filter(this.temp, result, 0);
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
    }

    public StructuringElement getStructuringElement() {
        return null;
    }

    public void setStructuringElement(StructuringElement se) {
    }

    public void Parameters(Object ... parameters) {
    }

    public List<Object> Parameters() {
        return null;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public MorphoFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

