/*
 * Decompiled with CFR 0.152.
 */
package morphee.geodesic;

import dv.DV;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.List;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import morphee.geodesic.UnderBuild;
import processing.filters.Invert;

public class CloseHole
implements MorphoFilter {
    protected UnderBuild rec = new UnderBuild();
    protected Invert invert = new Invert();
    protected BufferedImage Z = null;
    protected BufferedImage complement = null;
    private BufferedImage temp = null;

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage reference, BufferedImage result, int nbCPU) {
        if (ImageTools.isColored((BufferedImage)reference)) {
            throw new IllegalArgumentException("Colored image not supported.");
        }
        int width = reference.getWidth();
        int height = reference.getHeight();
        int w1 = width - 1;
        int h1 = height - 1;
        if (this.Z == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)reference, (BufferedImage)this.Z)) {
            this.Z = null;
            this.Z = ImageNew.Same((BufferedImage)reference);
            this.complement = null;
            this.complement = ImageNew.Same((BufferedImage)reference);
            this.temp = null;
            this.temp = ImageNew.Same((BufferedImage)reference);
        } else {
            ImageDrawer.Border(this.Z, 255, 1);
        }
        this.invert.Filter(reference, this.complement, 0);
        switch (reference.getType()) {
            case 12: {
                WritableRaster wrc = this.complement.getRaster();
                WritableRaster wrz = this.Z.getRaster();
                for (int y = 0; y < height; ++y) {
                    wrz.setSample(0, y, 0, wrc.getSample(0, y, 0));
                    wrz.setSample(w1, y, 0, wrc.getSample(w1, y, 0));
                }
                for (int x = 1; x < width - 1; ++x) {
                    wrz.setSample(x, 0, 0, wrc.getSample(x, 0, 0));
                    wrz.setSample(x, h1, 0, wrc.getSample(x, h1, 0));
                }
                wrz = null;
                wrc = null;
                break;
            }
            case 10: {
                byte[] bbin = ((DataBufferByte)reference.getRaster().getDataBuffer()).getData();
                byte[] bbz = ((DataBufferByte)this.Z.getRaster().getDataBuffer()).getData();
                int pos = 0;
                int y = 0;
                while (y < height) {
                    bbz[pos] = bbin[pos];
                    bbz[pos += w1] = bbin[pos];
                    ++y;
                    ++pos;
                }
                for (pos = 1; pos < w1; ++pos) {
                    bbz[pos] = bbin[pos];
                }
                int x = 1;
                pos = x + h1 * width;
                while (x < w1) {
                    bbz[pos] = bbin[pos];
                    ++x;
                    ++pos;
                }
                bbz = null;
                bbin = null;
                break;
            }
            case 11: {
                short[] sbin = ((DataBufferUShort)reference.getRaster().getDataBuffer()).getData();
                short[] sbz = ((DataBufferUShort)this.Z.getRaster().getDataBuffer()).getData();
                int pos = 0;
                int y = 0;
                while (y < height) {
                    sbz[pos] = sbin[pos];
                    sbz[pos += w1] = sbin[pos];
                    ++y;
                    ++pos;
                }
                for (pos = 1; pos < w1; ++pos) {
                    sbz[pos] = sbin[pos];
                }
                int x = 1;
                pos = x + h1 * width;
                while (x < w1) {
                    sbz[pos] = sbin[pos];
                    ++x;
                    ++pos;
                }
                sbz = null;
                sbin = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.rec.Filter(this.complement, this.Z, this.temp, nbCPU);
        this.invert.Filter(this.temp, result, 0);
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
    }

    public StructuringElement getStructuringElement() {
        return null;
    }

    public void setStructuringElement(StructuringElement se) {
    }

    public void Parameters(Object ... parameters) {
    }

    public List<Object> Parameters() {
        return null;
    }

    public int BorderEffectSizeX() {
        return 1;
    }

    public int BorderEffectSizeY() {
        return 1;
    }

    public int BorderEffectSizeZ() {
        return 1;
    }

    public MorphoFilter Clone() {
        return new CloseHole();
    }
}

