/*
 * Decompiled with CFR 0.152.
 */
package morphee.filters;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.util.List;
import morphee.Dilate;
import morphee.Erode;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;

public class ToggleMappingStrong
implements MorphoFilter {
    private Dilate dilate = new Dilate();
    private Erode erode = new Erode();
    private BufferedImage dilat;
    private BufferedImage erod;

    public BufferedImage Filter(BufferedImage source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, StructuringElement SE, BufferedImage Result, int nbCPU) {
        this.setStructuringElement(SE);
        this.Filter(source, Result, nbCPU);
    }

    public void Filter(BufferedImage source, BufferedImage Result, int nbCPU) {
        if (this.dilat == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)this.dilat)) {
            this.dilat = ImageNew.Same((BufferedImage)source);
            this.erod = ImageNew.Same((BufferedImage)source);
        }
        this.dilate.Filter(source, this.dilat, nbCPU);
        this.erode.Filter(source, this.erod, nbCPU);
        this.Filter(source, this.erod, this.dilat, Result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, BufferedImage imageinf, BufferedImage imagesup, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, imageinf, imagesup, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage imageinf, BufferedImage imagesup, BufferedImage Result, int nbCPU) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)imageinf)) {
            throw new IllegalArgumentException("ImageInf have different type or dimension.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)imagesup)) {
            throw new IllegalArgumentException("ImageSup have different type or dimension.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Result have different type or dimension.");
        }
        switch (source.getType()) {
            case 5: 
            case 6: 
            case 10: {
                byte[] byteori = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] byteres = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                byte[] bytesup = ((DataBufferByte)imagesup.getRaster().getDataBuffer()).getData();
                byte[] byteinf = ((DataBufferByte)imageinf.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < byteori.length; ++x) {
                    int sup = bytesup[x] & 0xFF;
                    int ori = byteori[x] & 0xFF;
                    int inf = byteinf[x] & 0xFF;
                    byteres[x] = sup - ori > ori - inf ? (byte)sup : (sup - ori < ori - inf ? (byte)inf : (byte)ori);
                }
                byteinf = null;
                bytesup = null;
                byteres = null;
                byteori = null;
                break;
            }
            case 11: {
                short[] shortori = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                short[] shortres = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                short[] shortsup = ((DataBufferUShort)imagesup.getRaster().getDataBuffer()).getData();
                short[] shortinf = ((DataBufferUShort)imageinf.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < shortori.length; ++x) {
                    int sup = shortsup[x] & 0xFFFF;
                    int ori = shortori[x] & 0xFFFF;
                    int inf = shortinf[x] & 0xFFFF;
                    shortres[x] = sup - ori > ori - inf ? (short)sup : (sup - ori < ori - inf ? (short)inf : (short)ori);
                }
                shortinf = null;
                shortsup = null;
                shortres = null;
                shortori = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Default: Image type not supported.");
            }
        }
    }

    public void FilterABS(BufferedImage source, BufferedImage imageinf, BufferedImage imagesup, BufferedImage Result, int nbCPU) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)imageinf)) {
            throw new IllegalArgumentException("ImageInf have different type or dimension.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)imagesup)) {
            throw new IllegalArgumentException("ImageSup have different type or dimension.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Result have different type or dimension.");
        }
        switch (source.getType()) {
            case 5: 
            case 6: 
            case 10: {
                byte[] byteori = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] byteres = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                byte[] bytesup = ((DataBufferByte)imagesup.getRaster().getDataBuffer()).getData();
                byte[] byteinf = ((DataBufferByte)imageinf.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < byteori.length; ++x) {
                    int ori = byteori[x] & 0xFF;
                    int sup = bytesup[x] & 0xFF;
                    int inf = byteinf[x] & 0xFF;
                    byteres[x] = Math.abs(sup - ori) > Math.abs(ori - inf) ? (byte)sup : (Math.abs(sup - ori) < Math.abs(ori - inf) ? (byte)inf : (byte)ori);
                }
                byteinf = null;
                bytesup = null;
                byteres = null;
                byteori = null;
                break;
            }
            case 11: {
                short[] shortori = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                short[] shortres = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                short[] shortsup = ((DataBufferUShort)imagesup.getRaster().getDataBuffer()).getData();
                short[] shortinf = ((DataBufferUShort)imageinf.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < shortori.length; ++x) {
                    int ori = shortori[x] & 0xFFFF;
                    int sup = shortsup[x] & 0xFFFF;
                    int inf = shortinf[x] & 0xFFFF;
                    shortres[x] = Math.abs(sup - ori) > Math.abs(ori - inf) ? (short)sup : (Math.abs(sup - ori) < Math.abs(ori - inf) ? (short)inf : (short)ori);
                }
                shortinf = null;
                shortsup = null;
                shortres = null;
                shortori = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Default: Image type not supported.");
            }
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
    }

    public StructuringElement getStructuringElement() {
        return this.dilate.getStructuringElement();
    }

    public void setStructuringElement(StructuringElement ES) {
        this.dilate.setStructuringElement(ES);
        this.erode.setStructuringElement(ES);
    }

    public void Marker(BufferedImage marker) {
    }

    public BufferedImage Marker() {
        return null;
    }

    public void Parameters(Object ... parameters) {
        this.dilate.Parameters(parameters);
        this.erode.Parameters(parameters);
    }

    public List<Object> Parameters() {
        return this.dilate.Parameters();
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public MorphoFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

