/*
 * Decompiled with CFR 0.152.
 */
package morphee.filters;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import morphee.Close;
import morphee.MorphoFilter;
import morphee.Open;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import processing.filters.SignalFilter;

public class MinMaxOrientations
implements MorphoFilter {
    private List<StructuringElement> ses = new ArrayList<StructuringElement>(11);
    public boolean opening = true;
    public boolean max = true;
    private Close close = new Close();
    private Open open = new Open();
    private BufferedImage imtmp = null;

    public synchronized void Kill() {
        this.open.Kill();
        this.close.Kill();
        this.imtmp = null;
        this.ses.clear();
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.Filter(source, result, nbCPU);
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (this.ses.isEmpty()) {
            throw new IllegalStateException("No orientations defined. Use AddOrientations or AddStructuringElement.");
        }
        if (this.opening) {
            this.open.Filter(source, this.ses.get(0), result, nbCPU);
        } else {
            this.close.Filter(source, this.ses.get(0), result, nbCPU);
        }
        if (this.imtmp == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)this.imtmp)) {
            this.imtmp = null;
            this.imtmp = ImageNew.Same((BufferedImage)source);
        }
        for (int i2 = 1; i2 < this.ses.size(); ++i2) {
            if (this.opening) {
                this.open.Filter(source, this.ses.get(i2), this.imtmp, nbCPU);
            } else {
                this.close.Filter(source, this.ses.get(i2), this.imtmp, nbCPU);
            }
            if (this.max) {
                ImageOperations.Maximum((BufferedImage)this.imtmp, (BufferedImage)result, (BufferedImage)result);
                continue;
            }
            ImageOperations.Minimum((BufferedImage)this.imtmp, (BufferedImage)result, (BufferedImage)result);
        }
    }

    public StructuringElement getStructuringElement() {
        throw new UnsupportedOperationException("Not relevant for this class!");
    }

    public void setStructuringElement(StructuringElement se) {
        throw new UnsupportedOperationException("Not relevant for this class! Use AddStructuringElement or AddOrientation.");
    }

    public void AddOrientation(int orientation, int order) {
        if (order <= 0) {
            throw new IllegalArgumentException("order <= 0");
        }
        StructuringElement se = null;
        switch (orientation) {
            case 0: {
                se = new StructuringElement(new Object[]{order, -5});
                break;
            }
            case 45: {
                se = new StructuringElement(new Object[]{order, -4});
                break;
            }
            case 90: {
                se = new StructuringElement(new Object[]{order, -6});
                break;
            }
            case 135: {
                se = new StructuringElement(new Object[]{order, -3});
                break;
            }
            default: {
                if (orientation < 0) {
                    throw new IllegalArgumentException("orientation < 0");
                }
                if (180 <= orientation) {
                    throw new IllegalArgumentException("180 <= orientation");
                }
                se = new StructuringElement(new Object[]{order, -11, orientation});
            }
        }
        this.AddStructuringElement(se);
    }

    public void AddStructuringElement(StructuringElement se) {
        switch (se.getType()) {
            case -11: 
            case -6: 
            case -5: 
            case -4: 
            case -3: {
                this.ses.add(se);
                break;
            }
            default: {
                throw new IllegalArgumentException("Oriented structuring element required.");
            }
        }
    }

    public void CleanOrientations() {
        this.ses.clear();
    }

    public DV Filter(DV source, int nbCPU) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public StructuringElement3D getStructuringElement3D() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setStructuringElement3D(StructuringElement3D se) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void Parameters(Object ... parameters) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<Object> Parameters() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int BorderEffectSizeX() {
        if (this.ses.isEmpty()) {
            throw new IllegalStateException("No orientations/ses defined.");
        }
        int be = this.ses.get(0).getSizeX();
        for (int i2 = 1; i2 < this.ses.size(); ++i2) {
            if (be >= this.ses.get(i2).getSizeX()) continue;
            be = this.ses.get(i2).getSizeX();
        }
        return be >> 1;
    }

    public int BorderEffectSizeY() {
        if (this.ses.isEmpty()) {
            throw new IllegalStateException("No orientations/ses defined.");
        }
        int be = this.ses.get(0).getSizeY();
        for (int i2 = 1; i2 < this.ses.size(); ++i2) {
            if (be >= this.ses.get(i2).getSizeX()) continue;
            be = this.ses.get(i2).getSizeY();
        }
        return be >> 1;
    }

    public int BorderEffectSizeZ() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SignalFilter Clone() {
        MinMaxOrientations mmo = new MinMaxOrientations();
        mmo.max = this.max;
        mmo.opening = this.opening;
        for (int i2 = 0; i2 < this.ses.size(); ++i2) {
            mmo.AddStructuringElement(this.ses.get(i2));
        }
        return mmo;
    }
}

