/*
 * Decompiled with CFR 0.152.
 */
package morphee.filters;

import arrayTiTi.ArrayComparator;
import arrayTiTi.ArrayFeatures;
import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.util.ArrayList;
import java.util.List;
import morphee.Dilate;
import morphee.Erode;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import processing.filters.DynamicExpansion;

public class Contrast
implements MorphoFilter {
    public static final int NONE = 0;
    public static final int DYNAMIC_EXPANSION = 1;
    public static final int ABS_AND_DYNAMIC_EXPANSION = 2;
    public static final int CUT_EXCESS = 3;
    private final Dilate dilate = new Dilate();
    private final Erode erode = new Erode();
    private int nbIterations = 1;
    private BufferedImage dilated;
    private BufferedImage eroded;
    private BufferedImage src;
    private final DynamicExpansion de = new DynamicExpansion();
    private int HowCorrect = 3;
    private int[] res = null;
    private final ArrayFeatures AF = new ArrayFeatures();

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbIterations, int HowCorrect, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, se, nbIterations, HowCorrect, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, StructuringElement se, int nbIterations, int HowCorrect, BufferedImage result, int nbCPU) {
        this.Parameters(se, nbIterations, HowCorrect);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result have different dimensions or types.");
        }
        if (this.dilated == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)this.dilated)) {
            this.src = null;
            this.eroded = null;
            this.dilated = null;
            this.dilated = ImageNew.Same((BufferedImage)source);
            this.eroded = ImageNew.Same((BufferedImage)source);
            this.src = ImageNew.Same((BufferedImage)source);
            this.res = null;
            this.res = new int[source.getWidth() * source.getHeight()];
        }
        int i2 = 0;
        int size = this.res.length;
        boolean stop = false;
        ImageNew.Copy((BufferedImage)source, (BufferedImage)this.src);
        while (!stop) {
            int x;
            int MAX;
            this.dilate.Filter(this.src, this.dilated, nbCPU);
            this.erode.Filter(this.src, this.eroded, nbCPU);
            switch (this.src.getType()) {
                case 5: 
                case 6: 
                case 10: {
                    MAX = 255;
                    byte[] bytebufferin = ((DataBufferByte)this.src.getRaster().getDataBuffer()).getData();
                    byte[] bytebufferdil = ((DataBufferByte)this.dilated.getRaster().getDataBuffer()).getData();
                    byte[] bytebufferero = ((DataBufferByte)this.eroded.getRaster().getDataBuffer()).getData();
                    for (x = 0; x < size; ++x) {
                        this.res[x] = 3 * (bytebufferin[x] & 0xFF) - (bytebufferdil[x] & 0xFF) - (bytebufferero[x] & 0xFF);
                    }
                    bytebufferero = null;
                    bytebufferdil = null;
                    bytebufferin = null;
                    break;
                }
                case 11: {
                    MAX = 65535;
                    short[] shortbufferin = ((DataBufferUShort)this.src.getRaster().getDataBuffer()).getData();
                    short[] shortbufferdil = ((DataBufferUShort)this.dilated.getRaster().getDataBuffer()).getData();
                    short[] shortbufferero = ((DataBufferUShort)this.eroded.getRaster().getDataBuffer()).getData();
                    for (x = 0; x < size; ++x) {
                        this.res[x] = 3 * (shortbufferin[x] & 0xFFFF) - (shortbufferdil[x] & 0xFFFF) - (shortbufferero[x] & 0xFFFF);
                    }
                    shortbufferero = null;
                    shortbufferdil = null;
                    shortbufferin = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Default: image type not supported.");
                }
            }
            switch (this.HowCorrect) {
                case 0: {
                    break;
                }
                case 2: {
                    for (x = 0; x < size; ++x) {
                        this.res[x] = Math.abs(this.res[x]);
                    }
                }
                case 1: {
                    int min = this.AF.Minimum(this.res);
                    int max = this.AF.Maximum(this.res);
                    if (min >= 0 && MAX >= max) break;
                    this.de.Filter(this.res, this.res, min, max, 0, MAX);
                    break;
                }
                case 3: {
                    ArrayComparator.Compare((int[])this.res, (String)">=", (int)0, (int[])this.res, (int)0, (int[])this.res);
                    ArrayComparator.Compare((int[])this.res, (String)"<=", (int)MAX, (int[])this.res, (int)MAX, (int[])this.res);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("HowCorrect value unknown.");
                }
            }
            switch (source.getType()) {
                case 5: 
                case 6: 
                case 10: {
                    byte[] bytebufferout = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                    for (x = 0; x < bytebufferout.length; ++x) {
                        bytebufferout[x] = (byte)this.res[x];
                    }
                    bytebufferout = null;
                    break;
                }
                case 11: {
                    short[] shortbufferout = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                    for (x = 0; x < shortbufferout.length; ++x) {
                        shortbufferout[x] = (short)this.res[x];
                    }
                    shortbufferout = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Default: image type not supported.");
                }
            }
            if (0 < this.nbIterations ? ++i2 == this.nbIterations : ImageTools.areEqual((BufferedImage)this.src, (BufferedImage)result)) break;
            ImageNew.Copy((BufferedImage)result, (BufferedImage)this.src);
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
    }

    public StructuringElement getStructuringElement() {
        return this.dilate.getStructuringElement();
    }

    public void setStructuringElement(StructuringElement se) {
        this.dilate.setStructuringElement(se);
        this.erode.setStructuringElement(se);
    }

    public void Marker(BufferedImage marker) {
    }

    public BufferedImage Marker() {
        return null;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 3) {
            throw new IllegalArgumentException("Exactly 3 parameters required.");
        }
        this.setStructuringElement((StructuringElement)parameters[0]);
        if ((Integer)parameters[1] < 0) {
            throw new IllegalArgumentException("Number of iterations < 1.");
        }
        this.nbIterations = (Integer)parameters[1];
        this.HowCorrect = (Integer)parameters[2];
    }

    public List<Object> Parameters() {
        ArrayList<Object> list = new ArrayList<Object>(3);
        list.add(this.dilate.getStructuringElement());
        list.add(this.nbIterations);
        list.add(this.HowCorrect);
        return list;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public MorphoFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

