/*
 * Decompiled with CFR 0.152.
 */
package morphee.filters;

import dv.DV;
import imageTiTi.ImageConverter;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.UnionFindCcl;
import measures.histogram.Histogram;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import processing.thresholding.Binary;
import utils.memory.Allocator;

public class AreaOpening
implements MorphoFilter {
    private Allocator allocator = Allocator.Instance();
    private int MaxGrayLevel = -1;
    private ConnectedComponentLabeling ccl = new UnionFindCcl();
    private boolean EightConnex = true;
    private int Lambda = 1;
    private Histogram histogram = new Histogram();
    private Binary binary = new Binary();

    public void Kill() {
        this.ccl.Kill();
        this.binary.Kill();
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        this.Filter(source, result, this.Lambda, this.EightConnex);
    }

    public BufferedImage Filter(BufferedImage source, int size, boolean EightConnex) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, size, EightConnex);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int size, boolean EightConnex) {
        int max;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Image source and result have different types or dimensions.");
        }
        int width = source.getWidth();
        int height = source.getHeight();
        this.Parameters(size, EightConnex);
        int[][] in = new int[height][width];
        int[] out = this.allocator.newIntArray(width * height);
        int[] SortPixels = this.allocator.newIntArray(width * height);
        switch (source.getType()) {
            case 12: {
                max = 2;
                break;
            }
            case 10: {
                max = 256;
                break;
            }
            case 11: {
                max = 65536;
                break;
            }
            default: {
                throw new IllegalArgumentException("Colored image not supported.");
            }
        }
        if (max != this.MaxGrayLevel) {
            this.MaxGrayLevel = max;
        }
        int[] hist = this.allocator.newIntArray(this.MaxGrayLevel);
        int[] idx = this.allocator.newIntArray(this.MaxGrayLevel);
        ImageConverter.ImageToInt((BufferedImage)source, (int[][])in);
        Arrays.fill(out, 0);
        this.GreyAreaOpening(size, width, height, in, out, EightConnex, SortPixels, hist, idx);
        ImageConverter.ArrayToImage((int[])out, (BufferedImage)result);
        hist = this.allocator.Release(hist);
        idx = this.allocator.Release(idx);
        out = this.allocator.Release(out);
        SortPixels = this.allocator.Release(SortPixels);
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
    }

    private void PixelDownSort(int width, int height, int[][] im, int[] SortPixels, int[] hist, int[] idx) {
        int i2;
        int j;
        Arrays.fill(hist, 0);
        for (j = 0; j < height; ++j) {
            for (i2 = 0; i2 < width; ++i2) {
                int n = im[j][i2];
                hist[n] = hist[n] + 1;
            }
        }
        idx[this.MaxGrayLevel - 1] = 0;
        for (i2 = this.MaxGrayLevel - 2; i2 >= 0; --i2) {
            idx[i2] = idx[i2 + 1] + hist[i2 + 1];
        }
        for (j = 0; j < height; ++j) {
            for (i2 = 0; i2 < width; ++i2) {
                int value = im[j][i2];
                int pos = idx[value];
                SortPixels[pos] = i2 + j * width;
                int n = value;
                idx[n] = idx[n] + 1;
            }
        }
    }

    private void Link1(int[] opening, int p, int pixel, int lambda) {
        int root = p;
        while (opening[root] >= 0) {
            root = opening[root];
        }
        int newroot = root;
        if (root != pixel) {
            if (-opening[root] < lambda) {
                int n = pixel;
                opening[n] = opening[n] + opening[root];
                opening[root] = pixel;
                newroot = pixel;
            } else {
                opening[pixel] = -lambda;
            }
        }
        int r = p;
        while (r != root) {
            int h = opening[r];
            opening[r] = newroot;
            r = h;
        }
    }

    private void GreyAreaOpening(int lambda, int width, int height, int[][] image, int[] opening, boolean EightConnex, int[] SortPixels, int[] hist, int[] idx) {
        int pixel;
        int i2;
        int imsize = width * height;
        this.PixelDownSort(width, height, image, SortPixels, hist, idx);
        for (i2 = 0; i2 < imsize; ++i2) {
            pixel = SortPixels[i2];
            opening[pixel] = -1;
            int x = pixel % width;
            int y = pixel / width;
            int gval = image[y][x];
            if (x - 1 >= 0 && gval <= image[y][x - 1]) {
                this.Link1(opening, pixel - 1, pixel, lambda);
            }
            if (x + 1 < width && gval < image[y][x + 1]) {
                this.Link1(opening, pixel + 1, pixel, lambda);
            }
            if (y - 1 >= 0 && gval <= image[y - 1][x]) {
                this.Link1(opening, pixel - width, pixel, lambda);
            }
            if (y + 1 < height && gval < image[y + 1][x]) {
                this.Link1(opening, pixel + width, pixel, lambda);
            }
            if (!EightConnex) continue;
            if (x - 1 >= 0 && y - 1 >= 0 && gval <= image[y - 1][x - 1]) {
                this.Link1(opening, pixel - 1 - width, pixel, lambda);
            }
            if (x + 1 < width && y - 1 >= 0 && gval <= image[y - 1][x + 1]) {
                this.Link1(opening, pixel + 1 - width, pixel, lambda);
            }
            if (x - 1 >= 0 && y + 1 < height && gval < image[y + 1][x - 1]) {
                this.Link1(opening, pixel - 1 + width, pixel, lambda);
            }
            if (x + 1 >= width || y + 1 >= height || gval >= image[y + 1][x + 1]) continue;
            this.Link1(opening, pixel + 1 + width, pixel, lambda);
        }
        for (i2 = imsize - 1; i2 >= 0; --i2) {
            pixel = SortPixels[i2];
            int n = opening[pixel] < 0 ? image[pixel / width][pixel % width] : opening[opening[pixel]];
            opening[pixel] = n;
        }
    }

    public void FilterBruteForce(BufferedImage source, BufferedImage result, int nbCPU) {
        if (ImageTools.isColored((BufferedImage)source)) {
            throw new IllegalArgumentException("Only gray level or binary image supported.");
        }
        BufferedImage bin = ImageNew.Same((BufferedImage)source);
        int width = source.getWidth();
        int height = source.getHeight();
        this.histogram.Fill(source);
        int[] histo = this.histogram.getValues()[0];
        switch (source.getType()) {
            case 12: {
                WritableRaster wr = source.getRaster();
                WritableRaster wrr = result.getRaster();
                this.ccl.Label(source, 0, this.EightConnex);
                int[] Labels = this.ccl.Labels1D();
                int[] Sizes = this.ccl.Sizes();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (wr.getSample(x, y, 0) == 1 && this.Lambda <= Sizes[Labels[pos]]) {
                            wrr.setSample(x, y, 0, 1);
                        }
                        ++x;
                        ++pos;
                    }
                }
                wr = null;
                wrr = null;
                break;
            }
            case 10: {
                byte[] data = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] res = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int Max = this.histogram.getMaxColor();
                for (int h = 1; h <= Max; ++h) {
                    if (histo[h] <= 0) continue;
                    this.binary.setThreshold(h);
                    this.binary.Filter(source, bin, 0);
                    this.ccl.Label(bin, 0, this.EightConnex);
                    int[] Labels = this.ccl.Labels1D();
                    int[] Sizes = this.ccl.Sizes();
                    int pos = 0;
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            if (0 < (data[pos] & 0xFF) && this.Lambda <= Sizes[Labels[pos]]) {
                                res[pos] = (byte)h;
                            }
                            ++x;
                            ++pos;
                        }
                    }
                }
                break;
            }
            case 11: {
                short[] datashort = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                short[] resshort = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                int Max = this.histogram.getMaxColor();
                for (int h = 1; h <= Max; ++h) {
                    if (histo[h] <= 0) continue;
                    this.binary.setThreshold(h);
                    this.binary.Filter(source, bin, 0);
                    this.ccl.Label(bin, 0, this.EightConnex);
                    int[] Labels = this.ccl.Labels1D();
                    int[] Sizes = this.ccl.Sizes();
                    int pos = 0;
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            if (0 < (datashort[pos] & 0xFF) && this.Lambda <= Sizes[Labels[pos]]) {
                                resshort[pos] = (byte)h;
                            }
                            ++x;
                            ++pos;
                        }
                    }
                    Sizes = null;
                    Labels = null;
                }
                break;
            }
            default: {
                throw new Error("Image type not supported => This error musn't occured!");
            }
        }
        bin = this.allocator.Release(bin);
    }

    public void EightConnex(boolean EightConnex) {
        this.EightConnex = EightConnex;
    }

    public boolean EightConnex() {
        return this.EightConnex;
    }

    public void Lambda(int Lambda) {
        if (Lambda <= 0) {
            throw new IllegalArgumentException("Bad value of argument : value < 1.");
        }
        this.Lambda = Lambda;
    }

    public int Lambda() {
        return this.Lambda;
    }

    public StructuringElement getStructuringElement() {
        return null;
    }

    public void setStructuringElement(StructuringElement ES) {
        this.Lambda(ES.getOrder());
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("Exactly 2 parameters required.");
        }
        this.Lambda((Integer)parameters[0]);
        this.EightConnex((Boolean)parameters[1]);
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(this.Lambda);
        params.add(this.EightConnex);
        return params;
    }

    public int BorderEffectSizeX() {
        return 0;
    }

    public int BorderEffectSizeY() {
        return 0;
    }

    public int BorderEffectSizeZ() {
        return 0;
    }

    public MorphoFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

