/*
 * Decompiled with CFR 0.152.
 */
package morphee.filters;

import arrayTiTi.ArrayNew;
import dv.DV;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import morphee.Close;
import morphee.MorphoFilter;
import morphee.Open;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import utils.memory.Allocator;

public class ASFilterOpenClose
implements MorphoFilter {
    private Allocator allocator = Allocator.Instance();
    private Open open = new Open();
    private Close close = new Close();
    private int Type = -1;
    private int Orientation = -1;
    private int Iterations = 0;
    private DV cldv = null;

    public void Kill() {
        if (this.cldv != null) {
            this.cldv.Kill();
        }
        this.cldv = null;
        this.open.Kill();
        this.close.Kill();
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        int size = 1;
        StructuringElement se = null;
        BufferedImage cl = ImageNew.Same((BufferedImage)source);
        ImageNew.Copy((BufferedImage)source, (BufferedImage)result);
        do {
            se = this.Type == -11 ? new StructuringElement(new Object[]{size, this.Type, this.Orientation}) : new StructuringElement(new Object[]{size, this.Type});
            this.close.setStructuringElement(se);
            this.open.setStructuringElement(se);
            this.close.Filter(result, cl, nbCPU);
            this.open.Filter(cl, result, nbCPU);
            se = null;
        } while (++size <= this.Iterations);
        cl = this.allocator.Release(cl);
    }

    public StructuringElement getStructuringElement() {
        return new StructuringElement(new Object[]{this.Iterations, this.Type, this.Orientation});
    }

    public void setStructuringElement(StructuringElement se) {
        this.Iterations = se.getOrder();
        this.Orientation = se.getOrientation();
        this.Type = se.getType();
    }

    public DV Filter(DV source, int nbCPU) {
        DV result = DvNew.Same((DV)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        this.setStructuringElement3D(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        this.setStructuringElement3D(se);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(DV source, DV result, int nbCPU) {
        int size = 1;
        StructuringElement3D se = null;
        if (this.cldv == null || !DvTools.areDimensionsAndTypeEqual((DV)source, (DV)this.cldv)) {
            if (this.cldv != null) {
                this.cldv.Kill();
            }
            this.cldv = null;
            this.cldv = DvNew.Same((DV)source);
        }
        DvNew.Copy((DV)source, (DV)result);
        do {
            se = new StructuringElement3D(new Object[]{size, this.Type});
            this.close.setStructuringElement3D(se);
            this.open.setStructuringElement3D(se);
            this.close.Filter(result, this.cldv, nbCPU);
            this.open.Filter(this.cldv, result, nbCPU);
            se = null;
        } while (++size <= this.Iterations);
    }

    public StructuringElement3D getStructuringElement3D() {
        return new StructuringElement3D(new Object[]{this.Iterations, this.Type});
    }

    public void setStructuringElement3D(StructuringElement3D se) {
        this.Iterations = se.getOrder();
        this.Orientation = -1;
        this.Type = se.getType();
    }

    public byte[] Filter(byte[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public byte[] Filter(byte[] source, int nbCPU) {
        byte[] result = ArrayNew.Same((byte[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(byte[] source, StructuringElement SE, byte[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(byte[] source, byte[] result, int nbCPU) {
        int size = 1;
        StructuringElement se = null;
        byte[] btmp = ArrayNew.Same((byte[])source);
        System.arraycopy(source, 0, result, 0, source.length);
        do {
            se = new StructuringElement(new Object[]{size, -5});
            this.close.setStructuringElement(se);
            this.open.setStructuringElement(se);
            this.close.Filter(result, btmp, nbCPU);
            this.open.Filter(btmp, result, nbCPU);
            se = null;
        } while (++size <= this.Iterations);
        btmp = this.allocator.Release(btmp);
    }

    public short[] Filter(short[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public short[] Filter(short[] source, int nbCPU) {
        short[] result = ArrayNew.Same((short[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(short[] source, StructuringElement SE, short[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(short[] source, short[] result, int nbCPU) {
        int size = 1;
        StructuringElement se = null;
        short[] stmp = ArrayNew.Same((short[])source);
        System.arraycopy(source, 0, result, 0, source.length);
        do {
            se = new StructuringElement(new Object[]{size, -5});
            this.close.setStructuringElement(se);
            this.open.setStructuringElement(se);
            this.close.Filter(result, stmp, nbCPU);
            this.open.Filter(stmp, result, nbCPU);
            se = null;
        } while (++size <= this.Iterations);
        stmp = this.allocator.Release(stmp);
    }

    public int[] Filter(int[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public int[] Filter(int[] source, int nbCPU) {
        int[] result = ArrayNew.Same((int[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(int[] source, StructuringElement SE, int[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(int[] source, int[] result, int nbCPU) {
        int size = 1;
        StructuringElement se = null;
        int[] itmp = ArrayNew.Same((int[])source);
        System.arraycopy(source, 0, result, 0, source.length);
        do {
            se = new StructuringElement(new Object[]{size, -5});
            this.close.setStructuringElement(se);
            this.open.setStructuringElement(se);
            this.close.Filter(result, itmp, nbCPU);
            this.open.Filter(itmp, result, nbCPU);
            se = null;
        } while (++size <= this.Iterations);
        itmp = this.allocator.Release(itmp);
    }

    public double[] Filter(double[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public double[] Filter(double[] source, int nbCPU) {
        double[] result = ArrayNew.Same((double[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(double[] source, StructuringElement SE, double[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(double[] source, double[] result, int nbCPU) {
        int size = 1;
        StructuringElement se = null;
        double[] dtmp = ArrayNew.Same((double[])source);
        System.arraycopy(source, 0, result, 0, source.length);
        do {
            se = new StructuringElement(new Object[]{size, -5});
            this.close.setStructuringElement(se);
            this.open.setStructuringElement(se);
            this.close.Filter(result, dtmp, nbCPU);
            this.open.Filter(dtmp, result, nbCPU);
            se = null;
        } while (++size <= this.Iterations);
        dtmp = this.allocator.Release(dtmp);
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        if (parameters[0] instanceof StructuringElement) {
            this.setStructuringElement((StructuringElement)parameters[0]);
        } else if (parameters[0] instanceof StructuringElement3D) {
            this.setStructuringElement3D((StructuringElement3D)parameters[0]);
        } else {
            throw new IllegalArgumentException("A structuring element is required.");
        }
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        switch (this.Type) {
            case -11: {
                params.add(new StructuringElement(new Object[]{this.Iterations, this.Type, this.Orientation}));
                break;
            }
            default: {
                params.add(new StructuringElement(new Object[]{this.Iterations, this.Type}));
            }
        }
        return params;
    }

    public int BorderEffectSizeX() {
        return this.Iterations;
    }

    public int BorderEffectSizeY() {
        return this.Iterations;
    }

    public int BorderEffectSizeZ() {
        return this.Iterations;
    }

    public MorphoFilter Clone() {
        ASFilterOpenClose clone = new ASFilterOpenClose();
        if (this.Orientation == -1) {
            return clone;
        }
        if (this.Orientation != Integer.MIN_VALUE) {
            clone.setStructuringElement(this.getStructuringElement());
        } else {
            clone.setStructuringElement3D(this.getStructuringElement3D());
        }
        return clone;
    }
}

