/*
 * Decompiled with CFR 0.152.
 */
package morphee.fastMorphee;

import arrayTiTi.ArrayNew;
import dv.DV;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;

public class OpenSegmentX
implements MorphoFilter {
    private OpenSegmentXThread[] threads = null;
    private Open3dSegmentXThread[] threads3d = null;
    private int nbFreeThreads = 0;
    private int sewidth = 0;

    public synchronized void Kill() {
        int i2;
        if (this.threads != null) {
            for (i2 = 0; i2 < this.threads.length; ++i2) {
                this.threads[i2].Kill();
                this.threads[i2] = null;
            }
        }
        this.threads = null;
        if (this.threads3d != null) {
            for (i2 = 0; i2 < this.threads3d.length; ++i2) {
                this.threads3d[i2].Kill();
                this.threads3d[i2] = null;
            }
        }
        this.threads3d = null;
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (this.sewidth == 0) {
            throw new IllegalArgumentException("Structuring element's width not defined or less/equals than 0.");
        }
        this.Filter(source, this.sewidth, result, nbCPU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Filter(BufferedImage source, int sewidth, BufferedImage result, int nbCPU) {
        Object object;
        int i2;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Image source and result have different dimensions or type.");
        }
        this.sewidth = sewidth;
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new OpenSegmentXThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threads[i2] = new OpenSegmentXThread();
                this.threads[i2].start();
            }
            OpenSegmentX openSegmentX = this;
            synchronized (openSegmentX) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = source.getHeight() / nbCPU;
        for (i2 = 0; i2 < nbCPU - 1; ++i2) {
            this.threads[i2].setConditions(source, result, sewidth, i2 * step, (i2 + 1) * step);
            object = this.threads[i2].lock;
            synchronized (object) {
                this.threads[i2].lock.notify();
                continue;
            }
        }
        this.threads[i2].setConditions(source, result, sewidth, i2 * step, source.getHeight());
        object = this.threads[i2].lock;
        synchronized (object) {
            this.threads[i2].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public DV Filter(DV source, int nbCPU) {
        DV result = DvNew.Same((DV)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(DV source, DV result, int nbCPU) {
        if (this.sewidth == 0) {
            throw new IllegalArgumentException("Structuring element's width not defined or less/equals than 0.");
        }
        this.Filter(source, this.sewidth, result, nbCPU);
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        this.setStructuringElement3D(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        this.setStructuringElement3D(se);
        this.Filter(source, result, nbCPU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Filter(DV source, int sewidth, DV result, int nbCPU) {
        Object object;
        int i2;
        if (!DvTools.areDimensionsAndTypeEqual((DV)source, (DV)result)) {
            throw new IllegalArgumentException("DV source and result have different dimensions or type.");
        }
        this.sewidth = sewidth;
        if (this.threads3d == null || this.threads3d.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads3d = null;
            this.threads3d = new Open3dSegmentXThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threads3d[i2] = new Open3dSegmentXThread();
                this.threads3d[i2].start();
            }
            OpenSegmentX openSegmentX = this;
            synchronized (openSegmentX) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = source.SizeZ / nbCPU;
        for (i2 = 0; i2 < nbCPU - 1; ++i2) {
            this.threads3d[i2].setConditions(source, result, sewidth, i2 * step, (i2 + 1) * step);
            object = this.threads3d[i2].lock;
            synchronized (object) {
                this.threads3d[i2].lock.notify();
                continue;
            }
        }
        this.threads3d[i2].setConditions(source, result, sewidth, i2 * step, source.SizeZ);
        object = this.threads3d[i2].lock;
        synchronized (object) {
            this.threads3d[i2].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
        this.sewidth = (se.getOrder() << 1) + 1;
    }

    public double[][] Filter(double[][] source, int nbCPU) {
        double[][] result = ArrayNew.Same((double[][])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(double[][] source, double[][] result, int nbCPU) {
        if (this.sewidth == 0) {
            throw new IllegalArgumentException("Structuring element's width not defined or less/equals than 0.");
        }
        this.Filter(source, this.sewidth, result, nbCPU);
    }

    public void Filter(double[][] source, int sewidth, double[][] result, int nbCPU) {
        throw new Error("Not (yet) implemented.");
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    public StructuringElement getStructuringElement() {
        return null;
    }

    public void setStructuringElement(StructuringElement se) {
        this.sewidth = (se.getOrder() << 1) + 1;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.sewidth = (Integer)parameters[0];
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(this.sewidth);
        return params;
    }

    public int BorderEffectSizeX() {
        return this.sewidth;
    }

    public int BorderEffectSizeY() {
        return 0;
    }

    public int BorderEffectSizeZ() {
        return 0;
    }

    public MorphoFilter Clone() {
        OpenSegmentX clone = new OpenSegmentX();
        clone.Parameters(this.sewidth);
        return clone;
    }

    private class Open3dSegmentXThread
    extends Thread {
        private int size = 0;
        private int miny;
        private int minz;
        private int maxy;
        private int maxz;
        private int width;
        private int layer;
        private DV source;
        private DV result;
        private Node[] MyStack = null;
        public Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            Arrays.fill(this.MyStack, null);
            this.MyStack = null;
            this.result = null;
            this.source = null;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(DV source, DV result, int sewidth, int minz, int maxz) {
            this.source = source;
            this.result = result;
            this.size = sewidth;
            this.miny = 0;
            this.minz = minz;
            this.maxy = source.SizeY;
            this.maxz = maxz;
            this.width = source.SizeX;
            this.layer = source.LayerSize;
            switch (source.Type) {
                case 8: {
                    if (this.MyStack != null && this.MyStack.length == 256) break;
                    this.MyStack = null;
                    this.MyStack = new Node[256];
                    break;
                }
                case 16: {
                    if (this.MyStack != null && this.MyStack.length == 65536) break;
                    this.MyStack = null;
                    this.MyStack = new Node[65536];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported DV type.");
                }
            }
            if (this.MyStack[0] == null) {
                for (int i2 = 0; i2 < this.MyStack.length; ++i2) {
                    this.MyStack[i2] = new Node();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block9: while (true) lbl-1000:
            // 3 sources

            {
                var11_11 = this.lock;
                synchronized (var11_11) {
                    try {
                        OpenSegmentX.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                switch (this.source.Type) {
                    case 8: {
                        c = 0;
                        while (true) {
                            if (c >= this.source.Channel) ** GOTO lbl-1000
                            bytebufferin = this.source.getDataBufferByte(c);
                            bytebufferout = this.result.getDataBufferByte(c);
                            pos = F = this.minz * this.layer;
                            for (z = this.minz; z < this.maxz; ++z) {
                                y = this.miny;
                                while (y < this.maxy) {
                                    stackSize = 1;
                                    this.MyStack[0].Value = val = bytebufferin[F++] & 255;
                                    this.MyStack[0].StartPos = 0;
                                    this.MyStack[0].Passed = 0;
                                    rp = 1;
                                    while (rp < this.width) {
                                        val = bytebufferin[F] & 255;
                                        if (val > this.MyStack[stackSize - 1].Value) {
                                            this.MyStack[stackSize].StartPos = rp;
                                            this.MyStack[stackSize].Passed = 0;
                                            this.MyStack[stackSize++].Value = val;
                                        } else {
                                            while (val < this.MyStack[stackSize - 1].Value) {
                                                if (this.MyStack[--stackSize].Passed != 0 || rp - this.MyStack[stackSize].StartPos >= this.size) {
                                                    for (k = 0; k < stackSize; ++k) {
                                                        for (i = this.MyStack[k].StartPos; i < this.MyStack[k + 1].StartPos; ++i) {
                                                            bytebufferout[i + pos] = (byte)this.MyStack[k].Value;
                                                        }
                                                    }
                                                    for (i = this.MyStack[stackSize].StartPos; i < rp; ++i) {
                                                        bytebufferout[i + pos] = (byte)this.MyStack[stackSize].Value;
                                                    }
                                                    this.MyStack[0].StartPos = rp;
                                                    this.MyStack[0].Passed = 1;
                                                    this.MyStack[0].Value = val;
                                                    stackSize = 1;
                                                    break;
                                                }
                                                if (stackSize != 0 && val <= this.MyStack[stackSize - 1].Value) continue;
                                                this.MyStack[stackSize++].Value = val;
                                                break;
                                            }
                                        }
                                        ++rp;
                                        ++F;
                                    }
                                    if (rp - this.MyStack[0].StartPos >= this.size) ** GOTO lbl65
                                    for (i = this.MyStack[0].StartPos; i < rp; ++i) {
                                        bytebufferout[i + pos] = (byte)this.MyStack[0].Value;
                                    }
                                    ** GOTO lbl78
lbl65:
                                    // 2 sources

                                    while (stackSize != 0) {
                                        if (rp - this.MyStack[stackSize - 1].StartPos < this.size) ** GOTO lbl76
                                        for (k = 0; k < stackSize - 1; ++k) {
                                            for (i = this.MyStack[k].StartPos; i < this.MyStack[k + 1].StartPos; ++i) {
                                                bytebufferout[i + pos] = (byte)this.MyStack[k].Value;
                                            }
                                        }
                                        for (i = this.MyStack[stackSize - 1].StartPos; i < rp; ++i) {
                                            bytebufferout[i + pos] = (byte)this.MyStack[stackSize - 1].Value;
                                        }
                                        break;
lbl76:
                                        // 1 sources

                                        --stackSize;
                                    }
lbl78:
                                    // 3 sources

                                    ++y;
                                    pos += this.width;
                                }
                            }
                            bytebufferout = null;
                            bytebufferin = null;
                            ++c;
                        }
                    }
                    case 16: {
                        c = 0;
                        while (true) {
                            if (c >= this.source.Channel) continue block9;
                            shortbufferin = this.source.getDataBufferShort(c);
                            shortbufferout = this.result.getDataBufferShort(c);
                            pos = F = this.minz * this.layer;
                            for (z = this.minz; z < this.maxz; ++z) {
                                y = this.miny;
                                while (y < this.maxy) {
                                    stackSize = 1;
                                    this.MyStack[0].Value = val = shortbufferin[F++] & 65535;
                                    this.MyStack[0].StartPos = 0;
                                    this.MyStack[0].Passed = 0;
                                    rp = 1;
                                    while (rp < this.width) {
                                        val = shortbufferin[F] & 65535;
                                        if (val > this.MyStack[stackSize - 1].Value) {
                                            this.MyStack[stackSize].StartPos = rp;
                                            this.MyStack[stackSize].Passed = 0;
                                            this.MyStack[stackSize++].Value = val;
                                        } else {
                                            while (val < this.MyStack[stackSize - 1].Value) {
                                                if (this.MyStack[--stackSize].Passed != 0 || rp - this.MyStack[stackSize].StartPos >= this.size) {
                                                    for (k = 0; k < stackSize; ++k) {
                                                        for (i = this.MyStack[k].StartPos; i < this.MyStack[k + 1].StartPos; ++i) {
                                                            shortbufferout[i + pos] = (short)this.MyStack[k].Value;
                                                        }
                                                    }
                                                    for (i = this.MyStack[stackSize].StartPos; i < rp; ++i) {
                                                        shortbufferout[i + pos] = (short)this.MyStack[stackSize].Value;
                                                    }
                                                    this.MyStack[0].StartPos = rp;
                                                    this.MyStack[0].Passed = 1;
                                                    this.MyStack[0].Value = val;
                                                    stackSize = 1;
                                                    break;
                                                }
                                                if (stackSize != 0 && val <= this.MyStack[stackSize - 1].Value) continue;
                                                this.MyStack[stackSize++].Value = val;
                                                break;
                                            }
                                        }
                                        ++rp;
                                        ++F;
                                    }
                                    if (rp - this.MyStack[0].StartPos >= this.size) ** GOTO lbl134
                                    for (i = this.MyStack[0].StartPos; i < rp; ++i) {
                                        shortbufferout[i + pos] = (short)this.MyStack[0].Value;
                                    }
                                    ** GOTO lbl147
lbl134:
                                    // 2 sources

                                    while (stackSize != 0) {
                                        if (rp - this.MyStack[stackSize - 1].StartPos < this.size) ** GOTO lbl145
                                        for (k = 0; k < stackSize - 1; ++k) {
                                            for (i = this.MyStack[k].StartPos; i < this.MyStack[k + 1].StartPos; ++i) {
                                                shortbufferout[i + pos] = (short)this.MyStack[k].Value;
                                            }
                                        }
                                        for (i = this.MyStack[stackSize - 1].StartPos; i < rp; ++i) {
                                            shortbufferout[i + pos] = (short)this.MyStack[stackSize - 1].Value;
                                        }
                                        break;
lbl145:
                                        // 1 sources

                                        --stackSize;
                                    }
lbl147:
                                    // 3 sources

                                    ++y;
                                    pos += this.width;
                                }
                            }
                            shortbufferout = null;
                            shortbufferin = null;
                            ++c;
                        }
                    }
                }
                break;
            }
            throw new IllegalArgumentException("DV type not supported.");
        }

        private class Node {
            public int Value = 0;
            public int StartPos = 0;
            public int Passed = 0;

            private Node() {
            }
        }
    }

    private class OpenSegmentXThread
    extends Thread {
        private WritableRaster wr = null;
        private WritableRaster wrres = null;
        private int channel = 0;
        private int size = 0;
        private int miny;
        private int maxy;
        private int type;
        private int width;
        private short[] shortbufferin = null;
        private short[] shortbufferout = null;
        private byte[] bytebufferin = null;
        private byte[] bytebufferout = null;
        private Node[] MyStack = null;
        public Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            Arrays.fill(this.MyStack, null);
            this.MyStack = null;
            this.wrres = null;
            this.wr = null;
            this.bytebufferout = null;
            this.bytebufferin = null;
            this.shortbufferout = null;
            this.shortbufferin = null;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(BufferedImage source, BufferedImage result, int sewidth, int miny, int maxy) {
            this.size = sewidth;
            this.miny = miny;
            this.maxy = maxy;
            this.type = source.getType();
            this.width = source.getWidth();
            this.bytebufferout = null;
            this.bytebufferin = null;
            this.shortbufferout = null;
            this.shortbufferin = null;
            this.wrres = null;
            this.wr = null;
            switch (source.getType()) {
                case 12: {
                    this.wr = source.getRaster();
                    this.wrres = result.getRaster();
                    if (this.MyStack != null && this.MyStack.length == 2) break;
                    this.MyStack = null;
                    this.MyStack = new Node[2];
                    break;
                }
                case 5: 
                case 6: 
                case 10: {
                    this.bytebufferin = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                    this.bytebufferout = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                    this.channel = source.getRaster().getNumBands();
                    if (this.MyStack != null && this.MyStack.length == 256) break;
                    this.MyStack = null;
                    this.MyStack = new Node[256];
                    break;
                }
                case 11: {
                    this.shortbufferin = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                    this.shortbufferout = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                    if (this.MyStack != null && this.MyStack.length == 65536) break;
                    this.MyStack = null;
                    this.MyStack = new Node[65536];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image type.");
                }
            }
            if (this.MyStack[0] == null) {
                for (int i2 = 0; i2 < this.MyStack.length; ++i2) {
                    this.MyStack[i2] = new Node();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block11: while (true) lbl-1000:
            // 5 sources

            {
                var10_10 = this.lock;
                synchronized (var10_10) {
                    try {
                        OpenSegmentX.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                switch (this.type) {
                    case 12: {
                        j = this.miny;
                        while (true) {
                            if (j >= this.maxy) ** GOTO lbl-1000
                            F = 0;
                            stackSize = 1;
                            this.MyStack[0].Value = val = this.wr.getSample(F++, j, 0);
                            this.MyStack[0].StartPos = 0;
                            this.MyStack[0].Passed = 0;
                            rp = 1;
                            while (rp < this.width) {
                                val = this.wr.getSample(F, j, 0);
                                if (val > this.MyStack[stackSize - 1].Value) {
                                    this.MyStack[stackSize].StartPos = rp;
                                    this.MyStack[stackSize].Passed = 0;
                                    this.MyStack[stackSize++].Value = val;
                                } else {
                                    while (val < this.MyStack[stackSize - 1].Value) {
                                        if (this.MyStack[--stackSize].Passed != 0 || rp - this.MyStack[stackSize].StartPos >= this.size) {
                                            for (k = 0; k < stackSize; ++k) {
                                                for (i = this.MyStack[k].StartPos; i < this.MyStack[k + 1].StartPos; ++i) {
                                                    this.wrres.setSample(i, j, 0, this.MyStack[k].Value);
                                                }
                                            }
                                            for (i = this.MyStack[stackSize].StartPos; i < rp; ++i) {
                                                this.wrres.setSample(i, j, 0, this.MyStack[stackSize].Value);
                                            }
                                            this.MyStack[0].StartPos = rp;
                                            this.MyStack[0].Passed = 1;
                                            this.MyStack[0].Value = val;
                                            stackSize = 1;
                                            break;
                                        }
                                        if (stackSize != 0 && val <= this.MyStack[stackSize - 1].Value) continue;
                                        this.MyStack[stackSize++].Value = val;
                                        break;
                                    }
                                }
                                ++rp;
                                ++F;
                            }
                            if (rp - this.MyStack[0].StartPos >= this.size) ** GOTO lbl60
                            for (i = this.MyStack[0].StartPos; i < rp; ++i) {
                                this.wrres.setSample(i, j, 0, this.MyStack[0].Value);
                            }
                            ** GOTO lbl73
lbl60:
                            // 2 sources

                            while (stackSize != 0) {
                                if (rp - this.MyStack[stackSize - 1].StartPos < this.size) ** GOTO lbl71
                                for (k = 0; k < stackSize - 1; ++k) {
                                    for (i = this.MyStack[k].StartPos; i < this.MyStack[k + 1].StartPos; ++i) {
                                        this.wrres.setSample(i, j, 0, this.MyStack[k].Value);
                                    }
                                }
                                for (i = this.MyStack[stackSize - 1].StartPos; i < rp; ++i) {
                                    this.wrres.setSample(i, j, 0, this.MyStack[stackSize - 1].Value);
                                }
                                break;
lbl71:
                                // 1 sources

                                --stackSize;
                            }
lbl73:
                            // 3 sources

                            ++j;
                        }
                    }
                    case 10: {
                        j = this.miny;
                        pos = F = this.miny * this.width;
                        while (true) {
                            if (j >= this.maxy) ** GOTO lbl-1000
                            stackSize = 1;
                            this.MyStack[0].Value = val = this.bytebufferin[F++] & 255;
                            this.MyStack[0].StartPos = 0;
                            this.MyStack[0].Passed = 0;
                            rp = 1;
                            while (rp < this.width) {
                                val = this.bytebufferin[F] & 255;
                                if (val > this.MyStack[stackSize - 1].Value) {
                                    this.MyStack[stackSize].StartPos = rp;
                                    this.MyStack[stackSize].Passed = 0;
                                    this.MyStack[stackSize++].Value = val;
                                } else {
                                    while (val < this.MyStack[stackSize - 1].Value) {
                                        if (this.MyStack[--stackSize].Passed != 0 || rp - this.MyStack[stackSize].StartPos >= this.size) {
                                            for (k = 0; k < stackSize; ++k) {
                                                for (i = this.MyStack[k].StartPos; i < this.MyStack[k + 1].StartPos; ++i) {
                                                    this.bytebufferout[i + pos] = (byte)this.MyStack[k].Value;
                                                }
                                            }
                                            for (i = this.MyStack[stackSize].StartPos; i < rp; ++i) {
                                                this.bytebufferout[i + pos] = (byte)this.MyStack[stackSize].Value;
                                            }
                                            this.MyStack[0].StartPos = rp;
                                            this.MyStack[0].Passed = 1;
                                            this.MyStack[0].Value = val;
                                            stackSize = 1;
                                            break;
                                        }
                                        if (stackSize != 0 && val <= this.MyStack[stackSize - 1].Value) continue;
                                        this.MyStack[stackSize++].Value = val;
                                        break;
                                    }
                                }
                                ++rp;
                                ++F;
                            }
                            if (rp - this.MyStack[0].StartPos >= this.size) ** GOTO lbl118
                            for (i = this.MyStack[0].StartPos; i < rp; ++i) {
                                this.bytebufferout[i + pos] = (byte)this.MyStack[0].Value;
                            }
                            ** GOTO lbl131
lbl118:
                            // 2 sources

                            while (stackSize != 0) {
                                if (rp - this.MyStack[stackSize - 1].StartPos < this.size) ** GOTO lbl129
                                for (k = 0; k < stackSize - 1; ++k) {
                                    for (i = this.MyStack[k].StartPos; i < this.MyStack[k + 1].StartPos; ++i) {
                                        this.bytebufferout[i + pos] = (byte)this.MyStack[k].Value;
                                    }
                                }
                                for (i = this.MyStack[stackSize - 1].StartPos; i < rp; ++i) {
                                    this.bytebufferout[i + pos] = (byte)this.MyStack[stackSize - 1].Value;
                                }
                                break;
lbl129:
                                // 1 sources

                                --stackSize;
                            }
lbl131:
                            // 3 sources

                            ++j;
                            pos += this.width;
                        }
                    }
                    case 11: {
                        j = this.miny;
                        pos = F = this.miny * this.width;
                        while (true) {
                            if (j >= this.maxy) ** GOTO lbl-1000
                            stackSize = 1;
                            this.MyStack[0].Value = val = this.shortbufferin[F++] & 65535;
                            this.MyStack[0].StartPos = 0;
                            this.MyStack[0].Passed = 0;
                            rp = 1;
                            while (rp < this.width) {
                                val = this.shortbufferin[F] & 65535;
                                if (val > this.MyStack[stackSize - 1].Value) {
                                    this.MyStack[stackSize].StartPos = rp;
                                    this.MyStack[stackSize].Passed = 0;
                                    this.MyStack[stackSize++].Value = val;
                                } else {
                                    while (val < this.MyStack[stackSize - 1].Value) {
                                        if (this.MyStack[--stackSize].Passed != 0 || rp - this.MyStack[stackSize].StartPos >= this.size) {
                                            for (k = 0; k < stackSize; ++k) {
                                                for (i = this.MyStack[k].StartPos; i < this.MyStack[k + 1].StartPos; ++i) {
                                                    this.shortbufferout[i + pos] = (short)this.MyStack[k].Value;
                                                }
                                            }
                                            for (i = this.MyStack[stackSize].StartPos; i < rp; ++i) {
                                                this.shortbufferout[i + pos] = (short)this.MyStack[stackSize].Value;
                                            }
                                            this.MyStack[0].StartPos = rp;
                                            this.MyStack[0].Passed = 1;
                                            this.MyStack[0].Value = val;
                                            stackSize = 1;
                                            break;
                                        }
                                        if (stackSize != 0 && val <= this.MyStack[stackSize - 1].Value) continue;
                                        this.MyStack[stackSize++].Value = val;
                                        break;
                                    }
                                }
                                ++rp;
                                ++F;
                            }
                            if (rp - this.MyStack[0].StartPos >= this.size) ** GOTO lbl177
                            for (i = this.MyStack[0].StartPos; i < rp; ++i) {
                                this.shortbufferout[i + pos] = (short)this.MyStack[0].Value;
                            }
                            ** GOTO lbl190
lbl177:
                            // 2 sources

                            while (stackSize != 0) {
                                if (rp - this.MyStack[stackSize - 1].StartPos < this.size) ** GOTO lbl188
                                for (k = 0; k < stackSize - 1; ++k) {
                                    for (i = this.MyStack[k].StartPos; i < this.MyStack[k + 1].StartPos; ++i) {
                                        this.shortbufferout[i + pos] = (short)this.MyStack[k].Value;
                                    }
                                }
                                for (i = this.MyStack[stackSize - 1].StartPos; i < rp; ++i) {
                                    this.shortbufferout[i + pos] = (short)this.MyStack[stackSize - 1].Value;
                                }
                                break;
lbl188:
                                // 1 sources

                                --stackSize;
                            }
lbl190:
                            // 3 sources

                            ++j;
                            pos += this.width;
                        }
                    }
                    case 5: 
                    case 6: {
                        widthchannel = this.width * this.channel;
                        j = this.miny;
                        while (true) {
                            if (j >= this.maxy) continue block11;
                            block46: for (c = 0; c < this.channel; ++c) {
                                pos = F = j * widthchannel + c;
                                stackSize = 1;
                                this.MyStack[0].Value = val = this.bytebufferin[F] & 255;
                                this.MyStack[0].StartPos = 0;
                                this.MyStack[0].Passed = 0;
                                F += this.channel;
                                rp = 1;
                                while (rp < this.width) {
                                    val = this.bytebufferin[F] & 255;
                                    if (val > this.MyStack[stackSize - 1].Value) {
                                        this.MyStack[stackSize].StartPos = rp;
                                        this.MyStack[stackSize].Passed = 0;
                                        this.MyStack[stackSize++].Value = val;
                                    } else {
                                        while (val < this.MyStack[stackSize - 1].Value) {
                                            if (this.MyStack[--stackSize].Passed != 0 || rp - this.MyStack[stackSize].StartPos >= this.size) {
                                                for (k = 0; k < stackSize; ++k) {
                                                    i = this.MyStack[k].StartPos;
                                                    ichan = i * this.channel;
                                                    while (i < this.MyStack[k + 1].StartPos) {
                                                        this.bytebufferout[ichan + pos] = (byte)this.MyStack[k].Value;
                                                        ++i;
                                                        ichan += this.channel;
                                                    }
                                                }
                                                i = this.MyStack[stackSize].StartPos;
                                                ichan = i * this.channel;
                                                while (i < rp) {
                                                    this.bytebufferout[ichan + pos] = (byte)this.MyStack[stackSize].Value;
                                                    ++i;
                                                    ichan += this.channel;
                                                }
                                                this.MyStack[0].StartPos = rp;
                                                this.MyStack[0].Passed = 1;
                                                this.MyStack[0].Value = val;
                                                stackSize = 1;
                                                break;
                                            }
                                            if (stackSize != 0 && this.MyStack[stackSize - 1].Value >= val) continue;
                                            this.MyStack[stackSize++].Value = val;
                                            break;
                                        }
                                    }
                                    ++rp;
                                    F += this.channel;
                                }
                                if (rp - this.MyStack[0].StartPos < this.size) {
                                    i = this.MyStack[0].StartPos;
                                    ichan = i * this.channel;
                                    while (i < rp) {
                                        this.bytebufferout[ichan + pos] = (byte)this.MyStack[0].Value;
                                        ++i;
                                        ichan += this.channel;
                                    }
                                    continue;
                                }
                                while (stackSize != 0) {
                                    if (this.size <= rp - this.MyStack[stackSize - 1].StartPos) {
                                        for (k = 0; k < stackSize - 1; ++k) {
                                            i = this.MyStack[k].StartPos;
                                            ichan = i * this.channel;
                                            while (i < this.MyStack[k + 1].StartPos) {
                                                this.bytebufferout[ichan + pos] = (byte)this.MyStack[k].Value;
                                                ++i;
                                                ichan += this.channel;
                                            }
                                        }
                                        i = this.MyStack[stackSize - 1].StartPos;
                                        ichan = i * this.channel;
                                        while (i < rp) {
                                            this.bytebufferout[ichan + pos] = (byte)this.MyStack[stackSize - 1].Value;
                                            ++i;
                                            ichan += this.channel;
                                        }
                                        continue block46;
                                    }
                                    --stackSize;
                                }
                            }
                            ++j;
                        }
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Image type not supported.");
        }

        private class Node {
            public int Value = 0;
            public int StartPos = 0;
            public int Passed = 0;

            private Node() {
            }
        }
    }
}

