/*
 * Decompiled with CFR 0.152.
 */
package morphee.fastMorphee;

import dv.DV;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import sun.misc.Unsafe;

public class DilateSegmentXUnsafe
implements MorphoFilter {
    private DilateSegmentHorizontalThread[] threads = null;
    private int nbFreeThreads = 0;
    private int sewidth = 0;

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage Original, BufferedImage Result, int nbCPU) {
        if (this.sewidth == 0) {
            throw new IllegalArgumentException("Structuring element's width not defined or less/equals than 0.");
        }
        this.Filter(Original, this.sewidth, Result, nbCPU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Filter(BufferedImage source, int sewidth, BufferedImage result, int nbCPU) {
        Object object;
        int i2;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Image source and result have different dimensions.");
        }
        this.sewidth = sewidth;
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new DilateSegmentHorizontalThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threads[i2] = new DilateSegmentHorizontalThread();
                this.threads[i2].start();
            }
            DilateSegmentXUnsafe dilateSegmentXUnsafe = this;
            synchronized (dilateSegmentXUnsafe) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = source.getHeight() / nbCPU;
        for (i2 = 0; i2 < nbCPU - 1; ++i2) {
            this.threads[i2].setConditions(source, result, sewidth, i2 * step, (i2 + 1) * step);
            object = this.threads[i2].lock;
            synchronized (object) {
                this.threads[i2].lock.notify();
                continue;
            }
        }
        this.threads[i2].setConditions(source, result, sewidth, i2 * step, source.getHeight());
        object = this.threads[i2].lock;
        synchronized (object) {
            this.threads[i2].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    public StructuringElement getStructuringElement() {
        return null;
    }

    public void setStructuringElement(StructuringElement se) {
        this.sewidth = 2 * se.getOrder() + 1;
    }

    public void Marker(BufferedImage marker) {
    }

    public BufferedImage Marker() {
        return null;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.sewidth = (Integer)parameters[0];
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(this.sewidth);
        return params;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public MorphoFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    private class DilateSegmentHorizontalThread
    extends Thread {
        private WritableRaster wr = null;
        private WritableRaster wrres = null;
        private int channel = 0;
        private int sewidth = 0;
        private int miny;
        private int maxy;
        private int type;
        private int width;
        private int[] buffer = null;
        private short[] shortbufferin = null;
        private short[] shortbufferout = null;
        private byte[] bytebufferin = null;
        private byte[] bytebufferout = null;
        private int[] Hist = new int[256];
        public Object lock = new Object();
        private Unsafe unsafe = null;

        public DilateSegmentHorizontalThread() {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                this.unsafe = (Unsafe)field.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }

        public void setConditions(BufferedImage Original, BufferedImage Result, int sewidth, int miny, int maxy) {
            this.sewidth = sewidth / 2;
            this.miny = miny;
            this.maxy = maxy;
            this.type = Original.getType();
            this.width = Original.getWidth();
            this.bytebufferout = null;
            this.bytebufferin = null;
            this.shortbufferout = null;
            this.shortbufferin = null;
            this.wrres = null;
            this.wr = null;
            switch (Original.getType()) {
                case 12: {
                    this.wr = Original.getRaster();
                    this.wrres = Result.getRaster();
                    if (this.buffer != null && this.buffer.length == this.width) break;
                    this.buffer = null;
                    this.buffer = new int[this.width];
                    break;
                }
                case 5: 
                case 6: 
                case 10: {
                    this.bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                    this.bytebufferout = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                    this.channel = Original.getRaster().getNumBands();
                    break;
                }
                case 11: {
                    this.shortbufferin = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                    this.shortbufferout = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                    if (this.buffer != null && this.buffer.length == this.width) break;
                    this.buffer = null;
                    this.buffer = new int[this.width];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image type.");
                }
            }
            Arrays.fill(this.Hist, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block11: while (true) lbl-1000:
            // 5 sources

            {
                var17_17 = this.lock;
                synchronized (var17_17) {
                    try {
                        DilateSegmentXUnsafe.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                switch (this.type) {
                    case 12: {
                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) ** GOTO lbl-1000
                            T = 0;
                            G = 0;
                            nbprop = 0;
                            for (x = 0; x < this.width; ++x) {
                                T_pre = T;
                                G_pre = G;
                                rowval = this.wr.getSample(x, y, 0);
                                T = x > this.width - this.sewidth - 1 ? (T_pre < rowval ? rowval : T_pre) : 0;
                                if (G_pre > rowval && nbprop < this.sewidth) {
                                    G = G_pre;
                                    ++nbprop;
                                } else {
                                    G = x > this.width - this.sewidth - 1 && nbprop >= this.sewidth ? T : rowval;
                                    T = 0;
                                    nbprop = 0;
                                }
                                this.buffer[this.width - x - 1] = x - this.sewidth < 0 ? G : Math.max(G, this.wr.getSample(x - this.sewidth, y, 0));
                            }
                            T = 0;
                            G = 0;
                            nbprop = 0;
                            rowval = 0;
                            rowval_pre = 0;
                            for (x = 0; x < this.width; ++x) {
                                T_pre = T;
                                G_pre = G;
                                rowval_pre = rowval;
                                rowval = this.buffer[x];
                                T = x == 0 ? rowval : (rowval > rowval_pre && T < rowval ? rowval : T_pre);
                                if (G_pre > rowval && nbprop < this.sewidth) {
                                    G = G_pre;
                                    ++nbprop;
                                } else {
                                    G = nbprop >= this.sewidth ? T : rowval;
                                    T = 0;
                                    nbprop = 0;
                                }
                                if (x < this.sewidth) {
                                    this.wrres.setSample(this.width - x - 1, y, 0, G);
                                    continue;
                                }
                                this.wrres.setSample(this.width - x - 1, y, 0, Math.max(G, this.buffer[x - this.sewidth]));
                            }
                            ++y;
                        }
                    }
                    case 10: {
                        bytebufferin0 = this.unsafe.arrayBaseOffset(this.bytebufferin.getClass());
                        bytebufferout0 = this.unsafe.arrayBaseOffset(this.bytebufferout.getClass());
                        scale = this.unsafe.arrayIndexScale(this.bytebufferin.getClass());
                        hist0 = this.unsafe.arrayBaseOffset(this.Hist.getClass());
                        s = this.unsafe.arrayIndexScale(this.Hist.getClass());
                        sewidthscale = this.sewidth * scale;
                        bbiPses = bytebufferin0 + sewidthscale;
                        bbiLses = bytebufferin0 - sewidthscale;
                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) ** GOTO lbl-1000
                            maxi = 0;
                            pos = y * this.width;
                            end = pos + this.sewidth;
                            x = pos;
                            adr = bytebufferin0 + (long)(pos * scale);
                            while (x < end) {
                                aux = this.unsafe.getByte(this.bytebufferin, adr) & 255;
                                t = hist0 + (long)aux * s;
                                this.unsafe.putInt(this.Hist, t, this.unsafe.getInt(this.Hist, t) + 1);
                                if (aux > maxi) {
                                    maxi = aux;
                                }
                                ++x;
                                adr += (long)scale;
                            }
                            x = pos;
                            adr = pos * scale;
                            while (x < end) {
                                aux = this.unsafe.getByte(this.bytebufferin, bbiPses + adr) & 255;
                                t = hist0 + (long)aux * s;
                                this.unsafe.putInt(this.Hist, t, this.unsafe.getInt(this.Hist, t) + 1);
                                if (aux > maxi) {
                                    maxi = aux;
                                }
                                this.unsafe.putByte(this.bytebufferout, bytebufferout0 + adr, (byte)maxi);
                                ++x;
                                adr += (long)scale;
                            }
                            start = pos + this.sewidth;
                            end = pos + this.width - this.sewidth;
                            x = start;
                            adr = start * scale;
                            while (x < end) {
                                v0 = aux = this.unsafe.getByte(this.bytebufferin, bbiPses + adr) & 255;
                                this.Hist[v0] = this.Hist[v0] + 1;
                                if (aux > maxi) {
                                    maxi = aux;
                                }
                                this.unsafe.putByte(this.bytebufferout, bytebufferout0 + adr, (byte)maxi);
                                v1 = this.unsafe.getByte(this.bytebufferin, bbiLses + adr) & 255;
                                this.Hist[v1] = this.Hist[v1] - 1;
                                while (this.Hist[maxi] == 0) {
                                    --maxi;
                                }
                                ++x;
                                adr += (long)scale;
                            }
                            start = end;
                            end = pos + this.width;
                            x = start;
                            adr = start * scale;
                            while (x < end) {
                                this.unsafe.putByte(this.bytebufferout, bytebufferout0 + adr, (byte)maxi);
                                v2 = this.unsafe.getByte(this.bytebufferin, bbiLses + adr) & 255;
                                this.Hist[v2] = this.Hist[v2] - 1;
                                while (this.Hist[maxi] == 0) {
                                    --maxi;
                                }
                                ++x;
                                adr += (long)scale;
                            }
                            x = start;
                            adr = bytebufferin0 + (long)(start * scale);
                            while (x < end) {
                                v3 = this.unsafe.getByte(this.bytebufferin, adr) & 255;
                                this.Hist[v3] = this.Hist[v3] - 1;
                                ++x;
                                adr += (long)scale;
                            }
                            ++y;
                        }
                    }
                    case 11: {
                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) ** GOTO lbl-1000
                            pos = y * this.width;
                            T = 0;
                            G = 0;
                            nbprop = 0;
                            for (x = 0; x < this.width; ++x) {
                                T_pre = T;
                                G_pre = G;
                                rowval = this.shortbufferin[pos + x] & 65535;
                                T = x > this.width - this.sewidth - 1 ? (T_pre < rowval ? rowval : T_pre) : 0;
                                if (G_pre > rowval && nbprop < this.sewidth) {
                                    G = G_pre;
                                    ++nbprop;
                                } else {
                                    G = x > this.width - this.sewidth - 1 && nbprop >= this.sewidth ? T : rowval;
                                    T = 0;
                                    nbprop = 0;
                                }
                                this.buffer[this.width - x - 1] = x - this.sewidth < 0 ? G : Math.max(G, this.shortbufferin[pos + x - this.sewidth] & 65535);
                            }
                            T = 0;
                            G = 0;
                            nbprop = 0;
                            rowval = 0;
                            rowval_pre = 0;
                            for (x = 0; x < this.width; ++x) {
                                T_pre = T;
                                G_pre = G;
                                rowval_pre = rowval;
                                rowval = this.buffer[x];
                                T = x == 0 ? rowval : (rowval > rowval_pre && T < rowval ? rowval : T_pre);
                                if (G_pre > rowval && nbprop < this.sewidth) {
                                    G = G_pre;
                                    ++nbprop;
                                } else {
                                    G = nbprop >= this.sewidth ? T : rowval;
                                    T = 0;
                                    nbprop = 0;
                                }
                                this.shortbufferout[pos + this.width - x - 1] = x < this.sewidth ? (short)G : (short)Math.max(G, this.buffer[x - this.sewidth]);
                            }
                            ++y;
                        }
                    }
                    case 5: 
                    case 6: {
                        sewidthchannel = this.sewidth * this.channel;
                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) continue block11;
                            for (c = 0; c < this.channel; ++c) {
                                maxi = 0;
                                pos = y * this.width;
                                end = (pos + this.sewidth) * this.channel + c;
                                for (x = pos * this.channel + c; x < end; x += this.channel) {
                                    v4 = aux = this.bytebufferin[x] & 255;
                                    this.Hist[v4] = this.Hist[v4] + 1;
                                    if (aux <= maxi) continue;
                                    maxi = aux;
                                }
                                for (x = pos * this.channel + c; x < end; x += this.channel) {
                                    v5 = aux = this.bytebufferin[x + sewidthchannel] & 255;
                                    this.Hist[v5] = this.Hist[v5] + 1;
                                    if (aux > maxi) {
                                        maxi = aux;
                                    }
                                    this.bytebufferout[x] = (byte)maxi;
                                }
                                start = end;
                                end = (pos + this.width - this.sewidth) * this.channel + c;
                                for (x = start; x < end; x += this.channel) {
                                    v6 = aux = this.bytebufferin[x + sewidthchannel] & 255;
                                    this.Hist[v6] = this.Hist[v6] + 1;
                                    if (aux > maxi) {
                                        maxi = aux;
                                    }
                                    this.bytebufferout[x] = (byte)maxi;
                                    v7 = this.bytebufferin[x - sewidthchannel] & 255;
                                    this.Hist[v7] = this.Hist[v7] - 1;
                                    while (this.Hist[maxi] == 0) {
                                        --maxi;
                                    }
                                }
                                start = end;
                                end = (pos + this.width) * this.channel + c;
                                for (x = start; x < end; x += this.channel) {
                                    this.bytebufferout[x] = (byte)maxi;
                                    v8 = this.bytebufferin[x - sewidthchannel] & 255;
                                    this.Hist[v8] = this.Hist[v8] - 1;
                                    while (this.Hist[maxi] == 0) {
                                        --maxi;
                                    }
                                }
                                for (x = start; x < end; x += this.channel) {
                                    v9 = this.bytebufferin[x] & 255;
                                    this.Hist[v9] = this.Hist[v9] - 1;
                                }
                            }
                            ++y;
                        }
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Image type not supported.");
        }
    }
}

