/*
 * Decompiled with CFR 0.152.
 */
package morphee.adaptive;

import arrayTiTi.ArrayFeatures;
import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;

public class DilateConstrained
implements MorphoFilter {
    private StructuringElement[] SE = null;
    private DilateConstraintThread[] threads = null;
    private int nbFreeThreads = 0;
    private int[] orders = null;
    private int setype = 0;
    private final ArrayFeatures AF = new ArrayFeatures();

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement SE, int[] orders, int nbCPU) {
        this.Parameters(SE, orders);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement SE, int[] orders, BufferedImage result, int nbCPU) {
        this.Parameters(SE, orders);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        Object object;
        int i2;
        if (nbCPU < 1) {
            throw new IllegalArgumentException("nbCPU < 1.");
        }
        if (this.SE == null) {
            throw new IllegalArgumentException("Any structuring element defined.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result must have identic dimensions and types.");
        }
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new DilateConstraintThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threads[i2] = new DilateConstraintThread();
                this.threads[i2].start();
            }
            DilateConstrained dilateConstrained = this;
            synchronized (dilateConstrained) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = source.getHeight() / nbCPU;
        for (i2 = 0; i2 < nbCPU - 1; ++i2) {
            this.threads[i2].setConditions(source, result, 0, i2 * step, source.getWidth(), (i2 + 1) * step);
            object = this.threads[i2].lock;
            synchronized (object) {
                this.threads[i2].lock.notify();
                continue;
            }
        }
        this.threads[i2].setConditions(source, result, 0, i2 * step, source.getWidth(), source.getHeight());
        object = this.threads[i2].lock;
        synchronized (object) {
            this.threads[i2].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public MorphoFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    public StructuringElement getStructuringElement() {
        return null;
    }

    public void setStructuringElement(StructuringElement SE) {
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("Exactly 2 parameters required.");
        }
        this.AnalyseOrders((StructuringElement)parameters[0], (int[])parameters[1]);
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(this.SE);
        return params;
    }

    private void AnalyseOrders(StructuringElement se, int[] orders) {
        this.orders = orders;
        int max = this.AF.Maximum(orders);
        if (this.SE == null || this.SE.length <= max || this.setype != se.getType()) {
            this.SE = null;
            this.SE = new StructuringElement[max + 1];
            this.setype = se.getType();
        }
        for (int y = 0; y < orders.length; ++y) {
            if (0 >= orders[y] || this.SE[orders[y]] != null) continue;
            this.SE[orders[y]] = new StructuringElement(new Object[]{orders[y], se.getType(), se.getOrientation()});
        }
    }

    private class DilateConstraintThread
    extends Thread {
        private WritableRaster wro = null;
        private WritableRaster wrr = null;
        private CoordinatesWeighted[] se = null;
        private int minx;
        private int miny;
        private int maxx;
        private int maxy;
        private int type;
        private int width;
        private int height;
        private short[] shortbufferin = null;
        private short[] shortbufferout = null;
        private byte[] bytebufferin = null;
        private byte[] bytebufferout = null;
        public final Object lock = new Object();

        public void setConditions(BufferedImage Original, BufferedImage Result, int minx, int miny, int maxx, int maxy) {
            this.minx = minx;
            this.miny = miny;
            this.maxx = maxx;
            this.maxy = maxy;
            this.width = Original.getWidth();
            this.height = Original.getHeight();
            this.type = Original.getType();
            switch (Original.getType()) {
                case 12: {
                    this.wro = Original.getRaster();
                    this.wrr = Result.getRaster();
                    break;
                }
                case 10: {
                    this.bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                    this.bytebufferout = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                    break;
                }
                case 11: {
                    this.shortbufferin = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                    this.shortbufferout = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image type.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        DilateConstrained.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                switch (this.type) {
                    case 12: {
                        int order;
                        int x;
                        int y;
                        int pos = this.miny * this.width;
                        for (y = this.miny; y < this.maxy; ++y) {
                            x = this.minx;
                            while (x < this.maxx) {
                                order = DilateConstrained.this.orders[pos];
                                if (this.wro.getSample(x, y, 0) == 1 && 0 < order) {
                                    this.se = DilateConstrained.this.SE[order].getSE();
                                    if (x < order || this.width <= x + order || y < order || this.height <= y + order) {
                                        for (CoordinatesWeighted coord : this.se) {
                                            if (0 > y + coord.Y || y + coord.Y >= this.height || 0 > x + coord.X || x + coord.X >= this.width) continue;
                                            this.wrr.setSample(x + coord.X, y + coord.Y, 0, 1);
                                        }
                                    } else {
                                        for (CoordinatesWeighted coord : this.se) {
                                            this.wrr.setSample(x + coord.X, y + coord.Y, 0, 1);
                                        }
                                    }
                                }
                                ++x;
                                ++pos;
                            }
                        }
                        this.wrr = null;
                        this.wro = null;
                        continue block10;
                    }
                    case 10: {
                        int posnew;
                        int order;
                        int x;
                        int y;
                        int pos = this.miny * this.width;
                        for (y = this.miny; y < this.maxy; ++y) {
                            x = this.minx;
                            while (x < this.maxx) {
                                order = DilateConstrained.this.orders[pos];
                                int v = this.bytebufferin[pos] & 0xFF;
                                if (0 < order && 0 < v) {
                                    this.se = DilateConstrained.this.SE[order].getSE();
                                    if (x < order || this.width <= x + order || y < order || this.height <= y + order) {
                                        for (CoordinatesWeighted coord : this.se) {
                                            if (0 > y + coord.Y || y + coord.Y >= this.height || 0 > x + coord.X || x + coord.X >= this.width || (this.bytebufferout[posnew = pos + coord.X + coord.Y * this.width] & 0xFF) >= v) continue;
                                            this.bytebufferout[posnew] = (byte)v;
                                        }
                                    } else {
                                        for (CoordinatesWeighted coord : this.se) {
                                            posnew = pos + coord.X + coord.Y * this.width;
                                            if ((this.bytebufferout[posnew] & 0xFF) >= v) continue;
                                            this.bytebufferout[posnew] = (byte)v;
                                        }
                                    }
                                }
                                ++x;
                                ++pos;
                            }
                        }
                        this.bytebufferout = null;
                        this.bytebufferin = null;
                        continue block10;
                    }
                    case 11: {
                        int posnew;
                        int order;
                        int x;
                        int y;
                        int pos = this.miny * this.width;
                        for (y = this.miny; y < this.maxy; ++y) {
                            x = this.minx;
                            while (x < this.maxx) {
                                order = DilateConstrained.this.orders[pos];
                                int v = this.shortbufferin[pos] & 0xFFFF;
                                if (0 < order && 0 < v) {
                                    this.se = DilateConstrained.this.SE[order].getSE();
                                    if (x < order || this.width <= x + order || y < order || this.height <= y + order) {
                                        for (CoordinatesWeighted coord : this.se) {
                                            if (0 > y + coord.Y || y + coord.Y >= this.height || 0 > x + coord.X || x + coord.X >= this.width || (this.shortbufferout[posnew = pos + coord.X + coord.Y * this.width] & 0xFFFF) >= v) continue;
                                            this.shortbufferout[posnew] = (short)v;
                                        }
                                    } else {
                                        for (CoordinatesWeighted coord : this.se) {
                                            posnew = pos + coord.X + coord.Y * this.width;
                                            if ((this.shortbufferout[posnew] & 0xFFFF) >= v) continue;
                                            this.shortbufferout[posnew] = (short)v;
                                        }
                                    }
                                }
                                ++x;
                                ++pos;
                            }
                        }
                        this.shortbufferout = null;
                        this.shortbufferin = null;
                        continue block10;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Image type not supported (yet).");
        }
    }
}

