/*
 * Decompiled with CFR 0.152.
 */
package morphee.adaptive;

import dv.DV;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import morphee.geodesic.OverBuild;
import processing.filters.SignalFilter;

public class Aminima
implements MorphoFilter {
    private BufferedImage ima;
    private BufferedImage imfil;
    private SignalFilter filter = null;
    private final OverBuild overbuild = new OverBuild();
    private int percentage = 1;
    private final ImageFeatures IF = new ImageFeatures();

    public Aminima() {
    }

    public Aminima(int percentage) {
        this.Parameters(percentage);
    }

    public BufferedImage Filter(BufferedImage reference, SignalFilter filter, int percentage, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)reference);
        this.Filter(reference, filter, percentage, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage reference, SignalFilter filter, int percentage, BufferedImage result, int nbCPU) {
        this.Parameters(filter, percentage);
        this.Filter(reference, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage reference, BufferedImage result, int nbCPU) {
        if (this.filter == null) {
            throw new IllegalArgumentException("Any filter specified.");
        }
        if (!ImageTools.isGrayLevel((BufferedImage)reference)) {
            throw new IllegalArgumentException("Only gray level image supported.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)reference, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images reference and result have different dimensions.");
        }
        if (this.ima == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)reference, (BufferedImage)this.ima)) {
            this.imfil = null;
            this.ima = null;
            this.ima = ImageNew.Same((BufferedImage)reference);
            this.imfil = ImageNew.Same((BufferedImage)reference);
        }
        int max = (int)this.IF.MaximumPotentialValue(reference);
        this.filter.Filter(reference, this.imfil, nbCPU);
        ImageArithmetic.Multiply(this.imfil, (double)this.percentage / 100.0, this.imfil, 0, 0, max, max);
        ImageArithmetic.Add(reference, this.imfil, this.ima, max, max);
        this.overbuild.Filter(reference, this.ima, result, nbCPU);
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
    }

    public BufferedImage ImageFiltered() {
        return this.imfil;
    }

    public void Marker(BufferedImage marker) {
    }

    public BufferedImage Marker() {
        return null;
    }

    public StructuringElement getStructuringElement() {
        return null;
    }

    public void setStructuringElement(StructuringElement ES) {
    }

    public int BorderEffectSizeX() {
        return this.filter.BorderEffectSizeX();
    }

    public int BorderEffectSizeY() {
        return this.filter.BorderEffectSizeY();
    }

    public int BorderEffectSizeZ() {
        return this.filter.BorderEffectSizeZ();
    }

    public MorphoFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("Exactly 2 parameters required.");
        }
        this.filter = (SignalFilter)parameters[0];
        this.percentage = (Integer)parameters[1];
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(this.filter);
        params.add(this.percentage);
        return params;
    }
}

