/*
 * Decompiled with CFR 0.152.
 */
package morphee;

import dv.DV;
import dv.DvArithmetic;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.util.List;
import morphee.Close;
import morphee.MorphoFilter;
import morphee.Open;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import utils.memory.Allocator;

public class WhiteTopHatExtended
implements MorphoFilter {
    private Allocator allocator = Allocator.Instance();
    protected Open open = new Open();
    protected Close close = new Close();
    private DV resopdv;
    private DV rescldv;

    public WhiteTopHatExtended() {
    }

    public synchronized void Kill() {
        this.close.Kill();
        this.open.Kill();
        if (this.resopdv != null) {
            this.resopdv.Kill();
            this.rescldv.Kill();
        }
    }

    public WhiteTopHatExtended(StructuringElement se) {
        this.setStructuringElement(se);
    }

    public WhiteTopHatExtended(StructuringElement3D se) {
        this.setStructuringElement3D(se);
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        BufferedImage resop = ImageNew.Same((BufferedImage)source);
        BufferedImage rescl = ImageNew.Same((BufferedImage)source);
        this.open.Filter(source, resop, nbCPU);
        this.close.Filter(resop, rescl, nbCPU);
        ImageArithmetic.Subtract(source, rescl, result, 0, 0);
        resop = this.allocator.Release(resop);
        rescl = this.allocator.Release(rescl);
    }

    public DV Filter(DV source, int nbCPU) {
        DV result = DvNew.Same((DV)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(DV source, DV result, int nbCPU) {
        if (this.resopdv == null || !DvTools.areDimensionsAndTypeEqual((DV)this.resopdv, (DV)source)) {
            if (this.resopdv != null) {
                this.resopdv.Kill();
                this.rescldv.Kill();
            }
            this.rescldv = null;
            this.resopdv = null;
            this.resopdv = DvNew.Same((DV)source);
            this.rescldv = DvNew.Same((DV)source);
        }
        this.open.Filter(source, this.resopdv, nbCPU);
        this.close.Filter(this.resopdv, this.rescldv, nbCPU);
        DvArithmetic.Subtract(source, this.rescldv, result, 0, 0);
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        DV result = DvNew.Same((DV)source);
        this.Filter(source, se, result, nbCPU);
        return result;
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        this.setStructuringElement3D(se);
        this.Filter(source, result, nbCPU);
    }

    public StructuringElement3D getStructuringElement3D() {
        return this.open.getStructuringElement3D();
    }

    public void setStructuringElement3D(StructuringElement3D se) {
        this.open.setStructuringElement3D(se);
        this.close.setStructuringElement3D(se);
    }

    public StructuringElement getStructuringElement() {
        return this.open.getStructuringElement();
    }

    public void setStructuringElement(StructuringElement se) {
        this.close.setStructuringElement(se);
        this.open.setStructuringElement(se);
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        if (parameters[0] instanceof StructuringElement) {
            this.setStructuringElement((StructuringElement)parameters[0]);
        } else if (parameters[0] instanceof StructuringElement3D) {
            this.setStructuringElement3D((StructuringElement3D)parameters[0]);
        } else {
            throw new IllegalArgumentException("The parameter is not a structuring element.");
        }
    }

    public List<Object> Parameters() {
        return this.close.Parameters();
    }

    public int BorderEffectSizeX() {
        return this.open.BorderEffectSizeX();
    }

    public int BorderEffectSizeY() {
        return this.open.BorderEffectSizeY();
    }

    public int BorderEffectSizeZ() {
        return this.open.BorderEffectSizeZ();
    }

    public MorphoFilter Clone() {
        WhiteTopHatExtended clone = new WhiteTopHatExtended();
        if (this.open.getStructuringElement() != null) {
            clone.setStructuringElement(this.open.getStructuringElement().Clone());
        }
        if (this.open.getStructuringElement3D() != null) {
            clone.setStructuringElement3D(this.open.getStructuringElement3D().Clone());
        }
        return clone;
    }
}

