/*
 * Decompiled with CFR 0.152.
 */
package morphee;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayNew;
import dv.DV;
import dv.DvArithmetic;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.util.List;
import morphee.MorphoFilter;
import morphee.Open;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import utils.memory.Allocator;

public class WhiteTopHat
implements MorphoFilter {
    private Allocator allocator = Allocator.Instance();
    private Open open = new Open();
    private DV tmpdv = null;

    public WhiteTopHat() {
    }

    public synchronized void Kill() {
        this.open.Kill();
        if (this.tmpdv != null) {
            this.tmpdv.Kill();
        }
    }

    public WhiteTopHat(StructuringElement se) {
        this.setStructuringElement(se);
    }

    public WhiteTopHat(StructuringElement3D se) {
        this.setStructuringElement3D(se);
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        BufferedImage tmp = ImageNew.Same((BufferedImage)source);
        this.open.Filter(source, tmp, nbCPU);
        ImageArithmetic.Subtract(source, tmp, result, 0, 0);
        tmp = this.allocator.Release(tmp);
    }

    public DV Filter(DV source, int nbCPU) {
        DV result = DvNew.Same((DV)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(DV source, DV result, int nbCPU) {
        if (this.tmpdv == null || !DvTools.areDimensionsAndTypeEqual((DV)this.tmpdv, (DV)source)) {
            this.tmpdv = null;
            this.tmpdv = DvNew.Same((DV)source);
        }
        this.open.Filter(source, this.tmpdv, nbCPU);
        DvArithmetic.Subtract(source, this.tmpdv, result, 0, 0);
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        DV result = DvNew.Same((DV)source);
        this.Filter(source, se, result, nbCPU);
        return result;
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        this.setStructuringElement3D(se);
        this.Filter(source, result, nbCPU);
    }

    public StructuringElement3D getStructuringElement3D() {
        return this.open.getStructuringElement3D();
    }

    public void setStructuringElement3D(StructuringElement3D se) {
        this.open.setStructuringElement3D(se);
    }

    public int[] Filter(int[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public int[] Filter(int[] source, int nbCPU) {
        int[] result = ArrayNew.Same((int[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(int[] source, int[] result, int nbCPU) {
        int[] itmp = ArrayNew.Same((int[])source);
        this.open.Filter(source, itmp, nbCPU);
        ArrayArithmetic.Subtract((int[])source, (int[])itmp, (int[])result, (int)0, (int)0);
        itmp = this.allocator.Release(itmp);
    }

    public double[] Filter(double[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public double[] Filter(double[] source, int nbCPU) {
        double[] result = ArrayNew.Same((double[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(double[] source, double[] result, int nbCPU) {
        double[] dtmp = ArrayNew.Same((double[])source);
        this.open.Filter(source, dtmp, nbCPU);
        ArrayArithmetic.Subtract((double[])source, (double[])dtmp, (double[])result, (double)0.0, (double)0.0);
        dtmp = this.allocator.Release(dtmp);
    }

    public byte[] Filter(byte[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public byte[] Filter(byte[] source, int nbCPU) {
        byte[] result = ArrayNew.Same((byte[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(byte[] source, byte[] result, int nbCPU) {
        byte[] btmp = ArrayNew.Same((byte[])source);
        this.open.Filter(source, btmp, nbCPU);
        ArrayArithmetic.SubtractUnsigned((byte[])source, (byte[])btmp, (byte[])result, (byte)0, (byte)0);
        btmp = this.allocator.Release(btmp);
    }

    public short[] Filter(short[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public short[] Filter(short[] source, int nbCPU) {
        short[] result = ArrayNew.Same((short[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(short[] source, short[] result, int nbCPU) {
        short[] stmp = ArrayNew.Same((short[])source);
        this.open.Filter(source, stmp, nbCPU);
        ArrayArithmetic.SubtractUnsigned((short[])source, (short[])stmp, (short[])result, (short)0, (short)0);
        stmp = this.allocator.Release(stmp);
    }

    public StructuringElement getStructuringElement() {
        return this.open.getStructuringElement();
    }

    public void setStructuringElement(StructuringElement se) {
        this.open.setStructuringElement(se);
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.open.Parameters(parameters[0]);
    }

    public List<Object> Parameters() {
        return this.open.Parameters();
    }

    public int BorderEffectSizeX() {
        return this.open.BorderEffectSizeX();
    }

    public int BorderEffectSizeY() {
        return this.open.BorderEffectSizeY();
    }

    public int BorderEffectSizeZ() {
        return this.open.BorderEffectSizeZ();
    }

    public MorphoFilter Clone() {
        WhiteTopHat clone = new WhiteTopHat();
        if (this.open.getStructuringElement() != null) {
            clone.setStructuringElement(this.open.getStructuringElement().Clone());
        }
        if (this.open.getStructuringElement3D() != null) {
            clone.setStructuringElement3D(this.open.getStructuringElement3D().Clone());
        }
        return clone;
    }
}

