/*
 * Decompiled with CFR 0.152.
 */
package morphee;

import arrayTiTi.ArrayNew;
import dv.DV;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.util.List;
import morphee.Dilate;
import morphee.Erode;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import morphee.fastMorphee.OpenSegmentDiagonal135;
import morphee.fastMorphee.OpenSegmentDiagonal45;
import morphee.fastMorphee.OpenSegmentX;
import morphee.fastMorphee.OpenSegmentY;
import morphee.fastMorphee.OpenSegmentZ;
import utils.memory.Allocator;

public class Open
implements MorphoFilter {
    private Allocator allocator = Allocator.Instance();
    private Dilate dilate = new Dilate();
    private Erode erode = new Erode();
    private OpenSegmentX opensegx = new OpenSegmentX();
    private OpenSegmentY opensegy = new OpenSegmentY();
    private OpenSegmentZ opensegz = new OpenSegmentZ();
    private OpenSegmentDiagonal45 open45 = new OpenSegmentDiagonal45();
    private OpenSegmentDiagonal135 open135 = new OpenSegmentDiagonal135();
    private DV tmpdv = null;
    private StructuringElement SE = null;
    private StructuringElement3D SE3 = null;

    public Open() {
    }

    public Open(StructuringElement se) {
        this.setStructuringElement(se);
    }

    public synchronized void Kill() {
        this.dilate.Kill();
        this.erode.Kill();
        this.opensegx.Kill();
        this.opensegy.Kill();
        this.opensegz.Kill();
        this.open45.Kill();
        this.open135.Kill();
        if (this.tmpdv != null) {
            this.tmpdv.Kill();
        }
        this.tmpdv = null;
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (this.SE.useFastestAlgorithmOC() && source.getType() != 0) {
            switch (this.SE.getType()) {
                case -5: {
                    this.opensegx.Filter(source, this.SE.getSize(), result, nbCPU);
                    return;
                }
                case -6: {
                    this.opensegy.Filter(source, this.SE.getSize(), result, nbCPU);
                    return;
                }
                case -4: {
                    this.open45.Filter(source, this.SE.getSize(), result, nbCPU);
                    return;
                }
                case -3: {
                    this.open135.Filter(source, this.SE.getSize(), result, nbCPU);
                    return;
                }
            }
        }
        BufferedImage tmp = ImageNew.Same((BufferedImage)source);
        this.erode.Filter(source, tmp, nbCPU);
        this.dilate.Filter(tmp, result, nbCPU);
        tmp = this.allocator.Release(tmp);
    }

    public DV Filter(DV source, int nbCPU) {
        DV result = DvNew.Same((DV)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(DV source, DV result, int nbCPU) {
        if (this.SE3 == null) {
            throw new IllegalStateException("Any 3D structuring element defined.");
        }
        this.Filter(source, this.SE3, result, nbCPU);
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        DV result = DvNew.Same((DV)source);
        this.Filter(source, se, result, nbCPU);
        return result;
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        this.setStructuringElement3D(se);
        if (se.useFastestAlgorithmOC()) {
            switch (se.getType()) {
                case -3: {
                    this.opensegx.Filter(source, se.getSize(), result, nbCPU);
                    return;
                }
                case -4: {
                    this.opensegy.Filter(source, se.getSize(), result, nbCPU);
                    return;
                }
                case -5: {
                    this.opensegz.Filter(source, se.getSize(), result, nbCPU);
                    return;
                }
            }
        }
        if (this.tmpdv == null || !DvTools.areDimensionsAndTypeEqual((DV)this.tmpdv, (DV)source)) {
            this.tmpdv = null;
            this.tmpdv = DvNew.Same((DV)source);
        }
        this.erode.Filter(source, this.tmpdv, nbCPU);
        this.dilate.Filter(this.tmpdv, result, nbCPU);
    }

    public StructuringElement3D getStructuringElement3D() {
        return this.SE3;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
        this.SE3 = se;
        this.dilate.setStructuringElement3D(se);
        this.erode.setStructuringElement3D(se);
    }

    public int[] Filter(int[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public int[] Filter(int[] source, int nbCPU) {
        int[] result = ArrayNew.Same((int[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(int[] source, StructuringElement SE, int[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(int[] source, int[] result, int nbCPU) {
        int[] itmp = ArrayNew.Same((int[])source);
        this.erode.Filter(source, itmp, nbCPU);
        this.dilate.Filter(itmp, result, nbCPU);
        itmp = this.allocator.Release(itmp);
    }

    public double[] Filter(double[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public double[] Filter(double[] source, int nbCPU) {
        double[] result = ArrayNew.Same((double[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(double[] source, StructuringElement SE, double[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(double[] source, double[] result, int nbCPU) {
        double[] dtmp = ArrayNew.Same((double[])source);
        this.erode.Filter(source, dtmp, nbCPU);
        this.dilate.Filter(dtmp, result, nbCPU);
        dtmp = this.allocator.Release(dtmp);
    }

    public byte[] Filter(byte[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public byte[] Filter(byte[] source, int nbCPU) {
        byte[] result = ArrayNew.Same((byte[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(byte[] source, StructuringElement SE, byte[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(byte[] source, byte[] result, int nbCPU) {
        byte[] btmp = ArrayNew.Same((byte[])source);
        this.erode.Filter(source, btmp, nbCPU);
        this.dilate.Filter(btmp, result, nbCPU);
        btmp = this.allocator.Release(btmp);
    }

    public short[] Filter(short[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public short[] Filter(short[] source, int nbCPU) {
        short[] result = ArrayNew.Same((short[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(short[] source, StructuringElement SE, short[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(short[] source, short[] result, int nbCPU) {
        short[] stmp = ArrayNew.Same((short[])source);
        this.erode.Filter(source, stmp, nbCPU);
        this.dilate.Filter(stmp, result, nbCPU);
        stmp = this.allocator.Release(stmp);
    }

    public StructuringElement getStructuringElement() {
        return this.SE;
    }

    public void setStructuringElement(StructuringElement SE) {
        this.SE = SE;
        this.dilate.setStructuringElement(SE);
        this.erode.setStructuringElement(SE);
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        if (parameters[0] instanceof StructuringElement) {
            this.setStructuringElement((StructuringElement)parameters[0]);
        } else if (parameters[0] instanceof StructuringElement3D) {
            this.setStructuringElement3D((StructuringElement3D)parameters[0]);
        } else {
            throw new IllegalArgumentException("Structuring element required.");
        }
    }

    public List<Object> Parameters() {
        return this.dilate.Parameters();
    }

    public int BorderEffectSizeX() {
        return this.dilate.BorderEffectSizeX();
    }

    public int BorderEffectSizeY() {
        return this.dilate.BorderEffectSizeY();
    }

    public int BorderEffectSizeZ() {
        return this.dilate.BorderEffectSizeZ();
    }

    public MorphoFilter Clone() {
        Open clone = new Open();
        if (this.dilate.getStructuringElement() != null) {
            clone.setStructuringElement(this.dilate.getStructuringElement().Clone());
        }
        if (this.dilate.getStructuringElement3D() != null) {
            clone.setStructuringElement3D(this.dilate.getStructuringElement3D().Clone());
        }
        return clone;
    }
}

