/*
 * Decompiled with CFR 0.152.
 */
package morphee;

import arrayTiTi.ArrayNew;
import arrayTiTi.ArrayTools;
import dv.DV;
import dv.DvIO;
import dv.DvNew;
import dv.DvOperations;
import dv.DvTools;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.io.IOException;
import morphee.Erode;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import utils.memory.Allocator;
import utils.times.Chronometer;

public class ErodeTest {
    private final Allocator allocator = Allocator.Instance();
    private static final Chronometer chrono = new Chronometer();
    private static int TimePoint = -1;

    @BeforeAll
    public static void setUpClass() {
        System.out.println("\n ---------------------------------- Starting test on class Erode ---------------------------------- ");
        TimePoint = chrono.NewMarker();
    }

    @AfterAll
    public static void tearDownClass() {
        System.out.println("Class Erode tests done in " + chrono.getTimeSinceMarker(TimePoint) + "s.\n\n");
    }

    private int getRandomDim(int base, int var) {
        return base + (Math.random() < 0.5 ? -1 : 1) * (int)(Math.random() * (double)var + 0.5);
    }

    private void LogError(BufferedImage src, BufferedImage res1, BufferedImage res2, String prefix) throws IOException {
        ImageIO.Write(src, prefix + " - Source.png", 6);
        ImageIO.Write(res1, prefix + " - Result 1.png", 6);
        ImageIO.Write(res2, prefix + " - Result 2.png", 6);
        ImageIO.Write(ImageOperations.Differences((BufferedImage)res1, (BufferedImage)res2), prefix + " - Differences.png", 6);
    }

    @Test
    public void testFilter_4args_1() throws IOException {
        StructuringElement sediag2;
        StructuringElement sediag;
        BufferedImage result2;
        BufferedImage result1;
        BufferedImage source;
        int[] radii;
        System.out.println("Filter(BufferedImage, se, BufferedImage, nbCPU)");
        Erode instance = new Erode();
        int BaseDim = 256;
        int VarDim = 13;
        for (int radius : radii = new int[]{1, 2, 3, 5, 7, 11}) {
            StructuringElement sesquare = new StructuringElement(new Object[]{radius, -1});
            StructuringElement sesquare2 = new StructuringElement(sesquare.getWeightsInt());
            Assertions.assertEquals(sesquare2.isFlat(), true);
            Assertions.assertEquals(sesquare2.isIterable(), false);
            source = ImageNew.Random((int)this.getRandomDim(256, 13), (int)this.getRandomDim(256, 13), (int)10);
            result1 = ImageNew.Same((BufferedImage)source);
            result2 = ImageNew.Same((BufferedImage)source);
            instance.Filter(source, sesquare, result1, 2);
            instance.Filter(source, sesquare2, result2, 2);
            if (!ImageTools.areEqual((BufferedImage)result1, (BufferedImage)result2)) {
                this.LogError(source, result1, result2, "Square Byte " + radius);
                Assertions.fail("Square Byte " + radius);
            }
            source = this.allocator.Release(source);
            result1 = this.allocator.Release(result1);
            result2 = this.allocator.Release(result2);
            source = ImageNew.Random((int)this.getRandomDim(256, 13), (int)this.getRandomDim(256, 13), (int)11);
            result1 = ImageNew.Same((BufferedImage)source);
            result2 = ImageNew.Same((BufferedImage)source);
            instance.Filter(source, sesquare, result1, 3);
            instance.Filter(source, sesquare2, result2, 3);
            if (!ImageTools.areEqual((BufferedImage)result1, (BufferedImage)result2)) {
                this.LogError(source, result1, result2, "Square Short " + radius);
                Assertions.fail("Square Short " + radius);
            }
            source = this.allocator.Release(source);
            result1 = this.allocator.Release(result1);
            result2 = this.allocator.Release(result2);
            if (radius == 1) {
                source = ImageNew.Float((int)this.getRandomDim(256, 13), (int)this.getRandomDim(256, 13), (int)1);
                ImageOperations.FillRandomly((BufferedImage)source);
                result1 = ImageNew.Same((BufferedImage)source);
                result2 = ImageNew.Same((BufferedImage)source);
                instance.Filter(source, sesquare, result1, 4);
                instance.Filter(source, sesquare2, result2, 4);
                if (!ImageTools.areEqual((BufferedImage)result1, (BufferedImage)result2)) {
                    Assertions.fail("Square Float " + radius);
                }
                source = this.allocator.Release(source);
                result1 = this.allocator.Release(result1);
                result2 = this.allocator.Release(result2);
            }
            sesquare.Kill();
            sesquare2.Kill();
        }
        for (int radius : radii) {
            StructuringElement sedisk = new StructuringElement(new Object[]{radius, -2});
            StructuringElement sedisk2 = new StructuringElement(sedisk.getWeightsInt());
            Assertions.assertEquals(sedisk2.isFlat(), true);
            Assertions.assertEquals(sedisk2.isIterable(), false);
            source = ImageNew.Random((int)this.getRandomDim(256, 13), (int)this.getRandomDim(256, 13), (int)10);
            result1 = ImageNew.Same((BufferedImage)source);
            result2 = ImageNew.Same((BufferedImage)source);
            instance.Filter(source, sedisk, result1, 3);
            instance.Filter(source, sedisk2, result2, 3);
            if (!ImageTools.areEqual((BufferedImage)result1, (BufferedImage)result2)) {
                this.LogError(source, result1, result2, "Disk Byte " + radius);
                Assertions.fail("Disk Byte " + radius);
            }
            source = this.allocator.Release(source);
            result1 = this.allocator.Release(result1);
            result2 = this.allocator.Release(result2);
            source = ImageNew.Random((int)this.getRandomDim(256, 13), (int)this.getRandomDim(256, 13), (int)11);
            result1 = ImageNew.Same((BufferedImage)source);
            result2 = ImageNew.Same((BufferedImage)source);
            instance.Filter(source, sedisk, result1, 4);
            instance.Filter(source, sedisk2, result2, 4);
            if (!ImageTools.areEqual((BufferedImage)result1, (BufferedImage)result2)) {
                this.LogError(source, result1, result2, "Disk Short " + radius);
                Assertions.fail("Disk Short " + radius);
            }
            source = this.allocator.Release(source);
            result1 = this.allocator.Release(result1);
            result2 = this.allocator.Release(result2);
            if (radius == 1) {
                source = ImageNew.Float((int)this.getRandomDim(256, 13), (int)this.getRandomDim(256, 13), (int)1);
                ImageOperations.FillRandomly((BufferedImage)source);
                result1 = ImageNew.Same((BufferedImage)source);
                result2 = ImageNew.Same((BufferedImage)source);
                instance.Filter(source, sedisk, result1, 2);
                instance.Filter(source, sedisk2, result2, 2);
                if (!ImageTools.areEqual((BufferedImage)result1, (BufferedImage)result2)) {
                    Assertions.fail("Disk Float " + radius);
                }
                source = this.allocator.Release(source);
                result1 = this.allocator.Release(result1);
                result2 = this.allocator.Release(result2);
            }
            sedisk.Kill();
            sedisk2.Kill();
        }
        for (int radius : radii) {
            sediag = new StructuringElement(new Object[]{radius, -4});
            sediag2 = new StructuringElement(sediag.getWeightsInt());
            Assertions.assertEquals(sediag2.isFlat(), true);
            Assertions.assertEquals(sediag2.isIterable(), false);
            source = ImageNew.Random((int)this.getRandomDim(256, 13), (int)this.getRandomDim(256, 13), (int)10);
            result1 = ImageNew.Same((BufferedImage)source);
            result2 = ImageNew.Same((BufferedImage)source);
            instance.Filter(source, sediag, result1, 3);
            instance.Filter(source, sediag2, result2, 3);
            if (!ImageTools.areEqual((BufferedImage)result1, (BufferedImage)result2)) {
                this.LogError(source, result1, result2, "Diagonal 45 Byte " + radius);
                Assertions.fail("Diagonal 45 Byte " + radius);
            }
            source = this.allocator.Release(source);
            result1 = this.allocator.Release(result1);
            result2 = this.allocator.Release(result2);
            source = ImageNew.Random((int)this.getRandomDim(256, 13), (int)this.getRandomDim(256, 13), (int)11);
            result1 = ImageNew.Same((BufferedImage)source);
            result2 = ImageNew.Same((BufferedImage)source);
            instance.Filter(source, sediag, result1, 4);
            instance.Filter(source, sediag2, result2, 4);
            if (!ImageTools.areEqual((BufferedImage)result1, (BufferedImage)result2)) {
                this.LogError(source, result1, result2, "Diagonal 45 Short " + radius);
                Assertions.fail("Diagonal 45 Short " + radius);
            }
            source = this.allocator.Release(source);
            result1 = this.allocator.Release(result1);
            result2 = this.allocator.Release(result2);
            if (radius == 1) {
                source = ImageNew.Float((int)this.getRandomDim(256, 13), (int)this.getRandomDim(256, 13), (int)1);
                ImageOperations.FillRandomly((BufferedImage)source);
                result1 = ImageNew.Same((BufferedImage)source);
                result2 = ImageNew.Same((BufferedImage)source);
                instance.Filter(source, sediag, result1, 2);
                instance.Filter(source, sediag2, result2, 2);
                if (!ImageTools.areEqual((BufferedImage)result1, (BufferedImage)result2)) {
                    Assertions.fail("Diagonal 45 Float " + radius);
                }
                source = this.allocator.Release(source);
                result1 = this.allocator.Release(result1);
                result2 = this.allocator.Release(result2);
            }
            sediag.Kill();
            sediag2.Kill();
        }
        for (int radius : radii) {
            sediag = new StructuringElement(new Object[]{radius, -3});
            sediag2 = new StructuringElement(sediag.getWeightsInt());
            Assertions.assertEquals(sediag2.isFlat(), true);
            Assertions.assertEquals(sediag2.isIterable(), false);
            source = ImageNew.Random((int)this.getRandomDim(256, 13), (int)this.getRandomDim(256, 13), (int)10);
            result1 = ImageNew.Same((BufferedImage)source);
            result2 = ImageNew.Same((BufferedImage)source);
            instance.Filter(source, sediag, result1, 3);
            instance.Filter(source, sediag2, result2, 3);
            if (!ImageTools.areEqual((BufferedImage)result1, (BufferedImage)result2)) {
                this.LogError(source, result1, result2, "Diagonal 135 Byte " + radius);
                Assertions.fail("Diagonal 135 Byte " + radius);
            }
            source = this.allocator.Release(source);
            result1 = this.allocator.Release(result1);
            result2 = this.allocator.Release(result2);
            source = ImageNew.Random((int)this.getRandomDim(256, 13), (int)this.getRandomDim(256, 13), (int)11);
            result1 = ImageNew.Same((BufferedImage)source);
            result2 = ImageNew.Same((BufferedImage)source);
            instance.Filter(source, sediag, result1, 4);
            instance.Filter(source, sediag2, result2, 4);
            if (!ImageTools.areEqual((BufferedImage)result1, (BufferedImage)result2)) {
                this.LogError(source, result1, result2, "Diagonal 135 Short " + radius);
                Assertions.fail("Diagonal 135 Short " + radius);
            }
            source = this.allocator.Release(source);
            result1 = this.allocator.Release(result1);
            result2 = this.allocator.Release(result2);
            if (radius == 1) {
                source = ImageNew.Float((int)this.getRandomDim(256, 13), (int)this.getRandomDim(256, 13), (int)1);
                ImageOperations.FillRandomly((BufferedImage)source);
                result1 = ImageNew.Same((BufferedImage)source);
                result2 = ImageNew.Same((BufferedImage)source);
                instance.Filter(source, sediag, result1, 2);
                instance.Filter(source, sediag2, result2, 2);
                if (!ImageTools.areEqual((BufferedImage)result1, (BufferedImage)result2)) {
                    Assertions.fail("Diagonal 135 Float " + radius);
                }
                source = this.allocator.Release(source);
                result1 = this.allocator.Release(result1);
                result2 = this.allocator.Release(result2);
            }
            sediag.Kill();
            sediag2.Kill();
        }
        instance.Kill();
        this.allocator.ClearAll(true);
    }

    private void LogError(DV src, DV res1, DV res2, String prefix) throws IOException {
        DvIO.WriteStack(src, "./", prefix + " - Source - ", 6);
        DvIO.WriteStack(res1, "./", prefix + " - Result 1 - ", 6);
        DvIO.WriteStack(res2, "./", prefix + " - Result 2 - ", 6);
        DvIO.WriteStack(DvOperations.Differences((DV)res1, (DV)res2), "./", prefix + " - Differences - ", 6);
    }

    @Test
    public void testFilter_4args_2() throws IOException {
        DV result2;
        DV result1;
        DV source;
        int[] radii;
        System.out.println("Filter(DV, se, DV, nbCPU)");
        Erode instance = new Erode();
        int BaseDim = 64;
        int VarDim = 7;
        for (int radius : radii = new int[]{1, 2, 3, 5}) {
            StructuringElement3D secube = new StructuringElement3D(new Object[]{radius, -1});
            StructuringElement3D secube2 = new StructuringElement3D(secube.getWeightsInt());
            Assertions.assertEquals(secube2.isFlat(), true);
            Assertions.assertEquals(secube2.isIterable(), false);
            source = DvNew.Random((int)this.getRandomDim(64, 7), (int)this.getRandomDim(64, 7), (int)this.getRandomDim(64, 7), (int)1, (int)8);
            result1 = DvNew.Same((DV)source);
            result2 = DvNew.Same((DV)source);
            instance.Filter(source, secube, result1, 2);
            instance.Filter(source, secube2, result2, 2);
            if (!DvTools.areEqual((DV)result1, (DV)result2)) {
                this.LogError(source, result1, result2, "Square Byte " + radius);
                Assertions.fail("Square Byte " + radius);
            }
            source.Kill();
            result1.Kill();
            result2.Kill();
            result2 = null;
            result1 = null;
            source = null;
            source = DvNew.Random((int)this.getRandomDim(64, 7), (int)this.getRandomDim(64, 7), (int)this.getRandomDim(64, 7), (int)1, (int)16);
            result1 = DvNew.Same((DV)source);
            result2 = DvNew.Same((DV)source);
            instance.Filter(source, secube, result1, 3);
            instance.Filter(source, secube2, result2, 3);
            if (!DvTools.areEqual((DV)result1, (DV)result2)) {
                this.LogError(source, result1, result2, "Square Short " + radius);
                Assertions.fail("Square Short " + radius);
            }
            source.Kill();
            result1.Kill();
            result2.Kill();
            result2 = null;
            result1 = null;
            source = null;
            if (radius == 1) {
                source = DvNew.Random((int)this.getRandomDim(64, 7), (int)this.getRandomDim(64, 7), (int)this.getRandomDim(64, 7), (int)1, (int)-32);
                DvOperations.FillRandomly((DV)source);
                result1 = DvNew.Same((DV)source);
                result2 = DvNew.Same((DV)source);
                instance.Filter(source, secube, result1, 4);
                instance.Filter(source, secube2, result2, 4);
                if (!DvTools.areEqual((DV)result1, (DV)result2)) {
                    Assertions.fail("Square Float " + radius);
                }
                source.Kill();
                result1.Kill();
                result2.Kill();
                result2 = null;
                result1 = null;
                source = null;
            }
            secube.Kill();
            secube2.Kill();
        }
        for (int radius : radii) {
            StructuringElement3D sesphere = new StructuringElement3D(new Object[]{radius, -2});
            StructuringElement3D sesphere2 = new StructuringElement3D(sesphere.getWeightsInt());
            Assertions.assertEquals(sesphere2.isFlat(), true);
            Assertions.assertEquals(sesphere2.isIterable(), false);
            source = DvNew.Random((int)this.getRandomDim(64, 7), (int)this.getRandomDim(64, 7), (int)this.getRandomDim(64, 7), (int)1, (int)8);
            result1 = DvNew.Same((DV)source);
            result2 = DvNew.Same((DV)source);
            instance.Filter(source, sesphere, result1, 3);
            instance.Filter(source, sesphere2, result2, 3);
            if (!DvTools.areEqual((DV)result1, (DV)result2)) {
                this.LogError(source, result1, result2, "Sphere Byte " + radius);
                Assertions.fail("Sphere Byte " + radius);
            }
            source.Kill();
            result1.Kill();
            result2.Kill();
            result2 = null;
            result1 = null;
            source = null;
            source = DvNew.Random((int)this.getRandomDim(64, 7), (int)this.getRandomDim(64, 7), (int)this.getRandomDim(64, 7), (int)1, (int)16);
            result1 = DvNew.Same((DV)source);
            result2 = DvNew.Same((DV)source);
            instance.Filter(source, sesphere, result1, 4);
            instance.Filter(source, sesphere2, result2, 4);
            if (!DvTools.areEqual((DV)result1, (DV)result2)) {
                this.LogError(source, result1, result2, "Sphere Short " + radius);
                Assertions.fail("Sphere Short " + radius);
            }
            source.Kill();
            result1.Kill();
            result2.Kill();
            result2 = null;
            result1 = null;
            source = null;
            if (radius == 1) {
                source = DvNew.Random((int)this.getRandomDim(64, 7), (int)this.getRandomDim(64, 7), (int)this.getRandomDim(64, 7), (int)1, (int)-32);
                DvOperations.FillRandomly((DV)source);
                result1 = DvNew.Same((DV)source);
                result2 = DvNew.Same((DV)source);
                instance.Filter(source, sesphere, result1, 2);
                instance.Filter(source, sesphere2, result2, 2);
                if (!DvTools.areEqual((DV)result1, (DV)result2)) {
                    Assertions.fail("Sphere Float " + radius);
                }
                source.Kill();
                result1.Kill();
                result2.Kill();
                result2 = null;
                result1 = null;
                source = null;
            }
            sesphere.Kill();
            sesphere2.Kill();
        }
        instance.Kill();
    }

    @Test
    public void testFilter_4args_3() {
        int[] radii;
        System.out.println("Filter(byte[], se, byte[], nbCPU)");
        Erode instance = new Erode();
        for (int radius : radii = new int[]{1, 2, 3, 7, 11, 23}) {
            StructuringElement se = new StructuringElement(new Object[]{radius, -5});
            StructuringElement se2 = new StructuringElement(se.getWeightsInt());
            Assertions.assertEquals(se2.isFlat(), true);
            Assertions.assertEquals(se2.isIterable(), false);
            byte[] source = ArrayNew.RandomByte((int)this.getRandomDim(1024, 13), (int)0, (int)256);
            byte[] result1 = ArrayNew.Same((byte[])source);
            byte[] result2 = ArrayNew.Same((byte[])source);
            instance.Filter(source, se, result1, 1);
            instance.Filter(source, se2, result2, 1);
            if (!ArrayTools.AreEqual((byte[])result1, (byte[])result2)) {
                Assertions.fail("Byte " + radius);
            }
            source = this.allocator.Release(source);
            result1 = this.allocator.Release(result1);
            result2 = this.allocator.Release(result2);
        }
        instance.Kill();
        this.allocator.ClearAll(true);
    }

    @Test
    public void testFilter_4args_4() {
        int[] radii;
        System.out.println("Filter(short[], se, short[], nbCPU)");
        Erode instance = new Erode();
        for (int radius : radii = new int[]{1, 2, 3, 7, 11, 23}) {
            StructuringElement se = new StructuringElement(new Object[]{radius, -5});
            StructuringElement se2 = new StructuringElement(se.getWeightsInt());
            Assertions.assertEquals(se2.isFlat(), true);
            Assertions.assertEquals(se2.isIterable(), false);
            short[] source = ArrayNew.RandomShort((int)this.getRandomDim(1024, 13), (int)0, (int)65536);
            short[] result1 = ArrayNew.Same((short[])source);
            short[] result2 = ArrayNew.Same((short[])source);
            instance.Filter(source, se, result1, 1);
            instance.Filter(source, se2, result2, 1);
            if (!ArrayTools.AreEqual((short[])result1, (short[])result2)) {
                Assertions.fail("Short " + radius);
            }
            source = this.allocator.Release(source);
            result1 = this.allocator.Release(result1);
            result2 = this.allocator.Release(result2);
        }
        instance.Kill();
        this.allocator.ClearAll(true);
    }

    @Test
    public void testFilter_4args_5() {
        int[] radii;
        System.out.println("Filter(int[], se, int[], nbCPU)");
        Erode instance = new Erode();
        for (int radius : radii = new int[]{1, 2, 3, 7, 11, 23}) {
            StructuringElement se = new StructuringElement(new Object[]{radius, -5});
            StructuringElement se2 = new StructuringElement(se.getWeightsInt());
            Assertions.assertEquals(se2.isFlat(), true);
            Assertions.assertEquals(se2.isIterable(), false);
            int[] source = ArrayNew.RandomInt((int)this.getRandomDim(1024, 13), (int)0, (int)1000001);
            int[] result1 = ArrayNew.Same((int[])source);
            int[] result2 = ArrayNew.Same((int[])source);
            instance.Filter(source, se, result1, 1);
            instance.Filter(source, se2, result2, 1);
            if (!ArrayTools.AreEqual((int[])result1, (int[])result2)) {
                Assertions.fail("Int " + radius);
            }
            source = this.allocator.Release(source);
            result1 = this.allocator.Release(result1);
            result2 = this.allocator.Release(result2);
        }
        instance.Kill();
        this.allocator.ClearAll(true);
    }

    @Test
    public void testFilter_4args_6() {
        int[] radii;
        System.out.println("Filter(double[], se, double[], nbCPU)");
        Erode instance = new Erode();
        for (int radius : radii = new int[]{1, 2, 3, 7, 11, 23}) {
            StructuringElement se = new StructuringElement(new Object[]{radius, -5});
            StructuringElement se2 = new StructuringElement(se.getWeightsInt());
            Assertions.assertEquals(se2.isFlat(), true);
            Assertions.assertEquals(se2.isIterable(), false);
            double[] source = ArrayNew.RandomDouble((int)this.getRandomDim(1024, 13), (double)0.0, (double)1.0);
            double[] result1 = ArrayNew.Same((double[])source);
            double[] result2 = ArrayNew.Same((double[])source);
            instance.Filter(source, se, result1, 1);
            instance.Filter(source, se2, result2, 1);
            if (!ArrayTools.AreEqual((double[])result1, (double[])result2)) {
                Assertions.fail("Double " + radius);
            }
            source = this.allocator.Release(source);
            result1 = this.allocator.Release(result1);
            result2 = this.allocator.Release(result2);
        }
        instance.Kill();
        this.allocator.ClearAll(true);
    }

    @Test
    public void testFilter_4args_7() {
        int[] radii;
        System.out.println("Filter(float[], se, float[], nbCPU)");
        Erode instance = new Erode();
        for (int radius : radii = new int[]{1, 2, 3, 7, 11, 23}) {
            StructuringElement se = new StructuringElement(new Object[]{radius, -5});
            StructuringElement se2 = new StructuringElement(se.getWeightsInt());
            Assertions.assertEquals(se2.isFlat(), true);
            Assertions.assertEquals(se2.isIterable(), false);
            float[] source = ArrayNew.RandomFloat((int)this.getRandomDim(1024, 13), (float)0.0f, (float)1.0f);
            float[] result1 = ArrayNew.Same((float[])source);
            float[] result2 = ArrayNew.Same((float[])source);
            instance.Filter(source, se, result1, 1);
            instance.Filter(source, se2, result2, 1);
            if (!ArrayTools.AreEqual((float[])result1, (float[])result2)) {
                Assertions.fail("Float " + radius);
            }
            source = this.allocator.Release(source);
            result1 = this.allocator.Release(result1);
            result2 = this.allocator.Release(result2);
        }
        instance.Kill();
        this.allocator.ClearAll(true);
    }

    @Test
    public void testParameters_ObjectArr() {
    }

    @Test
    public void testParameters_0args() {
    }

    @Test
    public void testBorderEffectSizeX() {
        System.out.println("BorderEffectSizeX");
        Erode instance = new Erode();
        int radius = this.getRandomDim(13, 11);
        instance.setStructuringElement(new StructuringElement(new Object[]{radius, -1}));
        Assertions.assertEquals(instance.BorderEffectSizeX(), radius);
        radius = this.getRandomDim(13, 11);
        instance.setStructuringElement(new StructuringElement(new Object[]{radius, -2}));
        Assertions.assertEquals(instance.BorderEffectSizeX(), radius);
        instance.Kill();
    }

    @Test
    public void testBorderEffectSizeY() {
        System.out.println("BorderEffectSizeY");
        Erode instance = new Erode();
        int radius = this.getRandomDim(13, 11);
        instance.setStructuringElement(new StructuringElement(new Object[]{radius, -1}));
        Assertions.assertEquals(instance.BorderEffectSizeY(), radius);
        radius = this.getRandomDim(13, 11);
        instance.setStructuringElement(new StructuringElement(new Object[]{radius, -2}));
        Assertions.assertEquals(instance.BorderEffectSizeY(), radius);
        instance.Kill();
    }

    @Test
    public void testBorderEffectSizeZ() {
    }
}

