/*
 * Decompiled with CFR 0.152.
 */
package morphee;

import arrayTiTi.ArrayNew;
import dv.DV;
import dv.DvNew;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.util.List;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import morphee.fastMorphee.ErodeDiamond;
import morphee.fastMorphee.ErodeGeneric;
import morphee.fastMorphee.ErodeHexagon;
import morphee.fastMorphee.ErodeOctagon;
import morphee.fastMorphee.ErodeSegment135;
import morphee.fastMorphee.ErodeSegment45;
import morphee.fastMorphee.ErodeSegmentX;
import morphee.fastMorphee.ErodeSegmentY;
import morphee.fastMorphee.ErodeSegmentZ;
import morphee.fastMorphee.ErodeSquare;

public class Erode
implements MorphoFilter {
    private StructuringElement SE = null;
    private StructuringElement3D SE3 = null;
    private final ErodeDiamond erodiamond = new ErodeDiamond();
    private final ErodeOctagon eroctogon = new ErodeOctagon();
    private final ErodeHexagon erohexagon = new ErodeHexagon();
    private final ErodeSegment135 eroseg135 = new ErodeSegment135();
    private final ErodeSegment45 eroseg45 = new ErodeSegment45();
    private final ErodeSegmentX erosegx = new ErodeSegmentX();
    private final ErodeSegmentY erosegy = new ErodeSegmentY();
    private final ErodeSegmentZ erosegz = new ErodeSegmentZ();
    private final ErodeSquare erosquare = new ErodeSquare();
    private final ErodeGeneric erogen = new ErodeGeneric();

    public Erode() {
    }

    public Erode(StructuringElement ES) {
        this.setStructuringElement(ES);
    }

    public Erode(StructuringElement3D ES) {
        this.setStructuringElement3D(ES);
    }

    public synchronized void Kill() {
        this.SE = null;
        this.SE3 = null;
        this.erodiamond.Kill();
        this.eroctogon.Kill();
        this.erohexagon.Kill();
        this.eroseg135.Kill();
        this.eroseg45.Kill();
        this.erosegx.Kill();
        this.erosegy.Kill();
        this.erosegz.Kill();
        this.erosquare.Kill();
        this.erogen.Kill();
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (this.SE.isIterable()) {
            switch (this.SE.getType()) {
                case -8: {
                    this.erodiamond.Filter(source, this.SE.getOrder(), result, nbCPU);
                    return;
                }
                case -10: {
                    this.eroctogon.Filter(source, this.SE.getOrder(), result, nbCPU);
                    return;
                }
                case -1: {
                    this.erosquare.Filter(source, this.SE.getOrder(), result, nbCPU);
                    return;
                }
            }
            ErodeSegment135 fm = null;
            switch (this.SE.getType()) {
                case -3: {
                    fm = this.eroseg135;
                    break;
                }
                case -4: {
                    fm = this.eroseg45;
                    break;
                }
                case -9: {
                    fm = this.erohexagon;
                    break;
                }
                case -5: {
                    fm = this.erosegx;
                    break;
                }
                case -6: {
                    fm = this.erosegy;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Iterable structuring element unknown! This error must not occured!");
                }
            }
            block12 : switch (source.getType()) {
                case 10: {
                    Object[] srcbb = new Object[]{((DataBufferByte)source.getRaster().getDataBuffer()).getData()};
                    Object[] resbb = new Object[]{((DataBufferByte)result.getRaster().getDataBuffer()).getData()};
                    fm.Filter(srcbb, source.getWidth(), source.getHeight(), 1, -2, this.SE.getOrder(), resbb, nbCPU);
                    resbb[0] = null;
                    srcbb[0] = null;
                    resbb = null;
                    srcbb = null;
                    break;
                }
                case 11: {
                    Object[] srcsb = new Object[]{((DataBufferUShort)source.getRaster().getDataBuffer()).getData()};
                    Object[] ressb = new Object[]{((DataBufferUShort)result.getRaster().getDataBuffer()).getData()};
                    fm.Filter(srcsb, source.getWidth(), source.getHeight(), 1, -3, this.SE.getOrder(), ressb, nbCPU);
                    ressb[0] = null;
                    srcsb[0] = null;
                    ressb = null;
                    srcsb = null;
                    break;
                }
                case 5: 
                case 6: {
                    fm.FilterInterlaced((Object)((DataBufferByte)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -2, this.SE.getOrder(), (Object)((DataBufferByte)result.getRaster().getDataBuffer()).getData(), nbCPU);
                    break;
                }
                case 0: {
                    switch (source.getRaster().getDataBuffer().getDataType()) {
                        case 3: {
                            fm.FilterInterlaced((Object)((DataBufferInt)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -1, this.SE.getOrder(), (Object)((DataBufferInt)result.getRaster().getDataBuffer()).getData(), nbCPU);
                            break block12;
                        }
                        case 4: {
                            fm.FilterInterlaced((Object)((DataBufferFloat)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -4, this.SE.getOrder(), (Object)((DataBufferFloat)result.getRaster().getDataBuffer()).getData(), nbCPU);
                            break block12;
                        }
                        case 5: {
                            fm.FilterInterlaced((Object)((DataBufferDouble)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -5, this.SE.getOrder(), (Object)((DataBufferDouble)result.getRaster().getDataBuffer()).getData(), nbCPU);
                            break block12;
                        }
                    }
                    throw new IllegalArgumentException("DataBuffer type not supported (yet).");
                }
                default: {
                    throw new IllegalArgumentException("Image type not supported (yet).");
                }
            }
            return;
        }
        this.SE.PreComputePositions(source.getWidth(), source.getRaster().getNumBands());
        block23 : switch (source.getType()) {
            case 10: {
                Object[] srcbb = new Object[]{((DataBufferByte)source.getRaster().getDataBuffer()).getData()};
                Object[] resbb = new Object[]{((DataBufferByte)result.getRaster().getDataBuffer()).getData()};
                this.erogen.Filter(srcbb, source.getWidth(), source.getHeight(), 1, -2, this.SE.getBackward(), this.SE.getSE(), this.SE.getForward(), this.SE.getSizeX(), this.SE.getSizeY(), 0, resbb, nbCPU);
                resbb[0] = null;
                srcbb[0] = null;
                resbb = null;
                srcbb = null;
                break;
            }
            case 11: {
                Object[] srcsb = new Object[]{((DataBufferUShort)source.getRaster().getDataBuffer()).getData()};
                Object[] ressb = new Object[]{((DataBufferUShort)result.getRaster().getDataBuffer()).getData()};
                this.erogen.Filter(srcsb, source.getWidth(), source.getHeight(), 1, -3, this.SE.getBackward(), this.SE.getSE(), this.SE.getForward(), this.SE.getSizeX(), this.SE.getSizeY(), 0, ressb, nbCPU);
                ressb[0] = null;
                srcsb[0] = null;
                ressb = null;
                srcsb = null;
                break;
            }
            case 5: 
            case 6: {
                this.erogen.FilterInterlaced((Object)((DataBufferByte)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -2, this.SE.getBackward(), this.SE.getSE(), this.SE.getForward(), this.SE.getSizeX(), this.SE.getSizeY(), 0, (Object)((DataBufferByte)result.getRaster().getDataBuffer()).getData(), nbCPU);
                break;
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        this.erogen.FilterInterlaced((Object)((DataBufferInt)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -1, this.SE.getBackward(), this.SE.getSE(), this.SE.getForward(), this.SE.getSizeX(), this.SE.getSizeY(), 0, (Object)((DataBufferInt)result.getRaster().getDataBuffer()).getData(), nbCPU);
                        break block23;
                    }
                    case 4: {
                        this.erogen.FilterInterlaced((Object)((DataBufferFloat)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -4, this.SE.getBackward(), this.SE.getSE(), this.SE.getForward(), this.SE.getSizeX(), this.SE.getSizeY(), 0, (Object)((DataBufferFloat)result.getRaster().getDataBuffer()).getData(), nbCPU);
                        break block23;
                    }
                    case 5: {
                        this.erogen.FilterInterlaced((Object)((DataBufferDouble)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -5, this.SE.getBackward(), this.SE.getSE(), this.SE.getForward(), this.SE.getSizeX(), this.SE.getSizeY(), 0, (Object)((DataBufferDouble)result.getRaster().getDataBuffer()).getData(), nbCPU);
                        break block23;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public StructuringElement getStructuringElement() {
        return this.SE;
    }

    public void setStructuringElement(StructuringElement SE) {
        this.SE = SE;
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        this.setStructuringElement3D(se);
        DV result = DvNew.Same((DV)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        this.setStructuringElement3D(se);
        this.Filter(source, result, nbCPU);
    }

    public DV Filter(DV source, int nbCPU) {
        DV result = DvNew.Same((DV)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(DV source, DV result, int nbCPU) {
        if (this.SE3.isIterable()) {
            switch (this.SE3.getType()) {
                case -1: {
                    this.erosquare.Filter(source, this.SE3.getOrder(), result, nbCPU);
                    return;
                }
            }
            ErodeSegmentX fm = null;
            switch (this.SE3.getType()) {
                case -3: {
                    fm = this.erosegx;
                    break;
                }
                case -4: {
                    fm = this.erosegy;
                    break;
                }
                case -5: {
                    fm = this.erosegz;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Iterable structuring element unknown! This error must not occured!");
                }
            }
            switch (source.Type) {
                case 8: {
                    fm.Filter(source.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -2, this.SE3.getOrder(), result.getDataBuffer(), nbCPU);
                    break;
                }
                case 16: {
                    fm.Filter(source.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -3, this.SE3.getOrder(), result.getDataBuffer(), nbCPU);
                    break;
                }
                case 32: {
                    fm.Filter(source.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -1, this.SE3.getOrder(), result.getDataBuffer(), nbCPU);
                    break;
                }
                case -32: {
                    fm.Filter(source.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -4, this.SE3.getOrder(), result.getDataBuffer(), nbCPU);
                    break;
                }
                case 64: {
                    fm.Filter(source.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -5, this.SE3.getOrder(), result.getDataBuffer(), nbCPU);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type not supported (yet).");
                }
            }
            return;
        }
        this.SE3.PreComputePositions(source.SizeX, source.SizeY);
        switch (source.Type) {
            case 8: {
                this.erogen.Filter(source.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -2, this.SE3.getBackward(), this.SE3.getSE(), this.SE3.getForward(), this.SE3.getSizeX(), this.SE3.getSizeY(), this.SE3.getSizeZ(), result.getDataBuffer(), nbCPU);
                break;
            }
            case 16: {
                this.erogen.Filter(source.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -3, this.SE3.getBackward(), this.SE3.getSE(), this.SE3.getForward(), this.SE3.getSizeX(), this.SE3.getSizeY(), this.SE3.getSizeZ(), result.getDataBuffer(), nbCPU);
                break;
            }
            case 32: {
                this.erogen.Filter(source.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -1, this.SE3.getBackward(), this.SE3.getSE(), this.SE3.getForward(), this.SE3.getSizeX(), this.SE3.getSizeY(), this.SE3.getSizeZ(), result.getDataBuffer(), nbCPU);
                break;
            }
            case -32: {
                this.erogen.Filter(source.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -4, this.SE3.getBackward(), this.SE3.getSE(), this.SE3.getForward(), this.SE3.getSizeX(), this.SE3.getSizeY(), this.SE3.getSizeZ(), result.getDataBuffer(), nbCPU);
                break;
            }
            case 64: {
                this.erogen.Filter(source.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -5, this.SE3.getBackward(), this.SE3.getSE(), this.SE3.getForward(), this.SE3.getSizeX(), this.SE3.getSizeY(), this.SE3.getSizeZ(), result.getDataBuffer(), nbCPU);
            }
        }
    }

    public StructuringElement3D getStructuringElement3D() {
        return this.SE3;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
        this.SE3 = se;
    }

    public byte[] Filter(byte[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public byte[] Filter(byte[] source, int nbCPU) {
        byte[] result = ArrayNew.Same((byte[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(byte[] source, byte[] result, int nbCPU) {
        this.Filter(source, this.SE, result, nbCPU);
    }

    public void Filter(byte[] source, StructuringElement SE, byte[] result, int nbCPU) {
        if (nbCPU < 1) {
            throw new IllegalArgumentException("nbCPU < 1.");
        }
        if (SE == null) {
            throw new IllegalArgumentException("Any structuring element defined.");
        }
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays source and result must have equal dimension.");
        }
        this.setStructuringElement(SE);
        Object[] objsrc = new Object[]{source};
        Object[] objres = new Object[]{result};
        this.erosegx.Filter(objsrc, source.length, 1, 1, -2, SE.getOrder(), objres, nbCPU);
        objres[0] = null;
        objsrc[0] = null;
        objres = null;
        objsrc = null;
    }

    public short[] Filter(short[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public short[] Filter(short[] source, int nbCPU) {
        short[] result = ArrayNew.Same((short[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(short[] source, short[] result, int nbCPU) {
        this.setStructuringElement(this.SE);
        this.Filter(source, this.SE, result, nbCPU);
    }

    public void Filter(short[] source, StructuringElement SE, short[] result, int nbCPU) {
        if (SE == null) {
            throw new IllegalArgumentException("Any structuring element defined.");
        }
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays source and result must have equal dimension.");
        }
        this.setStructuringElement(SE);
        Object[] objsrc = new Object[]{source};
        Object[] objres = new Object[]{result};
        this.erosegx.Filter(objsrc, source.length, 1, 1, -3, SE.getOrder(), objres, nbCPU);
        objres[0] = null;
        objsrc[0] = null;
        objres = null;
        objsrc = null;
    }

    public int[] Filter(int[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public int[] Filter(int[] source, int nbCPU) {
        int[] result = ArrayNew.Same((int[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(int[] source, StructuringElement SE, int[] result, int nbCPU) {
        this.setStructuringElement(SE);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(int[] source, int[] result, int nbCPU) {
        if (this.SE == null) {
            throw new IllegalArgumentException("Any structuring element defined.");
        }
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays source and result must have equal dimension.");
        }
        Object[] objsrc = new Object[]{source};
        Object[] objres = new Object[]{result};
        this.erosegx.Filter(objsrc, source.length, 1, 1, -1, this.SE.getOrder(), objres, nbCPU);
        objres[0] = null;
        objsrc[0] = null;
        objres = null;
        objsrc = null;
    }

    public double[] Filter(double[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public double[] Filter(double[] source, int nbCPU) {
        double[] result = ArrayNew.Same((double[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(double[] source, double[] result, int nbCPU) {
        this.Filter(source, this.SE, result, nbCPU);
    }

    public void Filter(double[] source, StructuringElement SE, double[] result, int nbCPU) {
        if (SE == null) {
            throw new IllegalArgumentException("Any structuring element defined.");
        }
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays source and result must have equal dimension.");
        }
        this.setStructuringElement(SE);
        Object[] objsrc = new Object[]{source};
        Object[] objres = new Object[]{result};
        this.erosegx.Filter(objsrc, source.length, 1, 1, -5, SE.getOrder(), objres, nbCPU);
        objres[0] = null;
        objsrc[0] = null;
        objres = null;
        objsrc = null;
    }

    public float[] Filter(float[] source, StructuringElement SE, int nbCPU) {
        this.setStructuringElement(SE);
        return this.Filter(source, nbCPU);
    }

    public float[] Filter(float[] source, int nbCPU) {
        float[] result = ArrayNew.Same((float[])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(float[] source, float[] result, int nbCPU) {
        this.Filter(source, this.SE, result, nbCPU);
    }

    public void Filter(float[] source, StructuringElement SE, float[] result, int nbCPU) {
        if (SE == null) {
            throw new IllegalArgumentException("Any structuring element defined.");
        }
        if (source.length != result.length) {
            throw new IllegalArgumentException("Arrays source and result must have equal dimension.");
        }
        this.setStructuringElement(SE);
        Object[] objsrc = new Object[]{source};
        Object[] objres = new Object[]{result};
        this.erosegx.Filter(objsrc, source.length, 1, 1, -4, SE.getOrder(), objres, nbCPU);
        objres[0] = null;
        objsrc[0] = null;
        objres = null;
        objsrc = null;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        if (parameters[0] instanceof StructuringElement) {
            this.setStructuringElement((StructuringElement)parameters[0]);
        } else if (parameters[0] instanceof StructuringElement3D) {
            this.setStructuringElement3D((StructuringElement3D)parameters[0]);
        } else {
            throw new IllegalArgumentException("The parameter is not a structuring element.");
        }
    }

    public List<Object> Parameters() {
        return null;
    }

    public int BorderEffectSizeX() {
        if (this.SE != null) {
            return this.SE.getSizeX() >> 1;
        }
        if (this.SE3 != null) {
            return this.SE3.getSizeX() >> 1;
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public int BorderEffectSizeY() {
        if (this.SE != null) {
            return this.SE.getSizeY() >> 1;
        }
        if (this.SE3 != null) {
            return this.SE3.getSizeY() >> 1;
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public int BorderEffectSizeZ() {
        if (this.SE != null) {
            return 0;
        }
        if (this.SE3 != null) {
            return this.SE3.getSizeX() >> 1;
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public MorphoFilter Clone() {
        Erode erode = new Erode();
        if (this.SE != null) {
            erode.setStructuringElement(this.SE.Clone());
        }
        if (this.SE3 != null) {
            erode.setStructuringElement3D(this.SE3.Clone());
        }
        return erode;
    }
}

