/*
 * Decompiled with CFR 0.152.
 */
package metaheuristics.taboo;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import metaheuristics.EvaluationFunctionBinary;

public class Taboo {
    private final int SUCCESS = 4;
    private final int NEUTRAL = 1;
    private final int FAILURE = -1;
    protected final int EXCHANGE = 0;
    protected final int DELETE = 1;
    protected final int ADD = 2;
    protected int nbVariables = 0;
    protected int Iteration = 0;
    protected int IterationMax = 1000;
    protected int Inchange = 0;
    protected int InchangeMax = 150;
    protected int AutomaticSave = -1;
    protected int ConstraintSizeMin = 1;
    protected int ConstraintSizeMax = 0;
    protected double Delta = 0.025;
    protected double Alpha = 0.9;
    protected double Ajout = 1.0;
    protected double Echange = 1.0;
    protected double Suppression = 1.0;
    protected double ProbabilitySecurity = 3.0;
    protected int FindBestMoveIterationSecurity = 2000;
    protected int[] NbPossibleMove = null;
    protected double[] MonoVariableEfficiency = null;
    protected double[][] Correlations = null;
    protected double[][] Exchanges = null;
    protected double[] Adds = null;
    protected double[] Deletes = null;
    protected List<MoveTaboo> Taboo = new Vector<MoveTaboo>(113);
    protected MoveTaboo[] Solutions = null;
    protected MoveTaboo BestSolution = null;
    private TabooThread[] threads = null;
    private List<Integer> threadsfree = new ArrayList<Integer>(13);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Launch(int nbVariables, boolean[] SolutionInitiale, EvaluationFunctionBinary[] Evaluations2, boolean Maximiser, int nbCPU) {
        Object object;
        int i2;
        MoveTaboo current = null;
        if (Evaluations2.length != nbCPU) {
            throw new IllegalArgumentException("nbCPU != Evaluations.length");
        }
        this.VerificationsAllocations(nbVariables);
        this.ComputeMonoVariableEfficiency(Evaluations2[0]);
        this.ComputeNbPossibleMoves();
        if (this.threads == null || this.threads.length != nbCPU) {
            this.threads = null;
            this.threads = new TabooThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threads[i2] = new TabooThread(i2);
                this.threads[i2].start();
            }
            object = this;
            synchronized (object) {
                while (this.threadsfree.size() != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (SolutionInitiale == null) {
            current = this.FindInitSolution();
        } else {
            if (nbVariables != SolutionInitiale.length) {
                throw new Error("nbVariables != SolutionInitiale.length");
            }
            current = new MoveTaboo(nbVariables);
            current.Result = SolutionInitiale;
            current.Nb = 0;
            for (i2 = 0; i2 < nbVariables; ++i2) {
                if (!current.Result[i2]) continue;
                ++current.Nb;
            }
        }
        current.Cost = Evaluations2[0].Evaluate(current.Result);
        current.Importance = Evaluations2[0].getImportanceVariable();
        this.SaveSolution(Maximiser, current, current);
        for (i2 = 0; i2 < nbCPU; ++i2) {
            try {
                this.threads[i2].Evaluation = Evaluations2[i2];
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.threads[i2].Maximiser = Maximiser;
            this.threads[i2].LastMove = current;
            this.threads[i2].Current = current;
        }
        this.Inchange = 0;
        this.Iteration = 0;
        this.threadsfree.clear();
        for (i2 = 0; i2 < nbCPU; ++i2) {
            object = this.threads[i2].lock;
            synchronized (object) {
                this.threads[i2].lock.notify();
                continue;
            }
        }
        object = this;
        synchronized (object) {
            while (this.threadsfree.size() != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected synchronized MoveTaboo FindBestMove(MoveTaboo Current) {
        int nbForay = 0;
        double Somme = this.Ajout + this.Suppression + this.Echange;
        double[] imp = Current.Importance;
        boolean End = false;
        MoveTaboo move = new MoveTaboo(this.nbVariables);
        move.Nb = Current.Nb;
        for (int i2 = 0; i2 < this.nbVariables; ++i2) {
            move.Importance[i2] = imp[i2];
            move.Result[i2] = Current.Result[i2];
        }
        while (!End) {
            End = true;
            double Tirage = Math.random() * Somme;
            move.Type = Tirage < this.Ajout ? 2 : (Tirage >= this.Ajout + this.Suppression ? 0 : 1);
            move.VarS = -1;
            move.VarA = -1;
            if (move.Nb == this.ConstraintSizeMax && move.Type == 2) {
                End = false;
            } else if (move.Nb == this.ConstraintSizeMin && move.Type == 1) {
                End = false;
            } else if (move.Nb == this.ConstraintSizeMax && move.Type == 0) {
                End = false;
            }
            if (End) {
                switch (move.Type) {
                    case 2: {
                        End = this.FindAdd(move);
                        break;
                    }
                    case 1: {
                        End = this.FindDelete(move);
                        break;
                    }
                    case 0: {
                        End = this.FindExchange(move);
                        break;
                    }
                    default: {
                        throw new Error("Default : " + move.Type);
                    }
                }
            }
            if (nbForay == this.FindBestMoveIterationSecurity) {
                this.Security(Current);
                nbForay = 0;
            }
            ++nbForay;
        }
        return move;
    }

    protected boolean FindAdd(MoveTaboo move) {
        double Somme;
        int candidat;
        int i2;
        double[] proba = null;
        double[] corre = null;
        double[] bornes = null;
        MoveTaboo mt = new MoveTaboo(2);
        Vector<Integer> liste = new Vector<Integer>(13);
        for (i2 = 0; i2 < this.nbVariables; ++i2) {
            if (move.Result[i2]) continue;
            mt.VarA = i2;
            if (this.IsTaboo(mt)) continue;
            liste.add(i2);
        }
        if (liste.isEmpty()) {
            return false;
        }
        if (liste.size() == 1) {
            move.VarA = (Integer)liste.get(0);
            move.Result[move.VarA] = true;
            ++move.Nb;
            liste = null;
            return true;
        }
        corre = new double[liste.size()];
        proba = new double[liste.size()];
        bornes = new double[liste.size()];
        double MaxCorre = 0.0;
        for (i2 = 0; i2 < liste.size(); ++i2) {
            candidat = (Integer)liste.get(i2);
            corre[i2] = 0.0;
            for (int j = 0; j < this.nbVariables; ++j) {
                if (!move.Result[j]) continue;
                int n = i2;
                corre[n] = corre[n] + this.Correlations[candidat][j];
            }
            if (!(MaxCorre < corre[i2])) continue;
            MaxCorre = corre[i2];
        }
        for (i2 = 0; i2 < liste.size(); ++i2) {
            corre[i2] = corre[i2] / MaxCorre * this.Alpha;
        }
        for (i2 = 0; i2 < liste.size(); ++i2) {
            candidat = (Integer)liste.get(i2);
            proba[i2] = this.Adds[candidat] * (1.0 - corre[i2]) * this.MonoVariableEfficiency[candidat];
        }
        bornes[0] = Somme = proba[0];
        for (i2 = 1; i2 < liste.size(); ++i2) {
            Somme += proba[i2];
            bornes[i2] = proba[i2] + bornes[i2 - 1];
        }
        double p = Math.random() * Somme;
        i2 = 0;
        while (p > bornes[i2]) {
            ++i2;
        }
        move.VarA = (Integer)liste.get(i2);
        move.VarS = -1;
        move.Result[move.VarA] = true;
        ++move.Nb;
        return true;
    }

    protected boolean FindDelete(MoveTaboo move) {
        double Somme;
        int candidat;
        int i2;
        double MaxCorre = 0.0;
        double[] proba = null;
        double[] corre = null;
        double[] bornes = null;
        MoveTaboo mt = new MoveTaboo(2);
        Vector<Integer> liste = new Vector<Integer>(13);
        for (i2 = 0; i2 < this.nbVariables; ++i2) {
            if (!move.Result[i2]) continue;
            mt.VarS = i2;
            if (this.IsTaboo(mt)) continue;
            liste.add(i2);
        }
        if (liste.isEmpty()) {
            return false;
        }
        if (liste.size() == 1) {
            move.VarS = (Integer)liste.get(0);
            move.Result[move.VarS] = false;
            --move.Nb;
            liste = null;
            return true;
        }
        corre = new double[liste.size()];
        proba = new double[liste.size()];
        bornes = new double[liste.size()];
        for (i2 = 0; i2 < liste.size(); ++i2) {
            candidat = (Integer)liste.get(i2);
            corre[i2] = 0.0;
            for (int j = 0; j < this.nbVariables; ++j) {
                if (!move.Result[j]) continue;
                int n = i2;
                corre[n] = corre[n] + this.Correlations[candidat][j];
            }
            int n = i2;
            corre[n] = corre[n] - 1.0;
            if (!(MaxCorre < corre[i2])) continue;
            MaxCorre = corre[i2];
        }
        for (i2 = 0; i2 < liste.size(); ++i2) {
            corre[i2] = corre[i2] / MaxCorre * this.Alpha;
        }
        for (i2 = 0; i2 < liste.size(); ++i2) {
            candidat = (Integer)liste.get(i2);
            proba[i2] = this.Deletes[candidat] * corre[i2] * (1.0 - this.Alpha * this.MonoVariableEfficiency[candidat]) * (1.0 - this.Alpha * move.Importance[candidat]);
        }
        bornes[0] = Somme = proba[0];
        for (i2 = 1; i2 < liste.size(); ++i2) {
            Somme += proba[i2];
            bornes[i2] = proba[i2] + bornes[i2 - 1];
        }
        double p = Math.random() * Somme;
        i2 = 0;
        while (p > bornes[i2]) {
            ++i2;
        }
        move.VarS = (Integer)liste.get(i2);
        move.VarA = -1;
        move.Result[move.VarS] = false;
        --move.Nb;
        return true;
    }

    protected boolean FindExchange(MoveTaboo move) {
        double Somme;
        int j;
        int i2;
        double[] proba = null;
        double[] correa = null;
        double[] corres = null;
        double[] bornes = null;
        Vector<MoveTaboo> liste = new Vector<MoveTaboo>(13);
        MoveTaboo mt = new MoveTaboo(2);
        for (i2 = 0; i2 < this.nbVariables; ++i2) {
            for (j = 0; j < this.nbVariables; ++j) {
                if (i2 == j || move.Result[i2] || !move.Result[j]) continue;
                mt.VarA = i2;
                mt.VarS = j;
                if (this.IsTaboo(mt)) continue;
                liste.add(mt);
                mt = null;
                mt = new MoveTaboo(2);
            }
        }
        if (liste.isEmpty()) {
            return false;
        }
        if (liste.size() == 1) {
            mt = null;
            mt = (MoveTaboo)liste.get(0);
            move.VarS = mt.VarS;
            move.VarA = mt.VarA;
            move.Result[move.VarS] = false;
            move.Result[move.VarA] = true;
            liste = null;
            return true;
        }
        correa = new double[liste.size()];
        corres = new double[liste.size()];
        proba = new double[liste.size()];
        bornes = new double[liste.size()];
        double MaxCorreS = 0.0;
        double MaxCorreA = 0.0;
        for (i2 = 0; i2 < liste.size(); ++i2) {
            mt = null;
            mt = (MoveTaboo)liste.get(i2);
            corres[i2] = 0.0;
            correa[i2] = 0.0;
            for (j = 0; j < this.nbVariables; ++j) {
                if (!move.Result[j] || j == move.VarS) continue;
                int n = i2;
                correa[n] = correa[n] + this.Correlations[mt.VarA][j];
                int n2 = i2;
                corres[n2] = corres[n2] + this.Correlations[mt.VarS][j];
            }
            if (MaxCorreA < correa[i2]) {
                MaxCorreA = correa[i2];
            }
            if (!(MaxCorreS < corres[i2])) continue;
            MaxCorreS = corres[i2];
        }
        for (i2 = 0; i2 < liste.size(); ++i2) {
            correa[i2] = correa[i2] / MaxCorreA * this.Alpha;
            corres[i2] = corres[i2] / MaxCorreS * this.Alpha;
        }
        for (i2 = 0; i2 < liste.size(); ++i2) {
            mt = null;
            mt = (MoveTaboo)liste.get(i2);
            proba[i2] = this.Deletes[mt.VarS] * this.Adds[mt.VarA] * this.Exchanges[mt.VarA][mt.VarS] * (1.0 - correa[i2]) * corres[i2] * this.MonoVariableEfficiency[mt.VarA] * (1.0 - this.Alpha * this.MonoVariableEfficiency[mt.VarS]) * (1.0 - this.Alpha * move.Importance[mt.VarS]);
        }
        bornes[0] = Somme = proba[0];
        for (i2 = 1; i2 < liste.size(); ++i2) {
            Somme += proba[i2];
            bornes[i2] = proba[i2] + bornes[i2 - 1];
        }
        double p = Math.random() * Somme;
        i2 = 0;
        while (p > bornes[i2]) {
            ++i2;
        }
        mt = (MoveTaboo)liste.get(i2);
        move.VarA = mt.VarA;
        move.VarS = mt.VarS;
        move.Result[move.VarA] = true;
        move.Result[move.VarS] = false;
        return true;
    }

    protected synchronized void MoveResult(double Result, MoveTaboo Move) {
        switch (Move.Type) {
            case 0: {
                this.Echange += Result * this.Delta;
                double[] dArray = this.Exchanges[Move.VarA];
                int n = Move.VarS;
                dArray[n] = dArray[n] + Result * this.Delta;
                double[] dArray2 = this.Exchanges[Move.VarS];
                int n2 = Move.VarA;
                dArray2[n2] = dArray2[n2] - Result * this.Delta;
                if (this.Echange < 2.0 * this.Delta) {
                    this.Echange = 2.0 * this.Delta;
                }
                if (this.Exchanges[Move.VarA][Move.VarS] < 2.0 * this.Delta) {
                    this.Exchanges[Move.VarA][Move.VarS] = 2.0 * this.Delta;
                }
                if (this.Exchanges[Move.VarS][Move.VarA] < 2.0 * this.Delta) {
                    this.Exchanges[Move.VarS][Move.VarA] = 2.0 * this.Delta;
                }
                if (this.Echange > this.ProbabilitySecurity) {
                    this.Echange = this.ProbabilitySecurity;
                }
                if (this.Exchanges[Move.VarA][Move.VarS] > this.ProbabilitySecurity) {
                    this.Exchanges[Move.VarA][Move.VarS] = this.ProbabilitySecurity;
                }
                if (!(this.Exchanges[Move.VarS][Move.VarA] > this.ProbabilitySecurity)) break;
                this.Exchanges[Move.VarS][Move.VarA] = this.ProbabilitySecurity;
                break;
            }
            case 2: {
                this.Ajout += Result * this.Delta;
                int n = Move.VarA;
                this.Adds[n] = this.Adds[n] + Result * this.Delta;
                if (this.Ajout < 2.0 * this.Delta) {
                    this.Ajout = 2.0 * this.Delta;
                }
                if (this.Adds[Move.VarA] < 2.0 * this.Delta) {
                    this.Adds[Move.VarA] = 2.0 * this.Delta;
                }
                if (this.Ajout > this.ProbabilitySecurity) {
                    this.Ajout = this.ProbabilitySecurity;
                }
                if (!(this.Adds[Move.VarA] > this.ProbabilitySecurity)) break;
                this.Adds[Move.VarA] = this.ProbabilitySecurity;
                break;
            }
            case 1: {
                this.Suppression += Result * this.Delta;
                int n = Move.VarS;
                this.Deletes[n] = this.Deletes[n] + Result * this.Delta;
                if (this.Suppression < 2.0 * this.Delta) {
                    this.Suppression = 2.0 * this.Delta;
                }
                if (this.Suppression > this.ProbabilitySecurity) {
                    this.Suppression = this.ProbabilitySecurity;
                }
                if (this.Deletes[Move.VarS] < 2.0 * this.Delta) {
                    this.Deletes[Move.VarS] = 2.0 * this.Delta;
                }
                if (!(this.Deletes[Move.VarS] > this.ProbabilitySecurity)) break;
                this.Deletes[Move.VarS] = this.ProbabilitySecurity;
                break;
            }
            default: {
                throw new Error("Default: " + Move.Type);
            }
        }
    }

    protected synchronized void UpdateTabooList(MoveTaboo Move, int Result) {
        double TirageI = Math.random();
        double TirageS = Math.random();
        double max = this.NbPossibleMove[Move.Nb];
        MoveTaboo mt = this.Complementaire(Move);
        if (TirageI > TirageS) {
            double Tampon = TirageS;
            TirageS = TirageI;
            TirageI = Tampon;
        }
        switch (Result) {
            case 4: {
                mt.Tabou = this.Iteration + (int)(max / 2.0 + TirageS * max / 2.0 + 0.5);
                Move.Tabou = this.Iteration + (int)(TirageS * max / 2.0 + 0.5);
                if (this.IsTaboo(mt)) break;
                this.Taboo.add(0, mt);
                break;
            }
            case 1: {
                mt.Tabou = this.Iteration + (int)(TirageS * max + 0.5);
                Move.Tabou = this.Iteration + (int)(TirageI * max + 0.5);
                if (this.IsTaboo(mt)) break;
                this.Taboo.add(0, mt);
                break;
            }
            case -1: {
                Move.Tabou = this.Iteration + (int)(TirageS * max + 0.5);
                break;
            }
            default: {
                throw new Error("Default : " + Result);
            }
        }
        this.Taboo.add(0, Move);
        int i2 = 0;
        while (i2 < this.Taboo.size()) {
            if (this.Taboo.get((int)i2).Tabou <= this.Iteration) {
                this.Taboo.remove(i2);
                continue;
            }
            ++i2;
        }
        while ((double)this.Taboo.size() >= max) {
            this.Taboo.remove(this.Taboo.size() - 1);
        }
        mt = null;
    }

    protected boolean IsTaboo(MoveTaboo move) {
        boolean Find = false;
        MoveTaboo mt = null;
        Iterator<MoveTaboo> iter = this.Taboo.iterator();
        while (iter.hasNext() && !Find) {
            mt = iter.next();
            if (mt.VarA == move.VarA && mt.VarS == move.VarS) {
                Find = true;
            }
            mt = null;
        }
        iter = null;
        return Find;
    }

    protected synchronized int SaveSolution(boolean Maximiser, MoveTaboo Current, MoveTaboo LastMove) {
        if (this.Solutions[Current.Nb].Cost < 0.0 || Maximiser && Current.Cost > this.Solutions[Current.Nb].Cost || !Maximiser && Current.Cost < this.Solutions[Current.Nb].Cost) {
            this.Solutions[Current.Nb] = this.Duplicate(Current);
        }
        if (this.BestSolution.Cost < 0.0 || Maximiser && Current.Cost > this.BestSolution.Cost || !Maximiser && Current.Cost < this.BestSolution.Cost) {
            this.BestSolution = this.Duplicate(Current);
            return 4;
        }
        if (Maximiser && LastMove.Cost <= Current.Cost || !Maximiser && Current.Cost <= LastMove.Cost) {
            return 1;
        }
        return -1;
    }

    protected MoveTaboo Duplicate(MoveTaboo src) {
        MoveTaboo copy = new MoveTaboo(src.Result.length);
        copy.Cost = src.Cost;
        copy.VarA = src.VarA;
        copy.VarS = src.VarS;
        copy.Nb = src.Nb;
        copy.Type = src.Type;
        for (int i2 = 0; i2 < src.Result.length; ++i2) {
            copy.Result[i2] = src.Result[i2];
            copy.Importance[i2] = src.Importance[i2];
        }
        return copy;
    }

    protected MoveTaboo Complementaire(MoveTaboo src) {
        MoveTaboo comp = new MoveTaboo(src.Result.length);
        comp.VarA = src.VarS;
        comp.VarS = src.VarA;
        comp.Nb = src.Nb;
        switch (src.Type) {
            case 2: {
                comp.Type = 1;
                break;
            }
            case 1: {
                comp.Type = 2;
                break;
            }
            case 0: {
                comp.Type = src.Type;
                break;
            }
            default: {
                throw new Error("Default : " + src.Type);
            }
        }
        return comp;
    }

    protected void Security(MoveTaboo Current) {
        int i2 = 0;
        if (this.Ajout < 1.0) {
            this.Ajout = 0.5;
        }
        if (this.Ajout > 2.0) {
            this.Ajout = 2.0;
        }
        if (this.Echange < 1.0) {
            this.Echange = 0.5;
        }
        if (this.Echange > 2.0) {
            this.Echange = 2.0;
        }
        if (this.Suppression < 1.0) {
            this.Suppression = 0.5;
        }
        if (this.Suppression > 2.0) {
            this.Suppression = 2.0;
        }
        if (Current.Nb == this.ConstraintSizeMax) {
            while (i2 < this.Taboo.size()) {
                if (this.Taboo.get((int)i2).Type == 1) {
                    this.Taboo.remove(i2);
                    continue;
                }
                ++i2;
            }
        } else if (Current.Nb == this.ConstraintSizeMin) {
            while (i2 < this.Taboo.size()) {
                if (this.Taboo.get((int)i2).Type == 2) {
                    this.Taboo.remove(i2);
                    continue;
                }
                ++i2;
            }
        } else {
            while (i2 < this.Taboo.size()) {
                if (this.Taboo.get((int)i2).Type == 2 || this.Taboo.get((int)i2).Type == 1) {
                    this.Taboo.remove(i2);
                    continue;
                }
                ++i2;
            }
        }
    }

    protected MoveTaboo FindInitSolution() {
        boolean Fin = false;
        MoveTaboo initsol = new MoveTaboo(this.nbVariables);
        while (!Fin) {
            int i2;
            Fin = true;
            for (i2 = 0; i2 < this.nbVariables; ++i2) {
                initsol.Result[i2] = (int)(Math.random() * 1000.0) % 2 != 0;
            }
            initsol.Nb = 0;
            for (i2 = 0; i2 < this.nbVariables; ++i2) {
                if (!initsol.Result[i2]) continue;
                ++initsol.Nb;
            }
            if (initsol.Nb >= this.ConstraintSizeMin && this.ConstraintSizeMax >= initsol.Nb) continue;
            Fin = false;
        }
        return initsol;
    }

    protected void ComputeMonoVariableEfficiency(EvaluationFunctionBinary Evaluation2) {
        int i2;
        double Max = 0.0;
        boolean[] var = new boolean[this.nbVariables];
        this.MonoVariableEfficiency = null;
        this.MonoVariableEfficiency = new double[this.nbVariables];
        for (i2 = 0; i2 < this.nbVariables; ++i2) {
            var[i2] = false;
        }
        for (i2 = 0; i2 < this.nbVariables; ++i2) {
            var[i2] = true;
            this.MonoVariableEfficiency[i2] = Evaluation2.Evaluate(var);
            var[i2] = false;
            if (!(this.MonoVariableEfficiency[i2] > Max)) continue;
            Max = this.MonoVariableEfficiency[i2];
        }
        i2 = 0;
        while (i2 < this.nbVariables) {
            int n = i2++;
            this.MonoVariableEfficiency[n] = this.MonoVariableEfficiency[n] / Max;
        }
        var = null;
    }

    protected void ComputeNbPossibleMoves() {
        for (int n = 1; n <= this.nbVariables; ++n) {
            int Exc;
            int Del;
            int Add;
            if (n == this.ConstraintSizeMin) {
                Add = this.nbVariables - n;
                Del = 0;
                Exc = this.ConstraintSizeMin * (this.nbVariables - this.ConstraintSizeMin);
            } else if (n == this.ConstraintSizeMax) {
                Add = 0;
                Del = n;
                Exc = this.ConstraintSizeMax * (this.nbVariables - this.ConstraintSizeMax);
            } else {
                Add = this.nbVariables - n;
                Del = n;
                Exc = n * (this.nbVariables - n);
            }
            this.NbPossibleMove[n] = Add + Del + Exc;
        }
    }

    protected void VerificationsAllocations(int nbVariables) {
        int j;
        int i2;
        if (nbVariables <= 1) {
            throw new Error("Nombre de variables errone (>1 attendu) : " + nbVariables);
        }
        this.nbVariables = nbVariables;
        if (this.ConstraintSizeMax == 0) {
            this.ConstraintSizeMax = nbVariables;
        } else if (this.ConstraintSizeMax < this.ConstraintSizeMin || nbVariables < this.ConstraintSizeMax) {
            throw new Error("ContrainteTailleMax, valeur erronee : " + this.ConstraintSizeMax + ", attendu [ContrainteTailleMin=" + this.ConstraintSizeMin + ",nbVariables=" + nbVariables + "].");
        }
        if (this.ConstraintSizeMin != 1 && (this.ConstraintSizeMin < 1 || this.ConstraintSizeMax < this.ConstraintSizeMin)) {
            throw new Error("ContrainteTailleMin, valeur erronee : " + this.ConstraintSizeMin + ", attendu [1,ContrainteTailleMax=" + this.ConstraintSizeMax + "].");
        }
        if (this.Correlations == null) {
            this.Correlations = new double[nbVariables][nbVariables];
            for (i2 = 0; i2 < nbVariables; ++i2) {
                for (j = 0; j < nbVariables; ++j) {
                    this.Correlations[i2][j] = 1.0;
                }
            }
        } else {
            if (this.Correlations != null && (this.Correlations.length != this.Correlations[0].length || this.Correlations.length != nbVariables)) {
                throw new Error("Taille du tableau de correlation entre les variables different du nombre de variable ou non carre.");
            }
            for (i2 = 0; i2 < nbVariables; ++i2) {
                for (j = 0; j < nbVariables; ++j) {
                    if (!(this.Correlations[i2][j] <= 0.0) && !(1.0 < this.Correlations[i2][j])) continue;
                    throw new Error("Valeur erronee dans le tableau de correlations (attendu ]0,1]) : " + this.Correlations[i2][j]);
                }
            }
        }
        this.BestSolution = new MoveTaboo(nbVariables);
        this.Solutions = new MoveTaboo[nbVariables + 1];
        for (i2 = 0; i2 <= nbVariables; ++i2) {
            this.Solutions[i2] = new MoveTaboo(nbVariables);
        }
        this.Adds = new double[nbVariables];
        this.Deletes = new double[nbVariables];
        this.Exchanges = new double[nbVariables][nbVariables];
        for (i2 = 0; i2 < nbVariables; ++i2) {
            this.Deletes[i2] = 1.0;
            this.Adds[i2] = 1.0;
            for (j = 0; j < nbVariables; ++j) {
                this.Exchanges[i2][j] = 1.0;
            }
        }
        this.NbPossibleMove = new int[nbVariables + 1];
    }

    protected void WriteCurrentSolutions() {
        Calendar cal = Calendar.getInstance();
        DataOutputStream Sortie = null;
        File FichierSortie = new File("TabooResults_" + cal.get(1) + "_" + (cal.get(2) + 1) + "_" + cal.get(5) + "_" + cal.get(11) + "h" + cal.get(12) + "_Iter" + this.Iteration + ".txt");
        try {
            FichierSortie.createNewFile();
            Sortie = new DataOutputStream(new FileOutputStream(FichierSortie));
            for (int y = 0; y < this.Solutions.length; ++y) {
                for (int x = 0; x < this.Solutions[y].Result.length; ++x) {
                    Sortie.write(String.valueOf((this.Solutions[y].Result[x] ? 1 : 0) + " ").getBytes("ASCII"));
                }
                Sortie.write(String.valueOf(this.Solutions[y].Cost + "\n").getBytes("ASCII"));
            }
            Sortie.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getIterationMax() {
        return this.IterationMax;
    }

    public void setIterationMax(int iterationMax) {
        this.IterationMax = iterationMax;
    }

    public int getInchangeMax() {
        return this.InchangeMax;
    }

    public void setInchangeMax(int InchangeMax) {
        this.InchangeMax = InchangeMax;
    }

    public int getConstraintSizeMin() {
        return this.ConstraintSizeMin;
    }

    public void setConstraintSizeMin(int ConstraintSizeMin) {
        this.ConstraintSizeMin = ConstraintSizeMin;
    }

    public int getConstraintSizeMax() {
        return this.ConstraintSizeMax;
    }

    public void setConstraintSizeMax(int ConstraintSizeMax) {
        this.ConstraintSizeMax = ConstraintSizeMax;
    }

    public double getDelta() {
        return this.Delta;
    }

    public int getAutomaticSave() {
        return this.AutomaticSave;
    }

    public void setAutomaticSave(int AutomaticSave) {
        if (AutomaticSave == 0 || AutomaticSave == 1) {
            throw new IllegalArgumentException("Valeur incorrecte. Attendu : tout sauf 0 et 1");
        }
        this.AutomaticSave = AutomaticSave;
    }

    public void setDelta(double Delta) {
        if (Delta < 0.0 || 1.0 <= Delta) {
            throw new IllegalArgumentException("Bad value of Delta (wish ]0,1[): " + Delta);
        }
        this.Delta = Delta;
    }

    public double getAlpha() {
        return this.Alpha;
    }

    public void setAlpha(double Alpha) {
        if (Alpha < 0.05 || 0.95 < Alpha) {
            throw new Error("Valeur incorrecte (attendu [0.05,0.95]) : " + Alpha);
        }
        this.Alpha = Alpha;
    }

    public MoveTaboo getBestSolution() {
        return this.BestSolution;
    }

    public MoveTaboo[] getSolutions() {
        return this.Solutions;
    }

    public void setCorrelations(double[][] Correlations2) {
        this.Correlations = Correlations2;
    }

    public double getProbabilitySecurity() {
        return this.ProbabilitySecurity;
    }

    public void setProbabilitySecurity(double ProbabilitySecurity) {
        if (ProbabilitySecurity < 1.0) {
            throw new Error("Probabilite de securite erronee, ProbabilitySecurity < 1.0");
        }
        this.ProbabilitySecurity = ProbabilitySecurity;
    }

    public int getFindBestMoveIterationSecurity() {
        return this.FindBestMoveIterationSecurity;
    }

    public void setFindBestMoveIterationSecurity(int FindBestMoveIterationSecurity) {
        if (FindBestMoveIterationSecurity < 100) {
            throw new Error("FindBestMoveIterationSecurity < 100");
        }
        this.FindBestMoveIterationSecurity = FindBestMoveIterationSecurity;
    }

    private synchronized void IncrementIteration() {
        ++this.Iteration;
    }

    private synchronized int getIteration() {
        return this.Iteration;
    }

    private synchronized void IncrementInchange() {
        ++this.Inchange;
    }

    private synchronized void ResetInchange() {
        this.Inchange = 0;
    }

    private synchronized int getInchange() {
        return this.Inchange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addFreeThread(int number) {
        List<Integer> list = this.threadsfree;
        synchronized (list) {
            this.threadsfree.add(number);
        }
        this.notify();
    }

    private class TabooThread
    extends Thread {
        private int number = -1;
        public EvaluationFunctionBinary Evaluation = null;
        public boolean Maximiser = true;
        public MoveTaboo Current = null;
        public MoveTaboo LastMove = null;
        public Object lock = new Object();

        public TabooThread(int number) {
            this.number = number;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        Taboo.this.addFreeThread(this.number);
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                while (true) {
                    if (Taboo.this.getInchange() >= Taboo.this.InchangeMax || Taboo.this.getIteration() >= Taboo.this.IterationMax) continue block10;
                    this.LastMove = null;
                    this.LastMove = this.Current;
                    this.Current = Taboo.this.FindBestMove(this.Current);
                    this.Current.Cost = this.Evaluation.Evaluate(this.Current.Result);
                    this.Current.Importance = this.Evaluation.getImportanceVariable();
                    int Result = Taboo.this.SaveSolution(this.Maximiser, this.Current, this.LastMove);
                    switch (Result) {
                        case 4: {
                            Taboo.this.MoveResult(4.0, this.Current);
                            Taboo.this.ResetInchange();
                            break;
                        }
                        case 1: {
                            Taboo.this.MoveResult(1.0, this.Current);
                            Taboo.this.IncrementInchange();
                            break;
                        }
                        case -1: {
                            Taboo.this.MoveResult(-1.0, this.Current);
                            Taboo.this.IncrementInchange();
                            break;
                        }
                        default: {
                            throw new Error("Default: SaveSolution(Maximiser).");
                        }
                    }
                    Taboo.this.UpdateTabooList(this.Current, Result);
                    Taboo.this.IncrementIteration();
                    if (Taboo.this.AutomaticSave <= 1 || Taboo.this.getIteration() % Taboo.this.AutomaticSave != 0) continue;
                    Taboo.this.WriteCurrentSolutions();
                }
                break;
            }
        }
    }

    public class MoveTaboo {
        public double Cost = -1.0;
        public int Type = -1;
        public int VarA = -1;
        public int VarS = -1;
        public int Nb = -1;
        public int Tabou = -1;
        public boolean[] Result = null;
        double[] Importance = null;

        public MoveTaboo(int Taille) {
            if (Taille < 2) {
                throw new Error("Taille du tableau erronees.");
            }
            this.Result = new boolean[Taille];
            this.Importance = new double[Taille];
        }
    }
}

