/*
 * Decompiled with CFR 0.152.
 */
package measures.qef;

import imageTiTi.ImageFeatures;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import measures.qef.QualityEvaluationFunction;
import morphee.Dilate;
import morphee.StructuringElement;

public class SurfaceQEF
implements QualityEvaluationFunction {
    private StructuringElement se = null;
    private final Dilate dilate = new Dilate();
    private final ImageFeatures IF = new ImageFeatures();
    private BufferedImage det;
    private BufferedImage gs;
    private BufferedImage inf1;
    private BufferedImage inf2;
    private BufferedImage supn;
    private BufferedImage supd;
    private double TP;
    private double TN;
    private double FP;
    private double FN;

    @Override
    public double Evaluate(BufferedImage Detection2, int SizeSE, int nbCPU, BufferedImage ... GoalStandard) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)Detection2, (BufferedImage)GoalStandard[0])) {
            throw new IllegalArgumentException("Detection and Goal Standard have different dimensions.");
        }
        if (SizeSE > 0 && (this.se == null || SizeSE != this.se.getOrder())) {
            this.se = new StructuringElement(new Object[]{SizeSE, -2});
            this.dilate.setStructuringElement(this.se);
        }
        if (this.det == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)Detection2, (BufferedImage)this.det)) {
            this.supd = null;
            this.supn = null;
            this.inf2 = null;
            this.inf1 = null;
            this.gs = null;
            this.det = null;
            this.det = ImageNew.Same((BufferedImage)Detection2);
            this.gs = ImageNew.Same((BufferedImage)Detection2);
            this.inf1 = ImageNew.Same((BufferedImage)Detection2);
            this.inf2 = ImageNew.Same((BufferedImage)Detection2);
            this.supn = ImageNew.Same((BufferedImage)Detection2);
            this.supd = ImageNew.Same((BufferedImage)Detection2);
        }
        double score = 0.0;
        this.FN = 0.0;
        this.FP = 0.0;
        this.TN = 0.0;
        this.TP = 0.0;
        if (SizeSE > 0) {
            this.dilate.Filter(Detection2, this.det, nbCPU);
        } else {
            ImageNew.Copy((BufferedImage)Detection2, (BufferedImage)this.det);
        }
        for (BufferedImage GoalStandard1 : GoalStandard) {
            if (0 < SizeSE) {
                this.dilate.Filter(GoalStandard1, this.gs, nbCPU);
            } else {
                ImageNew.Copy((BufferedImage)GoalStandard1, (BufferedImage)this.gs);
            }
            ImageOperations.Minimum((BufferedImage)this.det, (BufferedImage)GoalStandard1, (BufferedImage)this.inf1);
            ImageOperations.Minimum((BufferedImage)this.gs, (BufferedImage)Detection2, (BufferedImage)this.inf2);
            ImageOperations.Maximum((BufferedImage)this.inf1, (BufferedImage)this.inf2, (BufferedImage)this.supn);
            ImageOperations.Maximum((BufferedImage)Detection2, (BufferedImage)GoalStandard1, (BufferedImage)this.supd);
            for (int y = 0; y < Detection2.getHeight(); ++y) {
                for (int x = 0; x < Detection2.getWidth(); ++x) {
                    if (Detection2.getRaster().getSample(x, y, 0) > 0 && this.gs.getRaster().getSample(x, y, 0) > 0) {
                        this.TP += 1.0;
                    } else if (Detection2.getRaster().getSample(x, y, 0) == 0 && this.gs.getRaster().getSample(x, y, 0) == 0) {
                        this.TN += 1.0;
                    } else if (Detection2.getRaster().getSample(x, y, 0) > 0 && this.gs.getRaster().getSample(x, y, 0) == 0) {
                        this.FP += 1.0;
                    } else if (Detection2.getRaster().getSample(x, y, 0) == 0 && this.gs.getRaster().getSample(x, y, 0) > 0) {
                        this.FN += 1.0;
                    }
                    if (this.det.getRaster().getSample(x, y, 0) > 0 && GoalStandard1.getRaster().getSample(x, y, 0) > 0) {
                        this.TP += 1.0;
                        continue;
                    }
                    if (this.det.getRaster().getSample(x, y, 0) == 0 && GoalStandard1.getRaster().getSample(x, y, 0) == 0) {
                        this.TN += 1.0;
                        continue;
                    }
                    if (this.det.getRaster().getSample(x, y, 0) > 0 && GoalStandard1.getRaster().getSample(x, y, 0) == 0) {
                        this.FP += 1.0;
                        continue;
                    }
                    if (this.det.getRaster().getSample(x, y, 0) != 0 || GoalStandard1.getRaster().getSample(x, y, 0) <= 0) continue;
                    this.FN += 1.0;
                }
            }
            score += (double)this.IF.Counter(this.supn, 0, 0) / (double)this.IF.Counter(this.supd, 0, 0);
        }
        this.TP /= (double)GoalStandard.length;
        this.TN /= (double)GoalStandard.length;
        this.FP /= (double)GoalStandard.length;
        this.FN /= (double)GoalStandard.length;
        System.err.println("Check result");
        return score / (double)GoalStandard.length;
    }

    @Override
    public double TruePositive() {
        return this.TP / (this.TP + this.FN);
    }

    @Override
    public double TrueNegative() {
        return this.TN / (this.TN + this.FP);
    }

    @Override
    public double FalsePositive() {
        return this.FP / (this.FP + this.TP);
    }

    @Override
    public double FalseNegative() {
        return this.FN / (this.FN + this.TN);
    }
}

