/*
 * Decompiled with CFR 0.152.
 */
package measures.qef;

import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.UnionFindCcl;
import measures.qef.QualityEvaluationFunction;

public class SimpleDetectionQEF
implements QualityEvaluationFunction {
    private ConnectedComponentLabeling ccl = new UnionFindCcl();
    private double TP;
    private double TN;
    private double FP;
    private double FN;

    @Override
    public double Evaluate(BufferedImage Detection2, int SizeSE, int nbCPU, BufferedImage ... GoalStandard) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)Detection2, (BufferedImage)GoalStandard[0])) {
            throw new IllegalArgumentException("Detection and Goal Standard have different dimensions.");
        }
        this.FN = 0.0;
        this.FP = 0.0;
        this.TN = 0.0;
        this.TP = 0.0;
        this.ccl.Label(Detection2, 0, true);
        int nbdet = this.ccl.ConnectedComponentsNumber();
        for (int i2 = 0; i2 < GoalStandard.length; ++i2) {
            this.ccl.Label(GoalStandard[i2], 0, true);
            int nbgs = this.ccl.ConnectedComponentsNumber();
            if (nbdet > 0 && nbgs > 0) {
                this.TP += 1.0;
                continue;
            }
            if (nbdet == 0 && nbgs == 0) {
                this.TN += 1.0;
                continue;
            }
            if (nbdet > 0 && nbgs == 0) {
                this.FP += 1.0;
                continue;
            }
            if (nbdet == 0 && nbgs > 0) {
                this.FN += 1.0;
                continue;
            }
            throw new Error("Case unkwnow.");
        }
        this.TP /= (double)GoalStandard.length;
        this.TN /= (double)GoalStandard.length;
        this.FP /= (double)GoalStandard.length;
        this.FN /= (double)GoalStandard.length;
        return (this.TP + this.TN) / (this.TP + this.TN + this.FP + this.FN);
    }

    @Override
    public double TruePositive() {
        return this.TP / (this.TP + this.FN);
    }

    @Override
    public double TrueNegative() {
        return this.TN / (this.TN + this.FP);
    }

    @Override
    public double FalsePositive() {
        return this.FP / (this.FP + this.TP);
    }

    @Override
    public double FalseNegative() {
        return this.FN / (this.FN + this.TN);
    }
}

