/*
 * Decompiled with CFR 0.152.
 */
package measures.miniball;

import init.Native;
import java.util.Iterator;
import java.util.List;
import mathematics.primitives.Disk;
import mathematics.primitives.Sphere;
import mathematics.primitives.pointsTiTi.Coordinates;

public class Miniball {
    private double Accuracy = -1.0;
    private boolean Valid = false;

    private native Disk Compute2D(int[] var1, int[] var2, double[] var3);

    public Disk Compute2D(int[] X, int[] Y) {
        if (!Native.CallNative()) {
            throw new IllegalArgumentException("No native library loaded.");
        }
        double[] infos = new double[2];
        Disk disk = this.Compute2D(X, Y, infos);
        this.Accuracy = infos[0];
        this.Valid = infos[1] == 1.0;
        return disk;
    }

    public Disk Compute2D(List<Coordinates> list) {
        int nb = 0;
        int[] X = new int[list.size()];
        int[] Y = new int[X.length];
        for (Coordinates c : list) {
            X[nb] = c.X;
            Y[nb] = c.Y;
            ++nb;
            c = null;
        }
        Iterator<Coordinates> iter = null;
        Disk disk = this.Compute2D(X, Y);
        return disk;
    }

    private native Sphere Compute3D(int[] var1, int[] var2, int[] var3, double[] var4);

    public Sphere Compute3D(int[] X, int[] Y, int[] Z) {
        if (!Native.CallNative()) {
            throw new IllegalArgumentException("No native library loaded.");
        }
        double[] infos = new double[2];
        Sphere sphere = this.Compute3D(X, Y, Z, infos);
        this.Accuracy = infos[0];
        this.Valid = infos[1] == 1.0;
        return sphere;
    }

    public Sphere Compute3D(List<Coordinates> list) {
        int nb = 0;
        int[] X = new int[list.size()];
        int[] Y = new int[X.length];
        int[] Z = new int[X.length];
        for (Coordinates c : list) {
            X[nb] = c.X;
            Y[nb] = c.Y;
            Y[nb] = c.Z;
            ++nb;
            c = null;
        }
        Iterator<Coordinates> iter = null;
        return this.Compute3D(X, Y, Z);
    }

    public double Accuracy() {
        return this.Accuracy;
    }

    public boolean Valid() {
        return this.Valid;
    }
}

