/*
 * Decompiled with CFR 0.152.
 */
package measures.miniball;

import mathematics.primitives.pointsTiTi.Point;

public class MiniBall_b {
    int coucou;
    private int d;
    private int m;
    private int s;
    private double[] q0 = null;
    private double[] z = null;
    private double[] f = null;
    private double[][] v = null;
    private double[][] a = null;
    private double[][] c = null;
    private double[] sqr_r = null;
    private double[] current_c;
    private double current_sqr_r;

    public MiniBall_b(int d) {
        this.d = d;
        this.q0 = new double[d];
        this.z = new double[d + 1];
        this.f = new double[d + 1];
        this.v = new double[d + 1][d];
        this.a = new double[d + 1][d];
        this.c = new double[d + 1][d];
        this.sqr_r = new double[d + 1];
        this.reset();
    }

    public double[] center() {
        return this.current_c;
    }

    public double squared_radius() {
        return this.current_sqr_r;
    }

    public int size() {
        return this.m;
    }

    public int support_size() {
        return this.s;
    }

    public double excess(Point p) {
        double e = -this.current_sqr_r;
        for (int k = 0; k < this.d; ++k) {
            e += this.mb_sqr(p.get(k) - this.current_c[k]);
        }
        return e;
    }

    public void reset() {
        this.s = 0;
        this.m = 0;
        for (int j = 0; j < this.d; ++j) {
            this.c[0][j] = 0.0;
        }
        this.current_c = this.c[0];
        this.current_sqr_r = -1.0;
    }

    public void pop() {
        --this.m;
    }

    public boolean push(Point p) {
        double eps = 1.0E-32;
        if (this.m == 0) {
            int i2;
            for (i2 = 0; i2 < this.d; ++i2) {
                this.q0[i2] = p.get(i2);
            }
            for (i2 = 0; i2 < this.d; ++i2) {
                this.c[0][i2] = this.q0[i2];
            }
            this.sqr_r[0] = 0.0;
        } else {
            int j;
            int i3;
            for (i3 = 0; i3 < this.d; ++i3) {
                this.v[this.m][i3] = p.get(i3) - this.q0[i3];
            }
            for (i3 = 1; i3 < this.m; ++i3) {
                this.a[this.m][i3] = 0.0;
                for (j = 0; j < this.d; ++j) {
                    double[] dArray = this.a[this.m];
                    int n = i3;
                    dArray[n] = dArray[n] + this.v[i3][j] * this.v[this.m][j];
                }
                double[] dArray = this.a[this.m];
                int n = i3;
                dArray[n] = dArray[n] * (2.0 / this.z[i3]);
            }
            for (i3 = 1; i3 < this.m; ++i3) {
                for (j = 0; j < this.d; ++j) {
                    double[] dArray = this.v[this.m];
                    int n = j;
                    dArray[n] = dArray[n] - this.a[this.m][i3] * this.v[i3][j];
                }
            }
            this.z[this.m] = 0.0;
            for (j = 0; j < this.d; ++j) {
                int n = this.m;
                this.z[n] = this.z[n] + this.mb_sqr(this.v[this.m][j]);
            }
            int n = this.m;
            this.z[n] = this.z[n] * 2.0;
            if (this.z[this.m] < eps * this.current_sqr_r) {
                return false;
            }
            double e = -this.sqr_r[this.m - 1];
            for (i3 = 0; i3 < this.d; ++i3) {
                e += this.mb_sqr(p.get(i3) - this.c[this.m - 1][i3]);
            }
            this.f[this.m] = e / this.z[this.m];
            for (i3 = 0; i3 < this.d; ++i3) {
                this.c[this.m][i3] = this.c[this.m - 1][i3] + this.f[this.m] * this.v[this.m][i3];
            }
            this.sqr_r[this.m] = this.sqr_r[this.m - 1] + e * this.f[this.m] / 2.0;
        }
        this.current_c = this.c[this.m];
        this.current_sqr_r = this.sqr_r[this.m];
        this.s = ++this.m;
        return true;
    }

    public double slack() {
        double[] l = new double[this.d + 1];
        double min_l = 0.0;
        l[0] = 1.0;
        for (int i2 = this.s - 1; i2 > 0; --i2) {
            l[i2] = this.f[i2];
            for (int k = this.s - 1; k > i2; --k) {
                int n = i2;
                l[n] = l[n] - this.a[k][i2] * l[k];
            }
            if (l[i2] < min_l) {
                min_l = l[i2];
            }
            l[0] = l[0] - l[i2];
        }
        if (l[0] < min_l) {
            min_l = l[0];
        }
        return min_l < 0.0 ? -min_l : 0.0;
    }

    public double mb_sqr(double x) {
        return x * x;
    }
}

