/*
 * Decompiled with CFR 0.152.
 */
package measures.histogram;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import mathematics.Maths;
import measures.histogram.IntegralProjectionFunction;

public class VarianceProjectionFunction {
    private double[] DiagonalRight = null;
    private double[] DiagonalLeft = null;
    private double[] Horizontal = null;
    private double[] Vertical = null;
    public IntegralProjectionFunction ipf = new IntegralProjectionFunction();

    private void SetDimensions(int width, int height) {
        if (this.Horizontal == null || this.Horizontal.length != height || this.Vertical.length != width) {
            this.DiagonalRight = null;
            this.DiagonalRight = new double[width + height];
            this.DiagonalLeft = null;
            this.DiagonalLeft = new double[this.DiagonalRight.length];
            this.Horizontal = null;
            this.Horizontal = new double[height];
            this.Vertical = null;
            this.Vertical = new double[width];
        }
        Arrays.fill(this.Horizontal, 0.0);
        Arrays.fill(this.Vertical, 0.0);
        Arrays.fill(this.DiagonalRight, 0.0);
        Arrays.fill(this.DiagonalLeft, 0.0);
    }

    public void Compute(BufferedImage image, int ForbiddenValue) {
        double p;
        int x;
        int y;
        int width = image.getWidth();
        int height = image.getHeight();
        this.SetDimensions(width, height);
        this.ipf.Compute(image, -1);
        double[] DD = this.ipf.AverageDiagonalRight();
        double[] DG = this.ipf.AverageDiagonalLeft();
        double[] H = this.ipf.AverageHorizontal();
        double[] V = this.ipf.AverageVertical();
        switch (image.getType()) {
            case 12: {
                WritableRaster wr = image.getRaster();
                for (y = 0; y < height; ++y) {
                    for (x = 0; x < width; ++x) {
                        p = wr.getSample(x, y, 0);
                        if (p == (double)ForbiddenValue) continue;
                        int n = y + x;
                        this.DiagonalLeft[n] = this.DiagonalLeft[n] + Maths.Power((double)(p - DG[y + x]), (int)2);
                        int n2 = height - 1 - y + x;
                        this.DiagonalRight[n2] = this.DiagonalRight[n2] + Maths.Power((double)(p - DD[height - 1 - y + x]), (int)2);
                        int n3 = y;
                        this.Horizontal[n3] = this.Horizontal[n3] + Maths.Power((double)(p - H[y]), (int)2);
                        int n4 = x;
                        this.Vertical[n4] = this.Vertical[n4] + Maths.Power((double)(p - V[x]), (int)2);
                    }
                }
                break;
            }
            case 10: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (y = 0; y < height; ++y) {
                    x = 0;
                    while (x < width) {
                        p = bb[pos] & 0xFF;
                        if (p != (double)ForbiddenValue) {
                            int n = y + x;
                            this.DiagonalLeft[n] = this.DiagonalLeft[n] + Maths.Power((double)(p - DG[y + x]), (int)2);
                            int n5 = height - 1 - y + x;
                            this.DiagonalRight[n5] = this.DiagonalRight[n5] + Maths.Power((double)(p - DD[height - 1 - y + x]), (int)2);
                            int n6 = y;
                            this.Horizontal[n6] = this.Horizontal[n6] + Maths.Power((double)(p - H[y]), (int)2);
                            int n7 = x;
                            this.Vertical[n7] = this.Vertical[n7] + Maths.Power((double)(p - V[x]), (int)2);
                        }
                        ++x;
                        ++pos;
                    }
                }
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (y = 0; y < height; ++y) {
                    x = 0;
                    while (x < width) {
                        p = sb[pos] & 0xFFFF;
                        if (p != (double)ForbiddenValue) {
                            int n = y + x;
                            this.DiagonalLeft[n] = this.DiagonalLeft[n] + Maths.Power((double)(p - DG[y + x]), (int)2);
                            int n8 = height - 1 - y + x;
                            this.DiagonalRight[n8] = this.DiagonalRight[n8] + Maths.Power((double)(p - DD[height - 1 - y + x]), (int)2);
                            int n9 = y;
                            this.Horizontal[n9] = this.Horizontal[n9] + Maths.Power((double)(p - H[y]), (int)2);
                            int n10 = x;
                            this.Vertical[n10] = this.Vertical[n10] + Maths.Power((double)(p - V[x]), (int)2);
                        }
                        ++x;
                        ++pos;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Only gray level or binary image supported.");
            }
        }
        int[] counterhorizontal = this.ipf.CounterHorizontal();
        int[] countervertical = this.ipf.CounterVertical();
        int[] counterdiagright = this.ipf.CounterDiagonalRight();
        int[] counterdiagleft = this.ipf.CounterDiagonalLeft();
        for (x = 0; x < width; ++x) {
            int n = x;
            this.Vertical[n] = this.Vertical[n] / (double)countervertical[x];
        }
        for (y = 0; y < height; ++y) {
            int n = y;
            this.Horizontal[n] = this.Horizontal[n] / (double)counterhorizontal[y];
        }
        p = width + height;
        x = 0;
        while ((double)x < p) {
            int n = x;
            this.DiagonalRight[n] = this.DiagonalRight[n] / (double)counterdiagright[x];
            int n11 = x;
            this.DiagonalLeft[n11] = this.DiagonalLeft[n11] / (double)counterdiagleft[x];
            ++x;
        }
    }

    public double[] DiagonalRight() {
        return this.DiagonalRight;
    }

    public double[] DiagonalLeft() {
        return this.DiagonalLeft;
    }

    public double[] Horizontal() {
        return this.Horizontal;
    }

    public double[] Vertical() {
        return this.Vertical;
    }
}

