/*
 * Decompiled with CFR 0.152.
 */
package measures.histogram;

import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.util.List;
import mathematics.Bresenham;
import mathematics.primitives.pointsTiTi.Coordinates;

public class RadialProjectionFunction {
    private int[] Integrals = null;
    private int[] Counters = null;
    private double[] Averages = null;

    private void SetDimensions(int length) {
        if (this.Integrals == null || this.Integrals.length != length) {
            this.Integrals = null;
            this.Integrals = new int[length];
            this.Counters = null;
            this.Counters = new int[length];
            this.Averages = null;
            this.Averages = new double[length];
        }
    }

    public void Compute(BufferedImage image, int nbOrientations, int ForbiddenValue) {
        if (ImageTools.isColored((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level or binary image supported.");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int radius = Math.max(width, height);
        int bx = (int)((double)width / 2.0 + 0.5);
        int by = (int)((double)height / 2.0 + 0.5);
        int step = 360 / nbOrientations;
        List list = null;
        this.SetDimensions(nbOrientations);
        for (int ori = 0; ori < nbOrientations; ++ori) {
            this.Counters[ori] = 0;
            this.Integrals[ori] = 0;
            double theta = Math.toRadians(ori * step);
            int endx = bx + (int)((double)radius * Math.cos(theta) + 0.5);
            int endy = by + (int)((double)radius * Math.sin(theta) + 0.5);
            list = Bresenham.Coordinates((int)bx, (int)by, (int)endx, (int)endy);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                int v;
                Coordinates p = (Coordinates)list.get(i2);
                if (0 <= p.X && p.X < width && 0 <= p.Y && p.Y < height && (v = image.getRaster().getSample(p.X, p.Y, 0)) != ForbiddenValue) {
                    int n = ori;
                    this.Integrals[n] = this.Integrals[n] + v;
                    int n2 = ori;
                    this.Counters[n2] = this.Counters[n2] + 1;
                }
                p = null;
            }
            this.Averages[ori] = (double)this.Integrals[ori] / (double)this.Counters[ori];
        }
    }

    public int[] Integrals() {
        return this.Integrals;
    }

    public int[] Counters() {
        return this.Counters;
    }

    public double[] Averages() {
        return this.Averages;
    }
}

