/*
 * Decompiled with CFR 0.152.
 */
package measures.histogram;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.List;
import mathematics.Bresenham;
import mathematics.primitives.pointsTiTi.PointI;

public class IntegralProjectionFunction {
    private int[] DiagonalRight = null;
    private int[] DiagonalLeft = null;
    private int[] Horizontal = null;
    private int[] Vertical = null;
    private int[] CounterDiagonalRight = null;
    private int[] CounterDiagonalLeft = null;
    private int[] CounterHorizontal = null;
    private int[] CounterVertical = null;
    private double[] AverageDiagonalRight = null;
    private double[] AverageDiagonalLeft = null;
    private double[] AverageHorizontal = null;
    private double[] AverageVerticale = null;
    private BufferedImage Cpt = null;

    private void SetDimensions(int width, int height) {
        if (this.Horizontal == null || this.Horizontal.length != height || this.Vertical.length != width) {
            int diag = width + height;
            this.DiagonalRight = null;
            this.DiagonalRight = new int[diag];
            this.DiagonalLeft = null;
            this.DiagonalLeft = new int[diag];
            this.Horizontal = null;
            this.Horizontal = new int[height];
            this.Vertical = null;
            this.Vertical = new int[width];
            this.CounterDiagonalRight = null;
            this.CounterDiagonalRight = new int[diag];
            this.CounterDiagonalLeft = null;
            this.CounterDiagonalLeft = new int[diag];
            this.CounterHorizontal = null;
            this.CounterHorizontal = new int[height];
            this.CounterVertical = null;
            this.CounterVertical = new int[width];
            this.AverageDiagonalRight = null;
            this.AverageDiagonalRight = new double[diag];
            this.AverageDiagonalLeft = null;
            this.AverageDiagonalLeft = new double[diag];
            this.AverageHorizontal = null;
            this.AverageHorizontal = new double[height];
            this.AverageVerticale = null;
            this.AverageVerticale = new double[width];
        }
        Arrays.fill(this.Horizontal, 0);
        Arrays.fill(this.Vertical, 0);
        Arrays.fill(this.DiagonalRight, 0);
        Arrays.fill(this.DiagonalLeft, 0);
        Arrays.fill(this.CounterHorizontal, 0);
        Arrays.fill(this.CounterVertical, 0);
        Arrays.fill(this.CounterDiagonalRight, 0);
        Arrays.fill(this.CounterDiagonalLeft, 0);
    }

    public void Compute(BufferedImage image, int ForbiddenValue) {
        int p;
        int x;
        int y;
        int width = image.getWidth();
        int height = image.getHeight();
        this.SetDimensions(width, height);
        switch (image.getType()) {
            case 12: {
                WritableRaster wr = image.getRaster();
                for (y = 0; y < height; ++y) {
                    for (x = 0; x < width; ++x) {
                        p = wr.getSample(x, y, 0);
                        if (p == ForbiddenValue) continue;
                        int n = y + x;
                        this.DiagonalLeft[n] = this.DiagonalLeft[n] + p;
                        int n2 = height - 1 - y + x;
                        this.DiagonalRight[n2] = this.DiagonalRight[n2] + p;
                        int n3 = y;
                        this.Horizontal[n3] = this.Horizontal[n3] + p;
                        int n4 = x;
                        this.Vertical[n4] = this.Vertical[n4] + p;
                        int n5 = y + x;
                        this.CounterDiagonalLeft[n5] = this.CounterDiagonalLeft[n5] + 1;
                        int n6 = height - 1 - y + x;
                        this.CounterDiagonalRight[n6] = this.CounterDiagonalRight[n6] + 1;
                        int n7 = y;
                        this.CounterHorizontal[n7] = this.CounterHorizontal[n7] + 1;
                        int n8 = x;
                        this.CounterVertical[n8] = this.CounterVertical[n8] + 1;
                    }
                }
                break;
            }
            case 10: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (y = 0; y < height; ++y) {
                    x = 0;
                    while (x < width) {
                        p = bb[pos] & 0xFF;
                        if (p != ForbiddenValue) {
                            int n = y + x;
                            this.DiagonalLeft[n] = this.DiagonalLeft[n] + p;
                            int n9 = height - 1 - y + x;
                            this.DiagonalRight[n9] = this.DiagonalRight[n9] + p;
                            int n10 = y;
                            this.Horizontal[n10] = this.Horizontal[n10] + p;
                            int n11 = x;
                            this.Vertical[n11] = this.Vertical[n11] + p;
                            int n12 = y + x;
                            this.CounterDiagonalLeft[n12] = this.CounterDiagonalLeft[n12] + 1;
                            int n13 = height - 1 - y + x;
                            this.CounterDiagonalRight[n13] = this.CounterDiagonalRight[n13] + 1;
                            int n14 = y;
                            this.CounterHorizontal[n14] = this.CounterHorizontal[n14] + 1;
                            int n15 = x;
                            this.CounterVertical[n15] = this.CounterVertical[n15] + 1;
                        }
                        ++x;
                        ++pos;
                    }
                }
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (y = 0; y < height; ++y) {
                    x = 0;
                    while (x < width) {
                        p = sb[pos] & 0xFFFF;
                        if (p != ForbiddenValue) {
                            int n = y + x;
                            this.DiagonalLeft[n] = this.DiagonalLeft[n] + p;
                            int n16 = height - 1 - y + x;
                            this.DiagonalRight[n16] = this.DiagonalRight[n16] + p;
                            int n17 = y;
                            this.Horizontal[n17] = this.Horizontal[n17] + p;
                            int n18 = x;
                            this.Vertical[n18] = this.Vertical[n18] + p;
                            int n19 = y + x;
                            this.CounterDiagonalLeft[n19] = this.CounterDiagonalLeft[n19] + 1;
                            int n20 = height - 1 - y + x;
                            this.CounterDiagonalRight[n20] = this.CounterDiagonalRight[n20] + 1;
                            int n21 = y;
                            this.CounterHorizontal[n21] = this.CounterHorizontal[n21] + 1;
                            int n22 = x;
                            this.CounterVertical[n22] = this.CounterVertical[n22] + 1;
                        }
                        ++x;
                        ++pos;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Only gray level or binary image supported.");
            }
        }
        for (x = 0; x < width; ++x) {
            this.AverageVerticale[x] = this.CounterVertical[x] != 0 ? (double)this.Vertical[x] / (double)this.CounterVertical[x] : -1.0;
        }
        for (y = 0; y < height; ++y) {
            this.AverageHorizontal[y] = this.CounterHorizontal[y] != 0 ? (double)this.Horizontal[y] / (double)this.CounterHorizontal[y] : -1.0;
        }
        p = width + height;
        for (x = 0; x < p; ++x) {
            this.AverageDiagonalRight[x] = this.CounterDiagonalRight[x] != 0 ? (double)this.DiagonalRight[x] / (double)this.CounterDiagonalRight[x] : -1.0;
            this.AverageDiagonalLeft[x] = this.CounterDiagonalLeft[x] != 0 ? (double)this.DiagonalLeft[x] / (double)this.CounterDiagonalLeft[x] : -1.0;
        }
    }

    public void CPT(BufferedImage image) {
        int j;
        int i2;
        int largeur = image.getWidth();
        int hauteur = image.getHeight();
        WritableRaster wri = image.getRaster();
        int nb = 0;
        int By = 0;
        int Bx = 0;
        this.Cpt = null;
        this.Cpt = new BufferedImage(largeur, hauteur, 5);
        WritableRaster wrc = this.Cpt.getRaster();
        for (i2 = 0; i2 < hauteur; ++i2) {
            for (j = 0; j < largeur; ++j) {
                if (wri.getSample(j, i2, 0) <= 0) continue;
                wrc.setSample(j, i2, 0, wri.getSample(j, i2, 0));
                ++nb;
                Bx += j;
                By += i2;
            }
        }
        Bx = (int)((double)Bx / (double)nb + 0.5);
        By = (int)((double)By / (double)nb + 0.5);
        boolean fin = false;
        while (!fin) {
            fin = true;
            for (i2 = 0; i2 < hauteur; ++i2) {
                for (j = 0; j < largeur; ++j) {
                    if (wrc.getSample(j, i2, 0) <= 0) continue;
                    List Trajectoire = null;
                    Trajectoire = Bresenham.Points((int)j, (int)i2, (int)Bx, (int)By);
                    for (int k = Trajectoire.size() - 1; k >= 0; --k) {
                        int y;
                        int x = ((PointI)Trajectoire.get(k)).getX();
                        if (wrc.getSample(x, y = ((PointI)Trajectoire.get(k)).getY(), 0) != 0) continue;
                        wrc.setSample(x, y, 0, wrc.getSample(j, i2, 0));
                        wrc.setSample(j, i2, 0, 0);
                        k = -1;
                        fin = false;
                    }
                }
            }
        }
    }

    public BufferedImage Cpt() {
        return this.Cpt;
    }

    public int[] DiagonalRight() {
        return this.DiagonalRight;
    }

    public int[] DiagonalLeft() {
        return this.DiagonalLeft;
    }

    public int[] Horizontal() {
        return this.Horizontal;
    }

    public int[] Vertical() {
        return this.Vertical;
    }

    public int[] CounterDiagonalRight() {
        return this.CounterDiagonalRight;
    }

    public int[] CounterDiagonalLeft() {
        return this.CounterDiagonalLeft;
    }

    public int[] CounterHorizontal() {
        return this.CounterHorizontal;
    }

    public int[] CounterVertical() {
        return this.CounterVertical;
    }

    public double[] AverageDiagonalRight() {
        return this.AverageDiagonalRight;
    }

    public double[] AverageDiagonalLeft() {
        return this.AverageDiagonalLeft;
    }

    public double[] AverageHorizontal() {
        return this.AverageHorizontal;
    }

    public double[] AverageVertical() {
        return this.AverageVerticale;
    }
}

