/*
 * Decompiled with CFR 0.152.
 */
package measures.histogram;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import measures.histogram.IntegralProjectionFunction;
import measures.histogram.VarianceProjectionFunction;

public class GeneralizedProjectionFunction {
    private double[] DiagonalRight = null;
    private double[] DiagonalLeft = null;
    private double[] Horizontal = null;
    private double[] Vertical = null;
    public IntegralProjectionFunction ipf = new IntegralProjectionFunction();
    public VarianceProjectionFunction vpf = new VarianceProjectionFunction();

    private void SetDimensions(int width, int height) {
        if (this.Horizontal == null || this.Horizontal.length != height || this.Vertical.length != width) {
            this.DiagonalRight = null;
            this.DiagonalRight = new double[width + height];
            this.DiagonalLeft = null;
            this.DiagonalLeft = new double[this.DiagonalRight.length];
            this.Horizontal = null;
            this.Horizontal = new double[height];
            this.Vertical = null;
            this.Vertical = new double[width];
        }
        Arrays.fill(this.Horizontal, 0.0);
        Arrays.fill(this.Vertical, 0.0);
        Arrays.fill(this.DiagonalRight, 0.0);
        Arrays.fill(this.DiagonalLeft, 0.0);
    }

    public void Compute(BufferedImage image, double alpha, int ForbiddenValue) {
        int x;
        int width = image.getWidth();
        int height = image.getHeight();
        this.SetDimensions(width, height);
        this.ipf.Compute(image, ForbiddenValue);
        this.vpf.Compute(image, ForbiddenValue);
        double[] DD = this.ipf.AverageDiagonalRight();
        double[] DG = this.ipf.AverageDiagonalLeft();
        double[] H = this.ipf.AverageHorizontal();
        double[] V = this.ipf.AverageVertical();
        double[] vDD = this.vpf.DiagonalRight();
        double[] vDG = this.vpf.DiagonalLeft();
        double[] vH = this.vpf.Horizontal();
        double[] vV = this.vpf.Vertical();
        for (x = 0; x < width; ++x) {
            this.Vertical[x] = (1.0 - alpha) * V[x] + alpha * vV[x];
        }
        for (int y = 0; y < height; ++y) {
            this.Horizontal[y] = (1.0 - alpha) * H[y] + alpha * vH[y];
        }
        int p = width + height;
        for (x = 0; x < p; ++x) {
            this.DiagonalRight[x] = (1.0 - alpha) * DD[x] + alpha * vDD[x];
            this.DiagonalLeft[x] = (1.0 - alpha) * DG[x] + alpha * vDG[x];
        }
    }

    public double[] DiagonalRight() {
        return this.DiagonalRight;
    }

    public double[] DiagonalLeft() {
        return this.DiagonalLeft;
    }

    public double[] Horizontal() {
        return this.Horizontal;
    }

    public double[] Vertical() {
        return this.Vertical;
    }

    public IntegralProjectionFunction IntegralProjectionFunction() {
        return this.ipf;
    }

    public VarianceProjectionFunction VarianceProjectionFunction() {
        return this.vpf;
    }
}

