/*
 * Decompiled with CFR 0.152.
 */
package measures.histogram;

import arrayTiTi.ArrayOperations;
import arrayTiTi.ArrayTools;
import java.awt.image.BufferedImage;
import measures.histogram.Histogram;

public class AccumulatedHistogram {
    private int[][] Accumulated = null;
    private int GrayLevel = -1;
    private int MaxCumul = -1;
    private Histogram histogram = new Histogram();

    public AccumulatedHistogram() {
    }

    public AccumulatedHistogram(BufferedImage image, int ForbiddenValue) {
        this.Fill(image, ForbiddenValue);
    }

    public AccumulatedHistogram(Histogram hist) {
        this.Fill(hist);
    }

    public void Fill(BufferedImage image, int ForbiddenValue) {
        this.histogram.Fill(image, ForbiddenValue);
        this.Fill(this.histogram);
    }

    public void Fill(Histogram hist) {
        if (hist == null || hist.getValues() == null) {
            throw new NullPointerException();
        }
        this.Allocate(hist);
        int[][] Values2 = hist.getValues();
        for (int c = 0; c < Values2.length; ++c) {
            int somme = 0;
            for (int i2 = 0; i2 < this.GrayLevel; ++i2) {
                this.Accumulated[c][i2] = somme += Values2[c][i2];
            }
        }
        this.FindMaxValues();
    }

    public void FindMaxValues() {
        this.MaxCumul = -1;
        for (int c = 0; c < this.Accumulated.length; ++c) {
            for (int i2 = 0; i2 < this.GrayLevel; ++i2) {
                if (this.Accumulated[c][i2] <= this.MaxCumul) continue;
                this.MaxCumul = this.Accumulated[c][i2];
            }
        }
    }

    private void Allocate(Histogram hist) {
        this.GrayLevel = hist.getGrayLevel();
        if (this.Accumulated == null || !ArrayTools.areDimensionsEqual((int[][])this.Accumulated, (int[][])hist.getValues())) {
            this.Accumulated = null;
            this.Accumulated = new int[hist.getValues().length][hist.getValues()[0].length];
            return;
        }
        ArrayOperations.Fill((int[][])this.Accumulated, (int)0);
    }

    public int[][] getAccumulated() {
        return this.Accumulated;
    }

    public int[] getAccumulated(int index) {
        return this.Accumulated[index];
    }

    public int getGrayLevel() {
        return this.GrayLevel;
    }

    public int getMaxCumul() {
        return this.MaxCumul;
    }
}

