/*
 * Decompiled with CFR 0.152.
 */
package measures.hedgehop;

import arrayTiTi.ArrayFeatures;
import imageTiTi.ImageDrawer;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mathematics.Bresenham;
import mathematics.Maths;
import mathematics.metrics.Euclidian;
import mathematics.primitives.pointsTiTi.Coordinate;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.CoordinatesManager;
import measures.BasicMeasures;
import measures.hedgehop.DistanceMapComputer;
import morphee.StructuringElement;

public class GeodesicDiameter {
    private double[] VariationDiametrale = null;
    private double VariationDiametraleMoyenne = 0.0;
    private double Longueur = 0.0;
    private BasicMeasures bbc = new BasicMeasures();
    private CoordinatesManager Minimum = new CoordinatesManager((ArrayList)null);
    private CoordinatesManager Total = new CoordinatesManager((ArrayList)null);
    private DistanceMapComputer dmc = new DistanceMapComputer();
    private ArrayFeatures AF = new ArrayFeatures();

    public void Kill() {
        this.bbc.Kill();
        this.bbc = null;
        this.Minimum.Kill();
        this.Total.Kill();
        this.Total = null;
        this.Minimum = null;
        this.dmc.Kill();
        this.dmc = null;
        this.AF = null;
    }

    public void Compute(BufferedImage image, StructuringElement se, float[] DM, boolean FindPath) {
        this.bbc.Compute(image, true);
        this.Compute(image, this.bbc.Boundary, this.bbc.Centroid, se, DM, FindPath);
    }

    public void Compute(BufferedImage image, CoordinatesManager Contour, Coordinate Barycentre, StructuringElement se, float[] DM, boolean FindPath) {
        if (se.getType() != -15) {
            throw new IllegalArgumentException("A Montanari distance/SE is required.");
        }
        this.ComputeDiameter(image, Contour, Barycentre, se);
        if (FindPath) {
            this.DrawDiameter(image, DM, se);
        }
    }

    private void ComputeDiameter(BufferedImage input, CoordinatesManager Contour, Coordinate Barycentre, StructuringElement se) {
        Coordinates p;
        double[] distances = new double[20];
        float[] DMG = null;
        Coordinates depart = null;
        CoordinatesManager Geo = new CoordinatesManager((ArrayList)null);
        Coordinates pmax = null;
        Euclidian dist = new Euclidian();
        this.Minimum.RemoveAll();
        this.Total.RemoveAll();
        if (Contour.NbPoints() <= 1) {
            throw new IllegalArgumentException("Number of points in the contour inferior or equal to 1.");
        }
        if (input.getRaster().getSample((int)(Barycentre.X + 0.5), (int)(Barycentre.Y + 0.5), 0) == 0) {
            double vmax = Double.MAX_VALUE;
            for (int i2 = 0; i2 < Contour.Size(); ++i2) {
                p = Contour.Point(i2);
                if (!(dist.Distance(p, Barycentre) < vmax)) continue;
                pmax = Contour.Point(i2);
                vmax = dist.Distance(p, Barycentre);
            }
            depart = new Coordinates(pmax);
        } else {
            depart = new Coordinates((int)(Barycentre.X + 0.5), (int)(Barycentre.Y + 0.5), (int)(Barycentre.X + 0.5) + (int)(Barycentre.Y + 0.5) * input.getWidth());
        }
        int nb = 0;
        boolean Fin = false;
        do {
            if (Geo.NbPoints() == 0) {
                this.dmc.ComputeStartingPoint(input, se, depart);
            } else if (Geo.Size() % 2 == 0) {
                this.dmc.ComputeStartingPoints(input, se, Geo.Points());
            } else {
                this.dmc.ComputeStartingPoint(input, se, Geo.Point(Geo.Size() - 1));
            }
            DMG = this.dmc.getMontanariMap1D();
            double vmax = 0.0;
            pmax = Contour.Point(0);
            for (int i3 = 1; i3 < Contour.Size(); ++i3) {
                p = Contour.Point(i3);
                if (!(vmax < (double)DMG[p.Pos])) continue;
                pmax = Contour.Point(i3);
                vmax = DMG[p.Pos];
            }
            Geo.Add(pmax);
            if (Maths.ModuloDyadic((int)Geo.Size(), (int)2) == 0) {
                distances[nb++] = vmax;
            }
            if (Maths.ModuloDyadic((int)Geo.Size(), (int)2) != 0 || Geo.Size() <= 2 || !(distances[nb - 1] <= distances[nb - 2])) continue;
            Fin = true;
        } while (!Fin);
        this.Longueur = distances[nb - 2];
        this.Minimum.InsertPointAt(0, Geo.Point((int)(Geo.Size() - 3)).X, Geo.Point((int)(Geo.Size() - 3)).Y, 0);
        this.Minimum.InsertPointAt(1, Geo.Point((int)(Geo.Size() - 4)).X, Geo.Point((int)(Geo.Size() - 4)).Y, 0);
        Geo.RemoveAll();
        Geo = null;
        distances = null;
        DMG = null;
        depart = null;
        dist = null;
    }

    private void PreliminaryPath(BufferedImage input) {
        int width = input.getWidth();
        int height = input.getHeight();
        boolean Fin = false;
        StructuringElement se1 = new StructuringElement(new Object[]{1, -15});
        this.dmc.ComputeStartingPoint(input, se1, this.Minimum.Point(1));
        float[] map = this.dmc.getMontanariMap1D();
        int xmin = this.Minimum.Point((int)0).X;
        int ymin = this.Minimum.Point((int)0).Y;
        switch (input.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)input.getRaster().getDataBuffer()).getData();
                int i2 = 0;
                do {
                    int X = xmin;
                    int Y = ymin;
                    int Pos = X + Y * width;
                    float min = map[Pos];
                    for (int y = -1; y <= 1; ++y) {
                        for (int x = -1; x <= 1; ++x) {
                            int pos;
                            if (y == 0 && x == 0 || 0 > X + x || X + x >= width || 0 > Y + y || Y + y >= height || bb[pos = (Y + y) * width + X + x] == 0 || !(map[pos] < min)) continue;
                            min = map[pos];
                            xmin = X + x;
                            ymin = Y + y;
                        }
                    }
                    if (this.Minimum.Point((int)(i2 + 1)).X == xmin && this.Minimum.Point((int)(i2 + 1)).Y == ymin) {
                        Fin = true;
                        continue;
                    }
                    this.Minimum.InsertPointAt(i2 + 1, xmin, ymin, 0);
                    ++i2;
                } while (!Fin);
                bb = null;
            }
        }
        se1.Kill();
        map = null;
    }

    private void DrawDiameter(BufferedImage input, float[] DM, StructuringElement se) {
        int i2;
        int width = input.getWidth();
        Euclidian dist = new Euclidian();
        this.PreliminaryPath(input);
        List Resultat = null;
        Iterator<Object> iter = null;
        int Old = 0;
        int Securite = 0;
        do {
            boolean Fin;
            int i3;
            Old = this.Minimum.Size();
            for (i3 = 0; i3 < this.Minimum.Size() - 1; ++i3) {
                Resultat = Bresenham.Coordinates((int)this.Minimum.Point((int)i3).X, (int)this.Minimum.Point((int)i3).Y, (int)this.Minimum.Point((int)(i3 + 1)).X, (int)this.Minimum.Point((int)(i3 + 1)).Y);
                iter = Resultat.iterator();
                if (iter.hasNext()) {
                    iter.next();
                }
                int nb = 0;
                while (iter.hasNext()) {
                    Coordinates p = (Coordinates)iter.next();
                    if (!iter.hasNext()) continue;
                    this.Minimum.InsertPointAt(i3 + nb + 1, p);
                    ++nb;
                }
                i3 += nb;
                iter = null;
            }
            boolean Sens = true;
            do {
                Fin = true;
                if (Sens) {
                    i3 = 0;
                    while (i3 < this.Minimum.Size() - 2) {
                        if (this.TraceCorrect(input, this.Minimum.Point(i3), this.Minimum.Point(i3 + 2))) {
                            this.Minimum.Remove(i3 + 1);
                            Fin = false;
                            continue;
                        }
                        ++i3;
                    }
                } else {
                    i3 = this.Minimum.Size() - 1;
                    while (i3 - 2 >= 0) {
                        if (this.TraceCorrect(input, this.Minimum.Point(i3), this.Minimum.Point(i3 - 2))) {
                            this.Minimum.Remove(i3 - 1);
                            Fin = false;
                            --i3;
                            continue;
                        }
                        --i3;
                    }
                }
                boolean bl = Sens = !Sens;
            } while (!Fin);
        } while (Old != this.Minimum.Size() && ++Securite < 20);
        this.Total.Add(this.Minimum.Point(0));
        double distance = 0.0;
        for (i2 = 0; i2 < this.Minimum.Size() - 1; ++i2) {
            distance += dist.Distance(this.Minimum.Point(i2), this.Minimum.Point(i2 + 1));
            Resultat = Bresenham.Coordinates((int)this.Minimum.Point((int)i2).X, (int)this.Minimum.Point((int)i2).Y, (int)this.Minimum.Point((int)(i2 + 1)).X, (int)this.Minimum.Point((int)(i2 + 1)).Y);
            iter = Resultat.iterator();
            if (iter.hasNext()) {
                iter.next();
            }
            while (iter.hasNext()) {
                this.Total.Add((Coordinates)iter.next());
            }
            iter = null;
            Resultat.clear();
            Resultat = null;
        }
        this.Longueur = distance;
        iter = this.Minimum.Iterator();
        while (iter.hasNext()) {
            Coordinates p = (Coordinates)iter.next();
            p.Pos = p.X + p.Y * width;
            p = null;
        }
        iter = this.Total.Iterator();
        while (iter.hasNext()) {
            Coordinates p = (Coordinates)iter.next();
            p.Pos = p.X + p.Y * width;
            p = null;
        }
        this.VariationDiametrale = null;
        if (DM != null) {
            this.VariationDiametrale = new double[this.Total.Size()];
            this.dmc.Compute(input, se);
            for (i2 = 0; i2 < this.VariationDiametrale.length; ++i2) {
                this.VariationDiametrale[i2] = DM[this.Total.Point((int)i2).Pos];
            }
            this.VariationDiametraleMoyenne = this.AF.Average(this.VariationDiametrale);
        }
        dist = null;
    }

    protected boolean TraceCorrect(BufferedImage input, Coordinates start, Coordinates end) {
        int width = input.getWidth();
        List Resultat = Bresenham.Coordinates((int)start.X, (int)start.Y, (int)end.X, (int)end.Y);
        Iterator iter = Resultat.iterator();
        block0 : switch (input.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)input.getRaster().getDataBuffer()).getData();
                while (iter.hasNext()) {
                    Coordinates p = (Coordinates)iter.next();
                    if (bb[p.Y * width + p.X] == 0) {
                        iter = null;
                        p = null;
                        Resultat.clear();
                        Resultat = null;
                        return false;
                    }
                    p = null;
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)input.getRaster().getDataBuffer()).getData();
                while (iter.hasNext()) {
                    Coordinates p = (Coordinates)iter.next();
                    if (sb[p.Y * width + p.X] == 0) {
                        iter = null;
                        p = null;
                        Resultat.clear();
                        Resultat = null;
                        return false;
                    }
                    p = null;
                }
                sb = null;
                break;
            }
            case 0: {
                switch (input.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int[] ib = ((DataBufferInt)input.getRaster().getDataBuffer()).getData();
                        while (iter.hasNext()) {
                            Coordinates p = (Coordinates)iter.next();
                            if (ib[p.Y * width + p.X] == 0) {
                                iter = null;
                                p = null;
                                Resultat.clear();
                                Resultat = null;
                                return false;
                            }
                            p = null;
                        }
                        ib = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        iter = null;
        Resultat.clear();
        Resultat = null;
        return true;
    }

    public void Draw(BufferedImage image, float[] color, int order) {
        for (int i2 = 0; i2 < this.Minimum.Size() - 1; ++i2) {
            ImageDrawer.Line(image, this.Minimum.Point((int)i2).X, this.Minimum.Point((int)i2).Y, this.Minimum.Point((int)(i2 + 1)).X, this.Minimum.Point((int)(i2 + 1)).Y, order, color);
        }
    }

    public double getLength() {
        return this.Longueur;
    }

    public CoordinatesManager getMinimum() {
        return this.Minimum;
    }

    public Coordinates getIemeMinimum(int index) {
        return this.Minimum.Point(index);
    }

    public int getMinimumSize() {
        return this.Minimum.Size();
    }

    public CoordinatesManager getTotal() {
        return this.Total;
    }

    public Coordinates getIemeTotal(int index) {
        return this.Total.Point(index);
    }

    public int getTotalSize() {
        return this.Total.Size();
    }

    public double[] getVariationDiametrale() {
        return this.VariationDiametrale;
    }

    public double getIemeVariationDiametrale(int index) {
        return this.VariationDiametrale[index];
    }

    public double getVariationDiametraleMoyenne() {
        return this.VariationDiametraleMoyenne;
    }
}

