/*
 * Decompiled with CFR 0.152.
 */
package measures.hedgehop;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Scanner;
import mathematics.matriciel.VectorInt;
import mathematics.metrics.Euclidian;
import measures.hedgehop.Distance;
import measures.hedgehop.Mask;

public class DistanceTools {
    public static Distance Read(String Nom) {
        Distance Dist = new Distance();
        Scanner entree = null;
        try {
            entree = new Scanner(new FileInputStream(Nom));
        }
        catch (FileNotFoundException E) {
            E.printStackTrace();
            System.exit(0);
        }
        Dist.setName(entree.next());
        entree.nextLine();
        while (entree.hasNext()) {
            String keyword = entree.next();
            if (DistanceTools.StrCmp(keyword, "Distance")) {
                keyword = entree.next();
                keyword = entree.next();
                if (DistanceTools.StrCmp(keyword, "Chamfrein")) {
                    Dist.setChamfer(true);
                    keyword = entree.next();
                    keyword = entree.nextLine();
                    DistanceTools.ReadChamferMask(entree, Dist);
                    keyword = entree.next();
                } else if (DistanceTools.StrCmp(keyword, "Montanari")) {
                    System.err.println("Attention, les distances Montanari ne sont pas encore lue, ea va planter.");
                    System.err.println("3...2...1...Error!!!");
                    Dist.setChamfer(false);
                    keyword = entree.next();
                    keyword = entree.nextLine();
                    DistanceTools.ReadMontanariMask(entree, Dist);
                    keyword = entree.next();
                } else {
                    System.err.println("Erreur, OutilsDistances/Lire, type de distance non gere : " + keyword);
                    System.exit(0);
                }
            } else if (DistanceTools.StrCmp(keyword, "isNorme")) {
                keyword = entree.next();
                keyword = entree.next();
                if (DistanceTools.StrCmp(keyword, "TRUE")) {
                    Dist.setNorme(true);
                } else if (DistanceTools.StrCmp(keyword, "FALSE")) {
                    Dist.setNorme(false);
                } else {
                    System.err.println("Erreur, OutilsDistances/Lire, booleen incorrecte pour la norme : " + keyword);
                    System.exit(0);
                }
            } else if (DistanceTools.StrCmp(keyword, "Dimension")) {
                keyword = entree.next();
                Dist.setDimension(entree.nextInt());
            }
            keyword = entree.nextLine();
        }
        DistanceTools.GenerateMasksFromBase(Dist);
        return Dist;
    }

    private static void ReadChamferMask(Scanner stream, Distance dist) {
        dist.AllouerBase(stream.nextInt(), dist.getDimension());
        for (int i2 = 0; i2 < dist.Base.length; ++i2) {
            dist.Base[i2].vecteur.set(0, stream.nextInt());
            dist.Base[i2].vecteur.set(1, stream.nextInt());
            dist.Base[i2].setPoids(stream.nextInt());
            dist.Base[i2].setNom(stream.next());
        }
    }

    private static void ReadMontanariMask(Scanner stream, Distance dist) {
        dist.AllouerBase(stream.nextInt(), dist.getDimension());
        for (int i2 = 0; i2 < dist.Base.length; ++i2) {
            dist.Base[i2].vecteur.set(0, stream.nextInt());
            dist.Base[i2].vecteur.set(1, stream.nextInt());
            System.out.println("next = " + stream.hasNextDouble() + " " + stream.hasNextFloat() + " " + stream.next());
            dist.Base[i2].setWeight(stream.nextFloat());
            dist.Base[i2].setNom(stream.next());
        }
    }

    public static void Write(Distance Dist, String Nom) {
        throw new Error("Not implemented... (yet).");
    }

    public static Distance CreateChamferDistance(int[][] base) {
        int i2;
        Distance dist = new Distance();
        switch (base[0].length - 1) {
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new Error("Forme de la base incoherentes. Attendu : \"X Y Poids\" ou \"X Y Z Poids\".");
            }
        }
        dist.AllouerBase(base.length, base[0].length - 1);
        dist.AllouerMasques();
        for (i2 = 0; i2 < base.length; ++i2) {
            dist.Base[i2].setPoids(base[i2][2]);
            dist.Base[i2].setWeight(base[i2][2]);
            dist.Base[i2].setNom(String.valueOf(i2));
        }
        switch (base[0].length - 1) {
            case 2: {
                for (i2 = 0; i2 < base.length; ++i2) {
                    dist.Base[i2].vecteur.set(0, base[i2][0]);
                    dist.Base[i2].vecteur.set(1, base[i2][1]);
                }
                break;
            }
            case 3: {
                for (i2 = 0; i2 < base.length; ++i2) {
                    dist.Base[i2].vecteur.set(0, base[i2][0]);
                    dist.Base[i2].vecteur.set(1, base[i2][1]);
                    dist.Base[i2].vecteur.set(2, base[i2][2]);
                }
                break;
            }
            default: {
                throw new Error("Forme de la base incoherentes. Attendu : X Y Poids ou X Y Z Poids.");
            }
        }
        DistanceTools.GenerateMasksFromBase2D(dist);
        return dist;
    }

    public static void GenerateMasksFromBase(Distance Dist) {
        switch (Dist.getDimension()) {
            case 2: {
                DistanceTools.GenerateMasksFromBase2D(Dist);
                break;
            }
            case 3: {
                DistanceTools.GenerateMasksFromBase3D(Dist);
                break;
            }
            default: {
                System.err.println("Default, OutilsDistances/GenererMasquesFromBase, Aie, c'est la merde : " + Dist.getDimension());
                System.exit(0);
            }
        }
    }

    public static void GenerateMasksFromBase2D(Distance Dist) {
        int j;
        boolean Ajout;
        int i2;
        Mask[] QuartMasque = new Mask[2 * Dist.Base.length - 1];
        VectorInt v = new VectorInt(2);
        Dist.AllouerMasques();
        for (i2 = 0; i2 < QuartMasque.length; ++i2) {
            QuartMasque[i2] = new Mask(2);
        }
        for (i2 = 0; i2 < Dist.Base.length; ++i2) {
            Dist.mask[i2] = Dist.Base[i2];
            Dist.halfmask[i2] = Dist.Base[i2];
            QuartMasque[i2] = Dist.Base[i2];
        }
        int nb = 0;
        for (i2 = 0; i2 < Dist.Base.length; ++i2) {
            Ajout = true;
            for (j = 0; j <= i2 && Ajout; ++j) {
                v.set(0, Dist.Base[i2].vecteur.get(1));
                v.set(1, Dist.Base[i2].vecteur.get(0));
                if (!v.Equal(QuartMasque[j].vecteur)) continue;
                Ajout = false;
            }
            if (!Ajout) continue;
            QuartMasque[nb + Dist.Base.length].vecteur.set(0, Dist.Base[i2].vecteur.get(1));
            QuartMasque[nb + Dist.Base.length].vecteur.set(1, Dist.Base[i2].vecteur.get(0));
            QuartMasque[nb + Dist.Base.length].setPoids(Dist.Base[i2].getPoids());
            QuartMasque[nb + Dist.Base.length].setWeight(Dist.Base[i2].getWeight());
            QuartMasque[nb + Dist.Base.length].setNom(String.valueOf(nb + Dist.Base.length));
            Dist.halfmask[nb + Dist.Base.length].vecteur.set(0, Dist.Base[i2].vecteur.get(1));
            Dist.halfmask[nb + Dist.Base.length].vecteur.set(1, Dist.Base[i2].vecteur.get(0));
            Dist.halfmask[nb + Dist.Base.length].setPoids(Dist.Base[i2].getPoids());
            Dist.halfmask[nb + Dist.Base.length].setWeight(Dist.Base[i2].getWeight());
            Dist.halfmask[nb + Dist.Base.length].setNom(String.valueOf(nb + Dist.Base.length));
            Dist.mask[nb + Dist.Base.length].vecteur.set(0, Dist.Base[i2].vecteur.get(1));
            Dist.mask[nb + Dist.Base.length].vecteur.set(1, Dist.Base[i2].vecteur.get(0));
            Dist.mask[nb + Dist.Base.length].setPoids(Dist.Base[i2].getPoids());
            Dist.mask[nb + Dist.Base.length].setWeight(Dist.Base[i2].getWeight());
            Dist.mask[nb + Dist.Base.length].setNom(String.valueOf(nb + Dist.Base.length));
            ++nb;
        }
        nb = 0;
        for (i2 = 0; i2 < QuartMasque.length; ++i2) {
            Ajout = true;
            for (j = 0; j <= i2 && Ajout; ++j) {
                v.set(0, -QuartMasque[i2].vecteur.get(0));
                v.set(1, -QuartMasque[i2].vecteur.get(0));
                if (!v.Equal(Dist.halfmask[j].vecteur)) continue;
                Ajout = false;
            }
            if (!Ajout) continue;
            Dist.halfmask[nb + QuartMasque.length].vecteur.set(0, -QuartMasque[i2].vecteur.get(0));
            Dist.halfmask[nb + QuartMasque.length].vecteur.set(1, QuartMasque[i2].vecteur.get(1));
            Dist.halfmask[nb + QuartMasque.length].setPoids(QuartMasque[i2].getPoids());
            Dist.halfmask[nb + QuartMasque.length].setWeight(QuartMasque[i2].getWeight());
            Dist.halfmask[nb + QuartMasque.length].setNom(String.valueOf(nb + QuartMasque.length));
            Dist.mask[nb + QuartMasque.length].vecteur.set(0, -QuartMasque[i2].vecteur.get(0));
            Dist.mask[nb + QuartMasque.length].vecteur.set(1, QuartMasque[i2].vecteur.get(1));
            Dist.mask[nb + QuartMasque.length].setPoids(QuartMasque[i2].getPoids());
            Dist.mask[nb + QuartMasque.length].setWeight(QuartMasque[i2].getWeight());
            Dist.mask[nb + QuartMasque.length].setNom(String.valueOf(nb + QuartMasque.length));
            ++nb;
        }
        nb = 0;
        for (i2 = 0; i2 < Dist.halfmask.length; ++i2) {
            Ajout = true;
            for (j = 0; j <= i2 && Ajout; ++j) {
                v.set(0, Dist.halfmask[i2].vecteur.get(0));
                v.set(1, -Dist.halfmask[i2].vecteur.get(1));
                if (!v.Equal(Dist.mask[j].vecteur)) continue;
                Ajout = false;
            }
            if (!Ajout) continue;
            Dist.mask[nb + Dist.halfmask.length].vecteur.set(0, Dist.halfmask[i2].vecteur.get(0));
            Dist.mask[nb + Dist.halfmask.length].vecteur.set(1, -Dist.halfmask[i2].vecteur.get(1));
            Dist.mask[nb + Dist.halfmask.length].setPoids(Dist.halfmask[i2].getPoids());
            Dist.mask[nb + Dist.halfmask.length].setWeight(Dist.halfmask[i2].getWeight());
            Dist.mask[nb + Dist.halfmask.length].setNom(String.valueOf(nb + Dist.halfmask.length));
            ++nb;
        }
        QuartMasque = null;
    }

    private static void GenerateMasksFromBase3D(Distance Dist) {
        int j;
        boolean Ajout;
        int i2;
        VectorInt v = new VectorInt(3);
        Dist.AllouerMasques();
        Mask[] Demi = new Mask[Dist.halfmask.length];
        for (i2 = 0; i2 < Demi.length; ++i2) {
            Demi[i2] = new Mask(3);
        }
        Mask[] Complet = new Mask[Dist.mask.length];
        for (i2 = 0; i2 < Complet.length; ++i2) {
            Complet[i2] = new Mask(3);
        }
        int nb = 0;
        for (int y = -1; y <= 1; ++y) {
            if (y == 0) continue;
            for (int x = -1; x <= 1; ++x) {
                if (x == 0) continue;
                for (i2 = 0; i2 < Dist.Base.length; ++i2) {
                    Ajout = true;
                    for (j = 0; j <= nb && Ajout; ++j) {
                        v.set(0, x * Dist.Base[i2].vecteur.get(0));
                        v.set(1, y * Dist.Base[i2].vecteur.get(1));
                        v.set(2, Dist.Base[i2].vecteur.get(2));
                        if (!v.Equal(Demi[j].vecteur)) continue;
                        Ajout = false;
                    }
                    if (Ajout) {
                        Demi[nb].vecteur.set(0, x * Dist.Base[i2].vecteur.get(0));
                        Demi[nb].vecteur.set(1, y * Dist.Base[i2].vecteur.get(1));
                        Demi[nb].vecteur.set(2, Dist.Base[i2].vecteur.get(2));
                        Demi[nb].setPoids(Dist.Base[i2].getPoids());
                        Demi[nb].setWeight(Dist.Base[i2].getWeight());
                        Demi[nb].setNom(String.valueOf(nb));
                        ++nb;
                    }
                    Ajout = true;
                    for (j = 0; j <= nb && Ajout; ++j) {
                        v.set(0, y * Dist.Base[i2].vecteur.get(1));
                        v.set(1, x * Dist.Base[i2].vecteur.get(0));
                        v.set(2, Dist.Base[i2].vecteur.get(2));
                        if (!v.Equal(Demi[j].vecteur)) continue;
                        Ajout = false;
                    }
                    if (Ajout) {
                        Demi[nb].vecteur.set(0, y * Dist.Base[i2].vecteur.get(1));
                        Demi[nb].vecteur.set(1, x * Dist.Base[i2].vecteur.get(0));
                        Demi[nb].vecteur.set(2, Dist.Base[i2].vecteur.get(2));
                        Demi[nb].setPoids(Dist.Base[i2].getPoids());
                        Demi[nb].setWeight(Dist.Base[i2].getWeight());
                        Demi[nb].setNom(String.valueOf(nb));
                        ++nb;
                    }
                    if (y == 1) {
                        Ajout = true;
                        for (j = 0; j <= nb && Ajout; ++j) {
                            v.set(0, x * Dist.Base[i2].vecteur.get(0));
                            v.set(1, Dist.Base[i2].vecteur.get(2));
                            v.set(2, y * Dist.Base[i2].vecteur.get(1));
                            if (!v.Equal(Demi[j].vecteur)) continue;
                            Ajout = false;
                        }
                        if (Ajout) {
                            Demi[nb].vecteur.set(0, x * Dist.Base[i2].vecteur.get(0));
                            Demi[nb].vecteur.set(1, Dist.Base[i2].vecteur.get(2));
                            Demi[nb].vecteur.set(2, y * Dist.Base[i2].vecteur.get(1));
                            Demi[nb].setPoids(Dist.Base[i2].getPoids());
                            Demi[nb].setWeight(Dist.Base[i2].getWeight());
                            Demi[nb].setNom(String.valueOf(nb));
                            ++nb;
                        }
                    }
                    if (x != 1) continue;
                    Ajout = true;
                    for (j = 0; j <= nb && Ajout; ++j) {
                        v.set(0, Dist.Base[i2].vecteur.get(2));
                        v.set(1, y * Dist.Base[i2].vecteur.get(1));
                        v.set(2, x * Dist.Base[i2].vecteur.get(0));
                        if (!v.Equal(Demi[j].vecteur)) continue;
                        Ajout = false;
                    }
                    if (!Ajout) continue;
                    Demi[nb].vecteur.set(0, Dist.Base[i2].vecteur.get(2));
                    Demi[nb].vecteur.set(1, y * Dist.Base[i2].vecteur.get(1));
                    Demi[nb].vecteur.set(2, x * Dist.Base[i2].vecteur.get(0));
                    Demi[nb].setPoids(Dist.Base[i2].getPoids());
                    Demi[nb].setWeight(Dist.Base[i2].getWeight());
                    Demi[nb].setNom(String.valueOf(nb));
                    ++nb;
                }
            }
        }
        Dist.halfmask = null;
        Dist.halfmask = new Mask[nb];
        for (i2 = 0; i2 < nb; ++i2) {
            Dist.halfmask[i2] = new Mask(3);
        }
        for (i2 = 0; i2 < nb; ++i2) {
            Dist.halfmask[i2] = DistanceTools.CloneMask(Demi[i2]);
        }
        for (i2 = 0; i2 < nb; ++i2) {
            Complet[i2] = Demi[i2];
        }
        for (i2 = 0; i2 < Demi.length; ++i2) {
            Ajout = true;
            for (j = 0; j <= nb && Ajout; ++j) {
                v.set(0, Demi[i2].vecteur.get(0));
                v.set(1, Demi[i2].vecteur.get(1));
                v.set(2, -Demi[i2].vecteur.get(2));
                if (!v.Equal(Complet[j].vecteur)) continue;
                Ajout = false;
            }
            if (!Ajout) continue;
            Complet[nb].vecteur.set(0, Demi[i2].vecteur.get(0));
            Complet[nb].vecteur.set(1, Demi[i2].vecteur.get(1));
            Complet[nb].vecteur.set(2, -Demi[i2].vecteur.get(2));
            Complet[nb].setPoids(Demi[i2].getPoids());
            Complet[nb].setWeight(Demi[i2].getWeight());
            Complet[nb].setNom(String.valueOf(nb));
            ++nb;
        }
        Dist.mask = null;
        Dist.mask = new Mask[nb];
        for (i2 = 0; i2 < nb; ++i2) {
            Dist.mask[i2] = new Mask(3);
        }
        for (i2 = 0; i2 < nb; ++i2) {
            Dist.mask[i2] = DistanceTools.CloneMask(Complet[i2]);
        }
        Demi = null;
        Complet = null;
    }

    public static Distance CreateMontanariDistance(int Dimension2, int Radius) {
        switch (Dimension2) {
            case 2: {
                return DistanceTools.CreateMontanariDistance2D(Radius);
            }
            case 3: {
                return DistanceTools.CreateMontanariDistance3D(Radius);
            }
        }
        System.err.println("Default, OutilsDistances/CreerDistance, Dimension incorrecte : " + Dimension2);
        System.exit(0);
        return null;
    }

    private static Distance CreateMontanariDistance2D(int Radius) {
        int x;
        int y;
        double Epsilon = 1.0E-4;
        boolean[][] visible = new boolean[Radius][Radius];
        Distance dist = new Distance();
        Euclidian distances = new Euclidian();
        dist.setChamfer(false);
        dist.setDimension(2);
        for (y = 0; y < Radius; ++y) {
            for (x = 0; x < Radius; ++x) {
                boolean bl = visible[y][x] = x >= y;
                if (!(distances.Distance(0.0, 0.0, 0.0, (double)x, (double)y, 0.0) > (double)Radius + Epsilon)) continue;
                visible[y][x] = false;
            }
        }
        int nb = 0;
        for (x = 1; x < Radius; ++x) {
            for (y = 0; y <= x; ++y) {
                if (!visible[y][x]) continue;
                ++nb;
                int i2 = 2;
                while (i2 * y < Radius && i2 * x < Radius) {
                    visible[i2 * y][i2 * x] = false;
                    ++i2;
                }
            }
        }
        dist.AllouerBase(nb, dist.getDimension());
        nb = 0;
        for (x = 1; x < Radius; ++x) {
            for (y = 0; y <= x; ++y) {
                if (!visible[y][x]) continue;
                dist.Base[nb].vecteur.set(0, x);
                dist.Base[nb].vecteur.set(1, y);
                dist.Base[nb].setPoids(x * x + y * y);
                dist.Base[nb].setWeight((float)Math.sqrt(x * x + y * y));
                dist.Base[nb].setNom(String.valueOf(nb));
                ++nb;
            }
        }
        DistanceTools.GenerateMasksFromBase(dist);
        return dist;
    }

    private static Distance CreateMontanariDistance3D(int Radius) {
        int x;
        int y;
        int z;
        double Epsilon = 1.0E-4;
        boolean[][][] visible = new boolean[Radius][Radius][Radius];
        Distance dist = new Distance();
        Euclidian distances = new Euclidian();
        dist.setChamfer(false);
        dist.setDimension(3);
        for (z = 0; z < Radius; ++z) {
            for (y = 0; y < Radius; ++y) {
                for (x = 0; x < Radius; ++x) {
                    boolean bl = visible[z][y][x] = x >= y && y >= z;
                    if (!(distances.Distance(0.0, 0.0, 0.0, (double)x, (double)y, (double)z) > (double)Radius + Epsilon)) continue;
                    visible[z][y][x] = false;
                }
            }
        }
        int nb = 0;
        for (x = 1; x < Radius; ++x) {
            for (y = 0; y <= x; ++y) {
                for (z = 0; z <= y; ++z) {
                    if (!visible[z][y][x]) continue;
                    ++nb;
                    int i2 = 2;
                    while (i2 * z < Radius && i2 * y < Radius && i2 * x < Radius) {
                        visible[i2 * z][i2 * y][i2 * x] = false;
                        ++i2;
                    }
                }
            }
        }
        dist.AllouerBase(nb);
        nb = 0;
        for (x = 1; x < Radius; ++x) {
            for (y = 0; y <= x; ++y) {
                for (z = 0; z <= y; ++z) {
                    if (!visible[z][y][x]) continue;
                    dist.Base[nb].vecteur.set(0, x);
                    dist.Base[nb].vecteur.set(1, y);
                    dist.Base[nb].vecteur.set(2, z);
                    dist.Base[nb].setPoids(x * x + y * y + z * z);
                    dist.Base[nb].setWeight((float)Math.sqrt(x * x + y * y + z * z));
                    dist.Base[nb].setNom(String.valueOf(nb));
                    ++nb;
                }
            }
        }
        DistanceTools.GenerateMasksFromBase(dist);
        return dist;
    }

    public static void SqrtAndNearestInt(Distance Dist) {
        for (int i2 = 0; i2 < Dist.mask.length; ++i2) {
            Dist.mask[i2].setPoids((int)(Math.sqrt(Dist.mask[i2].getPoids()) + 0.5));
        }
    }

    public static void ChamferToMontanari(Distance Dist) {
        for (int i2 = 0; i2 < Dist.mask.length; ++i2) {
            Dist.mask[i2].setWeight((float)Math.sqrt(Dist.mask[i2].getPoids()));
        }
        Dist.setChamfer(false);
    }

    public static Distance Clone(Distance dist) {
        Distance clone = new Distance();
        clone.setDimension(dist.getDimension());
        clone.setNorme(dist.isNorme());
        clone.setChamfer(dist.isChamfer());
        clone.AllouerBase(dist.Base.length);
        for (int i2 = 0; i2 < dist.Base.length; ++i2) {
            clone.Base[i2].vecteur.set(0, dist.Base[i2].vecteur.get(0));
            clone.Base[i2].vecteur.set(1, dist.Base[i2].vecteur.get(1));
            clone.Base[i2].setPoids(dist.Base[i2].getPoids());
        }
        DistanceTools.GenerateMasksFromBase(clone);
        return clone;
    }

    public static Mask CloneMask(Mask mask) {
        Mask clone = new Mask(mask.vecteur.Dimension());
        clone.vecteur = DistanceTools.DupliquerVecteurEntier(mask.vecteur);
        clone.setPoids(mask.getPoids());
        clone.setWeight(mask.getWeight());
        if (mask.getNom() != null) {
            clone.setNom(mask.getNom());
        }
        return clone;
    }

    public static VectorInt DupliquerVecteurEntier(VectorInt v) {
        VectorInt clone = new VectorInt(v.Dimension());
        for (int i2 = 0; i2 < v.Dimension(); ++i2) {
            clone.set(i2, v.get(i2));
        }
        return clone;
    }

    private static boolean StrCmp(String str1, String str2) {
        if (str1.length() != str2.length()) {
            return false;
        }
        for (int i2 = 0; i2 < str1.length(); ++i2) {
            if (str1.charAt(i2) == str2.charAt(i2)) continue;
            return false;
        }
        return true;
    }
}

