/*
 * Decompiled with CFR 0.152.
 */
package measures.hedgehop;

import arrayTiTi.ArrayComparator;
import imageTiTi.ImageComparator;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import listTiTi.Queue;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import measures.cclh.UnionFindCcl;
import measures.hedgehop.Mask;
import morphee.StructuringElement;

public class DistanceMapComputer {
    private StructuringElement se = null;
    public Mask[] halfmask = null;
    public Mask[] mask = null;
    private int width = 0;
    private int height = 0;
    private int[] ChamferMap1D = null;
    private float[] MontanariMap1D = null;
    private int[] Labels1D = null;
    private Queue<Coordinates> fifo = new Queue();
    private Queue<CoordinatesWeighted> fifow = new Queue();
    private UnionFindCcl ccl = new UnionFindCcl();

    public void Kill() {
        this.se = null;
        this.mask = null;
        this.halfmask = null;
        this.ChamferMap1D = null;
        this.MontanariMap1D = null;
        this.Labels1D = null;
        if (this.fifo != null) {
            this.fifo.Clear();
        }
        this.fifo = null;
        if (this.fifow != null) {
            this.fifow.Clear();
        }
        this.fifow = null;
        if (this.ccl != null) {
            this.ccl.Kill();
        }
        this.ccl = null;
    }

    public void Compute(BufferedImage image, StructuringElement se) {
        this.se = se;
        se.PreComputePositions(image.getWidth());
        switch (se.getType()) {
            case -14: {
                this.ComputeChamfer(image);
                break;
            }
            case -15: {
                this.ComputeMontanari(image);
                break;
            }
            default: {
                throw new IllegalArgumentException("The StructuringElement type must be CHAMFER or MONTANARI.");
            }
        }
    }

    private void ComputeMontanari(BufferedImage image) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        int length = this.width * this.height;
        CoordinatesWeighted[] coordinates = null;
        if (this.MontanariMap1D == null || this.MontanariMap1D.length != length) {
            this.MontanariMap1D = null;
            this.MontanariMap1D = new float[length];
        }
        Arrays.fill(this.MontanariMap1D, 0.0f);
        block0 : switch (image.getType()) {
            case 12: {
                float dv;
                int dy;
                int dx;
                float mini;
                int x;
                int y;
                WritableRaster wr = image.getRaster();
                int pos = 0;
                for (y = 0; y < this.height; ++y) {
                    x = 0;
                    while (x < this.width) {
                        if (wr.getSample(x, y, 0) != 0) {
                            this.MontanariMap1D[pos] = Float.MAX_VALUE;
                        }
                        ++x;
                        ++pos;
                    }
                }
                coordinates = this.se.getForward();
                pos = 0;
                for (y = 0; y < this.height; ++y) {
                    x = 0;
                    while (x < this.width) {
                        if (wr.getSample(x, y, 0) != 0) {
                            mini = this.MontanariMap1D[pos];
                            for (CoordinatesWeighted cw : coordinates) {
                                dx = x + cw.X;
                                if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || !((dv = this.MontanariMap1D[pos + cw.Pos] + (float)cw.Wd) < mini)) continue;
                                mini = dv;
                            }
                            this.MontanariMap1D[pos] = mini;
                        }
                        ++x;
                        ++pos;
                    }
                }
                coordinates = this.se.getBackward();
                pos = length - 1;
                for (y = this.height - 1; y >= 0; --y) {
                    x = this.width - 1;
                    while (x >= 0) {
                        if (wr.getSample(x, y, 0) != 0) {
                            mini = this.MontanariMap1D[pos];
                            for (CoordinatesWeighted cw : coordinates) {
                                dx = x + cw.X;
                                if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || !((dv = this.MontanariMap1D[pos + cw.Pos] + (float)cw.Wd) < mini)) continue;
                                mini = dv;
                            }
                            this.MontanariMap1D[pos] = mini;
                        }
                        --x;
                        --pos;
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                float dv;
                int dy;
                int dx;
                float mini;
                int x;
                int y;
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                for (int x2 = 0; x2 < bb.length; ++x2) {
                    if (bb[x2] == 0) continue;
                    this.MontanariMap1D[x2] = Float.MAX_VALUE;
                }
                coordinates = this.se.getForward();
                int pos = 0;
                for (y = 0; y < this.height; ++y) {
                    x = 0;
                    while (x < this.width) {
                        if (bb[pos] != 0) {
                            mini = this.MontanariMap1D[pos];
                            for (CoordinatesWeighted cw : coordinates) {
                                dx = x + cw.X;
                                if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || !((dv = this.MontanariMap1D[pos + cw.Pos] + (float)cw.Wd) < mini)) continue;
                                mini = dv;
                            }
                            this.MontanariMap1D[pos] = mini;
                        }
                        ++x;
                        ++pos;
                    }
                }
                coordinates = this.se.getBackward();
                pos = length - 1;
                for (y = this.height - 1; y >= 0; --y) {
                    x = this.width - 1;
                    while (x >= 0) {
                        if (bb[pos] != 0) {
                            mini = this.MontanariMap1D[pos];
                            for (CoordinatesWeighted cw : coordinates) {
                                dx = x + cw.X;
                                if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || !((dv = this.MontanariMap1D[pos + cw.Pos] + (float)cw.Wd) < mini)) continue;
                                mini = dv;
                            }
                            this.MontanariMap1D[pos] = mini;
                        }
                        --x;
                        --pos;
                    }
                }
                bb = null;
                break;
            }
            case 11: {
                float dv;
                int dy;
                int dx;
                float mini;
                int x;
                int y;
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                for (int x3 = 0; x3 < sb.length; ++x3) {
                    if (sb[x3] == 0) continue;
                    this.MontanariMap1D[x3] = Float.MAX_VALUE;
                }
                coordinates = this.se.getForward();
                int pos = 0;
                for (y = 0; y < this.height; ++y) {
                    x = 0;
                    while (x < this.width) {
                        if (sb[pos] != 0) {
                            mini = this.MontanariMap1D[pos];
                            for (CoordinatesWeighted cw : coordinates) {
                                dx = x + cw.X;
                                if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || !((dv = this.MontanariMap1D[pos + cw.Pos] + (float)cw.Wd) < mini)) continue;
                                mini = dv;
                            }
                            this.MontanariMap1D[pos] = mini;
                        }
                        ++x;
                        ++pos;
                    }
                }
                coordinates = this.se.getBackward();
                pos = length - 1;
                for (y = this.height - 1; y >= 0; --y) {
                    x = this.width - 1;
                    while (x >= 0) {
                        if (sb[pos] != 0) {
                            mini = this.MontanariMap1D[pos];
                            for (CoordinatesWeighted cw : coordinates) {
                                dx = x + cw.X;
                                if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || !((dv = this.MontanariMap1D[pos + cw.Pos] + (float)cw.Wd) < mini)) continue;
                                mini = dv;
                            }
                            this.MontanariMap1D[pos] = mini;
                        }
                        --x;
                        --pos;
                    }
                }
                sb = null;
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        float dv;
                        int dy;
                        int dx;
                        float mini;
                        int x;
                        int y;
                        int[] ib = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                        for (int x4 = 0; x4 < ib.length; ++x4) {
                            if (ib[x4] == 0) continue;
                            this.MontanariMap1D[x4] = Float.MAX_VALUE;
                        }
                        coordinates = this.se.getForward();
                        int pos = 0;
                        for (y = 0; y < this.height; ++y) {
                            x = 0;
                            while (x < this.width) {
                                if (ib[pos] != 0) {
                                    mini = this.MontanariMap1D[pos];
                                    for (CoordinatesWeighted cw : coordinates) {
                                        dx = x + cw.X;
                                        if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || !((dv = this.MontanariMap1D[pos + cw.Pos] + (float)cw.Wd) < mini)) continue;
                                        mini = dv;
                                    }
                                    this.MontanariMap1D[pos] = mini;
                                }
                                ++x;
                                ++pos;
                            }
                        }
                        coordinates = this.se.getBackward();
                        pos = length - 1;
                        for (y = this.height - 1; y >= 0; --y) {
                            x = this.width - 1;
                            while (x >= 0) {
                                if (ib[pos] != 0) {
                                    mini = this.MontanariMap1D[pos];
                                    for (CoordinatesWeighted cw : coordinates) {
                                        dx = x + cw.X;
                                        if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || !((dv = this.MontanariMap1D[pos + cw.Pos] + (float)cw.Wd) < mini)) continue;
                                        mini = dv;
                                    }
                                    this.MontanariMap1D[pos] = mini;
                                }
                                --x;
                                --pos;
                            }
                        }
                        ib = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    private void ComputeChamfer(BufferedImage image) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        int length = this.width * this.height;
        CoordinatesWeighted[] coordinates = null;
        if (this.ChamferMap1D == null || this.ChamferMap1D.length != length) {
            this.ChamferMap1D = null;
            this.ChamferMap1D = new int[length];
        }
        Arrays.fill(this.ChamferMap1D, 0);
        block0 : switch (image.getType()) {
            case 12: {
                int dv;
                int dy;
                int dx;
                int mini;
                int x;
                int y;
                WritableRaster wr = image.getRaster();
                int pos = 0;
                for (y = 0; y < this.height; ++y) {
                    x = 0;
                    while (x < this.width) {
                        if (wr.getSample(x, y, 0) != 0) {
                            this.ChamferMap1D[pos] = Integer.MAX_VALUE;
                        }
                        ++x;
                        ++pos;
                    }
                }
                coordinates = this.se.getForward();
                pos = 0;
                for (y = 0; y < this.height; ++y) {
                    x = 0;
                    while (x < this.width) {
                        if (wr.getSample(x, y, 0) != 0) {
                            mini = this.ChamferMap1D[pos];
                            for (CoordinatesWeighted cw : coordinates) {
                                dx = x + cw.X;
                                if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || (dv = this.ChamferMap1D[pos + cw.Pos] + cw.Wi) >= mini) continue;
                                mini = dv;
                            }
                            this.ChamferMap1D[pos] = mini;
                        }
                        ++x;
                        ++pos;
                    }
                }
                coordinates = this.se.getBackward();
                pos = length - 1;
                for (y = this.height - 1; y >= 0; --y) {
                    x = this.width - 1;
                    while (x >= 0) {
                        if (wr.getSample(x, y, 0) != 0) {
                            mini = this.ChamferMap1D[pos];
                            for (CoordinatesWeighted cw : coordinates) {
                                dx = x + cw.X;
                                if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || (dv = this.ChamferMap1D[pos + cw.Pos] + cw.Wi) >= mini) continue;
                                mini = dv;
                            }
                            this.ChamferMap1D[pos] = mini;
                        }
                        --x;
                        --pos;
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                int dv;
                int dy;
                int dx;
                int mini;
                int x;
                int y;
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                for (int x2 = 0; x2 < bb.length; ++x2) {
                    if ((bb[x2] & 0xFF) == 0) continue;
                    this.ChamferMap1D[x2] = Integer.MAX_VALUE;
                }
                coordinates = this.se.getForward();
                int pos = 0;
                for (y = 0; y < this.height; ++y) {
                    x = 0;
                    while (x < this.width) {
                        if ((bb[pos] & 0xFF) != 0) {
                            mini = this.ChamferMap1D[pos];
                            for (CoordinatesWeighted cw : coordinates) {
                                dx = x + cw.X;
                                if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || (dv = this.ChamferMap1D[pos + cw.Pos] + cw.Wi) >= mini) continue;
                                mini = dv;
                            }
                            this.ChamferMap1D[pos] = mini;
                        }
                        ++x;
                        ++pos;
                    }
                }
                coordinates = this.se.getBackward();
                pos = length - 1;
                for (y = this.height - 1; y >= 0; --y) {
                    x = this.width - 1;
                    while (x >= 0) {
                        if ((bb[pos] & 0xFF) != 0) {
                            mini = this.ChamferMap1D[pos];
                            for (CoordinatesWeighted cw : coordinates) {
                                dx = x + cw.X;
                                if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || (dv = this.ChamferMap1D[pos + cw.Pos] + cw.Wi) >= mini) continue;
                                mini = dv;
                            }
                            this.ChamferMap1D[pos] = mini;
                        }
                        --x;
                        --pos;
                    }
                }
                bb = null;
                break;
            }
            case 11: {
                int dv;
                int dy;
                int dx;
                int mini;
                int x;
                int y;
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                for (int x3 = 0; x3 < sb.length; ++x3) {
                    if ((sb[x3] & 0xFFFF) == 0) continue;
                    this.ChamferMap1D[x3] = Integer.MAX_VALUE;
                }
                coordinates = this.se.getForward();
                int pos = 0;
                for (y = 0; y < this.height; ++y) {
                    x = 0;
                    while (x < this.width) {
                        if ((sb[pos] & 0xFFFF) != 0) {
                            mini = this.ChamferMap1D[pos];
                            for (CoordinatesWeighted cw : coordinates) {
                                dx = x + cw.X;
                                if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || (dv = this.ChamferMap1D[pos + cw.Pos] + cw.Wi) >= mini) continue;
                                mini = dv;
                            }
                            this.ChamferMap1D[pos] = mini;
                        }
                        ++x;
                        ++pos;
                    }
                }
                coordinates = this.se.getBackward();
                pos = length - 1;
                for (y = this.height - 1; y >= 0; --y) {
                    x = this.width - 1;
                    while (x >= 0) {
                        if ((sb[pos] & 0xFFFF) != 0) {
                            mini = this.ChamferMap1D[pos];
                            for (CoordinatesWeighted cw : coordinates) {
                                dx = x + cw.X;
                                if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || (dv = this.ChamferMap1D[pos + cw.Pos] + cw.Wi) >= mini) continue;
                                mini = dv;
                            }
                            this.ChamferMap1D[pos] = mini;
                        }
                        --x;
                        --pos;
                    }
                }
                sb = null;
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int dv;
                        int dy;
                        int dx;
                        int mini;
                        int x;
                        int y;
                        int[] ib = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                        for (int x4 = 0; x4 < ib.length; ++x4) {
                            if (ib[x4] == 0) continue;
                            this.ChamferMap1D[x4] = Integer.MAX_VALUE;
                        }
                        coordinates = this.se.getForward();
                        int pos = 0;
                        for (y = 0; y < this.height; ++y) {
                            x = 0;
                            while (x < this.width) {
                                if (ib[x] != 0) {
                                    mini = this.ChamferMap1D[pos];
                                    for (CoordinatesWeighted cw : coordinates) {
                                        dx = x + cw.X;
                                        if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || (dv = this.ChamferMap1D[pos + cw.Pos] + cw.Wi) >= mini) continue;
                                        mini = dv;
                                    }
                                    this.ChamferMap1D[pos] = mini;
                                }
                                ++x;
                                ++pos;
                            }
                        }
                        coordinates = this.se.getBackward();
                        pos = length - 1;
                        for (y = this.height - 1; y >= 0; --y) {
                            x = this.width - 1;
                            while (x >= 0) {
                                if (ib[x] != 0) {
                                    mini = this.ChamferMap1D[pos];
                                    for (CoordinatesWeighted cw : coordinates) {
                                        dx = x + cw.X;
                                        if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || (dv = this.ChamferMap1D[pos + cw.Pos] + cw.Wi) >= mini) continue;
                                        mini = dv;
                                    }
                                    this.ChamferMap1D[pos] = mini;
                                }
                                --x;
                                --pos;
                            }
                        }
                        ib = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public void ComputeGrayLevel(BufferedImage image, StructuringElement se, boolean eightconnex) {
        this.se = se;
        se.PreComputePositions(image.getWidth());
        switch (se.getType()) {
            case -14: {
                this.ComputeGrayLevelChamfer(image, eightconnex);
                break;
            }
            case -15: {
                this.ComputeGrayLevelMontanari(image, eightconnex);
                break;
            }
            default: {
                throw new IllegalArgumentException("The StructuringElement type must be CHAMFER or MONTANARI.");
            }
        }
    }

    private void ComputeGrayLevelMontanari(BufferedImage image, boolean eightconnex) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        int length = this.width * this.height;
        CoordinatesWeighted[] coordinates = null;
        if (this.MontanariMap1D == null || this.MontanariMap1D.length != length) {
            this.MontanariMap1D = null;
            this.MontanariMap1D = new float[length];
        }
        Arrays.fill(this.MontanariMap1D, 0.0f);
        if (this.ccl == null) {
            this.ccl = new UnionFindCcl();
        }
        this.ccl.Label(image, 0, eightconnex);
        int[] labels = this.ccl.Labels1D();
        block0 : switch (image.getType()) {
            case 10: {
                int dpos;
                float dv;
                int dy;
                int dx;
                float mini;
                int x;
                int y;
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                ArrayComparator.CompareUnsigned((byte[])bb, (String)"!=", (int)0, (float)length, (float)0.0f, (float[])this.MontanariMap1D);
                coordinates = this.se.getForward();
                int pos = 0;
                for (y = 0; y < this.height; ++y) {
                    x = 0;
                    while (x < this.width) {
                        if ((bb[pos] & 0xFF) != 0) {
                            mini = this.MontanariMap1D[pos];
                            for (CoordinatesWeighted cw : coordinates) {
                                dx = x + cw.X;
                                if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || !((dv = (labels[pos] != labels[dpos = pos + cw.Pos] ? 0.0f : this.MontanariMap1D[dpos]) + (float)cw.Wd) < mini)) continue;
                                mini = dv;
                            }
                            this.MontanariMap1D[pos] = mini;
                        }
                        ++x;
                        ++pos;
                    }
                }
                coordinates = this.se.getBackward();
                pos = length - 1;
                for (y = this.height - 1; y >= 0; --y) {
                    x = this.width - 1;
                    while (x >= 0) {
                        if ((bb[pos] & 0xFF) != 0) {
                            mini = this.MontanariMap1D[pos];
                            for (CoordinatesWeighted cw : coordinates) {
                                dx = x + cw.X;
                                if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || !((dv = (labels[pos] != labels[dpos = pos + cw.Pos] ? 0.0f : this.MontanariMap1D[dpos]) + (float)cw.Wd) < mini)) continue;
                                mini = dv;
                            }
                            this.MontanariMap1D[pos] = mini;
                        }
                        --x;
                        --pos;
                    }
                }
                bb = null;
                break;
            }
            case 11: {
                int dpos;
                float dv;
                int dy;
                int dx;
                float mini;
                int x;
                int y;
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                ArrayComparator.CompareUnsigned((short[])sb, (String)"!=", (int)0, (float)length, (float)0.0f, (float[])this.MontanariMap1D);
                coordinates = this.se.getForward();
                int pos = 0;
                for (y = 0; y < this.height; ++y) {
                    x = 0;
                    while (x < this.width) {
                        if ((sb[pos] & 0xFFFF) != 0) {
                            mini = this.MontanariMap1D[pos];
                            for (CoordinatesWeighted cw : coordinates) {
                                dx = x + cw.X;
                                if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || !((dv = (labels[pos] != labels[dpos = pos + cw.Pos] ? 0.0f : this.MontanariMap1D[dpos]) + (float)cw.Wd) < mini)) continue;
                                mini = dv;
                            }
                            this.MontanariMap1D[pos] = mini;
                        }
                        ++x;
                        ++pos;
                    }
                }
                coordinates = this.se.getBackward();
                pos = length - 1;
                for (y = this.height - 1; y >= 0; --y) {
                    x = this.width - 1;
                    while (x >= 0) {
                        if ((sb[pos] & 0xFFFF) != 0) {
                            mini = this.MontanariMap1D[pos];
                            for (CoordinatesWeighted cw : coordinates) {
                                dx = x + cw.X;
                                if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || !((dv = (labels[pos] != labels[dpos = pos + cw.Pos] ? 0.0f : this.MontanariMap1D[dpos]) + (float)cw.Wd) < mini)) continue;
                                mini = dv;
                            }
                            this.MontanariMap1D[pos] = mini;
                        }
                        --x;
                        --pos;
                    }
                }
                sb = null;
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int dpos;
                        float dv;
                        int dy;
                        int dx;
                        float mini;
                        int x;
                        int y;
                        int[] ib = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                        ArrayComparator.Compare((int[])ib, (String)"!=", (int)0, (float)length, (float)0.0f, (float[])this.MontanariMap1D);
                        coordinates = this.se.getForward();
                        int pos = 0;
                        for (y = 0; y < this.height; ++y) {
                            x = 0;
                            while (x < this.width) {
                                if (ib[pos] != 0) {
                                    mini = this.MontanariMap1D[pos];
                                    for (CoordinatesWeighted cw : coordinates) {
                                        dx = x + cw.X;
                                        if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || !((dv = (labels[pos] != labels[dpos = pos + cw.Pos] ? 0.0f : this.MontanariMap1D[dpos]) + (float)cw.Wd) < mini)) continue;
                                        mini = dv;
                                    }
                                    this.MontanariMap1D[pos] = mini;
                                }
                                ++x;
                                ++pos;
                            }
                        }
                        coordinates = this.se.getBackward();
                        pos = length - 1;
                        for (y = this.height - 1; y >= 0; --y) {
                            x = this.width - 1;
                            while (x >= 0) {
                                if (ib[pos] != 0) {
                                    mini = this.MontanariMap1D[pos];
                                    for (CoordinatesWeighted cw : coordinates) {
                                        dx = x + cw.X;
                                        if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || !((dv = (labels[pos] != labels[dpos = pos + cw.Pos] ? 0.0f : this.MontanariMap1D[dpos]) + (float)cw.Wd) < mini)) continue;
                                        mini = dv;
                                    }
                                    this.MontanariMap1D[pos] = mini;
                                }
                                --x;
                                --pos;
                            }
                        }
                        ib = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        labels = null;
    }

    private void ComputeGrayLevelChamfer(BufferedImage image, boolean eightconnex) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        int length = this.width * this.height;
        CoordinatesWeighted[] coordinates = null;
        if (this.ChamferMap1D == null || this.ChamferMap1D.length != length) {
            this.ChamferMap1D = null;
            this.ChamferMap1D = new int[length];
        }
        Arrays.fill(this.ChamferMap1D, 0);
        if (this.ccl == null) {
            this.ccl = new UnionFindCcl();
        }
        this.ccl.Label(image, 0, eightconnex);
        int[] labels = this.ccl.Labels1D();
        block0 : switch (image.getType()) {
            case 12: {
                int dpos;
                int dv;
                int dy;
                int dx;
                int mini;
                int x;
                int y;
                WritableRaster wr = image.getRaster();
                int pos = 0;
                for (y = 0; y < this.height; ++y) {
                    x = 0;
                    while (x < this.width) {
                        if (wr.getSample(x, y, 0) != 0) {
                            this.ChamferMap1D[pos] = length;
                        }
                        ++x;
                        ++pos;
                    }
                }
                coordinates = this.se.getForward();
                pos = 0;
                for (y = 0; y < this.height; ++y) {
                    x = 0;
                    while (x < this.width) {
                        if (wr.getSample(x, y, 0) != 0) {
                            mini = this.ChamferMap1D[pos];
                            for (CoordinatesWeighted cw : coordinates) {
                                dx = x + cw.X;
                                if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || (dv = (labels[pos] != labels[dpos = pos + cw.Pos] ? 0 : this.ChamferMap1D[dpos]) + cw.Wi) >= mini) continue;
                                mini = dv;
                            }
                            this.ChamferMap1D[pos] = mini;
                        }
                        ++x;
                        ++pos;
                    }
                }
                coordinates = this.se.getBackward();
                pos = length - 1;
                for (y = this.height - 1; y >= 0; --y) {
                    x = this.width - 1;
                    while (x >= 0) {
                        if (wr.getSample(x, y, 0) != 0) {
                            mini = this.ChamferMap1D[pos];
                            for (CoordinatesWeighted cw : coordinates) {
                                dx = x + cw.X;
                                if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || (dv = (labels[pos] != labels[dpos = pos + cw.Pos] ? 0 : this.ChamferMap1D[dpos]) + cw.Wi) >= mini) continue;
                                mini = dv;
                            }
                            this.ChamferMap1D[pos] = mini;
                        }
                        --x;
                        --pos;
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                int dpos;
                int dv;
                int dy;
                int dx;
                int mini;
                int x;
                int y;
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                ArrayComparator.CompareUnsigned((byte[])bb, (String)"!=", (int)0, (int)length, (int)0, (int[])this.ChamferMap1D);
                coordinates = this.se.getForward();
                int pos = 0;
                for (y = 0; y < this.height; ++y) {
                    x = 0;
                    while (x < this.width) {
                        if ((bb[pos] & 0xFF) != 0) {
                            mini = this.ChamferMap1D[pos];
                            for (CoordinatesWeighted cw : coordinates) {
                                dx = x + cw.X;
                                if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || (dv = (labels[pos] != labels[dpos = pos + cw.Pos] ? 0 : this.ChamferMap1D[dpos]) + cw.Wi) >= mini) continue;
                                mini = dv;
                            }
                            this.ChamferMap1D[pos] = mini;
                        }
                        ++x;
                        ++pos;
                    }
                }
                coordinates = this.se.getBackward();
                pos = length - 1;
                for (y = this.height - 1; y >= 0; --y) {
                    x = this.width - 1;
                    while (x >= 0) {
                        if ((bb[pos] & 0xFF) != 0) {
                            mini = this.ChamferMap1D[pos];
                            for (CoordinatesWeighted cw : coordinates) {
                                dx = x + cw.X;
                                if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || (dv = (labels[pos] != labels[dpos = pos + cw.Pos] ? 0 : this.ChamferMap1D[dpos]) + cw.Wi) >= mini) continue;
                                mini = dv;
                            }
                            this.ChamferMap1D[pos] = mini;
                        }
                        --x;
                        --pos;
                    }
                }
                bb = null;
                break;
            }
            case 11: {
                int dpos;
                int dv;
                int dy;
                int dx;
                int mini;
                int x;
                int y;
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                ArrayComparator.CompareUnsigned((short[])sb, (String)"!=", (int)0, (int)length, (int)0, (int[])this.ChamferMap1D);
                coordinates = this.se.getForward();
                int pos = 0;
                for (y = 0; y < this.height; ++y) {
                    x = 0;
                    while (x < this.width) {
                        if ((sb[pos] & 0xFFFF) != 0) {
                            mini = this.ChamferMap1D[pos];
                            for (CoordinatesWeighted cw : coordinates) {
                                dx = x + cw.X;
                                if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || (dv = (labels[pos] != labels[dpos = pos + cw.Pos] ? 0 : this.ChamferMap1D[dpos]) + cw.Wi) >= mini) continue;
                                mini = dv;
                            }
                            this.ChamferMap1D[pos] = mini;
                        }
                        ++x;
                        ++pos;
                    }
                }
                coordinates = this.se.getBackward();
                pos = length - 1;
                for (y = this.height - 1; y >= 0; --y) {
                    x = this.width - 1;
                    while (x >= 0) {
                        if ((sb[pos] & 0xFFFF) != 0) {
                            mini = this.ChamferMap1D[pos];
                            for (CoordinatesWeighted cw : coordinates) {
                                dx = x + cw.X;
                                if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || (dv = (labels[pos] != labels[dpos = pos + cw.Pos] ? 0 : this.ChamferMap1D[dpos]) + cw.Wi) >= mini) continue;
                                mini = dv;
                            }
                            this.ChamferMap1D[pos] = mini;
                        }
                        --x;
                        --pos;
                    }
                }
                sb = null;
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int dpos;
                        int dv;
                        int dy;
                        int dx;
                        int mini;
                        int x;
                        int y;
                        int[] ib = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                        ArrayComparator.Compare((int[])ib, (String)"!=", (int)0, (int)length, (int)0, (int[])this.ChamferMap1D);
                        coordinates = this.se.getForward();
                        int pos = 0;
                        for (y = 0; y < this.height; ++y) {
                            x = 0;
                            while (x < this.width) {
                                if (ib[pos] != 0) {
                                    mini = this.ChamferMap1D[pos];
                                    for (CoordinatesWeighted cw : coordinates) {
                                        dx = x + cw.X;
                                        if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || (dv = (labels[pos] != labels[dpos = pos + cw.Pos] ? 0 : this.ChamferMap1D[dpos]) + cw.Wi) >= mini) continue;
                                        mini = dv;
                                    }
                                    this.ChamferMap1D[pos] = mini;
                                }
                                ++x;
                                ++pos;
                            }
                        }
                        coordinates = this.se.getBackward();
                        pos = length - 1;
                        for (y = this.height - 1; y >= 0; --y) {
                            x = this.width - 1;
                            while (x >= 0) {
                                if (ib[pos] != 0) {
                                    mini = this.ChamferMap1D[pos];
                                    for (CoordinatesWeighted cw : coordinates) {
                                        dx = x + cw.X;
                                        if (dx < 0 || this.width <= dx || (dy = y + cw.Y) < 0 || this.height <= dy || (dv = (labels[pos] != labels[dpos = pos + cw.Pos] ? 0 : this.ChamferMap1D[dpos]) + cw.Wi) >= mini) continue;
                                        mini = dv;
                                    }
                                    this.ChamferMap1D[pos] = mini;
                                }
                                --x;
                                --pos;
                            }
                        }
                        ib = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        labels = null;
    }

    public void ComputeStartingPoint(BufferedImage image, StructuringElement se, Coordinates point) {
        ArrayList<Coordinates> ListeIn = new ArrayList<Coordinates>(1);
        ListeIn.add(point);
        this.ComputeStartingPoints(image, se, ListeIn);
        ListeIn.clear();
        ListeIn = null;
    }

    public void ComputeStartingPoints(BufferedImage image, StructuringElement se, List<Coordinates> ListeIn) {
        this.se = se;
        switch (se.getType()) {
            case -14: {
                this.ComputeStartingPointsChamfer(image, ListeIn);
                break;
            }
            case -15: {
                this.ComputeStartingPointsMontanari(image, ListeIn);
                break;
            }
            default: {
                throw new IllegalArgumentException("The structuring element must be of type MONTANARI or CHAMFER.");
            }
        }
    }

    private void ComputeStartingPointsMontanari(BufferedImage image, List<Coordinates> ListeIn) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        int length = this.width * this.height;
        CoordinatesWeighted[] sec = this.se.getSE();
        if (this.MontanariMap1D == null || this.MontanariMap1D.length != length) {
            this.MontanariMap1D = null;
            this.MontanariMap1D = new float[length];
        }
        if (this.fifo == null) {
            this.fifo = new Queue();
        }
        this.fifo.clear();
        ImageComparator.Compare((BufferedImage)image, (String)"!=", (int)0, (float)Float.MAX_VALUE, (float)-1.0f, (float[])this.MontanariMap1D);
        for (Coordinates point : ListeIn) {
            int x = point.X;
            int y = point.Y;
            int pos = x + y * this.width;
            this.MontanariMap1D[pos] = 0.0f;
            this.fifo.Push(new Coordinates(x, y, 0, pos));
            point = null;
        }
        Iterator<Coordinates> Iter = null;
        this.se.PreComputePositions(this.width);
        block0 : switch (image.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                do {
                    Coordinates point = this.fifo.FrontPop();
                    int x = point.X;
                    int y = point.Y;
                    int pos = point.Pos;
                    point = null;
                    for (CoordinatesWeighted cw : sec) {
                        float dv;
                        int dp;
                        int dy;
                        int dx = x + cw.X;
                        if (dx < 0 || dx >= this.width || (dy = y + cw.Y) < 0 || dy >= this.height || bb[dp = pos + cw.Pos] == 0 || !((dv = this.MontanariMap1D[pos] + (float)cw.Wd) < this.MontanariMap1D[dp])) continue;
                        this.MontanariMap1D[dp] = dv;
                        this.fifo.Push(new Coordinates(dx, dy, 0, dp));
                    }
                } while (!this.fifo.isEmpty());
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                do {
                    Coordinates point = this.fifo.FrontPop();
                    int x = point.X;
                    int y = point.Y;
                    int pos = point.Pos;
                    point = null;
                    for (CoordinatesWeighted cw : sec) {
                        float dv;
                        int dp;
                        int dy;
                        int dx = x + cw.X;
                        if (dx < 0 || dx >= this.width || (dy = y + cw.Y) < 0 || dy >= this.height || sb[dp = pos + cw.Pos] == 0 || !((dv = this.MontanariMap1D[pos] + (float)cw.Wd) < this.MontanariMap1D[dp])) continue;
                        this.MontanariMap1D[dp] = dv;
                        this.fifo.Push(new Coordinates(dx, dy, 0, dp));
                    }
                } while (!this.fifo.isEmpty());
                sb = null;
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int[] ib = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                        do {
                            Coordinates point = this.fifo.FrontPop();
                            int x = point.X;
                            int y = point.Y;
                            int pos = point.Pos;
                            point = null;
                            for (CoordinatesWeighted cw : sec) {
                                float dv;
                                int dp;
                                int dy;
                                int dx = x + cw.X;
                                if (dx < 0 || dx >= this.width || (dy = y + cw.Y) < 0 || dy >= this.height || ib[dp = pos + cw.Pos] == 0 || !((dv = this.MontanariMap1D[pos] + (float)cw.Wd) < this.MontanariMap1D[dp])) continue;
                                this.MontanariMap1D[dp] = dv;
                                this.fifo.Push(new Coordinates(dx, dy, 0, dp));
                            }
                        } while (!this.fifo.isEmpty());
                        ib = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        ImageComparator.Compare((BufferedImage)image, (String)"!=", (int)0, (float[])this.MontanariMap1D, (float)-1.0f, (float[])this.MontanariMap1D);
        sec = null;
    }

    private void ComputeStartingPointsChamfer(BufferedImage image, List<Coordinates> ListeIn) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        int length = this.width * this.height;
        CoordinatesWeighted[] sec = this.se.getSE();
        if (this.ChamferMap1D == null || this.ChamferMap1D.length != length) {
            this.ChamferMap1D = null;
            this.ChamferMap1D = new int[length];
        }
        if (this.fifo == null) {
            this.fifo = new Queue();
        }
        this.fifo.clear();
        ImageComparator.Compare((BufferedImage)image, (String)"!=", (int)0, (int)Integer.MAX_VALUE, (int)-1, (int[])this.ChamferMap1D);
        for (Coordinates point : ListeIn) {
            int x = point.X;
            int y = point.Y;
            int pos = x + y * this.width;
            this.ChamferMap1D[pos] = 0;
            this.fifo.Push(new Coordinates(x, y, 0, pos));
            point = null;
        }
        this.se.PreComputePositions(this.width);
        block0 : switch (image.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                do {
                    Coordinates point = this.fifo.FrontPop();
                    int x = point.X;
                    int y = point.Y;
                    int pos = point.Pos;
                    point = null;
                    for (CoordinatesWeighted cw : sec) {
                        int dv;
                        int dp;
                        int dy;
                        int dx = x + cw.X;
                        if (dx < 0 || dx >= this.width || (dy = y + cw.Y) < 0 || dy >= this.height || bb[dp = pos + cw.Pos] == 0 || (dv = this.ChamferMap1D[pos] + cw.Wi) >= this.ChamferMap1D[dp]) continue;
                        this.ChamferMap1D[dp] = dv;
                        this.fifo.Push(new Coordinates(dx, dy, 0, dp));
                    }
                } while (!this.fifo.isEmpty());
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                do {
                    Coordinates point = this.fifo.FrontPop();
                    int x = point.X;
                    int y = point.Y;
                    int pos = point.Pos;
                    point = null;
                    for (CoordinatesWeighted cw : sec) {
                        int dv;
                        int dp;
                        int dy;
                        int dx = x + cw.X;
                        if (dx < 0 || dx >= this.width || (dy = y + cw.Y) < 0 || dy >= this.height || sb[dp = pos + cw.Pos] == 0 || (dv = this.ChamferMap1D[pos] + cw.Wi) >= this.ChamferMap1D[dp]) continue;
                        this.ChamferMap1D[dp] = dv;
                        this.fifo.Push(new Coordinates(dx, dy, 0, dp));
                    }
                } while (!this.fifo.isEmpty());
                sb = null;
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int[] ib = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                        do {
                            Coordinates point = this.fifo.FrontPop();
                            int x = point.X;
                            int y = point.Y;
                            int pos = point.Pos;
                            point = null;
                            for (CoordinatesWeighted cw : sec) {
                                int dv;
                                int dp;
                                int dy;
                                int dx = x + cw.X;
                                if (dx < 0 || dx >= this.width || (dy = y + cw.Y) < 0 || dy >= this.height || ib[dp = pos + cw.Pos] == 0 || (dv = this.ChamferMap1D[pos] + cw.Wi) >= this.ChamferMap1D[dp]) continue;
                                this.ChamferMap1D[dp] = dv;
                                this.fifo.Push(new Coordinates(dx, dy, 0, dp));
                            }
                        } while (!this.fifo.isEmpty());
                        ib = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        ImageComparator.Compare((BufferedImage)image, (String)"!=", (int)0, (int[])this.ChamferMap1D, (int)-1, (int[])this.ChamferMap1D);
        sec = null;
    }

    public void VoronoiFromSets(BufferedImage source, StructuringElement se) {
        block0 : switch (source.getType()) {
            case 10: {
                this.VoronoiFromSets(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), se);
                break;
            }
            case 11: {
                this.VoronoiFromSets(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), se);
                break;
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        this.VoronoiFromSets(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), se);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public void VoronoiFromSets(int[] input, int width, int height, StructuringElement se) {
        if (input.length != width * height) {
            throw new IllegalArgumentException("input.length != width*height.");
        }
        this.se = se;
        se.PreComputePositions(width);
        switch (se.getType()) {
            case -14: {
                this.VoronoiFromSetsInt(input, width, height);
                break;
            }
            case -15: {
                this.VoronoiFromSetsDouble(input, width, height);
                break;
            }
            default: {
                throw new IllegalArgumentException("SE type not supported: Chamfer or Montanari required.");
            }
        }
    }

    private void VoronoiFromSetsDouble(int[] input, int width, int height) {
        int x;
        if (this.MontanariMap1D == null || this.MontanariMap1D.length != input.length) {
            this.MontanariMap1D = null;
            this.MontanariMap1D = new float[input.length];
        }
        if (this.Labels1D == null || this.Labels1D.length != this.MontanariMap1D.length) {
            this.Labels1D = null;
            this.Labels1D = new int[this.MontanariMap1D.length];
        }
        Arrays.fill(this.Labels1D, 0);
        ArrayComparator.Compare((int[])input, (String)"==", (int)0, (float)Float.MAX_VALUE, (float)0.0f, (float[])this.MontanariMap1D);
        this.fifo.Clear();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (input[pos] != 0) {
                    this.fifo.Push(new Coordinates(x, y, 0, pos));
                    this.Labels1D[pos] = input[pos];
                }
                ++x;
                ++pos;
            }
        }
        this.se.PreComputePositions(width);
        CoordinatesWeighted[] sec = this.se.getSE();
        do {
            Coordinates c = this.fifo.FrontPop();
            x = c.X;
            int y = c.Y;
            int pos2 = c.Pos;
            c = null;
            for (CoordinatesWeighted cw : sec) {
                int dp;
                float dv;
                int dy;
                int dx = x + cw.X;
                if (dx < 0 || dx >= width || (dy = y + cw.Y) < 0 || dy >= height || !((dv = this.MontanariMap1D[pos2] + (float)cw.Wd) < this.MontanariMap1D[dp = pos2 + cw.Pos])) continue;
                this.MontanariMap1D[dp] = dv;
                this.fifo.Push(new Coordinates(dx, dy, 0, dp));
                this.Labels1D[dp] = this.Labels1D[pos2];
            }
        } while (!this.fifo.isEmpty());
    }

    private void VoronoiFromSetsInt(int[] input, int width, int height) {
        int x;
        if (this.ChamferMap1D == null || this.ChamferMap1D.length != input.length) {
            this.ChamferMap1D = null;
            this.ChamferMap1D = new int[input.length];
        }
        if (this.Labels1D == null || this.Labels1D.length != this.ChamferMap1D.length) {
            this.Labels1D = null;
            this.Labels1D = new int[this.ChamferMap1D.length];
        }
        Arrays.fill(this.Labels1D, 0);
        ArrayComparator.Compare((int[])input, (String)"==", (int)0, (int)Integer.MAX_VALUE, (int)0, (int[])this.ChamferMap1D);
        this.fifo.Clear();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (input[pos] != 0) {
                    this.fifo.Push(new Coordinates(x, y, 0, pos));
                    this.Labels1D[pos] = input[pos];
                }
                ++x;
                ++pos;
            }
        }
        this.se.PreComputePositions(width);
        CoordinatesWeighted[] sec = this.se.getSE();
        do {
            Coordinates c = this.fifo.FrontPop();
            x = c.X;
            int y = c.Y;
            int pos2 = c.Pos;
            c = null;
            for (CoordinatesWeighted cw : sec) {
                int dp;
                int dv;
                int dy;
                int dx = x + cw.X;
                if (dx < 0 || dx >= width || (dy = y + cw.Y) < 0 || dy >= height || (dv = this.ChamferMap1D[pos2] + cw.Wi) >= this.ChamferMap1D[dp = pos2 + cw.Pos]) continue;
                this.ChamferMap1D[dp] = dv;
                this.fifo.Push(new Coordinates(dx, dy, 0, dp));
                this.Labels1D[dp] = this.Labels1D[pos2];
            }
        } while (!this.fifo.isEmpty());
    }

    public void VoronoiFromSets(byte[] input, int width, int height, StructuringElement se) {
        if (input.length != width * height) {
            throw new IllegalArgumentException("input.length != width*height.");
        }
        this.se = se;
        se.PreComputePositions(width);
        switch (se.getType()) {
            case -14: {
                this.VoronoiFromSetsInt(input, width, height);
                break;
            }
            case -15: {
                this.VoronoiFromSetsDouble(input, width, height);
                break;
            }
            default: {
                throw new IllegalArgumentException("SE type not supported: Chamfer or Montanari required.");
            }
        }
    }

    private void VoronoiFromSetsDouble(byte[] input, int width, int height) {
        int x;
        if (this.MontanariMap1D == null || this.MontanariMap1D.length != input.length) {
            this.MontanariMap1D = null;
            this.MontanariMap1D = new float[input.length];
        }
        if (this.Labels1D == null || this.Labels1D.length != this.MontanariMap1D.length) {
            this.Labels1D = null;
            this.Labels1D = new int[this.MontanariMap1D.length];
        }
        Arrays.fill(this.Labels1D, 0);
        ArrayComparator.CompareUnsigned((byte[])input, (String)"==", (int)0, (float)Float.MAX_VALUE, (float)0.0f, (float[])this.MontanariMap1D);
        this.fifo.Clear();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (input[pos] != 0) {
                    this.fifo.Push(new Coordinates(x, y, 0, pos));
                    this.Labels1D[pos] = input[pos] & 0xFF;
                }
                ++x;
                ++pos;
            }
        }
        this.se.PreComputePositions(width);
        CoordinatesWeighted[] sec = this.se.getSE();
        do {
            Coordinates c = this.fifo.FrontPop();
            x = c.X;
            int y = c.Y;
            int pos2 = c.Pos;
            c = null;
            for (CoordinatesWeighted cw : sec) {
                int dp;
                float dv;
                int dy;
                int dx = x + cw.X;
                if (dx < 0 || dx >= width || (dy = y + cw.Y) < 0 || dy >= height || !((dv = this.MontanariMap1D[pos2] + (float)cw.Wd) < this.MontanariMap1D[dp = pos2 + cw.Pos])) continue;
                this.MontanariMap1D[dp] = dv;
                this.fifo.Push(new Coordinates(dx, dy, 0, dp));
                this.Labels1D[dp] = this.Labels1D[pos2];
            }
        } while (!this.fifo.isEmpty());
    }

    private void VoronoiFromSetsInt(byte[] input, int width, int height) {
        int x;
        if (this.ChamferMap1D == null || this.ChamferMap1D.length != input.length) {
            this.ChamferMap1D = null;
            this.ChamferMap1D = new int[input.length];
        }
        if (this.Labels1D == null || this.Labels1D.length != this.ChamferMap1D.length) {
            this.Labels1D = null;
            this.Labels1D = new int[this.ChamferMap1D.length];
        }
        Arrays.fill(this.Labels1D, 0);
        ArrayComparator.CompareUnsigned((byte[])input, (String)"==", (int)0, (int)Integer.MAX_VALUE, (int)0, (int[])this.ChamferMap1D);
        this.fifo.Clear();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (input[pos] != 0) {
                    this.fifo.Push(new Coordinates(x, y, 0, pos));
                    this.Labels1D[pos] = input[pos] & 0xFF;
                }
                ++x;
                ++pos;
            }
        }
        this.se.PreComputePositions(width);
        CoordinatesWeighted[] sec = this.se.getSE();
        do {
            Coordinates c = this.fifo.FrontPop();
            x = c.X;
            int y = c.Y;
            int pos2 = c.Pos;
            c = null;
            for (CoordinatesWeighted cw : sec) {
                int dp;
                int dv;
                int dy;
                int dx = x + cw.X;
                if (dx < 0 || dx >= width || (dy = y + cw.Y) < 0 || dy >= height || (dv = this.ChamferMap1D[pos2] + cw.Wi) >= this.ChamferMap1D[dp = pos2 + cw.Pos]) continue;
                this.ChamferMap1D[dp] = dv;
                this.fifo.Push(new Coordinates(dx, dy, 0, dp));
                this.Labels1D[dp] = this.Labels1D[pos2];
            }
        } while (!this.fifo.isEmpty());
    }

    public void VoronoiFromSets(short[] input, int width, int height, StructuringElement se) {
        if (input.length != width * height) {
            throw new IllegalArgumentException("input.length != width*height.");
        }
        this.se = se;
        se.PreComputePositions(width);
        switch (se.getType()) {
            case -14: {
                this.VoronoiFromSetsInt(input, width, height);
                break;
            }
            case -15: {
                this.VoronoiFromSetsDouble(input, width, height);
                break;
            }
            default: {
                throw new IllegalArgumentException("SE type not supported: Chamfer or Montanari required.");
            }
        }
    }

    private void VoronoiFromSetsDouble(short[] input, int width, int height) {
        int x;
        if (this.MontanariMap1D == null || this.MontanariMap1D.length != input.length) {
            this.MontanariMap1D = null;
            this.MontanariMap1D = new float[input.length];
        }
        if (this.Labels1D == null || this.Labels1D.length != this.MontanariMap1D.length) {
            this.Labels1D = null;
            this.Labels1D = new int[this.MontanariMap1D.length];
        }
        Arrays.fill(this.Labels1D, 0);
        ArrayComparator.CompareUnsigned((short[])input, (String)"==", (int)0, (float)Float.MAX_VALUE, (float)0.0f, (float[])this.MontanariMap1D);
        this.fifo.Clear();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (input[pos] != 0) {
                    this.fifo.Push(new Coordinates(x, y, 0, pos));
                    this.Labels1D[pos] = input[pos] & 0xFFFF;
                }
                ++x;
                ++pos;
            }
        }
        this.se.PreComputePositions(width);
        CoordinatesWeighted[] sec = this.se.getSE();
        do {
            Coordinates c = this.fifo.FrontPop();
            x = c.X;
            int y = c.Y;
            int pos2 = c.Pos;
            c = null;
            for (CoordinatesWeighted cw : sec) {
                int dp;
                float dv;
                int dy;
                int dx = x + cw.X;
                if (dx < 0 || dx >= width || (dy = y + cw.Y) < 0 || dy >= height || !((dv = this.MontanariMap1D[pos2] + (float)cw.Wd) < this.MontanariMap1D[dp = pos2 + cw.Pos])) continue;
                this.MontanariMap1D[dp] = dv;
                this.fifo.Push(new Coordinates(dx, dy, 0, dp));
                this.Labels1D[dp] = this.Labels1D[pos2];
            }
        } while (!this.fifo.isEmpty());
    }

    private void VoronoiFromSetsInt(short[] input, int width, int height) {
        int x;
        if (this.ChamferMap1D == null || this.ChamferMap1D.length != input.length) {
            this.ChamferMap1D = null;
            this.ChamferMap1D = new int[input.length];
        }
        if (this.Labels1D == null || this.Labels1D.length != this.ChamferMap1D.length) {
            this.Labels1D = null;
            this.Labels1D = new int[this.ChamferMap1D.length];
        }
        Arrays.fill(this.Labels1D, 0);
        ArrayComparator.CompareUnsigned((short[])input, (String)"==", (int)0, (int)Integer.MAX_VALUE, (int)0, (int[])this.ChamferMap1D);
        this.fifo.Clear();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (input[pos] != 0) {
                    this.fifo.Push(new Coordinates(x, y, 0, pos));
                    this.Labels1D[pos] = input[pos] & 0xFFFF;
                }
                ++x;
                ++pos;
            }
        }
        this.se.PreComputePositions(width);
        CoordinatesWeighted[] sec = this.se.getSE();
        do {
            Coordinates c = this.fifo.FrontPop();
            x = c.X;
            int y = c.Y;
            int pos2 = c.Pos;
            c = null;
            for (CoordinatesWeighted cw : sec) {
                int dp;
                int dv;
                int dy;
                int dx = x + cw.X;
                if (dx < 0 || dx >= width || (dy = y + cw.Y) < 0 || dy >= height || (dv = this.ChamferMap1D[pos2] + cw.Wi) >= this.ChamferMap1D[dp = pos2 + cw.Pos]) continue;
                this.ChamferMap1D[dp] = dv;
                this.fifo.Push(new Coordinates(dx, dy, 0, dp));
                this.Labels1D[dp] = this.Labels1D[pos2];
            }
        } while (!this.fifo.isEmpty());
    }

    public void VoronoiFromSets(BufferedImage source, StructuringElement se, float[] constraints) {
        block0 : switch (source.getType()) {
            case 10: {
                this.VoronoiFromSets(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), se, constraints);
                break;
            }
            case 11: {
                this.VoronoiFromSets(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), se, constraints);
                break;
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        this.VoronoiFromSets(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), se, constraints);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public void VoronoiFromSets(int[] input, int width, int height, StructuringElement se, float[] constraints) {
        int x;
        this.se = se;
        se.PreComputePositions(width);
        if (this.MontanariMap1D == null || this.MontanariMap1D.length != input.length) {
            this.MontanariMap1D = null;
            this.MontanariMap1D = new float[input.length];
        }
        if (this.Labels1D == null || this.Labels1D.length != this.MontanariMap1D.length) {
            this.Labels1D = null;
            this.Labels1D = new int[this.MontanariMap1D.length];
        }
        Arrays.fill(this.Labels1D, 0);
        ArrayComparator.Compare((int[])input, (String)"==", (int)0, (float)Float.MAX_VALUE, (float)0.0f, (float[])this.MontanariMap1D);
        this.fifo.Clear();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (input[pos] != 0) {
                    this.fifo.Push(new Coordinates(x, y, 0, pos));
                    this.Labels1D[pos] = input[pos];
                }
                ++x;
                ++pos;
            }
        }
        CoordinatesWeighted[] sec = se.getSE();
        do {
            Coordinates c = this.fifo.FrontPop();
            x = c.X;
            int y = c.Y;
            int pos2 = c.Pos;
            c = null;
            for (CoordinatesWeighted cw : sec) {
                int dp;
                float dv;
                int dy;
                int dx = x + cw.X;
                if (dx < 0 || dx >= width || (dy = y + cw.Y) < 0 || dy >= height || !((dv = this.MontanariMap1D[pos2] + (float)cw.Wd) < this.MontanariMap1D[dp = pos2 + cw.Pos]) || !(dv < constraints[this.Labels1D[pos2]])) continue;
                this.MontanariMap1D[dp] = dv;
                this.fifo.Push(new Coordinates(dx, dy, 0, dp));
                this.Labels1D[dp] = this.Labels1D[pos2];
            }
        } while (!this.fifo.isEmpty());
    }

    public void VoronoiFromSets(byte[] input, int width, int height, StructuringElement se, float[] constraints) {
        int x;
        if (this.MontanariMap1D == null || this.MontanariMap1D.length != input.length) {
            this.MontanariMap1D = null;
            this.MontanariMap1D = new float[input.length];
        }
        if (this.Labels1D == null || this.Labels1D.length != this.MontanariMap1D.length) {
            this.Labels1D = null;
            this.Labels1D = new int[this.MontanariMap1D.length];
        }
        Arrays.fill(this.Labels1D, 0);
        ArrayComparator.CompareUnsigned((byte[])input, (String)"==", (int)0, (float)Float.MAX_VALUE, (float)0.0f, (float[])this.MontanariMap1D);
        this.fifo.Clear();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (input[pos] != 0) {
                    this.fifo.Push(new Coordinates(x, y, 0, pos));
                    this.Labels1D[pos] = input[pos] & 0xFF;
                }
                ++x;
                ++pos;
            }
        }
        se.PreComputePositions(width);
        CoordinatesWeighted[] sec = se.getSE();
        do {
            Coordinates c = this.fifo.FrontPop();
            x = c.X;
            int y = c.Y;
            int pos2 = c.Pos;
            c = null;
            for (CoordinatesWeighted cw : sec) {
                int dp;
                float dv;
                int dy;
                int dx = x + cw.X;
                if (dx < 0 || dx >= width || (dy = y + cw.Y) < 0 || dy >= height || !((dv = this.MontanariMap1D[pos2] + (float)cw.Wd) < this.MontanariMap1D[dp = pos2 + cw.Pos]) || !(dv < constraints[this.Labels1D[pos2]])) continue;
                this.MontanariMap1D[dp] = dv;
                this.fifo.Push(new Coordinates(dx, dy, 0, dp));
                this.Labels1D[dp] = this.Labels1D[pos2];
            }
        } while (!this.fifo.isEmpty());
    }

    public void VoronoiFromSets(short[] input, int width, int height, StructuringElement se, float[] constraints) {
        int x;
        if (this.MontanariMap1D == null || this.MontanariMap1D.length != input.length) {
            this.MontanariMap1D = null;
            this.MontanariMap1D = new float[input.length];
        }
        if (this.Labels1D == null || this.Labels1D.length != this.MontanariMap1D.length) {
            this.Labels1D = null;
            this.Labels1D = new int[this.MontanariMap1D.length];
        }
        Arrays.fill(this.Labels1D, 0);
        ArrayComparator.CompareUnsigned((short[])input, (String)"==", (int)0, (float)Float.MAX_VALUE, (float)0.0f, (float[])this.MontanariMap1D);
        this.fifo.Clear();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (input[pos] != 0) {
                    this.fifo.Push(new Coordinates(x, y, 0, pos));
                    this.Labels1D[pos] = input[pos] & 0xFFFF;
                }
                ++x;
                ++pos;
            }
        }
        se.PreComputePositions(width);
        CoordinatesWeighted[] sec = se.getSE();
        do {
            Coordinates c = this.fifo.FrontPop();
            x = c.X;
            int y = c.Y;
            int pos2 = c.Pos;
            c = null;
            for (CoordinatesWeighted cw : sec) {
                int dp;
                float dv;
                int dy;
                int dx = x + cw.X;
                if (dx < 0 || dx >= width || (dy = y + cw.Y) < 0 || dy >= height || !((dv = this.MontanariMap1D[pos2] + (float)cw.Wd) < this.MontanariMap1D[dp = pos2 + cw.Pos]) || !(dv < constraints[this.Labels1D[pos2]])) continue;
                this.MontanariMap1D[dp] = dv;
                this.fifo.Push(new Coordinates(dx, dy, 0, dp));
                this.Labels1D[dp] = this.Labels1D[pos2];
            }
        } while (!this.fifo.isEmpty());
    }

    public void VoronoiFromSets(BufferedImage source, StructuringElement se, int[] constraints) {
        block0 : switch (source.getType()) {
            case 10: {
                this.VoronoiFromSets(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), se, constraints);
                break;
            }
            case 11: {
                this.VoronoiFromSets(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), se, constraints);
                break;
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        this.VoronoiFromSets(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), se, constraints);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public void VoronoiFromSets(int[] input, int width, int height, StructuringElement se, int[] constraints) {
        int x;
        if (this.ChamferMap1D == null || this.ChamferMap1D.length != input.length) {
            this.ChamferMap1D = null;
            this.ChamferMap1D = new int[input.length];
        }
        if (this.Labels1D == null || this.Labels1D.length != this.ChamferMap1D.length) {
            this.Labels1D = null;
            this.Labels1D = new int[this.ChamferMap1D.length];
        }
        Arrays.fill(this.Labels1D, 0);
        ArrayComparator.Compare((int[])input, (String)"==", (int)0, (int)Integer.MAX_VALUE, (int)0, (int[])this.ChamferMap1D);
        this.fifo.Clear();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (input[pos] != 0) {
                    this.fifo.Push(new Coordinates(x, y, 0, pos));
                    this.Labels1D[pos] = input[pos];
                }
                ++x;
                ++pos;
            }
        }
        se.PreComputePositions(width);
        CoordinatesWeighted[] sec = se.getSE();
        do {
            Coordinates c = this.fifo.FrontPop();
            x = c.X;
            int y = c.Y;
            int pos2 = c.Pos;
            c = null;
            for (CoordinatesWeighted cw : sec) {
                int dp;
                int dv;
                int dy;
                int dx = x + cw.X;
                if (dx < 0 || dx >= width || (dy = y + cw.Y) < 0 || dy >= height || (dv = this.ChamferMap1D[pos2] + cw.Wi) >= this.ChamferMap1D[dp = pos2 + cw.Pos] || dv >= constraints[this.Labels1D[pos2]]) continue;
                this.ChamferMap1D[dp] = dv;
                this.fifo.Push(new Coordinates(dx, dy, 0, dp));
                this.Labels1D[dp] = this.Labels1D[pos2];
            }
        } while (!this.fifo.isEmpty());
    }

    public void VoronoiFromSets(byte[] input, int width, int height, StructuringElement se, int[] constraints) {
        int x;
        if (this.ChamferMap1D == null || this.ChamferMap1D.length != input.length) {
            this.ChamferMap1D = null;
            this.ChamferMap1D = new int[input.length];
        }
        if (this.Labels1D == null || this.Labels1D.length != this.ChamferMap1D.length) {
            this.Labels1D = null;
            this.Labels1D = new int[this.ChamferMap1D.length];
        }
        Arrays.fill(this.Labels1D, 0);
        ArrayComparator.CompareUnsigned((byte[])input, (String)"==", (int)0, (int)Integer.MAX_VALUE, (int)0, (int[])this.ChamferMap1D);
        this.fifo.Clear();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (input[pos] != 0) {
                    this.fifo.Push(new Coordinates(x, y, 0, pos));
                    this.Labels1D[pos] = input[pos] & 0xFF;
                }
                ++x;
                ++pos;
            }
        }
        se.PreComputePositions(width);
        CoordinatesWeighted[] sec = se.getSE();
        do {
            Coordinates c = this.fifo.FrontPop();
            x = c.X;
            int y = c.Y;
            int pos2 = c.Pos;
            c = null;
            for (CoordinatesWeighted cw : sec) {
                int dp;
                int dv;
                int dy;
                int dx = x + cw.X;
                if (dx < 0 || dx >= width || (dy = y + cw.Y) < 0 || dy >= height || (dv = this.ChamferMap1D[pos2] + cw.Wi) >= this.ChamferMap1D[dp = pos2 + cw.Pos] || dv >= constraints[this.Labels1D[pos2]]) continue;
                this.ChamferMap1D[dp] = dv;
                this.fifo.Push(new Coordinates(dx, dy, 0, dp));
                this.Labels1D[dp] = this.Labels1D[pos2];
            }
        } while (!this.fifo.isEmpty());
    }

    public void VoronoiFromSets(short[] input, int width, int height, StructuringElement se, int[] constraints) {
        int x;
        if (this.ChamferMap1D == null || this.ChamferMap1D.length != input.length) {
            this.ChamferMap1D = null;
            this.ChamferMap1D = new int[input.length];
        }
        if (this.Labels1D == null || this.Labels1D.length != this.ChamferMap1D.length) {
            this.Labels1D = null;
            this.Labels1D = new int[this.ChamferMap1D.length];
        }
        Arrays.fill(this.Labels1D, 0);
        ArrayComparator.CompareUnsigned((short[])input, (String)"==", (int)0, (int)Integer.MAX_VALUE, (int)0, (int[])this.ChamferMap1D);
        this.fifo.Clear();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (input[pos] != 0) {
                    this.fifo.Push(new Coordinates(x, y, 0, pos));
                    this.Labels1D[pos] = input[pos] & 0xFFFF;
                }
                ++x;
                ++pos;
            }
        }
        se.PreComputePositions(width);
        CoordinatesWeighted[] sec = se.getSE();
        do {
            Coordinates c = this.fifo.FrontPop();
            x = c.X;
            int y = c.Y;
            int pos2 = c.Pos;
            c = null;
            for (CoordinatesWeighted cw : sec) {
                int dp;
                int dv;
                int dy;
                int dx = x + cw.X;
                if (dx < 0 || dx >= width || (dy = y + cw.Y) < 0 || dy >= height || (dv = this.ChamferMap1D[pos2] + cw.Wi) >= this.ChamferMap1D[dp = pos2 + cw.Pos] || dv >= constraints[this.Labels1D[pos2]]) continue;
                this.ChamferMap1D[dp] = dv;
                this.fifo.Push(new Coordinates(dx, dy, 0, dp));
                this.Labels1D[dp] = this.Labels1D[pos2];
            }
        } while (!this.fifo.isEmpty());
    }

    public void VoronoiGeodesicFromSets(BufferedImage source, BufferedImage mask, StructuringElement se) {
        block0 : switch (source.getType()) {
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        switch (mask.getType()) {
                            case 10: {
                                this.VoronoiGeodesicFromSets(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), ((DataBufferByte)mask.getRaster().getDataBuffer()).getData(), se);
                                break block0;
                            }
                            case 11: {
                                this.VoronoiGeodesicFromSets(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), ((DataBufferUShort)mask.getRaster().getDataBuffer()).getData(), se);
                                break block0;
                            }
                            case 0: {
                                switch (mask.getRaster().getDataBuffer().getDataType()) {
                                    case 3: {
                                        this.VoronoiGeodesicFromSets(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), ((DataBufferInt)mask.getRaster().getDataBuffer()).getData(), se);
                                        break block0;
                                    }
                                }
                                throw new IllegalArgumentException("Mask image DataBuffer type not supported (yet).");
                            }
                        }
                        throw new IllegalArgumentException("Mask image type not supported (yet).");
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Source image type not supported (yet).");
            }
        }
    }

    public void VoronoiGeodesicFromSets(int[] input, int width, int height, int[] mask, StructuringElement se) {
        if (input.length != width * height) {
            throw new IllegalArgumentException("input.length != width*height.");
        }
        if (input.length != mask.length) {
            throw new IllegalArgumentException("input.length != mask.length");
        }
        this.se = se;
        switch (se.getType()) {
            case -14: {
                this.VoronoiGeodesicFromSetsInt(input, width, height, mask);
                break;
            }
            case -15: {
                this.VoronoiGeodesicFromSetsDouble(input, width, height, mask);
                break;
            }
            default: {
                throw new IllegalArgumentException("SE type not supported: Chamfer or Montanari required.");
            }
        }
    }

    private void VoronoiGeodesicFromSetsInt(int[] input, int width, int height, int[] mask) {
        int x;
        if (this.ChamferMap1D == null || this.ChamferMap1D.length != input.length) {
            this.ChamferMap1D = null;
            this.ChamferMap1D = new int[input.length];
        }
        if (this.Labels1D == null || this.Labels1D.length != this.ChamferMap1D.length) {
            this.Labels1D = null;
            this.Labels1D = new int[this.ChamferMap1D.length];
        }
        ArrayComparator.Compare((int[])input, (String)"==", (int)0, (int)(Math.max(width, height) << 1), (int)0, (int[])this.ChamferMap1D);
        System.arraycopy(input, 0, this.Labels1D, 0, input.length);
        this.fifow.Clear();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (input[pos] != 0) {
                    this.fifow.Push(new CoordinatesWeighted(x, y, 0, pos, input[pos]));
                }
                ++x;
                ++pos;
            }
        }
        this.se.PreComputePositions(width);
        CoordinatesWeighted[] sec = this.se.getSE();
        do {
            CoordinatesWeighted point = this.fifow.FrontPop();
            x = point.X;
            int y = point.Y;
            int pos2 = point.Pos;
            int label = this.Labels1D[pos2];
            point = null;
            for (CoordinatesWeighted cw : sec) {
                int dv;
                int dp;
                int dy;
                int dx = x + cw.X;
                if (dx < 0 || dx >= width || (dy = y + cw.Y) < 0 || dy >= height || mask[dp = pos2 + cw.Pos] == 0 || (dv = this.ChamferMap1D[pos2] + cw.Wi) >= this.ChamferMap1D[dp]) continue;
                this.ChamferMap1D[dp] = dv;
                this.Labels1D[dp] = label;
                this.fifow.Push(new CoordinatesWeighted(dx, dy, 0, dp, label));
            }
        } while (!this.fifow.isEmpty());
    }

    private void VoronoiGeodesicFromSetsDouble(int[] input, int width, int height, int[] mask) {
        int x;
        if (this.MontanariMap1D == null || this.MontanariMap1D.length != input.length) {
            this.MontanariMap1D = null;
            this.MontanariMap1D = new float[input.length];
        }
        if (this.Labels1D == null || this.Labels1D.length != this.MontanariMap1D.length) {
            this.Labels1D = null;
            this.Labels1D = new int[this.MontanariMap1D.length];
        }
        ArrayComparator.Compare((int[])input, (String)"==", (int)0, (float)(Math.max(width, height) << 1), (float)0.0f, (float[])this.MontanariMap1D);
        System.arraycopy(input, 0, this.Labels1D, 0, input.length);
        this.fifow.Clear();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (input[pos] != 0) {
                    this.fifow.Push(new CoordinatesWeighted(x, y, 0, pos, input[pos]));
                }
                ++x;
                ++pos;
            }
        }
        this.se.PreComputePositions(width);
        CoordinatesWeighted[] sec = this.se.getSE();
        do {
            CoordinatesWeighted point = this.fifow.FrontPop();
            x = point.X;
            int y = point.Y;
            int pos2 = point.Pos;
            int label = this.Labels1D[pos2];
            point = null;
            for (CoordinatesWeighted cw : sec) {
                float dv;
                int dp;
                int dy;
                int dx = x + cw.X;
                if (dx < 0 || dx >= width || (dy = y + cw.Y) < 0 || dy >= height || mask[dp = pos2 + cw.Pos] == 0 || !((dv = this.MontanariMap1D[pos2] + (float)cw.Wd) < this.MontanariMap1D[dp])) continue;
                this.MontanariMap1D[dp] = dv;
                this.Labels1D[dp] = label;
                this.fifow.Push(new CoordinatesWeighted(dx, dy, 0, dp, label));
            }
        } while (!this.fifow.isEmpty());
    }

    public void VoronoiGeodesicFromSets(int[] input, int width, int height, byte[] mask, StructuringElement se) {
        if (input.length != width * height) {
            throw new IllegalArgumentException("input.length != width*height.");
        }
        if (input.length != mask.length) {
            throw new IllegalArgumentException("input.length != mask.length");
        }
        this.se = se;
        switch (se.getType()) {
            case -14: {
                this.VoronoiGeodesicFromSetsInt(input, width, height, mask);
                break;
            }
            case -15: {
                this.VoronoiGeodesicFromSetsDouble(input, width, height, mask);
                break;
            }
            default: {
                throw new IllegalArgumentException("SE type not supported: Chamfer or Montanari required.");
            }
        }
    }

    private void VoronoiGeodesicFromSetsInt(int[] input, int width, int height, byte[] mask) {
        int x;
        if (this.ChamferMap1D == null || this.ChamferMap1D.length != input.length) {
            this.ChamferMap1D = null;
            this.ChamferMap1D = new int[input.length];
        }
        if (this.Labels1D == null || this.Labels1D.length != this.ChamferMap1D.length) {
            this.Labels1D = null;
            this.Labels1D = new int[this.ChamferMap1D.length];
        }
        ArrayComparator.Compare((int[])input, (String)"==", (int)0, (int)(Math.max(width, height) << 1), (int)0, (int[])this.ChamferMap1D);
        System.arraycopy(input, 0, this.Labels1D, 0, input.length);
        this.fifow.Clear();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (input[pos] != 0) {
                    this.fifow.Push(new CoordinatesWeighted(x, y, 0, pos, input[pos]));
                }
                ++x;
                ++pos;
            }
        }
        this.se.PreComputePositions(width);
        CoordinatesWeighted[] sec = this.se.getSE();
        do {
            CoordinatesWeighted point = this.fifow.FrontPop();
            x = point.X;
            int y = point.Y;
            int pos2 = point.Pos;
            int label = this.Labels1D[pos2];
            point = null;
            for (CoordinatesWeighted cw : sec) {
                int dv;
                int dp;
                int dy;
                int dx = x + cw.X;
                if (dx < 0 || dx >= width || (dy = y + cw.Y) < 0 || dy >= height || mask[dp = pos2 + cw.Pos] == 0 || (dv = this.ChamferMap1D[pos2] + cw.Wi) >= this.ChamferMap1D[dp]) continue;
                this.ChamferMap1D[dp] = dv;
                this.Labels1D[dp] = label;
                this.fifow.Push(new CoordinatesWeighted(dx, dy, 0, dp, label));
            }
        } while (!this.fifow.isEmpty());
    }

    private void VoronoiGeodesicFromSetsDouble(int[] input, int width, int height, byte[] mask) {
        int x;
        if (this.MontanariMap1D == null || this.MontanariMap1D.length != input.length) {
            this.MontanariMap1D = null;
            this.MontanariMap1D = new float[input.length];
        }
        if (this.Labels1D == null || this.Labels1D.length != this.MontanariMap1D.length) {
            this.Labels1D = null;
            this.Labels1D = new int[this.MontanariMap1D.length];
        }
        ArrayComparator.Compare((int[])input, (String)"==", (int)0, (float)(Math.max(width, height) << 1), (float)0.0f, (float[])this.MontanariMap1D);
        System.arraycopy(input, 0, this.Labels1D, 0, input.length);
        this.fifow.Clear();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (input[pos] != 0) {
                    this.fifow.Push(new CoordinatesWeighted(x, y, 0, pos, input[pos]));
                }
                ++x;
                ++pos;
            }
        }
        this.se.PreComputePositions(width);
        CoordinatesWeighted[] sec = this.se.getSE();
        do {
            CoordinatesWeighted point = this.fifow.FrontPop();
            x = point.X;
            int y = point.Y;
            int pos2 = point.Pos;
            int label = this.Labels1D[pos2];
            point = null;
            for (CoordinatesWeighted cw : sec) {
                float dv;
                int dp;
                int dy;
                int dx = x + cw.X;
                if (dx < 0 || dx >= width || (dy = y + cw.Y) < 0 || dy >= height || mask[dp = pos2 + cw.Pos] == 0 || !((dv = this.MontanariMap1D[pos2] + (float)cw.Wd) < this.MontanariMap1D[dp])) continue;
                this.MontanariMap1D[dp] = dv;
                this.Labels1D[dp] = label;
                this.fifow.Push(new CoordinatesWeighted(dx, dy, 0, dp, label));
            }
        } while (!this.fifow.isEmpty());
    }

    public void VoronoiGeodesicFromSets(int[] input, int width, int height, short[] mask, StructuringElement se) {
        if (input.length != width * height) {
            throw new IllegalArgumentException("input.length != width*height.");
        }
        if (input.length != mask.length) {
            throw new IllegalArgumentException("input.length != mask.length");
        }
        this.se = se;
        switch (se.getType()) {
            case -14: {
                this.VoronoiGeodesicFromSetsInt(input, width, height, mask);
                break;
            }
            case -15: {
                this.VoronoiGeodesicFromSetsDouble(input, width, height, mask);
                break;
            }
            default: {
                throw new IllegalArgumentException("SE type not supported: Chamfer or Montanari required.");
            }
        }
    }

    private void VoronoiGeodesicFromSetsInt(int[] input, int width, int height, short[] mask) {
        int x;
        if (this.ChamferMap1D == null || this.ChamferMap1D.length != input.length) {
            this.ChamferMap1D = null;
            this.ChamferMap1D = new int[input.length];
        }
        if (this.Labels1D == null || this.Labels1D.length != this.ChamferMap1D.length) {
            this.Labels1D = null;
            this.Labels1D = new int[this.ChamferMap1D.length];
        }
        ArrayComparator.Compare((int[])input, (String)"==", (int)0, (int)(Math.max(width, height) << 1), (int)0, (int[])this.ChamferMap1D);
        System.arraycopy(input, 0, this.Labels1D, 0, input.length);
        this.fifow.Clear();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (input[pos] != 0) {
                    this.fifow.Push(new CoordinatesWeighted(x, y, 0, pos, input[pos]));
                }
                ++x;
                ++pos;
            }
        }
        this.se.PreComputePositions(width);
        CoordinatesWeighted[] sec = this.se.getSE();
        do {
            CoordinatesWeighted point = this.fifow.FrontPop();
            x = point.X;
            int y = point.Y;
            int pos2 = point.Pos;
            int label = this.Labels1D[pos2];
            point = null;
            for (CoordinatesWeighted cw : sec) {
                int dv;
                int dp;
                int dy;
                int dx = x + cw.X;
                if (dx < 0 || dx >= width || (dy = y + cw.Y) < 0 || dy >= height || mask[dp = pos2 + cw.Pos] == 0 || (dv = this.ChamferMap1D[pos2] + cw.Wi) >= this.ChamferMap1D[dp]) continue;
                this.ChamferMap1D[dp] = dv;
                this.Labels1D[dp] = label;
                this.fifow.Push(new CoordinatesWeighted(dx, dy, 0, dp, label));
            }
        } while (!this.fifow.isEmpty());
    }

    private void VoronoiGeodesicFromSetsDouble(int[] input, int width, int height, short[] mask) {
        int x;
        if (this.MontanariMap1D == null || this.MontanariMap1D.length != input.length) {
            this.MontanariMap1D = null;
            this.MontanariMap1D = new float[input.length];
        }
        if (this.Labels1D == null || this.Labels1D.length != this.MontanariMap1D.length) {
            this.Labels1D = null;
            this.Labels1D = new int[this.MontanariMap1D.length];
        }
        ArrayComparator.Compare((int[])input, (String)"==", (int)0, (float)(Math.max(width, height) << 1), (float)0.0f, (float[])this.MontanariMap1D);
        System.arraycopy(input, 0, this.Labels1D, 0, input.length);
        this.fifow.Clear();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (input[pos] != 0) {
                    this.fifow.Push(new CoordinatesWeighted(x, y, 0, pos, input[pos]));
                }
                ++x;
                ++pos;
            }
        }
        this.se.PreComputePositions(width);
        CoordinatesWeighted[] sec = this.se.getSE();
        do {
            CoordinatesWeighted point = this.fifow.FrontPop();
            x = point.X;
            int y = point.Y;
            int pos2 = point.Pos;
            int label = this.Labels1D[pos2];
            point = null;
            for (CoordinatesWeighted cw : sec) {
                float dv;
                int dp;
                int dy;
                int dx = x + cw.X;
                if (dx < 0 || dx >= width || (dy = y + cw.Y) < 0 || dy >= height || mask[dp = pos2 + cw.Pos] == 0 || !((dv = this.MontanariMap1D[pos2] + (float)cw.Wd) < this.MontanariMap1D[dp])) continue;
                this.MontanariMap1D[dp] = dv;
                this.Labels1D[dp] = label;
                this.fifow.Push(new CoordinatesWeighted(dx, dy, 0, dp, label));
            }
        } while (!this.fifow.isEmpty());
    }

    public float[] getMontanariMap1D() {
        return this.MontanariMap1D;
    }

    public int[] getChamferMap1D() {
        return this.ChamferMap1D;
    }

    public int[] getLabels1D() {
        return this.Labels1D;
    }
}

