/*
 * Decompiled with CFR 0.152.
 */
package measures.hedgehop;

import arrayTiTi.ArrayComparator;
import dv.DV;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import listTiTi.Queue;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import measures.hedgehop.Distance;
import morphee.StructuringElement3D;

public class DistanceMap3DComputer {
    public Distance Dist = null;
    private StructuringElement3D se = null;
    private float[] MontanariMap1D = null;
    private Queue<Coordinates> fifo = null;

    public void Kill() {
        this.MontanariMap1D = null;
        this.se = null;
        if (this.fifo != null) {
            this.fifo.clear();
        }
        this.fifo = null;
        this.Dist = null;
    }

    public void Compute(DV dv, StructuringElement3D se) {
        this.se = se;
        se.PreComputePositions(dv.SizeX, dv.SizeY);
        switch (se.getType()) {
            case -15: {
                this.ComputeMontanari(dv);
                break;
            }
            default: {
                throw new IllegalArgumentException("The StructuringElement type must be MONTANARI.");
            }
        }
    }

    private void ComputeMontanari(DV source) {
        CoordinatesWeighted[] coordinates = null;
        if (this.MontanariMap1D == null || this.MontanariMap1D.length != source.Length) {
            this.MontanariMap1D = null;
            this.MontanariMap1D = new float[source.Length];
        }
        switch (source.Type) {
            case 8: {
                float dv;
                int dz;
                int dy;
                int dx;
                CoordinatesWeighted cw;
                int k;
                float mini;
                int x;
                int y;
                int z;
                byte[] bb = source.getDataBufferByte(0);
                ArrayComparator.CompareUnsigned((byte[])bb, (String)"!=", (int)0, (float)Float.MAX_VALUE, (float)0.0f, (float[])this.MontanariMap1D);
                coordinates = this.se.getForward();
                int pos = 0;
                for (z = 0; z < source.SizeZ; ++z) {
                    for (y = 0; y < source.SizeY; ++y) {
                        x = 0;
                        while (x < source.SizeX) {
                            if (bb[pos] != 0) {
                                mini = this.MontanariMap1D[pos];
                                for (k = 0; k < coordinates.length; ++k) {
                                    cw = coordinates[k];
                                    dx = x + cw.X;
                                    if (dx < 0 || source.SizeX <= dx || (dy = y + cw.Y) < 0 || source.SizeY <= dy || (dz = z + cw.Z) < 0 || source.SizeZ <= dz) continue;
                                    dv = this.MontanariMap1D[pos + cw.Pos] + (float)cw.Wd;
                                    if (dv < mini) {
                                        mini = dv;
                                    }
                                    cw = null;
                                }
                                this.MontanariMap1D[pos] = mini;
                            }
                            ++x;
                            ++pos;
                        }
                    }
                }
                coordinates = this.se.getBackward();
                pos = source.Length - 1;
                for (z = source.SizeZ - 1; z >= 0; --z) {
                    for (y = source.SizeY - 1; y >= 0; --y) {
                        x = source.SizeX - 1;
                        while (x >= 0) {
                            if (bb[pos] != 0) {
                                mini = this.MontanariMap1D[pos];
                                for (k = 0; k < coordinates.length; ++k) {
                                    cw = coordinates[k];
                                    dx = x + cw.X;
                                    if (dx < 0 || source.SizeX <= dx || (dy = y + cw.Y) < 0 || source.SizeY <= dy || (dz = z + cw.Z) < 0 || source.SizeZ <= dz) continue;
                                    dv = this.MontanariMap1D[pos + cw.Pos] + (float)cw.Wd;
                                    if (dv < mini) {
                                        mini = dv;
                                    }
                                    cw = null;
                                }
                                this.MontanariMap1D[pos] = mini;
                            }
                            --x;
                            --pos;
                        }
                    }
                }
                bb = null;
                break;
            }
            case 16: {
                float dv;
                int dz;
                int dy;
                int dx;
                CoordinatesWeighted cw;
                int k;
                float mini;
                int x;
                int y;
                int z;
                short[] sb = source.getDataBufferShort(0);
                ArrayComparator.CompareUnsigned((short[])sb, (String)"!=", (int)0, (float)Float.MAX_VALUE, (float)0.0f, (float[])this.MontanariMap1D);
                coordinates = this.se.getForward();
                int pos = 0;
                for (z = 0; z < source.SizeZ; ++z) {
                    for (y = 0; y < source.SizeY; ++y) {
                        x = 0;
                        while (x < source.SizeX) {
                            if (sb[pos] != 0) {
                                mini = this.MontanariMap1D[pos];
                                for (k = 0; k < coordinates.length; ++k) {
                                    cw = coordinates[k];
                                    dx = x + cw.X;
                                    if (dx < 0 || source.SizeX <= dx || (dy = y + cw.Y) < 0 || source.SizeY <= dy || (dz = z + cw.Z) < 0 || source.SizeZ <= dz) continue;
                                    dv = this.MontanariMap1D[pos + cw.Pos] + (float)cw.Wd;
                                    if (dv < mini) {
                                        mini = dv;
                                    }
                                    cw = null;
                                }
                                this.MontanariMap1D[pos] = mini;
                            }
                            ++x;
                            ++pos;
                        }
                    }
                }
                coordinates = this.se.getBackward();
                pos = source.Length - 1;
                for (z = source.SizeZ - 1; z >= 0; --z) {
                    for (y = source.SizeY - 1; y >= 0; --y) {
                        x = source.SizeX - 1;
                        while (x >= 0) {
                            if (sb[pos] != 0) {
                                mini = this.MontanariMap1D[pos];
                                for (k = 0; k < coordinates.length; ++k) {
                                    cw = coordinates[k];
                                    dx = x + cw.X;
                                    if (dx < 0 || source.SizeX <= dx || (dy = y + cw.Y) < 0 || source.SizeY <= dy || (dz = z + cw.Z) < 0 || source.SizeZ <= dz) continue;
                                    dv = this.MontanariMap1D[pos + cw.Pos] + (float)cw.Wd;
                                    if (dv < mini) {
                                        mini = dv;
                                    }
                                    cw = null;
                                }
                                this.MontanariMap1D[pos] = mini;
                            }
                            --x;
                            --pos;
                        }
                    }
                }
                sb = null;
                break;
            }
            case 32: {
                float dv;
                int dz;
                int dy;
                int dx;
                CoordinatesWeighted cw;
                int k;
                float mini;
                int x;
                int y;
                int z;
                int[] ib = source.getDataBufferInt(0);
                ArrayComparator.Compare((int[])ib, (String)"!=", (int)0, (float)Float.MAX_VALUE, (float)0.0f, (float[])this.MontanariMap1D);
                coordinates = this.se.getForward();
                int pos = 0;
                for (z = 0; z < source.SizeZ; ++z) {
                    for (y = 0; y < source.SizeY; ++y) {
                        x = 0;
                        while (x < source.SizeX) {
                            if (ib[pos] != 0) {
                                mini = this.MontanariMap1D[pos];
                                for (k = 0; k < coordinates.length; ++k) {
                                    cw = coordinates[k];
                                    dx = x + cw.X;
                                    if (dx < 0 || source.SizeX <= dx || (dy = y + cw.Y) < 0 || source.SizeY <= dy || (dz = z + cw.Z) < 0 || source.SizeZ <= dz) continue;
                                    dv = this.MontanariMap1D[pos + cw.Pos] + (float)cw.Wd;
                                    if (dv < mini) {
                                        mini = dv;
                                    }
                                    cw = null;
                                }
                                this.MontanariMap1D[pos] = mini;
                            }
                            ++x;
                            ++pos;
                        }
                    }
                }
                coordinates = this.se.getBackward();
                pos = source.Length - 1;
                for (z = source.SizeZ - 1; z >= 0; --z) {
                    for (y = source.SizeY - 1; y >= 0; --y) {
                        x = source.SizeX - 1;
                        while (x >= 0) {
                            if (ib[pos] != 0) {
                                mini = this.MontanariMap1D[pos];
                                for (k = 0; k < coordinates.length; ++k) {
                                    cw = coordinates[k];
                                    dx = x + cw.X;
                                    if (dx < 0 || source.SizeX <= dx || (dy = y + cw.Y) < 0 || source.SizeY <= dy || (dz = z + cw.Z) < 0 || source.SizeZ <= dz) continue;
                                    dv = this.MontanariMap1D[pos + cw.Pos] + (float)cw.Wd;
                                    if (dv < mini) {
                                        mini = dv;
                                    }
                                    cw = null;
                                }
                                this.MontanariMap1D[pos] = mini;
                            }
                            --x;
                            --pos;
                        }
                    }
                }
                ib = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
    }

    public void ComputeStartingPoint(DV source, StructuringElement3D se, Coordinates point) {
        ArrayList<Coordinates> ListeIn = new ArrayList<Coordinates>(1);
        ListeIn.add(point);
        this.ComputeStartingPoints(source, se, ListeIn);
        ListeIn.clear();
        ListeIn = null;
    }

    public void ComputeStartingPoints(DV source, StructuringElement3D se, List<Coordinates> ListeIn) {
        this.se = se;
        switch (se.getType()) {
            case -15: {
                this.ComputeStartingPointsMontanari(source, ListeIn);
                break;
            }
            default: {
                throw new IllegalArgumentException("The structuring element must be of type MONTANARI.");
            }
        }
    }

    private void ComputeStartingPointsMontanari(DV source, List<Coordinates> ListeIn) {
        CoordinatesWeighted[] sec = this.se.getSE();
        Iterator<Coordinates> Iter = null;
        Coordinates point2 = null;
        if (this.MontanariMap1D == null || this.MontanariMap1D.length != source.Length) {
            this.MontanariMap1D = null;
            this.MontanariMap1D = new float[source.Length];
        }
        if (this.fifo == null) {
            this.fifo = new Queue();
        }
        this.fifo.clear();
        this.se.PreComputePositions(source.SizeX, source.SizeY);
        switch (source.Type) {
            case 8: {
                ArrayComparator.CompareUnsigned((byte[])source.getDataBufferByte(0), (String)"!=", (int)0, (float)Float.MAX_VALUE, (float)-1.0f, (float[])this.MontanariMap1D);
                break;
            }
            case 16: {
                ArrayComparator.CompareUnsigned((short[])source.getDataBufferShort(0), (String)"!=", (int)0, (float)Float.MAX_VALUE, (float)-1.0f, (float[])this.MontanariMap1D);
                break;
            }
            case 32: {
                ArrayComparator.Compare((int[])source.getDataBufferInt(0), (String)"!=", (int)0, (float)Float.MAX_VALUE, (float)-1.0f, (float[])this.MontanariMap1D);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        for (Coordinates point2 : ListeIn) {
            int pos = source.Position(point2.X, point2.Y, point2.Z);
            this.MontanariMap1D[pos] = 0.0f;
            this.fifo.Push(new Coordinates(point2.X, point2.Y, point2.Z, pos));
            point2 = null;
        }
        Iter = null;
        switch (source.Type) {
            case 8: {
                byte[] bb = source.getDataBufferByte(0);
                do {
                    point2 = this.fifo.FrontPop();
                    int x = point2.X;
                    int y = point2.Y;
                    int z = point2.Z;
                    int pos = point2.Pos;
                    point2 = null;
                    for (int k = 0; k < sec.length; ++k) {
                        int dp;
                        int dz;
                        int dy;
                        CoordinatesWeighted cw = sec[k];
                        int dx = x + cw.X;
                        if (dx < 0 || source.SizeX <= dx || (dy = y + cw.Y) < 0 || source.SizeY <= dy || (dz = z + cw.Z) < 0 || source.SizeZ <= dz || bb[dp = pos + cw.Pos] == 0) continue;
                        float dv = this.MontanariMap1D[pos] + (float)cw.Wd;
                        if (dv < this.MontanariMap1D[dp]) {
                            this.MontanariMap1D[dp] = dv;
                            this.fifo.Push(new Coordinates(dx, dy, dz, dp));
                        }
                        cw = null;
                    }
                } while (!this.fifo.isEmpty());
                ArrayComparator.CompareUnsigned((byte[])bb, (String)"!=", (int)0, (float[])this.MontanariMap1D, (float)0.0f, (float[])this.MontanariMap1D);
                bb = null;
                break;
            }
            case 16: {
                short[] sb = source.getDataBufferShort(0);
                do {
                    point2 = this.fifo.FrontPop();
                    int x = point2.X;
                    int y = point2.Y;
                    int z = point2.Z;
                    int pos = point2.Pos;
                    point2 = null;
                    for (int k = 0; k < sec.length; ++k) {
                        int dp;
                        int dz;
                        int dy;
                        CoordinatesWeighted cw = sec[k];
                        int dx = x + cw.X;
                        if (dx < 0 || source.SizeX <= dx || (dy = y + cw.Y) < 0 || source.SizeY <= dy || (dz = z + cw.Z) < 0 || source.SizeZ <= dz || sb[dp = pos + cw.Pos] == 0) continue;
                        float dv = this.MontanariMap1D[pos] + (float)cw.Wd;
                        if (dv < this.MontanariMap1D[dp]) {
                            this.MontanariMap1D[dp] = dv;
                            this.fifo.Push(new Coordinates(dx, dy, dz, dp));
                        }
                        cw = null;
                    }
                } while (!this.fifo.isEmpty());
                ArrayComparator.CompareUnsigned((short[])sb, (String)"!=", (int)0, (float[])this.MontanariMap1D, (float)0.0f, (float[])this.MontanariMap1D);
                sb = null;
                break;
            }
            case 32: {
                int[] ib = source.getDataBufferInt(0);
                do {
                    point2 = this.fifo.FrontPop();
                    int x = point2.X;
                    int y = point2.Y;
                    int z = point2.Z;
                    int pos = point2.Pos;
                    point2 = null;
                    for (int k = 0; k < sec.length; ++k) {
                        int dp;
                        int dz;
                        int dy;
                        CoordinatesWeighted cw = sec[k];
                        int dx = x + cw.X;
                        if (dx < 0 || source.SizeX <= dx || (dy = y + cw.Y) < 0 || source.SizeY <= dy || (dz = z + cw.Z) < 0 || source.SizeZ <= dz || ib[dp = pos + cw.Pos] == 0) continue;
                        float dv = this.MontanariMap1D[pos] + (float)cw.Wd;
                        if (dv < this.MontanariMap1D[dp]) {
                            this.MontanariMap1D[dp] = dv;
                            this.fifo.Push(new Coordinates(dx, dy, dz, dp));
                        }
                        cw = null;
                    }
                } while (!this.fifo.isEmpty());
                ArrayComparator.Compare((int[])ib, (String)"!=", (int)0, (float[])this.MontanariMap1D, (float)0.0f, (float[])this.MontanariMap1D);
                ib = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        sec = null;
    }

    public float[] MontanariMap1D() {
        return this.MontanariMap1D;
    }
}

