/*
 * Decompiled with CFR 0.152.
 */
package measures.hedgehop;

import measures.hedgehop.Mask;

public class Distance {
    public Mask[] Base = null;
    public Mask[] mask = null;
    public Mask[] halfmask = null;
    private int Dimension = 0;
    private boolean Chamfer = true;
    private boolean Norm;
    private String name = null;

    public void AllouerBase(int taille) {
        this.AllouerBase(taille, this.Dimension);
    }

    public void AllouerBase(int taille, int Dimension2) {
        if (taille < 1) {
            throw new Error("Taille incorrecte : " + taille);
        }
        this.setDimension(Dimension2);
        this.Base = new Mask[taille];
        for (int i2 = 0; i2 < taille; ++i2) {
            this.Base[i2] = new Mask(Dimension2);
        }
    }

    public void AllouerMasques() {
        switch (this.Dimension) {
            case 2: {
                int i2;
                this.halfmask = new Mask[4 * this.Base.length - 3];
                for (i2 = 0; i2 < this.halfmask.length; ++i2) {
                    this.halfmask[i2] = new Mask(2);
                }
                this.mask = new Mask[2 * this.halfmask.length - 2];
                for (i2 = 0; i2 < this.mask.length; ++i2) {
                    this.mask[i2] = new Mask(2);
                }
                break;
            }
            case 3: {
                this.TrouverTailles();
                break;
            }
            default: {
                throw new Error("Default, Dimension incorrecte : " + this.Dimension);
            }
        }
    }

    private void TrouverTailles() {
        int x;
        int y;
        int z;
        int i2;
        double max = Math.max(this.Base[0].vecteur.get(0), Math.max(this.Base[0].vecteur.get(1), this.Base[0].vecteur.get(2)));
        for (i2 = 1; i2 < this.Base.length; ++i2) {
            double distance = Math.max(this.Base[i2].vecteur.get(0), Math.max(this.Base[i2].vecteur.get(1), this.Base[i2].vecteur.get(2)));
            if (!(distance > max)) continue;
            max = distance;
        }
        int Taille = (int)max + 1;
        int size = (Taille << 1) + 1;
        boolean[][][] visible = new boolean[size][size][size];
        for (z = -Taille; z < Taille; ++z) {
            for (y = -Taille; y < Taille; ++y) {
                for (x = -Taille; x < Taille; ++x) {
                    visible[z + Taille][y + Taille][x + Taille] = Math.sqrt(x * x + y * y + z * z) < (double)Taille;
                }
            }
        }
        visible[Taille][Taille][Taille] = false;
        for (z = -Taille; z < Taille; ++z) {
            for (y = -Taille; y < Taille; ++y) {
                for (x = -Taille; x < Taille; ++x) {
                    if (!visible[z + Taille][y + Taille][x + Taille]) continue;
                    i2 = 2;
                    while (i2 * z + Taille < Taille && i2 * y + Taille < Taille && i2 * x + Taille < Taille && i2 * z + Taille >= 0 && i2 * y + Taille >= 0 && i2 * x + Taille >= 0) {
                        visible[i2 * z + Taille][i2 * y + Taille][i2 * x + Taille] = false;
                        ++i2;
                    }
                }
            }
        }
        int nbd = 0;
        int nb = 0;
        for (z = 0; z < size; ++z) {
            for (y = 0; y < size; ++y) {
                for (x = 0; x < size; ++x) {
                    if (!visible[z][y][x]) continue;
                    ++nb;
                    if (z - Taille < 0) continue;
                    ++nbd;
                }
            }
        }
        this.halfmask = new Mask[nbd];
        for (i2 = 0; i2 < nbd; ++i2) {
            this.halfmask[i2] = new Mask(3);
        }
        this.mask = new Mask[nb];
        for (i2 = 0; i2 < nb; ++i2) {
            this.mask[i2] = new Mask(3);
        }
    }

    public void Display() {
        int i2;
        System.out.println("Affichage de la distance : Chamfrein = " + this.Chamfer);
        System.out.println("Base = " + this.Base.length + " vecteurs");
        for (i2 = 0; i2 < this.Base.length; ++i2) {
            this.Base[i2].Afficher();
            System.out.println();
        }
        System.out.println("Masque = " + this.mask.length + " vecteurs");
        for (i2 = 0; i2 < this.mask.length; ++i2) {
            this.mask[i2].Afficher();
            System.out.println();
        }
    }

    public boolean isNorme() {
        return this.Norm;
    }

    public void setNorme(boolean Norm2) {
        this.Norm = Norm2;
    }

    public boolean isChamfer() {
        return this.Chamfer;
    }

    public boolean isMontanari() {
        return !this.Chamfer;
    }

    public void setChamfer(boolean Chamfrein) {
        this.Chamfer = Chamfrein;
    }

    public int getDimension() {
        return this.Dimension;
    }

    public void setDimension(int Dimension2) {
        if (Dimension2 != 2 && Dimension2 != 3) {
            throw new IllegalArgumentException("Dimension different of 2 or 3: " + Dimension2);
        }
        this.Dimension = Dimension2;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }
}

