/*
 * Decompiled with CFR 0.152.
 */
package measures.cclh;

import dv.DV;
import dv.DvNew;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import measures.cclh.ConnectedComponentLabeling;
import processing.filters.Invert;
import utils.memory.Allocator;

public class FillHole {
    private final Allocator allocator = Allocator.Instance();
    private final Invert complementary = new Invert();

    public BufferedImage Fill(BufferedImage image, ConnectedComponentLabeling ccl, int size, boolean EightConnex) {
        BufferedImage result = ImageNew.Same((BufferedImage)image);
        this.Fill(image, ccl, size, EightConnex, result);
        return result;
    }

    public void Fill(BufferedImage image, ConnectedComponentLabeling ccl, int size, boolean EightConnex, BufferedImage result) {
        if (!ImageTools.isGrayLevel((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage comp = ImageNew.Same((BufferedImage)image);
        this.complementary.Filter(image, comp, 0);
        ccl.Label(comp, 0, EightConnex);
        int[] Labels = ccl.Labels1D();
        int[] sizes = ccl.Sizes();
        switch (image.getType()) {
            case 12: {
                WritableRaster wr = comp.getRaster();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (1 < Labels[pos] && sizes[Labels[pos]] < size) {
                            wr.setSample(x, y, 0, 0);
                        }
                        ++x;
                        ++pos;
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bb = ((DataBufferByte)comp.getRaster().getDataBuffer()).getData();
                for (int pos = 0; pos < Labels.length; ++pos) {
                    if (1 >= Labels[pos] || sizes[Labels[pos]] >= size) continue;
                    bb[pos] = 0;
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)comp.getRaster().getDataBuffer()).getData();
                for (int pos = 0; pos < Labels.length; ++pos) {
                    if (1 >= Labels[pos] || sizes[Labels[pos]] >= size) continue;
                    sb[pos] = 0;
                }
                sb = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.complementary.Filter(comp, result, 0);
        sizes = null;
        Labels = null;
        comp = this.allocator.Release(comp);
    }

    public void Fill(DV dv, ConnectedComponentLabeling ccl, int size, boolean TwentySixConnex, DV result) {
        switch (dv.Type) {
            case 8: 
            case 16: 
            case 32: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Float and Double encodings are not supported.");
            }
        }
        DV comp = DvNew.Same((DV)dv);
        this.complementary.Filter(dv, comp, 0);
        ccl.Label(comp, 0, TwentySixConnex);
        int[] Labels = ccl.Labels1D();
        int[] sizes = ccl.Sizes();
        switch (dv.Type) {
            case 8: {
                byte[] bb = comp.getDataBufferByte(0);
                for (int pos = 0; pos < Labels.length; ++pos) {
                    if (1 >= Labels[pos] || sizes[Labels[pos]] >= size) continue;
                    bb[pos] = 0;
                }
                bb = null;
                break;
            }
            case 16: {
                short[] sb = comp.getDataBufferShort(0);
                for (int pos = 0; pos < Labels.length; ++pos) {
                    if (1 >= Labels[pos] || sizes[Labels[pos]] >= size) continue;
                    sb[pos] = 0;
                }
                sb = null;
                break;
            }
            case 32: {
                int[] ib = comp.getDataBufferInt(0);
                for (int pos = 0; pos < Labels.length; ++pos) {
                    if (1 >= Labels[pos] || sizes[Labels[pos]] >= size) continue;
                    ib[pos] = 0;
                }
                ib = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.complementary.Filter(comp, result, 0);
        comp.Kill();
        comp = null;
        sizes = null;
        Labels = null;
    }
}

