/*
 * Decompiled with CFR 0.152.
 */
package measures.cclh;

import arrayTiTi.ArrayFeatures;
import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.SubImage;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mathematics.primitives.pointsTiTi.Coordinates;
import measures.cclh.ConnectedComponentLabeling;
import utils.memory.Allocator;

public class FifoCcl
implements ConnectedComponentLabeling {
    private final Allocator allocator = Allocator.Instance();
    private int Width;
    private int Height;
    private int Depth;
    private int Length = -1;
    private int[] Labels1D = null;
    private int[] Sizes = null;
    private Object Colors = null;
    private int Counter = -1;
    private List<Coordinates> fifo1D = new LinkedList<Coordinates>();
    private List<Coordinates> fifo3D = new LinkedList<Coordinates>();
    private int[] minx;
    private int[] miny;
    private int[] maxx;
    private int[] maxy;
    private ArrayFeatures AF = new ArrayFeatures();

    public void Kill() {
        this.fifo1D.clear();
        this.fifo3D.clear();
        this.fifo3D = null;
        this.fifo1D = null;
        this.Sizes = this.allocator.Release(this.Sizes);
        this.Colors = null;
        this.Labels1D = this.allocator.Release(this.Labels1D);
        this.AF = null;
    }

    public void ImportLabels(BufferedImage Original) {
        switch (Original.getRaster().getDataBuffer().getDataType()) {
            case 0: {
                this.ImportLabels(((DataBufferByte)Original.getRaster().getDataBuffer()).getData(), Original.getWidth(), Original.getHeight());
                break;
            }
            case 1: {
                this.ImportLabels(((DataBufferUShort)Original.getRaster().getDataBuffer()).getData(), Original.getWidth(), Original.getHeight());
                break;
            }
            case 3: {
                this.ImportLabels(((DataBufferInt)Original.getRaster().getDataBuffer()).getData(), Original.getWidth(), Original.getHeight());
                break;
            }
            default: {
                throw new IllegalArgumentException("DataBuffer encoding not supported.");
            }
        }
    }

    public void ImportLabels(byte[] Labels, int Width, int Height) {
        this.ImportLabels(Labels, Width, Height, 1);
    }

    public void ImportLabels(byte[] Labels, int Width, int Height, int Depth) {
        int i2;
        this.Width = Width;
        this.Height = Height;
        this.Depth = Depth;
        this.Length = Labels.length;
        this.maxy = null;
        this.maxx = null;
        this.miny = null;
        this.minx = null;
        if (this.Labels1D == null || this.Labels1D.length != this.Length) {
            this.Labels1D = this.allocator.Release(this.Labels1D);
            this.Labels1D = this.allocator.newIntArray(this.Length);
        }
        for (i2 = 0; i2 < this.Length; ++i2) {
            this.Labels1D[i2] = Labels[i2] & 0xFF;
        }
        this.Counter = this.AF.Maximum(Labels);
        if (this.Sizes == null || this.Counter + 1 != this.Sizes.length) {
            this.Sizes = this.allocator.Release(this.Sizes);
            this.Sizes = this.allocator.newIntArray(this.Counter + 1);
        }
        Arrays.fill(this.Sizes, 0);
        for (i2 = 0; i2 < this.Length; ++i2) {
            int n = this.Labels1D[i2];
            this.Sizes[n] = this.Sizes[n] + 1;
        }
    }

    public void ImportLabels(short[] Labels, int Width, int Height) {
        this.ImportLabels(Labels, Width, Height, 1);
    }

    public void ImportLabels(short[] Labels, int Width, int Height, int Depth) {
        int i2;
        this.Width = Width;
        this.Height = Height;
        this.Depth = Depth;
        this.Length = Labels.length;
        this.maxy = null;
        this.maxx = null;
        this.miny = null;
        this.minx = null;
        if (this.Labels1D == null || this.Labels1D.length != this.Length) {
            this.Labels1D = this.allocator.Release(this.Labels1D);
            this.Labels1D = this.allocator.newIntArray(this.Length);
        }
        for (i2 = 0; i2 < this.Length; ++i2) {
            this.Labels1D[i2] = Labels[i2] & 0xFFFF;
        }
        this.Counter = this.AF.Maximum(Labels);
        if (this.Sizes == null || this.Counter + 1 != this.Sizes.length) {
            this.Sizes = this.allocator.Release(this.Sizes);
            this.Sizes = this.allocator.newIntArray(this.Counter + 1);
        }
        Arrays.fill(this.Sizes, 0);
        for (i2 = 0; i2 < this.Length; ++i2) {
            int n = this.Labels1D[i2];
            this.Sizes[n] = this.Sizes[n] + 1;
        }
    }

    public void ImportLabels(int[] Labels, int Width, int Height) {
        this.ImportLabels(Labels, Width, Height, 1);
    }

    public void ImportLabels(int[] Labels, int Width, int Height, int Depth) {
        this.Width = Width;
        this.Height = Height;
        this.Depth = Depth;
        this.Length = Labels.length;
        this.maxy = null;
        this.maxx = null;
        this.miny = null;
        this.minx = null;
        if (this.Labels1D == null || this.Labels1D.length != this.Length) {
            this.Labels1D = this.allocator.Release(this.Labels1D);
            this.Labels1D = this.allocator.newIntArray(this.Length);
        }
        System.arraycopy(Labels, 0, this.Labels1D, 0, this.Length);
        this.Counter = this.AF.Maximum(Labels);
        if (this.Sizes == null || this.Counter + 1 != this.Sizes.length) {
            this.Sizes = this.allocator.Release(this.Sizes);
            this.Sizes = this.allocator.newIntArray(this.Counter + 1);
        } else {
            Arrays.fill(this.Sizes, 0);
        }
        for (int i2 = 0; i2 < this.Length; ++i2) {
            int n = this.Labels1D[i2];
            this.Sizes[n] = this.Sizes[n] + 1;
        }
    }

    public int Label(BufferedImage Original, int ForbiddenValue, boolean EightConnex) {
        this.Height = Original.getHeight();
        this.Width = Original.getWidth();
        this.Depth = 1;
        this.Length = this.Width * this.Height;
        if (this.Labels1D == null || this.Length != this.Labels1D.length) {
            this.Labels1D = this.allocator.Release(this.Labels1D);
            this.Labels1D = this.allocator.newIntArray(this.Length);
        }
        Arrays.fill(this.Labels1D, -1);
        this.fifo1D.clear();
        this.Counter = 0;
        switch (Original.getType()) {
            case 10: {
                return this.Label(((DataBufferByte)Original.getRaster().getDataBuffer()).getData(), Original.getWidth(), Original.getHeight(), (byte)ForbiddenValue, EightConnex);
            }
            case 11: {
                return this.Label(((DataBufferUShort)Original.getRaster().getDataBuffer()).getData(), Original.getWidth(), Original.getHeight(), (short)ForbiddenValue, EightConnex);
            }
            case 0: {
                switch (Original.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        return this.Label(((DataBufferInt)Original.getRaster().getDataBuffer()).getData(), Original.getWidth(), Original.getHeight(), ForbiddenValue, EightConnex);
                    }
                }
                throw new IllegalArgumentException("Unsupported DataBuffer type.");
            }
        }
        throw new IllegalArgumentException("Image type not supported (yet).");
    }

    public int Label(int[] Original, int width, int height, int Background, boolean EightConnex) {
        int x;
        if (width * height != Original.length) {
            throw new IllegalArgumentException("Wrong dimensions <=> width * height != Original.length.");
        }
        this.Height = height;
        this.Width = width;
        this.Depth = 1;
        this.Length = Original.length;
        this.maxy = null;
        this.maxx = null;
        this.miny = null;
        this.minx = null;
        if (this.Labels1D == null || this.Length != this.Labels1D.length) {
            this.Labels1D = this.allocator.Release(this.Labels1D);
            this.Labels1D = this.allocator.newIntArray(this.Length);
        }
        this.fifo1D.clear();
        Arrays.fill(this.Labels1D, -1);
        this.Counter = 0;
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (this.Labels1D[pos] == -1) {
                    if (Original[pos] == Background) {
                        this.Labels1D[pos] = 0;
                    } else {
                        ++this.Counter;
                        this.Mark1D(x, y, pos, this.Counter);
                        int Color2 = Original[pos];
                        int X = x;
                        int Y = y;
                        do {
                            Coordinates c = this.fifo1D.remove(0);
                            x = c.X;
                            y = c.Y;
                            int p = y * width + x;
                            int pp = p - width;
                            if (y - 1 >= 0 && this.Labels1D[pp] == -1 && Original[pp] == Color2) {
                                this.Mark1D(x, y - 1, pp, this.Counter);
                            }
                            pp = p + width;
                            if (y + 1 < height && this.Labels1D[pp] == -1 && Original[pp] == Color2) {
                                this.Mark1D(x, y + 1, pp, this.Counter);
                            }
                            pp = p - 1;
                            if (x - 1 >= 0 && this.Labels1D[pp] == -1 && Original[pp] == Color2) {
                                this.Mark1D(x - 1, y, pp, this.Counter);
                            }
                            pp = p + 1;
                            if (x + 1 < width && this.Labels1D[pp] == -1 && Original[pp] == Color2) {
                                this.Mark1D(x + 1, y, pp, this.Counter);
                            }
                            if (EightConnex) {
                                pp = p - width - 1;
                                if (y - 1 >= 0 && x - 1 >= 0 && this.Labels1D[pp] == -1 && Original[pp] == Color2) {
                                    this.Mark1D(x - 1, y - 1, pp, this.Counter);
                                }
                                pp = p - width + 1;
                                if (y - 1 >= 0 && x + 1 < width && this.Labels1D[pp] == -1 && Original[pp] == Color2) {
                                    this.Mark1D(x + 1, y - 1, pp, this.Counter);
                                }
                                pp = p + width - 1;
                                if (y + 1 < height && x - 1 >= 0 && this.Labels1D[pp] == -1 && Original[pp] == Color2) {
                                    this.Mark1D(x - 1, y + 1, pp, this.Counter);
                                }
                                pp = p + width + 1;
                                if (y + 1 < height && x + 1 < width && this.Labels1D[pp] == -1 && Original[pp] == Color2) {
                                    this.Mark1D(x + 1, y + 1, pp, this.Counter);
                                }
                            }
                            c = null;
                        } while (!this.fifo1D.isEmpty());
                        x = X;
                        y = Y;
                    }
                }
                ++x;
                ++pos;
            }
        }
        if (this.Sizes == null || this.Counter + 1 != this.Sizes.length) {
            this.Sizes = this.allocator.Release(this.Sizes);
            this.Sizes = this.allocator.newIntArray(this.Counter + 1);
            this.Colors = null;
            this.Colors = new int[this.Counter + 1];
        } else {
            Arrays.fill(this.Sizes, 0);
        }
        int[] colors = (int[])this.Colors;
        for (pos = 0; pos < Original.length; ++pos) {
            int n = x = this.Labels1D[pos];
            this.Sizes[n] = this.Sizes[n] + 1;
            colors[x] = Original[pos];
        }
        colors = null;
        return this.Counter;
    }

    public int Label(byte[] Original, int width, int height, byte Background, boolean EightConnex) {
        int x;
        if (width * height != Original.length) {
            throw new IllegalArgumentException("Wrong dimensions <=> width * height != Original.length.");
        }
        this.Height = height;
        this.Width = width;
        this.Depth = 1;
        this.Length = Original.length;
        this.maxy = null;
        this.maxx = null;
        this.miny = null;
        this.minx = null;
        if (this.Labels1D == null || this.Length != this.Labels1D.length) {
            this.Labels1D = this.allocator.Release(this.Labels1D);
            this.Labels1D = this.allocator.newIntArray(this.Length);
        }
        this.fifo1D.clear();
        Arrays.fill(this.Labels1D, -1);
        this.Counter = 0;
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (this.Labels1D[pos] == -1) {
                    if (Original[pos] == Background) {
                        this.Labels1D[pos] = 0;
                    } else {
                        ++this.Counter;
                        this.Mark1D(x, y, pos, this.Counter);
                        int Color2 = Original[pos] & 0xFF;
                        int X = x;
                        int Y = y;
                        do {
                            Coordinates c = this.fifo1D.remove(0);
                            x = c.X;
                            y = c.Y;
                            int p = y * width + x;
                            int pp = p - width;
                            if (y - 1 >= 0 && this.Labels1D[pp] == -1 && (Original[pp] & 0xFF) == Color2) {
                                this.Mark1D(x, y - 1, pp, this.Counter);
                            }
                            pp = p + width;
                            if (y + 1 < height && this.Labels1D[pp] == -1 && (Original[pp] & 0xFF) == Color2) {
                                this.Mark1D(x, y + 1, pp, this.Counter);
                            }
                            pp = p - 1;
                            if (x - 1 >= 0 && this.Labels1D[pp] == -1 && (Original[pp] & 0xFF) == Color2) {
                                this.Mark1D(x - 1, y, pp, this.Counter);
                            }
                            pp = p + 1;
                            if (x + 1 < width && this.Labels1D[pp] == -1 && (Original[pp] & 0xFF) == Color2) {
                                this.Mark1D(x + 1, y, pp, this.Counter);
                            }
                            if (EightConnex) {
                                pp = p - width - 1;
                                if (y - 1 >= 0 && x - 1 >= 0 && this.Labels1D[pp] == -1 && (Original[pp] & 0xFF) == Color2) {
                                    this.Mark1D(x - 1, y - 1, pp, this.Counter);
                                }
                                pp = p - width + 1;
                                if (y - 1 >= 0 && x + 1 < width && this.Labels1D[pp] == -1 && (Original[pp] & 0xFF) == Color2) {
                                    this.Mark1D(x + 1, y - 1, pp, this.Counter);
                                }
                                pp = p + width - 1;
                                if (y + 1 < height && x - 1 >= 0 && this.Labels1D[pp] == -1 && (Original[pp] & 0xFF) == Color2) {
                                    this.Mark1D(x - 1, y + 1, pp, this.Counter);
                                }
                                pp = p + width + 1;
                                if (y + 1 < height && x + 1 < width && this.Labels1D[pp] == -1 && (Original[pp] & 0xFF) == Color2) {
                                    this.Mark1D(x + 1, y + 1, pp, this.Counter);
                                }
                            }
                            c = null;
                        } while (!this.fifo1D.isEmpty());
                        x = X;
                        y = Y;
                    }
                }
                ++x;
                ++pos;
            }
        }
        if (this.Sizes == null || this.Counter + 1 != this.Sizes.length) {
            this.Sizes = this.allocator.Release(this.Sizes);
            this.Sizes = this.allocator.newIntArray(this.Counter + 1);
            this.Colors = null;
            this.Colors = new byte[this.Counter + 1];
        } else {
            Arrays.fill(this.Sizes, 0);
        }
        byte[] colors = (byte[])this.Colors;
        for (pos = 0; pos < Original.length; ++pos) {
            int n = x = this.Labels1D[pos];
            this.Sizes[n] = this.Sizes[n] + 1;
            colors[x] = Original[pos];
        }
        return this.Counter;
    }

    public int Label(short[] Original, int width, int height, short Background, boolean EightConnex) {
        int x;
        if (width * height != Original.length) {
            throw new IllegalArgumentException("Wrong dimensions <=> width * height != Original.length.");
        }
        this.Height = height;
        this.Width = width;
        this.Depth = 1;
        this.Length = Original.length;
        this.maxy = null;
        this.maxx = null;
        this.miny = null;
        this.minx = null;
        if (this.Labels1D == null || this.Length != this.Labels1D.length) {
            this.Labels1D = this.allocator.Release(this.Labels1D);
            this.Labels1D = this.allocator.newIntArray(this.Length);
        }
        this.fifo1D.clear();
        Arrays.fill(this.Labels1D, -1);
        this.Counter = 0;
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (this.Labels1D[pos] == -1) {
                    if (Original[pos] == Background) {
                        this.Labels1D[pos] = 0;
                    } else {
                        ++this.Counter;
                        this.Mark1D(x, y, pos, this.Counter);
                        int Color2 = Original[pos] & 0xFFFF;
                        int X = x;
                        int Y = y;
                        do {
                            Coordinates c = this.fifo1D.remove(0);
                            x = c.X;
                            y = c.Y;
                            int p = y * width + x;
                            int pp = p - width;
                            if (y - 1 >= 0 && this.Labels1D[pp] == -1 && (Original[pp] & 0xFFFF) == Color2) {
                                this.Mark1D(x, y - 1, pp, this.Counter);
                            }
                            pp = p + width;
                            if (y + 1 < height && this.Labels1D[pp] == -1 && (Original[pp] & 0xFFFF) == Color2) {
                                this.Mark1D(x, y + 1, pp, this.Counter);
                            }
                            pp = p - 1;
                            if (x - 1 >= 0 && this.Labels1D[pp] == -1 && (Original[pp] & 0xFFFF) == Color2) {
                                this.Mark1D(x - 1, y, pp, this.Counter);
                            }
                            pp = p + 1;
                            if (x + 1 < width && this.Labels1D[pp] == -1 && (Original[pp] & 0xFFFF) == Color2) {
                                this.Mark1D(x + 1, y, pp, this.Counter);
                            }
                            if (EightConnex) {
                                pp = p - width - 1;
                                if (y - 1 >= 0 && x - 1 >= 0 && this.Labels1D[pp] == -1 && (Original[pp] & 0xFFFF) == Color2) {
                                    this.Mark1D(x - 1, y - 1, pp, this.Counter);
                                }
                                pp = p - width + 1;
                                if (y - 1 >= 0 && x + 1 < width && this.Labels1D[pp] == -1 && (Original[pp] & 0xFFFF) == Color2) {
                                    this.Mark1D(x + 1, y - 1, pp, this.Counter);
                                }
                                pp = p + width - 1;
                                if (y + 1 < height && x - 1 >= 0 && this.Labels1D[pp] == -1 && (Original[pp] & 0xFFFF) == Color2) {
                                    this.Mark1D(x - 1, y + 1, pp, this.Counter);
                                }
                                pp = p + width + 1;
                                if (y + 1 < height && x + 1 < width && this.Labels1D[pp] == -1 && (Original[pp] & 0xFFFF) == Color2) {
                                    this.Mark1D(x + 1, y + 1, pp, this.Counter);
                                }
                            }
                            c = null;
                        } while (!this.fifo1D.isEmpty());
                        x = X;
                        y = Y;
                    }
                }
                ++x;
                ++pos;
            }
        }
        if (this.Sizes == null || this.Counter + 1 != this.Sizes.length) {
            this.Sizes = this.allocator.Release(this.Sizes);
            this.Sizes = this.allocator.newIntArray(this.Counter + 1);
            this.Colors = null;
            this.Colors = new short[this.Counter + 1];
        } else {
            Arrays.fill(this.Sizes, 0);
        }
        short[] colors = (short[])this.Colors;
        for (pos = 0; pos < Original.length; ++pos) {
            int n = x = this.Labels1D[pos];
            this.Sizes[n] = this.Sizes[n] + 1;
            colors[x] = Original[pos];
        }
        return this.Counter;
    }

    public int Label(DV Original, int Background, boolean TwentySixConnex) {
        if (Original.Channel != 1) {
            throw new IllegalArgumentException("DV with multiple channels => Not supported.");
        }
        switch (Original.Type) {
            case 8: {
                return this.Label(Original.getDataBufferByte(0), Original.SizeX, Original.SizeY, Original.SizeZ, (byte)Background, TwentySixConnex);
            }
            case 16: {
                return this.Label(Original.getDataBufferShort(0), Original.SizeX, Original.SizeY, Original.SizeZ, (short)Background, TwentySixConnex);
            }
            case 32: {
                return this.Label(Original.getDataBufferInt(0), Original.SizeX, Original.SizeY, Original.SizeZ, Background, TwentySixConnex);
            }
        }
        throw new IllegalArgumentException("DV type not supported.");
    }

    public int Label(int[] Original, int width, int height, int depth, int Background, boolean TwentySixConnex) {
        if (width * height * depth != Original.length) {
            throw new IllegalArgumentException("Wrong given dimensions <=> width * height * depth != Original.length.");
        }
        this.Height = height;
        this.Width = width;
        this.Depth = depth;
        this.Length = Original.length;
        int zpm1 = height * width;
        this.maxy = null;
        this.maxx = null;
        this.miny = null;
        this.minx = null;
        if (this.Labels1D == null || Original.length != this.Labels1D.length) {
            this.Labels1D = this.allocator.Release(this.Labels1D);
            this.Labels1D = this.allocator.newIntArray(this.Length);
        }
        this.fifo3D.clear();
        Arrays.fill(this.Labels1D, -1);
        this.Counter = 0;
        int pos = 0;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    if (this.Labels1D[pos] == -1) {
                        if (Original[pos] == Background) {
                            this.Labels1D[pos] = 0;
                        } else {
                            ++this.Counter;
                            this.Mark3D(x, y, z, pos, this.Counter);
                            int Color2 = Original[pos];
                            int X = x;
                            int Y = y;
                            int Z = z;
                            int POS = pos;
                            do {
                                Coordinates c = this.fifo3D.get(0);
                                x = c.X;
                                y = c.Y;
                                z = c.Z;
                                pos = c.Pos;
                                this.fifo3D.remove(0);
                                int p = pos - zpm1;
                                if (z - 1 >= 0 && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x, y, z - 1, p, this.Counter);
                                }
                                p = pos + zpm1;
                                if (z + 1 < depth && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x, y, z + 1, p, this.Counter);
                                }
                                p = pos - width;
                                if (y - 1 >= 0 && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x, y - 1, z, p, this.Counter);
                                }
                                p = pos + width;
                                if (y + 1 < height && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x, y + 1, z, p, this.Counter);
                                }
                                p = pos - 1;
                                if (x - 1 >= 0 && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x - 1, y, z, p, this.Counter);
                                }
                                p = pos + 1;
                                if (x + 1 < width && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x + 1, y, z, p, this.Counter);
                                }
                                if (!TwentySixConnex) continue;
                                p = pos - zpm1 - width - 1;
                                if (z - 1 >= 0 && y - 1 >= 0 && x - 1 >= 0 && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x - 1, y - 1, z - 1, p, this.Counter);
                                }
                                p = pos - zpm1 - width;
                                if (z - 1 >= 0 && y - 1 >= 0 && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x, y - 1, z - 1, p, this.Counter);
                                }
                                p = pos - zpm1 - width + 1;
                                if (z - 1 >= 0 && y - 1 >= 0 && x + 1 < width && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x + 1, y - 1, z - 1, p, this.Counter);
                                }
                                p = pos - zpm1 - 1;
                                if (z - 1 >= 0 && x - 1 >= 0 && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x - 1, y, z - 1, p, this.Counter);
                                }
                                p = pos - zpm1 + 1;
                                if (z - 1 >= 0 && x + 1 < width && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x + 1, y, z - 1, p, this.Counter);
                                }
                                p = pos - zpm1 + width - 1;
                                if (z - 1 >= 0 && y + 1 < height && x - 1 >= 0 && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x - 1, y + 1, z - 1, p, this.Counter);
                                }
                                p = pos - zpm1 + width;
                                if (z - 1 >= 0 && y + 1 < height && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x, y + 1, z - 1, p, this.Counter);
                                }
                                p = pos - zpm1 + width + 1;
                                if (z - 1 >= 0 && y + 1 < height && x + 1 < width && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x + 1, y + 1, z - 1, p, this.Counter);
                                }
                                p = pos - width - 1;
                                if (y - 1 >= 0 && x - 1 >= 0 && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x - 1, y - 1, z, p, this.Counter);
                                }
                                p = pos - width + 1;
                                if (y - 1 >= 0 && x + 1 < width && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x + 1, y - 1, z, p, this.Counter);
                                }
                                p = pos + width - 1;
                                if (y + 1 < height && x - 1 >= 0 && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x - 1, y + 1, z, p, this.Counter);
                                }
                                p = pos + width + 1;
                                if (y + 1 < height && x + 1 < width && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x + 1, y + 1, z, p, this.Counter);
                                }
                                p = pos + zpm1 - width - 1;
                                if (z + 1 < depth && y - 1 >= 0 && x - 1 >= 0 && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x - 1, y - 1, z + 1, p, this.Counter);
                                }
                                p = pos + zpm1 - width;
                                if (z + 1 < depth && y - 1 >= 0 && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x, y - 1, z + 1, p, this.Counter);
                                }
                                p = pos + zpm1 - width + 1;
                                if (z + 1 < depth && y - 1 >= 0 && x + 1 < width && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x + 1, y - 1, z + 1, p, this.Counter);
                                }
                                p = pos + zpm1 - 1;
                                if (z + 1 < depth && x - 1 >= 0 && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x - 1, y, z + 1, p, this.Counter);
                                }
                                p = pos + zpm1 + 1;
                                if (z + 1 < depth && x + 1 < width && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x + 1, y, z + 1, p, this.Counter);
                                }
                                p = pos + zpm1 + width - 1;
                                if (z + 1 < depth && y + 1 < height && x - 1 >= 0 && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x - 1, y + 1, z + 1, p, this.Counter);
                                }
                                p = pos + zpm1 + width;
                                if (z + 1 < depth && y + 1 < height && this.Labels1D[p] == -1 && Original[p] == Color2) {
                                    this.Mark3D(x, y + 1, z + 1, p, this.Counter);
                                }
                                p = pos + zpm1 + width + 1;
                                if (z + 1 >= depth || y + 1 >= height || x + 1 >= width || this.Labels1D[p] != -1 || Original[p] != Color2) continue;
                                this.Mark3D(x + 1, y + 1, z + 1, p, this.Counter);
                            } while (!this.fifo3D.isEmpty());
                            x = X;
                            y = Y;
                            z = Z;
                            pos = POS;
                        }
                    }
                    ++x;
                    ++pos;
                }
            }
        }
        if (this.Sizes == null || this.Sizes.length != this.Counter + 1) {
            this.Colors = null;
            this.Colors = new int[this.Counter + 1];
            this.Sizes = this.allocator.Release(this.Sizes);
            this.Sizes = this.allocator.newIntArray(this.Counter + 1);
        } else {
            Arrays.fill(this.Sizes, 0);
        }
        int[] colors = (int[])this.Colors;
        for (pos = 0; pos < this.Labels1D.length; ++pos) {
            int x;
            int n = x = this.Labels1D[pos];
            this.Sizes[n] = this.Sizes[n] + 1;
            colors[x] = Original[pos];
        }
        colors = null;
        return this.Counter;
    }

    public int Label(byte[] Original, int width, int height, int depth, byte Background, boolean TwentySixConnex) {
        if (width * height * depth != Original.length) {
            throw new IllegalArgumentException("Wrong given dimensions <=> width * height * depth != Original.length.");
        }
        this.Height = height;
        this.Width = width;
        this.Depth = depth;
        this.Length = Original.length;
        int zpm1 = height * width;
        this.maxy = null;
        this.maxx = null;
        this.miny = null;
        this.minx = null;
        if (this.Labels1D == null || Original.length != this.Labels1D.length) {
            this.Labels1D = this.allocator.Release(this.Labels1D);
            this.Labels1D = this.allocator.newIntArray(this.Length);
        }
        this.fifo3D.clear();
        Arrays.fill(this.Labels1D, -1);
        this.Counter = 0;
        int pos = 0;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    if (this.Labels1D[pos] == -1) {
                        if (Original[pos] == Background) {
                            this.Labels1D[pos] = 0;
                        } else {
                            ++this.Counter;
                            this.Mark3D(x, y, z, pos, this.Counter);
                            int Color2 = Original[pos] & 0xFF;
                            int X = x;
                            int Y = y;
                            int Z = z;
                            int POS = pos;
                            do {
                                Coordinates c = this.fifo3D.get(0);
                                x = c.X;
                                y = c.Y;
                                z = c.Z;
                                pos = c.Pos;
                                this.fifo3D.remove(0);
                                int p = pos - zpm1;
                                if (z - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x, y, z - 1, p, this.Counter);
                                }
                                p = pos + zpm1;
                                if (z + 1 < depth && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x, y, z + 1, p, this.Counter);
                                }
                                p = pos - width;
                                if (y - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x, y - 1, z, p, this.Counter);
                                }
                                p = pos + width;
                                if (y + 1 < height && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x, y + 1, z, p, this.Counter);
                                }
                                p = pos - 1;
                                if (x - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x - 1, y, z, p, this.Counter);
                                }
                                p = pos + 1;
                                if (x + 1 < width && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x + 1, y, z, p, this.Counter);
                                }
                                if (!TwentySixConnex) continue;
                                p = pos - zpm1 - width - 1;
                                if (z - 1 >= 0 && y - 1 >= 0 && x - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x - 1, y - 1, z - 1, p, this.Counter);
                                }
                                p = pos - zpm1 - width;
                                if (z - 1 >= 0 && y - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x, y - 1, z - 1, p, this.Counter);
                                }
                                p = pos - zpm1 - width + 1;
                                if (z - 1 >= 0 && y - 1 >= 0 && x + 1 < width && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x + 1, y - 1, z - 1, p, this.Counter);
                                }
                                p = pos - zpm1 - 1;
                                if (z - 1 >= 0 && x - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x - 1, y, z - 1, p, this.Counter);
                                }
                                p = pos - zpm1 + 1;
                                if (z - 1 >= 0 && x + 1 < width && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x + 1, y, z - 1, p, this.Counter);
                                }
                                p = pos - zpm1 + width - 1;
                                if (z - 1 >= 0 && y + 1 < height && x - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x - 1, y + 1, z - 1, p, this.Counter);
                                }
                                p = pos - zpm1 + width;
                                if (z - 1 >= 0 && y + 1 < height && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x, y + 1, z - 1, p, this.Counter);
                                }
                                p = pos - zpm1 + width + 1;
                                if (z - 1 >= 0 && y + 1 < height && x + 1 < width && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x + 1, y + 1, z - 1, p, this.Counter);
                                }
                                p = pos - width - 1;
                                if (y - 1 >= 0 && x - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x - 1, y - 1, z, p, this.Counter);
                                }
                                p = pos - width + 1;
                                if (y - 1 >= 0 && x + 1 < width && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x + 1, y - 1, z, p, this.Counter);
                                }
                                p = pos + width - 1;
                                if (y + 1 < height && x - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x - 1, y + 1, z, p, this.Counter);
                                }
                                p = pos + width + 1;
                                if (y + 1 < height && x + 1 < width && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x + 1, y + 1, z, p, this.Counter);
                                }
                                p = pos + zpm1 - width - 1;
                                if (z + 1 < depth && y - 1 >= 0 && x - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x - 1, y - 1, z + 1, p, this.Counter);
                                }
                                p = pos + zpm1 - width;
                                if (z + 1 < depth && y - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x, y - 1, z + 1, p, this.Counter);
                                }
                                p = pos + zpm1 - width + 1;
                                if (z + 1 < depth && y - 1 >= 0 && x + 1 < width && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x + 1, y - 1, z + 1, p, this.Counter);
                                }
                                p = pos + zpm1 - 1;
                                if (z + 1 < depth && x - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x - 1, y, z + 1, p, this.Counter);
                                }
                                p = pos + zpm1 + 1;
                                if (z + 1 < depth && x + 1 < width && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x + 1, y, z + 1, p, this.Counter);
                                }
                                p = pos + zpm1 + width - 1;
                                if (z + 1 < depth && y + 1 < height && x - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x - 1, y + 1, z + 1, p, this.Counter);
                                }
                                p = pos + zpm1 + width;
                                if (z + 1 < depth && y + 1 < height && this.Labels1D[p] == -1 && (Original[p] & 0xFF) == Color2) {
                                    this.Mark3D(x, y + 1, z + 1, p, this.Counter);
                                }
                                p = pos + zpm1 + width + 1;
                                if (z + 1 >= depth || y + 1 >= height || x + 1 >= width || this.Labels1D[p] != -1 || (Original[p] & 0xFF) != Color2) continue;
                                this.Mark3D(x + 1, y + 1, z + 1, p, this.Counter);
                            } while (!this.fifo3D.isEmpty());
                            x = X;
                            y = Y;
                            z = Z;
                            pos = POS;
                        }
                    }
                    ++x;
                    ++pos;
                }
            }
        }
        if (this.Sizes == null || this.Sizes.length != this.Counter + 1) {
            this.Colors = null;
            this.Colors = new byte[this.Counter + 1];
            this.Sizes = this.allocator.Release(this.Sizes);
            this.Sizes = this.allocator.newIntArray(this.Counter + 1);
        } else {
            Arrays.fill(this.Sizes, 0);
        }
        byte[] colors = (byte[])this.Colors;
        for (pos = 0; pos < this.Labels1D.length; ++pos) {
            int x;
            int n = x = this.Labels1D[pos];
            this.Sizes[n] = this.Sizes[n] + 1;
            colors[x] = Original[pos];
        }
        colors = null;
        return this.Counter;
    }

    public int Label(short[] Original, int width, int height, int depth, short Background, boolean TwentySixConnex) {
        if (width * height * depth != Original.length) {
            throw new IllegalArgumentException("Wrong given dimensions <=> width * height * depth != Original.length.");
        }
        this.Height = height;
        this.Width = width;
        this.Depth = depth;
        this.Length = Original.length;
        int zpm1 = height * width;
        this.maxy = null;
        this.maxx = null;
        this.miny = null;
        this.minx = null;
        if (this.Labels1D == null || Original.length != this.Labels1D.length) {
            this.Labels1D = this.allocator.Release(this.Labels1D);
            this.Labels1D = this.allocator.newIntArray(this.Length);
        }
        this.fifo3D.clear();
        Arrays.fill(this.Labels1D, -1);
        this.Counter = 0;
        int pos = 0;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    if (this.Labels1D[pos] == -1) {
                        if (Original[pos] == Background) {
                            this.Labels1D[pos] = 0;
                        } else {
                            ++this.Counter;
                            this.Mark3D(x, y, z, pos, this.Counter);
                            int Color2 = Original[pos] & 0xFFFF;
                            int X = x;
                            int Y = y;
                            int Z = z;
                            int POS = pos;
                            do {
                                Coordinates c = this.fifo3D.get(0);
                                x = c.X;
                                y = c.Y;
                                z = c.Z;
                                pos = c.Pos;
                                this.fifo3D.remove(0);
                                int p = pos - zpm1;
                                if (z - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x, y, z - 1, p, this.Counter);
                                }
                                p = pos + zpm1;
                                if (z + 1 < depth && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x, y, z + 1, p, this.Counter);
                                }
                                p = pos - width;
                                if (y - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x, y - 1, z, p, this.Counter);
                                }
                                p = pos + width;
                                if (y + 1 < height && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x, y + 1, z, p, this.Counter);
                                }
                                p = pos - 1;
                                if (x - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x - 1, y, z, p, this.Counter);
                                }
                                p = pos + 1;
                                if (x + 1 < width && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x + 1, y, z, p, this.Counter);
                                }
                                if (!TwentySixConnex) continue;
                                p = pos - zpm1 - width - 1;
                                if (z - 1 >= 0 && y - 1 >= 0 && x - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x - 1, y - 1, z - 1, p, this.Counter);
                                }
                                p = pos - zpm1 - width;
                                if (z - 1 >= 0 && y - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x, y - 1, z - 1, p, this.Counter);
                                }
                                p = pos - zpm1 - width + 1;
                                if (z - 1 >= 0 && y - 1 >= 0 && x + 1 < width && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x + 1, y - 1, z - 1, p, this.Counter);
                                }
                                p = pos - zpm1 - 1;
                                if (z - 1 >= 0 && x - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x - 1, y, z - 1, p, this.Counter);
                                }
                                p = pos - zpm1 + 1;
                                if (z - 1 >= 0 && x + 1 < width && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x + 1, y, z - 1, p, this.Counter);
                                }
                                p = pos - zpm1 + width - 1;
                                if (z - 1 >= 0 && y + 1 < height && x - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x - 1, y + 1, z - 1, p, this.Counter);
                                }
                                p = pos - zpm1 + width;
                                if (z - 1 >= 0 && y + 1 < height && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x, y + 1, z - 1, p, this.Counter);
                                }
                                p = pos - zpm1 + width + 1;
                                if (z - 1 >= 0 && y + 1 < height && x + 1 < width && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x + 1, y + 1, z - 1, p, this.Counter);
                                }
                                p = pos - width - 1;
                                if (y - 1 >= 0 && x - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x - 1, y - 1, z, p, this.Counter);
                                }
                                p = pos - width + 1;
                                if (y - 1 >= 0 && x + 1 < width && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x + 1, y - 1, z, p, this.Counter);
                                }
                                p = pos + width - 1;
                                if (y + 1 < height && x - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x - 1, y + 1, z, p, this.Counter);
                                }
                                p = pos + width + 1;
                                if (y + 1 < height && x + 1 < width && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x + 1, y + 1, z, p, this.Counter);
                                }
                                p = pos + zpm1 - width - 1;
                                if (z + 1 < depth && y - 1 >= 0 && x - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x - 1, y - 1, z + 1, p, this.Counter);
                                }
                                p = pos + zpm1 - width;
                                if (z + 1 < depth && y - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x, y - 1, z + 1, p, this.Counter);
                                }
                                p = pos + zpm1 - width + 1;
                                if (z + 1 < depth && y - 1 >= 0 && x + 1 < width && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x + 1, y - 1, z + 1, p, this.Counter);
                                }
                                p = pos + zpm1 - 1;
                                if (z + 1 < depth && x - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x - 1, y, z + 1, p, this.Counter);
                                }
                                p = pos + zpm1 + 1;
                                if (z + 1 < depth && x + 1 < width && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x + 1, y, z + 1, p, this.Counter);
                                }
                                p = pos + zpm1 + width - 1;
                                if (z + 1 < depth && y + 1 < height && x - 1 >= 0 && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x - 1, y + 1, z + 1, p, this.Counter);
                                }
                                p = pos + zpm1 + width;
                                if (z + 1 < depth && y + 1 < height && this.Labels1D[p] == -1 && (Original[p] & 0xFFFF) == Color2) {
                                    this.Mark3D(x, y + 1, z + 1, p, this.Counter);
                                }
                                p = pos + zpm1 + width + 1;
                                if (z + 1 >= depth || y + 1 >= height || x + 1 >= width || this.Labels1D[p] != -1 || (Original[p] & 0xFFFF) != Color2) continue;
                                this.Mark3D(x + 1, y + 1, z + 1, p, this.Counter);
                            } while (!this.fifo3D.isEmpty());
                            x = X;
                            y = Y;
                            z = Z;
                            pos = POS;
                        }
                    }
                    ++x;
                    ++pos;
                }
            }
        }
        if (this.Sizes == null || this.Sizes.length != this.Counter + 1) {
            this.Colors = null;
            this.Colors = new short[this.Counter + 1];
            this.Sizes = this.allocator.Release(this.Sizes);
            this.Sizes = this.allocator.newIntArray(this.Counter + 1);
        } else {
            Arrays.fill(this.Sizes, 0);
        }
        short[] colors = (short[])this.Colors;
        for (pos = 0; pos < this.Labels1D.length; ++pos) {
            int x;
            int n = x = this.Labels1D[pos];
            this.Sizes[n] = this.Sizes[n] + 1;
            colors[x] = Original[pos];
        }
        colors = null;
        return this.Counter;
    }

    private void Mark1D(int x, int y, int pos, int count) {
        this.fifo1D.add(new Coordinates(x, y));
        this.Labels1D[pos] = count;
    }

    private void Mark3D(int x, int y, int z, int pos, int count) {
        this.fifo3D.add(new Coordinates(x, y, z, pos));
        this.Labels1D[pos] = count;
    }

    public void ComputeBoundingBoxes() {
        if (this.minx != null) {
            return;
        }
        this.minx = new int[this.Counter + 1];
        this.maxx = new int[this.minx.length];
        this.miny = new int[this.minx.length];
        this.maxy = new int[this.minx.length];
        Arrays.fill(this.minx, this.Width);
        Arrays.fill(this.miny, this.Height);
        Arrays.fill(this.maxx, 0);
        Arrays.fill(this.maxy, 0);
        int pos = 0;
        for (int y = 0; y < this.Height; ++y) {
            int x = 0;
            while (x < this.Width) {
                if (0 < this.Labels1D[pos]) {
                    int v = this.Labels1D[pos];
                    if (x < this.minx[v]) {
                        this.minx[v] = x;
                    }
                    if (this.maxx[v] < x) {
                        this.maxx[v] = x;
                    }
                    if (y < this.miny[v]) {
                        this.miny[v] = y;
                    }
                    if (this.maxy[v] < y) {
                        this.maxy[v] = y;
                    }
                }
                ++x;
                ++pos;
            }
        }
    }

    public BufferedImage[] SeparateAllComponents(BufferedImage Source2, int Threshold, int Margin) {
        int channel;
        if (this.Labels1D == null) {
            throw new NullPointerException("Execution of method Label(Image, ***) required before this one.");
        }
        if (Source2 != null && (Source2.getWidth() != this.Width || Source2.getHeight() != this.Height)) {
            throw new IllegalArgumentException("This image must have identic dimensions than image used to label.");
        }
        BufferedImage[] list = new BufferedImage[this.Counter + 1];
        int margin = 2 * Margin + 1;
        this.ComputeBoundingBoxes();
        WritableRaster wrs = Source2.getRaster();
        WritableRaster wri = null;
        switch (Source2.getType()) {
            case 10: 
            case 11: 
            case 12: {
                channel = 1;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                channel = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        for (int i2 = 1; i2 <= this.Counter; ++i2) {
            if (this.Sizes[i2] < Threshold) continue;
            int minix = this.minx[i2];
            int miniy = this.miny[i2];
            int maxix = this.maxx[i2];
            int maxiy = this.maxy[i2];
            BufferedImage image = list[i2] = new BufferedImage(maxix - minix + margin, maxiy - miniy + margin, Source2.getType());
            wri = image.getRaster();
            for (int y = miniy; y <= maxiy; ++y) {
                int x = minix;
                int pos = y * this.Width + x;
                while (x <= maxix) {
                    if (this.Labels1D[pos] == i2) {
                        for (int c = 0; c < channel; ++c) {
                            wri.setSample(x - minix + Margin, y - miniy + Margin, c, wrs.getSample(x, y, c));
                        }
                    }
                    ++x;
                    ++pos;
                }
            }
            image = null;
            wri = null;
        }
        return list;
    }

    public BufferedImage[] SeparateComponents(BufferedImage Source2, int Threshold, int Margin) {
        if (this.Labels1D == null) {
            throw new NullPointerException("Execution of Label(Image, ***) method required before this one.");
        }
        if (this.Width != Source2.getWidth() || this.Height != Source2.getHeight()) {
            throw new IllegalArgumentException("This image must have identic dimension than image used to label.");
        }
        BufferedImage[] list = new BufferedImage[this.Counter + 1];
        int marge = (Margin << 1) + 1;
        this.ComputeBoundingBoxes();
        WritableRaster wrs = Source2.getRaster();
        WritableRaster wri = null;
        for (int i2 = 1; i2 <= this.Counter; ++i2) {
            if (this.Sizes[i2] < Threshold || this.minx[i2] == 0 || this.miny[i2] == 0 || this.maxx[i2] == this.Width - 1 || this.maxy[i2] == this.Height - 1) continue;
            int minix = this.minx[i2];
            int miniy = this.miny[i2];
            int maxix = this.maxx[i2];
            int maxiy = this.maxy[i2];
            BufferedImage image = new BufferedImage(maxix - minix + marge, maxiy - miniy + marge, Source2.getType());
            wri = image.getRaster();
            for (int y = miniy; y <= maxiy; ++y) {
                int x = minix;
                int pos = y * this.Width + x;
                while (x <= maxix) {
                    if (this.Labels1D[pos] == i2) {
                        wri.setSample(x - minix + Margin, y - miniy + Margin, 0, wrs.getSample(x, y, 0));
                    }
                    ++x;
                    ++pos;
                }
            }
            list[i2] = image;
            image = null;
            wri = null;
        }
        return list;
    }

    public List<SubImage> SeparateComponentsSub(BufferedImage Source2, int Threshold, int Margin) {
        if (this.Labels1D == null) {
            throw new NullPointerException("Execution of Label(Image, ***) method required before this one.");
        }
        if (Source2.getWidth() != this.Width || Source2.getHeight() != this.Height) {
            throw new IllegalArgumentException("This image must have identic dimension than image used to label.");
        }
        ArrayList<SubImage> liste = new ArrayList<SubImage>(this.Counter);
        this.ComputeBoundingBoxes();
        for (int i2 = 1; i2 <= this.Counter; ++i2) {
            if (this.Sizes[i2] < Threshold || this.minx[i2] == 0 || this.miny[i2] == 0 || this.maxx[i2] == this.Width - 1 || this.maxy[i2] == this.Height - 1) continue;
            liste.add(new SubImage(Source2, (ConnectedComponentLabeling)this, i2, Margin));
        }
        return liste;
    }

    public BufferedImage ExtractComponent(BufferedImage Source2, int Number2, int Margin, int Background) {
        if (Source2.getWidth() != this.Width || Source2.getHeight() != this.Height) {
            throw new IllegalArgumentException("Source image and the image/array used to create the labeling have not identical dimensions");
        }
        int minix = this.minx[Number2] - Margin <= 0 ? 0 : this.minx[Number2] - Margin;
        int miniy = this.miny[Number2] - Margin <= 0 ? 0 : this.miny[Number2] - Margin;
        int maxix = this.Width <= this.maxx[Number2] + Margin ? this.Width - 1 : this.maxx[Number2] + Margin;
        int maxiy = this.Height <= this.maxy[Number2] + Margin ? this.Height - 1 : this.maxy[Number2] + Margin;
        BufferedImage image = ImageNew.SubImage((BufferedImage)Source2, (int)minix, (int)miniy, (int)maxix, (int)maxiy);
        WritableRaster wri = image.getRaster();
        int channel = Source2.getRaster().getNumBands();
        for (int y = miniy; y <= maxiy; ++y) {
            int x = minix;
            int pos = y * this.Width + x;
            while (x <= maxix) {
                if (this.Labels1D[pos] != Number2) {
                    for (int c = 0; c < channel; ++c) {
                        wri.setSample(x - minix, y - miniy, c, Background);
                    }
                }
                ++x;
                ++pos;
            }
        }
        return image;
    }

    public void DeleteSmallerThan(int Threshold) {
        for (int i2 = 1; i2 < this.Sizes.length; ++i2) {
            if (this.Sizes[i2] >= Threshold) continue;
            this.DeleteCC(i2);
        }
    }

    public void DeleteSmallerThan(BufferedImage Original, int Threshold) {
        for (int i2 = 1; i2 < this.Sizes.length; ++i2) {
            if (this.Sizes[i2] >= Threshold) continue;
            this.DeleteCC(Original, i2);
        }
    }

    public void DeleteBiggerThan(int Threshold) {
        for (int i2 = 1; i2 < this.Sizes.length; ++i2) {
            if (Threshold >= this.Sizes[i2]) continue;
            this.DeleteCC(i2);
        }
    }

    public void DeleteBiggerThan(BufferedImage Original, int Threshold) {
        for (int i2 = 1; i2 < this.Sizes.length; ++i2) {
            if (Threshold >= this.Sizes[i2]) continue;
            this.DeleteCC(Original, i2);
        }
    }

    public void DeleteCCs(List<Integer> numbers) {
        Iterator<Integer> iter = numbers.iterator();
        while (iter.hasNext()) {
            this.DeleteCC(iter.next());
        }
        iter = null;
    }

    public void DeleteCC(int number) {
        if (number <= 0) {
            throw new IllegalArgumentException("number <= 0. Number must be positive and connected component 0 (background) cannot be deleted.");
        }
        if (this.minx == null) {
            this.ComputeBoundingBoxes();
        }
        int xmin = this.minx[number];
        int xmax = this.maxx[number];
        int ymin = this.miny[number];
        int ymax = this.maxy[number];
        for (int y = ymin; y <= ymax; ++y) {
            int x = xmin;
            int pos = y * this.Width + x;
            while (x <= xmax) {
                if (this.Labels1D[pos] == number) {
                    this.Labels1D[pos] = 0;
                }
                ++x;
                ++pos;
            }
        }
        this.maxy[number] = -1;
        this.miny[number] = -1;
        this.maxx[number] = -1;
        this.minx[number] = -1;
        this.Sizes[0] = this.Sizes[0] + this.Sizes[number];
        this.Sizes[number] = 0;
    }

    public void DeleteCCs(BufferedImage Original, List<Integer> numbers) {
        Iterator<Integer> iter = numbers.iterator();
        while (iter.hasNext()) {
            this.DeleteCC(Original, iter.next());
        }
        iter = null;
    }

    public void DeleteCC(BufferedImage Original, int number) {
        if (number <= 0) {
            throw new IllegalArgumentException("number <= 0. Number must be positive and connected component 0 (background) cannot be deleted.");
        }
        if (Original.getWidth() != this.Width || Original.getHeight() != this.Height) {
            throw new IllegalArgumentException("Image dimensions are different from image used for labelling.");
        }
        if (this.minx == null) {
            this.ComputeBoundingBoxes();
        }
        int xmin = this.minx[number];
        int xmax = this.maxx[number];
        int ymin = this.miny[number];
        int ymax = this.maxy[number];
        block0 : switch (Original.getType()) {
            case 12: {
                WritableRaster wr = Original.getRaster();
                for (int y = ymin; y <= ymax; ++y) {
                    int x = xmin;
                    int pos = y * this.Width + x;
                    while (x <= xmax) {
                        if (this.Labels1D[pos] == number) {
                            wr.setSample(x, y, 0, 0);
                            this.Labels1D[pos] = 0;
                        }
                        ++x;
                        ++pos;
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                for (int y = ymin; y <= ymax; ++y) {
                    int x = xmin;
                    int pos = y * this.Width + x;
                    while (x <= xmax) {
                        if (this.Labels1D[pos] == number) {
                            bytebufferin[pos] = 0;
                            this.Labels1D[pos] = 0;
                        }
                        ++x;
                        ++pos;
                    }
                }
                bytebufferin = null;
                break;
            }
            case 11: {
                short[] shortbufferin = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                for (int y = ymin; y <= ymax; ++y) {
                    int x = xmin;
                    int pos = y * this.Width + x;
                    while (x <= xmax) {
                        if (this.Labels1D[pos] == number) {
                            shortbufferin[pos] = 0;
                            this.Labels1D[pos] = 0;
                        }
                        ++x;
                        ++pos;
                    }
                }
                shortbufferin = null;
                break;
            }
            case 0: {
                switch (Original.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int[] intbufferin = ((DataBufferInt)Original.getRaster().getDataBuffer()).getData();
                        for (int y = ymin; y <= ymax; ++y) {
                            int x = xmin;
                            int pos = y * this.Width + x;
                            while (x <= xmax) {
                                if (this.Labels1D[pos] == number) {
                                    this.Labels1D[pos] = 0;
                                    intbufferin[pos] = 0;
                                }
                                ++x;
                                ++pos;
                            }
                        }
                        intbufferin = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Unsupported DataBuffer type.");
            }
            default: {
                throw new IllegalArgumentException("Unsupported image type.");
            }
        }
        this.maxy[number] = -1;
        this.miny[number] = -1;
        this.maxx[number] = -1;
        this.minx[number] = -1;
        this.Sizes[0] = this.Sizes[0] + this.Sizes[number];
        this.Sizes[number] = 0;
    }

    public void DeleteOnBorder(int ... Except) {
        boolean[] todelete = new boolean[this.Sizes.length];
        int y = 0;
        int pos = 0;
        int pos2 = this.Width - 1;
        while (y < this.Height) {
            if (this.Labels1D[pos] != 0) {
                todelete[this.Labels1D[pos]] = true;
            }
            if (this.Labels1D[pos2] != 0) {
                todelete[this.Labels1D[pos2]] = true;
            }
            ++y;
            pos += this.Width;
            pos2 += this.Width;
        }
        int x = 0;
        pos = (this.Height - 1) * this.Width;
        while (x < this.Width) {
            if (this.Labels1D[x] != 0) {
                todelete[this.Labels1D[x]] = true;
            }
            if (this.Labels1D[pos] != 0) {
                todelete[this.Labels1D[pos]] = true;
            }
            ++x;
            ++pos;
        }
        for (int i2 = 0; i2 < Except.length; ++i2) {
            todelete[Except[i2]] = false;
        }
        for (x = 1; x < todelete.length; ++x) {
            if (!todelete[x]) continue;
            this.DeleteCC(x);
        }
        todelete = null;
    }

    public void DeleteOnBorder(BufferedImage Original, int ... Except) {
        if (Original.getWidth() != this.Width || Original.getHeight() != this.Height) {
            throw new IllegalArgumentException("Image dimensions are different from image used for labeling.");
        }
        boolean[] todelete = new boolean[this.Sizes.length];
        int y = 0;
        int pos = 0;
        int pos2 = this.Width - 1;
        while (y < this.Height) {
            if (this.Labels1D[pos] != 0) {
                todelete[this.Labels1D[pos]] = true;
            }
            if (this.Labels1D[pos2] != 0) {
                todelete[this.Labels1D[pos2]] = true;
            }
            ++y;
            pos += this.Width;
            pos2 += this.Width;
        }
        int x = 0;
        pos = (this.Height - 1) * this.Width;
        while (x < this.Width) {
            if (this.Labels1D[x] != 0) {
                todelete[this.Labels1D[x]] = true;
            }
            if (this.Labels1D[pos] != 0) {
                todelete[this.Labels1D[pos]] = true;
            }
            ++x;
            ++pos;
        }
        for (int i2 = 0; i2 < Except.length; ++i2) {
            todelete[Except[i2]] = false;
        }
        for (x = 1; x < todelete.length; ++x) {
            if (!todelete[x]) continue;
            this.DeleteCC(Original, x);
        }
        todelete = null;
    }

    public int ConnectedComponentsNumber(int Threshold) {
        int nbccf = 0;
        for (int i2 = 1; i2 <= this.Counter; ++i2) {
            if (this.Sizes[i2] < Threshold) continue;
            ++nbccf;
        }
        return nbccf;
    }

    public int ConnectedComponentsNumber() {
        return this.Counter;
    }

    public int[] minx() {
        return this.minx;
    }

    public int[] miny() {
        return this.miny;
    }

    public int[] maxx() {
        return this.maxx;
    }

    public int[] maxy() {
        return this.maxy;
    }

    public int[] Sizes() {
        return this.Sizes;
    }

    public Object Colors() {
        return this.Colors;
    }

    public int[] Labels1D() {
        return this.Labels1D;
    }

    public int Width() {
        return this.Width;
    }

    public int Height() {
        return this.Height;
    }

    public int Depth() {
        return this.Depth;
    }
}

