/*
 * Decompiled with CFR 0.152.
 */
package measures;

import arrayTiTi.ArrayFeatures;
import filesAndFolders.FileNameFilters;
import filesAndFolders.fichiersTabules.FichierTabule;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.io.File;
import java.io.IOException;

public class SNR {
    private double MAE = 0.0;
    private double MSE = 0.0;
    private double PSNR = 0.0;
    private final ArrayFeatures AF = new ArrayFeatures();

    public void Compute(BufferedImage original, BufferedImage noise) {
        int length;
        double max;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)original, (BufferedImage)noise)) {
            throw new IllegalArgumentException("Images are different.");
        }
        long mae = 0L;
        long mse = 0L;
        switch (original.getType()) {
            case 5: 
            case 6: 
            case 10: {
                max = 255.0;
                byte[] bbor = ((DataBufferByte)original.getRaster().getDataBuffer()).getData();
                byte[] bbno = ((DataBufferByte)noise.getRaster().getDataBuffer()).getData();
                length = bbor.length;
                for (int i2 = 0; i2 < length; ++i2) {
                    int o = bbor[i2] & 0xFF;
                    int n = bbno[i2] & 0xFF;
                    mae += (long)Math.abs(o - n);
                    mse += (long)((o - n) * (o - n));
                }
                break;
            }
            case 11: {
                max = 65535.0;
                short[] sbor = ((DataBufferUShort)original.getRaster().getDataBuffer()).getData();
                short[] sbno = ((DataBufferUShort)noise.getRaster().getDataBuffer()).getData();
                length = sbor.length;
                for (int i3 = 0; i3 < length; ++i3) {
                    int o = sbor[i3] & 0xFFFF;
                    int n = sbno[i3] & 0xFFFF;
                    mae += (long)Math.abs(o - n);
                    mse += (long)((o - n) * (o - n));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.MAE = (double)mae / (double)length;
        this.MSE = (double)mse / (double)length;
        this.PSNR = 10.0 * Math.log10(max * max / this.MSE);
    }

    public FichierTabule Compute(String inputs, String outputs, String groundtruth) {
        int i2;
        File[] images = new File(inputs).listFiles(FileNameFilters.ImagesPNGorTIF);
        FichierTabule results = new FichierTabule(images.length + 2, new int[]{2, 1, 1, 1, 1, 1, 1}, "SNR");
        results.setColumnsNames(new String[]{"Images", "Inputs MAE", "Inputs MSE", "Inputs PSNR", "Outputs MAE", "Outputs MSE", "Outputs PNSR"});
        for (i2 = 0; i2 < images.length; ++i2) {
            try {
                int sy;
                int sx;
                results.setValue(i2, 0, images[i2].getName());
                BufferedImage imin = ImageIO.Read(images[i2]);
                BufferedImage imout = ImageIO.Read(images[i2].getAbsolutePath().replace(inputs, outputs));
                BufferedImage imgt = ImageIO.Read(images[i2].getAbsolutePath().replace(inputs, groundtruth));
                if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)imin, (BufferedImage)imout)) {
                    sx = imin.getWidth() - imout.getWidth() >> 1;
                    sy = imin.getHeight() - imout.getHeight() >> 1;
                    imin = ImageNew.SubImageWH((BufferedImage)imin, (int)sx, (int)sy, (int)imout.getWidth(), (int)imout.getHeight());
                }
                if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)imgt, (BufferedImage)imout)) {
                    sx = imgt.getWidth() - imout.getWidth() >> 1;
                    sy = imgt.getHeight() - imout.getHeight() >> 1;
                    imgt = ImageNew.SubImageWH((BufferedImage)imgt, (int)sx, (int)sy, (int)imout.getWidth(), (int)imout.getHeight());
                }
                this.Compute(imin, imgt);
                results.setValue(i2, 1, this.MAE);
                results.setValue(i2, 2, this.MSE);
                results.setValue(i2, 3, this.PSNR);
                this.Compute(imout, imgt);
                results.setValue(i2, 4, this.MAE);
                results.setValue(i2, 5, this.MSE);
                results.setValue(i2, 6, this.PSNR);
                imgt = null;
                imout = null;
                imin = null;
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        results.setValue(images.length, 0, "Averages");
        results.setValue(images.length + 1, 0, "Variances");
        for (i2 = 1; i2 < 7; ++i2) {
            this.AF.Moments(results.getColumnDouble(i2), 0, images.length);
            results.setValue(images.length, i2, this.AF.Average());
            results.setValue(images.length + 1, i2, this.AF.Variance());
        }
        return results;
    }

    public double MAE() {
        return this.MAE;
    }

    public double MSE() {
        return this.MSE;
    }

    public double PSNR() {
        return this.PSNR;
    }
}

