/*
 * Decompiled with CFR 0.152.
 */
package measures;

import Jama.Matrix;
import algoGeo.convexhull.QuickHull3D;
import characterization.shapes.polarSignature.PolarSignature3D;
import dataMining.pca.PCA;
import dv.DV;
import mathematics.metrics.Euclidian;
import mathematics.primitives.Box3D;
import mathematics.primitives.LineSegment;
import mathematics.primitives.Plan;
import mathematics.primitives.Sphere;
import mathematics.primitives.pointsTiTi.Coordinate;
import mathematics.primitives.pointsTiTi.CoordinatesManager;
import measures.BasicMeasures3D;
import measures.hedgehop.DistanceMap3DComputer;
import measures.hedgehop.GeodesicDiameter3D;
import morphee.StructuringElement3D;

public class Measures3D {
    private int Surface;
    private int Volume;
    private int nbHoles;
    private int nbCompConnexe;
    private int nbCompConnexeEcart;
    private double ShortestRadius;
    private double LongestRadius;
    private double AverageRadius;
    public DV differences = null;
    public LineSegment MainAxis01 = null;
    public LineSegment SecondAxis02 = null;
    public LineSegment ThirdAxis03 = null;
    private final BasicMeasures3D basics = new BasicMeasures3D();
    public Box3D box = null;
    public Coordinate Barycentre = null;
    public float[] distmap = null;
    public QuickHull3D convexhull = null;
    public LineSegment EnclidianDiameter = null;
    public GeodesicDiameter3D geodesicdiameter = null;
    public CoordinatesManager surface = null;
    public Matrix Mat = null;
    public Matrix MatInv = null;
    public Plan MainPlan01 = null;
    public Plan SecondPlan02 = null;
    public Plan ThirdPlan03 = null;
    public Sphere MinSphere = null;
    public Sphere MaxSphere = null;
    public PolarSignature3D Signature = null;
    private DV dv = null;

    public Measures3D(DV dv) {
        this.dv = dv;
        this.Initialisation();
    }

    private void Initialisation() {
        this.nbCompConnexe = -1;
        this.nbHoles = -1;
        this.Surface = -1;
        this.Volume = -1;
        this.AverageRadius = -1.0;
        this.LongestRadius = -1.0;
        this.ShortestRadius = -1.0;
    }

    public void Basics(int Type2) {
        if (0 < this.Surface) {
            return;
        }
        this.basics.Compute(this.dv, Type2 == 26);
        this.Volume = this.basics.getVolume();
        this.Surface = this.basics.getSurface();
        this.Barycentre = this.basics.Centroid;
        this.box = this.basics.BoundingBox;
        this.surface = this.basics.Boundary;
    }

    public void EuclidianRadius() {
        if (0.0 <= this.AverageRadius) {
            return;
        }
        this.Basics(26);
        Euclidian distances = new Euclidian();
        this.ShortestRadius = this.LongestRadius = distances.Distance(this.surface.Point(0), this.Barycentre);
        for (int i2 = 1; i2 < this.Surface; ++i2) {
            double distance = distances.Distance(this.surface.Point(i2), this.Barycentre);
            this.AverageRadius += distance;
            if (distance < this.ShortestRadius) {
                this.ShortestRadius = distance;
            }
            if (!(distance > this.LongestRadius)) continue;
            this.LongestRadius = distance;
        }
        this.AverageRadius /= (double)this.Surface;
        distances = null;
    }

    public void EuclidianDiameter() {
        throw new Error("Must not be computed");
    }

    public void DistanceMapAndSphereMax(StructuringElement3D se) {
        if (this.MaxSphere != null) {
            return;
        }
        this.MaxSphere = new Sphere();
        this.MaxSphere.setRadius(0.0);
        DistanceMap3DComputer cd = new DistanceMap3DComputer();
        cd.Compute(this.dv, se);
        this.distmap = cd.MontanariMap1D();
        int pos = 0;
        for (int z = 0; z < this.dv.SizeZ; ++z) {
            for (int y = 0; y < this.dv.SizeY; ++y) {
                int x = 0;
                while (x < this.dv.SizeX) {
                    if (this.MaxSphere.getRadius() < (double)this.distmap[pos]) {
                        this.MaxSphere.setRadius(this.distmap[pos]);
                        this.MaxSphere.setCenter(x, y, z);
                    }
                    ++x;
                    ++pos;
                }
            }
        }
        cd.Kill();
        cd = null;
    }

    public void GeodesicDiameter(StructuringElement3D se, boolean Fast, boolean FindPath) {
        throw new UnsupportedOperationException("To upgrade.");
    }

    public void SphereMin() {
        throw new UnsupportedOperationException("To upgrade.");
    }

    public void MainPlans() {
        if (this.MainAxis01 != null) {
            return;
        }
        if (this.Surface < 0) {
            this.Basics(26);
        }
        PCA pca = new PCA();
        pca.Compute(this.dv, this.Barycentre);
        this.MainAxis01 = new LineSegment(this.Barycentre, pca.getEigenVectors()[0], 3);
        this.MainAxis01.vector.Standardize();
        this.MainAxis01.FindExtremities(this.dv, true);
        this.SecondAxis02 = new LineSegment(this.Barycentre, pca.getEigenVectors()[1], 3);
        this.SecondAxis02.vector.Standardize();
        this.SecondAxis02.FindExtremities(this.dv, true);
        this.ThirdAxis03 = new LineSegment(this.Barycentre, pca.getEigenVectors()[2], 3);
        this.ThirdAxis03.vector.Standardize();
        this.ThirdAxis03.FindExtremities(this.dv, true);
        this.MainPlan01.V1.set(pca.getEigenVectors()[0].get());
        this.MainPlan01.V1.Standardize();
        this.MainPlan01.V2.set(pca.getEigenVectors()[1].get());
        this.MainPlan01.V2.Standardize();
        this.MainPlan01.Point.setXYZ(this.Barycentre.X, this.Barycentre.Y, this.Barycentre.Z);
        this.MainPlan01.ComputeEquation();
        this.MainPlan01.FindParallelogram(this.box);
        this.SecondPlan02.V1.set(pca.getEigenVectors()[0].get());
        this.SecondPlan02.V1.Standardize();
        this.SecondPlan02.V2.set(pca.getEigenVectors()[2].get());
        this.SecondPlan02.V2.Standardize();
        this.SecondPlan02.Point.setXYZ(this.Barycentre.X, this.Barycentre.Y, this.Barycentre.Z);
        this.SecondPlan02.ComputeEquation();
        this.SecondPlan02.FindParallelogram(this.box);
        this.ThirdPlan03.V1.set(pca.getEigenVectors()[1].get());
        this.ThirdPlan03.V1.Standardize();
        this.ThirdPlan03.V2.set(pca.getEigenVectors()[2].get());
        this.ThirdPlan03.V2.Standardize();
        this.ThirdPlan03.Point.setXYZ(this.Barycentre.X, this.Barycentre.Y, this.Barycentre.Z);
        this.ThirdPlan03.ComputeEquation();
        this.ThirdPlan03.FindParallelogram(this.box);
        pca = null;
    }

    public void ConvexHull() {
        if (this.convexhull != null) {
            return;
        }
        this.convexhull = new QuickHull3D();
        this.convexhull.Compute(this.surface, true);
        this.convexhull.ComputeProperties(this.Barycentre);
    }

    private void ComputeDifferences() {
        throw new UnsupportedOperationException("To upgrade.");
    }

    public int ComposanteConnexeEcart(boolean HuitConnexe, boolean ModifierEcarts) {
        throw new UnsupportedOperationException("To upgrade.");
    }

    public int ComposanteConnexe(boolean HuitConnexe) {
        throw new UnsupportedOperationException("To upgrade.");
    }

    public int NombreDeTrou(boolean HuitConnexe) {
        throw new UnsupportedOperationException("To upgrade.");
    }

    public void SignaturePolaire(int nbBoules) {
        if (this.Signature != null) {
            return;
        }
        this.Signature = new PolarSignature3D();
        this.Signature.SetDimension(nbBoules);
        this.Signature.Calculer(this.dv, this.Barycentre, this.LongestRadius);
    }

    public DV getDV() {
        return this.dv;
    }

    public double getLongestRadius() {
        return this.LongestRadius;
    }

    public double getSmallestRadius() {
        return this.ShortestRadius;
    }

    public double getAverageRadius() {
        return this.AverageRadius;
    }

    public int getSurface() {
        return this.Surface;
    }

    public int getVolume() {
        return this.Volume;
    }

    public int getNbComponents() {
        return this.nbCompConnexe;
    }

    public int getNbCompConnexeEcart() {
        return this.nbCompConnexeEcart;
    }

    public int getNbHoles() {
        return this.nbHoles;
    }
}

