/*
 * Decompiled with CFR 0.152.
 */
package measures;

import algoGeo.convexhull.AklToussaint;
import algoGeo.convexhull.ConvexHull;
import algoGeo.convexhull.JShull;
import characterization.shapes.polarSignature.PolarSignature;
import dataMining.pca.PCA;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.util.Iterator;
import mathematics.Geometry2D;
import mathematics.metrics.Euclidian;
import mathematics.metrics.Metric;
import mathematics.primitives.Box;
import mathematics.primitives.Disk;
import mathematics.primitives.LineSegment;
import mathematics.primitives.pointsTiTi.Coordinate;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.CoordinatesManager;
import mathematics.primitives.pointsTiTi.Point;
import mathematics.primitives.pointsTiTi.Point3DF;
import mathematics.primitives.pointsTiTi.Point3DI;
import mathematics.primitives.pointsTiTi.PointND;
import measures.BasicMeasures;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.HoleCounter;
import measures.cclh.UnionFindCcl;
import measures.hedgehop.DistanceMapComputer;
import measures.hedgehop.GeodesicDiameter;
import measures.histogram.IntegralProjectionFunction;
import morphee.StructuringElement;

public class Measures2D {
    private int Surface;
    private int Perimetre;
    private int nbHoles;
    private int nbCompConnexe;
    private double AngleAP1;
    private double AngleAP2;
    private double ShortestRadius;
    private double LongestRadius;
    private double AverageRadius;
    private double EpaisseurD;
    private double EpaisseurAP1;
    private double EpaisseurAP2;
    private BufferedImage image = null;
    public LineSegment eucdiam = null;
    public GeodesicDiameter geodiam = null;
    public LineSegment MainAxis01 = null;
    public LineSegment SecondAxis02 = null;
    public Box BoundingBox = null;
    private BasicMeasures basics = new BasicMeasures();
    public Coordinate Barycentre = null;
    public float[] distancemap = null;
    public Disk DiskMin = null;
    public Disk DiskMax = null;
    public ConvexHull convexhull = null;
    public CoordinatesManager Contour = null;
    public CoordinatesManager SortedContour = null;
    private IntegralProjectionFunction HP = null;
    private PolarSignature SigPol = null;
    private Metric metric = new Euclidian();
    private UnionFindCcl ccl = new UnionFindCcl();

    public Measures2D(BufferedImage image) {
        if (!ImageTools.isGrayLevel((BufferedImage)image) && image.getType() != 12) {
            throw new IllegalArgumentException("Binary or gray levels image required.");
        }
        this.image = image;
        this.Initialisations();
    }

    private void Initialisations() {
        this.nbCompConnexe = -1;
        this.nbHoles = -1;
        this.Surface = -1;
        this.Perimetre = -1;
        this.AverageRadius = -1.0;
        this.LongestRadius = -1.0;
        this.ShortestRadius = -1.0;
        this.EpaisseurAP2 = -1.0;
        this.EpaisseurAP1 = -1.0;
        this.EpaisseurD = -1.0;
        this.AngleAP2 = -1.0;
        this.AngleAP1 = -1.0;
    }

    public void Kill() {
        this.image = null;
        this.eucdiam = null;
        this.geodiam = null;
        this.SecondAxis02 = null;
        this.MainAxis01 = null;
        this.BoundingBox = null;
        this.basics.Kill();
        this.basics = null;
        this.Barycentre = null;
        this.distancemap = null;
        this.DiskMax = null;
        this.DiskMin = null;
        this.convexhull = null;
        if (this.SortedContour != null) {
            this.SortedContour.Kill();
        }
        this.SortedContour = null;
        this.HP = null;
        this.SigPol = null;
        this.metric = null;
        this.ccl.Kill();
        this.ccl = null;
    }

    public void Basics(boolean HuitConnexe, boolean ComputeClockWiseBoundary) {
        if (0 < this.Surface) {
            return;
        }
        this.basics.Compute(this.image, HuitConnexe);
        this.Perimetre = this.basics.getPerimeter();
        this.Surface = this.basics.getSurface();
        this.Barycentre = this.basics.Centroid;
        this.BoundingBox = this.basics.BoundingBox;
        this.Contour = this.basics.Boundary;
        if (ComputeClockWiseBoundary) {
            this.basics.ComputeClockWiseBoundary();
            this.SortedContour = this.basics.ClockWiseBoundary;
        }
    }

    public void EuclidianRadii() {
        if (this.ShortestRadius >= 0.0) {
            return;
        }
        if (this.Surface < 0) {
            this.Basics(true, false);
        }
        Iterator<Coordinates> iter = this.Contour.Iterator();
        this.ShortestRadius = this.LongestRadius = this.metric.Distance(iter.next(), this.Barycentre);
        this.AverageRadius = this.ShortestRadius / (double)this.Perimetre;
        while (iter.hasNext()) {
            double distance = this.metric.Distance(iter.next(), this.Barycentre);
            this.AverageRadius += distance / (double)this.Perimetre;
            if (distance < this.ShortestRadius) {
                this.ShortestRadius = distance;
            }
            if (!(distance > this.LongestRadius)) continue;
            this.LongestRadius = distance;
        }
        iter = null;
    }

    public void EuclidianDiameter() {
        double distance;
        int i2;
        if (this.eucdiam != null) {
            return;
        }
        if (this.Surface < 0) {
            this.Basics(true, false);
        }
        double dist = 0.0;
        int b = 0;
        int a = 0;
        for (i2 = 0; i2 < this.Perimetre - 1; ++i2) {
            for (int j = i2 + 1; j < this.Perimetre; ++j) {
                distance = this.metric.Distance(this.Contour.Point(i2), this.Contour.Point(j));
                if (!(distance > dist)) continue;
                dist = distance;
                a = i2;
                b = j;
            }
        }
        this.eucdiam = new LineSegment(new Point3DI(this.Contour.Point((int)a).X, this.Contour.Point((int)a).Y), new Point3DI(this.Contour.Point((int)b).X, this.Contour.Point((int)b).Y), 2);
        this.EpaisseurD = 0.0;
        for (i2 = 0; i2 < this.Perimetre; ++i2) {
            distance = this.metric.Distance(Geometry2D.ProjectionPointOnLine(this.eucdiam, this.Contour.Point(i2)), this.Contour.Point(i2));
            if (!(distance > this.EpaisseurD)) continue;
            this.EpaisseurD = distance;
        }
    }

    public void DistanceMapAndDiskMax(StructuringElement se) {
        if (this.DiskMax != null) {
            return;
        }
        if (se.getType() != -15) {
            throw new IllegalArgumentException("Montanari distance/se required.");
        }
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        this.DiskMax = new Disk();
        DistanceMapComputer dmc = new DistanceMapComputer();
        dmc.Compute(this.image, se);
        this.distancemap = dmc.getMontanariMap1D();
        block0 : switch (this.image.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (bb[pos] != 0 && this.DiskMax.getRadius() < (double)this.distancemap[pos]) {
                            this.DiskMax.setRadius(this.distancemap[pos]);
                            this.DiskMax.setCenter(x, y);
                        }
                        ++x;
                        ++pos;
                    }
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)this.image.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (sb[pos] != 0 && this.DiskMax.getRadius() < (double)this.distancemap[pos]) {
                            this.DiskMax.setRadius(this.distancemap[pos]);
                            this.DiskMax.setCenter(x, y);
                        }
                        ++x;
                        ++pos;
                    }
                }
                sb = null;
                break;
            }
            case 0: {
                switch (this.image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int[] ib = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        for (int y = 0; y < height; ++y) {
                            int x = 0;
                            while (x < width) {
                                if (ib[pos] != 0 && this.DiskMax.getRadius() < (double)this.distancemap[pos]) {
                                    this.DiskMax.setRadius(this.distancemap[pos]);
                                    this.DiskMax.setCenter(x, y);
                                }
                                ++x;
                                ++pos;
                            }
                        }
                        ib = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        dmc.Kill();
        dmc = null;
    }

    public void GeodesicDiameter(StructuringElement se, boolean FindPath) {
        if (se.getType() != -15) {
            throw new IllegalArgumentException("Montanary distance/SE required.");
        }
        if (this.Surface < 0) {
            this.Basics(true, false);
        }
        if (FindPath) {
            this.DistanceMapAndDiskMax(se);
        }
        this.geodiam = new GeodesicDiameter();
        this.geodiam.Compute(this.image, this.Contour, this.Barycentre, se, this.distancemap, FindPath);
    }

    public void DiskMin() {
    }

    public int ConnectedComponents(int BackGround, boolean EightConnex) {
        if (0 <= this.nbCompConnexe) {
            return this.nbCompConnexe;
        }
        this.nbCompConnexe = this.ccl.Label(this.image, BackGround, EightConnex);
        return this.nbCompConnexe;
    }

    public int NbHoles(boolean EightConnex) {
        if (0 <= this.nbHoles) {
            return this.nbHoles;
        }
        HoleCounter hole = new HoleCounter();
        this.nbHoles = hole.Count(this.image, (ConnectedComponentLabeling)this.ccl, EightConnex);
        hole = null;
        return this.nbHoles;
    }

    public void MainAxes() {
        double dist;
        if (this.MainAxis01 != null) {
            return;
        }
        if (this.basics.Centroid == null) {
            this.Basics(true, false);
        }
        PCA pca = new PCA();
        pca.Compute(this.image, this.basics.Centroid);
        this.MainAxis01 = new LineSegment(pca.getBarycenter(), pca.getEigenVectors()[0], 2);
        try {
            this.MainAxis01.FindExtremities(this.image, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.AngleAP1 = Geometry2D.AngleBAC(new PointND(1.0, 0.0), (Point)new PointND(0.0, 0.0), new PointND(this.MainAxis01.vector.get(0), this.MainAxis01.vector.get(1)), false);
        this.EpaisseurAP1 = 0.0;
        for (int i2 = 0; i2 < this.Perimetre; ++i2) {
            dist = this.metric.Distance(Geometry2D.ProjectionPointOnLine(this.MainAxis01, this.Contour.Point(i2)), this.Contour.Point(i2));
            if (!(dist > this.EpaisseurAP1)) continue;
            this.EpaisseurAP1 = dist;
        }
        this.SecondAxis02 = new LineSegment(pca.getBarycenter(), pca.getEigenVectors()[1], 2);
        try {
            this.SecondAxis02.FindExtremities(this.image, true);
        }
        catch (Exception i2) {
            // empty catch block
        }
        this.AngleAP2 = Geometry2D.AngleBAC(new Point3DF(1.0, 0.0), (Point)new Point3DF(0.0, 0.0), new Point3DF(this.SecondAxis02.vector.get(0), this.SecondAxis02.vector.get(1)), false);
        this.EpaisseurAP2 = 0.0;
        for (int i3 = 0; i3 < this.Perimetre; ++i3) {
            dist = this.metric.Distance(Geometry2D.ProjectionPointOnLine(this.SecondAxis02, this.Contour.Point(i3)), this.Contour.Point(i3));
            if (!(dist > this.EpaisseurAP2)) continue;
            this.EpaisseurAP2 = dist;
        }
        pca = null;
    }

    public void ConvexHull(boolean AklToussaint2, int MinimumArea) {
        if (this.convexhull != null) {
            return;
        }
        this.convexhull = new JShull();
        this.convexhull.Compute(this.Contour.Points(), new AklToussaint(8));
        this.convexhull.ComputeProperties(this.image, MinimumArea);
    }

    public void ProjectionHistograms(int ForbiddenValue) {
        if (this.HP != null) {
            return;
        }
        this.HP = new IntegralProjectionFunction();
        this.HP.Compute(this.image, ForbiddenValue);
    }

    public void PolarSignature(int nbCircles) {
        if (this.SigPol != null) {
            return;
        }
        if (this.Surface < 0) {
            this.Basics(true, false);
        }
        this.SigPol = new PolarSignature();
        this.SigPol.Compute(this.image, nbCircles, this.Barycentre, this.LongestRadius);
    }

    public void Display(String string) {
        System.out.println("Measures: " + string);
        System.out.println("\tSurface = " + this.Surface);
        System.out.println("\tPerimetre = " + this.Perimetre);
        System.out.println("\tBarycentre = " + this.Barycentre.X + ", " + this.Barycentre.Y);
        System.out.println("\tPlus Petit Rayon = " + this.ShortestRadius);
        System.out.println("\tPlus Grand Rayon = " + this.LongestRadius);
        System.out.println("\tRayon de la plus grande boule inscrite= " + this.DiskMax.getRadius());
        System.out.println("\tRayon de la plus petite boule circonscrite = " + this.DiskMin.getRadius());
        System.out.println("\tDiametre euclidien = " + this.eucdiam.Length() + ", epaisseur = " + this.EpaisseurD);
        System.out.println("\tDiametre geodesique = " + this.geodiam.getLength());
        System.out.println("\tVariation diametrale moyenne = " + this.geodiam.getVariationDiametraleMoyenne());
        System.out.println("\tNombre de trous = " + this.nbHoles);
        System.out.println("\tNombre de composantes connexes = " + this.nbCompConnexe);
        System.out.println("\tPerimetre de l'enveloppe convexe = " + this.convexhull.getPerimeter());
        System.out.println("\tSurface de l'enveloppe convexe = " + this.convexhull.getSurface());
        System.out.println("\tNombre de composante d'ecart avec l'enveloppe = " + this.convexhull.getNcce());
        System.out.println("\tLongueur Axe Principal 01 = " + this.MainAxis01.Length() + ", epaisseur = " + this.EpaisseurAP1);
        System.out.println("\tLongueur Axe Principal 02 = " + this.SecondAxis02.Length() + ", epaisseur = " + this.EpaisseurAP2);
    }

    public void DisplayValues(String string) {
        System.out.println("Affichage des mesures : " + string);
        System.out.println(this.Surface);
        System.out.println(this.Perimetre);
        System.out.println(this.Barycentre.X + " " + this.Barycentre.Y);
        System.out.println(this.ShortestRadius);
        System.out.println(this.LongestRadius);
        System.out.println(this.eucdiam.Length());
        System.out.println(this.geodiam.getLength());
        System.out.println(this.geodiam.getVariationDiametraleMoyenne());
        System.out.println(this.nbHoles);
        System.out.println(this.nbCompConnexe);
        System.out.println(this.convexhull.getPerimeter());
        System.out.println(this.convexhull.getSurface());
        System.out.println(this.convexhull.getNcce());
        System.out.println(this.MainAxis01.Length());
        System.out.println(this.SecondAxis02.Length());
    }

    public int getNbCompConnexe() {
        return this.nbCompConnexe;
    }

    public double getAnglePA(boolean Degres) {
        if (Degres) {
            return Math.toDegrees(this.AngleAP1);
        }
        return this.AngleAP1;
    }

    public double getAngleSA(boolean Degres) {
        if (Degres) {
            return Math.toDegrees(this.AngleAP2);
        }
        return this.AngleAP2;
    }

    public double getThicknessD() {
        return this.EpaisseurD;
    }

    public double getThicknessPA() {
        return this.EpaisseurAP1;
    }

    public double getThicknessSA() {
        return this.EpaisseurAP2;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public int getPerimetre() {
        return this.Perimetre;
    }

    public double getLongestRadius() {
        return this.LongestRadius;
    }

    public double getSmallestRadius() {
        return this.ShortestRadius;
    }

    public double getAverageRadius() {
        return this.AverageRadius;
    }

    public int getSurface() {
        return this.Surface;
    }

    public int getNbHoles() {
        return this.nbHoles;
    }
}

