/*
 * Decompiled with CFR 0.152.
 */
package measures;

import arrayTiTi.ArrayConverter;
import arrayTiTi.ArrayFeatures;
import filesAndFolders.fichiersTabules.FichierTabule;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageComparator;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import utils.memory.Allocator;

public class Evaluations {
    private static void FillVotes(BufferedImage im1, BufferedImage im2, int[][] votes, int[] sizes1, int[] sizes2) throws Exception {
        int[] array2;
        int[] array1;
        if (!ImageTools.areDimensionsEqual((BufferedImage)im1, (BufferedImage)im2)) {
            throw new IllegalArgumentException("Images have different dimensions.");
        }
        block0 : switch (im1.getType()) {
            case 10: {
                array1 = ArrayConverter.UnsignedByteToInt((byte[])((DataBufferByte)im1.getRaster().getDataBuffer()).getData());
                break;
            }
            case 11: {
                array1 = ArrayConverter.UnsignedShortToInt((short[])((DataBufferUShort)im1.getRaster().getDataBuffer()).getData());
                break;
            }
            case 0: {
                switch (im1.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        array1 = ((DataBufferInt)im1.getRaster().getDataBuffer()).getData();
                        break block0;
                    }
                }
                throw new Exception("DataBuffer type not supported (yet).");
            }
            default: {
                throw new Exception("Image type not supported (yet).");
            }
        }
        block8 : switch (im2.getType()) {
            case 10: {
                array2 = ArrayConverter.UnsignedByteToInt((byte[])((DataBufferByte)im2.getRaster().getDataBuffer()).getData());
                break;
            }
            case 11: {
                array2 = ArrayConverter.UnsignedShortToInt((short[])((DataBufferUShort)im2.getRaster().getDataBuffer()).getData());
                break;
            }
            case 0: {
                switch (im2.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        array2 = ((DataBufferInt)im2.getRaster().getDataBuffer()).getData();
                        break block8;
                    }
                }
                throw new Exception("DataBuffer type not supported (yet).");
            }
            default: {
                throw new Exception("Image type not supported (yet).");
            }
        }
        int width = im1.getWidth();
        int height = im1.getHeight();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                int[] nArray = votes[array1[pos]];
                int n = array2[pos];
                nArray[n] = nArray[n] + 1;
                int n2 = array1[pos];
                sizes1[n2] = sizes1[n2] + 1;
                int n3 = array2[pos];
                sizes2[n3] = sizes2[n3] + 1;
                ++x;
                ++pos;
            }
        }
    }

    public static void Detection(String Prediction, String GroundTruth, float Overlap, String SaveImageAs, String csv) throws Exception {
        BufferedImage imPred = ImageIO.Read(Prediction);
        BufferedImage imGT = ImageIO.Read(GroundTruth);
        DetectionResults dr = Evaluations.Detection(imPred, imGT, Overlap, SaveImageAs);
        System.out.println(dr.Accuracy + ", " + dr.Sensitivity + ", " + dr.Precision);
        if (csv != null && !csv.isEmpty()) {
            FichierTabule results = new FichierTabule(1, new int[]{1, 1, 1}, "");
            results.setColumnsNames(new String[]{"Accuracy", "Sensitivity", "Precision"});
            results.setValue(0, 0, dr.Accuracy);
            results.setValue(0, 1, dr.Sensitivity);
            results.setValue(0, 2, dr.Precision);
            results.Write(csv, false, ",");
            results.Kill();
            results = null;
        }
        imGT = null;
        imPred = null;
        dr = null;
    }

    public static DetectionResults Detection(String Prediction, String GroundTruth, float Overlap, String SaveImageAs) throws Exception {
        BufferedImage imPred = ImageIO.Read(Prediction);
        BufferedImage imGT = ImageIO.Read(GroundTruth);
        return Evaluations.Detection(imPred, imGT, Overlap, SaveImageAs);
    }

    public static DetectionResults Detection(BufferedImage Prediction, BufferedImage GroundTruth, float Overlap, String SaveImageAs) throws Exception {
        float Precision;
        int index;
        int width = Prediction.getWidth();
        int height = Prediction.getHeight();
        ArrayFeatures AF = new ArrayFeatures();
        ImageFeatures IF = new ImageFeatures();
        int nbPred = (int)IF.Maximum(Prediction) + 1;
        int nbGT = (int)IF.Maximum(GroundTruth) + 1;
        int[][] votes = new int[nbGT][nbPred];
        int[] sizesGT = new int[nbGT];
        int[] sizesPred = new int[nbPred];
        Evaluations.FillVotes(GroundTruth, Prediction, votes, sizesGT, sizesPred);
        int TP = 0;
        int TN = 0;
        int FP = 0;
        int FN = 0;
        boolean[] FNs = new boolean[nbGT];
        boolean[] TPs = new boolean[nbGT];
        boolean[] FPs = new boolean[nbPred];
        for (int y = 1; y < nbGT; ++y) {
            if (0 >= sizesGT[y]) continue;
            index = AF.MaximumIndex(votes[y]);
            if (index == 0 || (float)votes[y][index] / (float)sizesGT[y] < Overlap) {
                ++FN;
                FNs[y] = true;
                continue;
            }
            ++TP;
            TPs[y] = true;
        }
        for (int x = 1; x < nbPred; ++x) {
            if (0 >= sizesPred[x]) continue;
            index = 1;
            for (int y = 1; y < votes.length; ++y) {
                if (votes[index][x] >= votes[y][x]) continue;
                index = y;
            }
            if (index != 0 && !((float)votes[index][x] / (float)sizesPred[x] < Overlap)) continue;
            ++FP;
            FPs[x] = true;
        }
        float Acc = (float)(TP + TN) / (float)(TP + TN + FP + FN);
        float Sensitivity = TP + FN == 0 ? Float.NaN : (float)TP / (float)(TP + FN);
        float f = Precision = TP + FP == 0 ? Float.NaN : (float)TP / (float)(TP + FP);
        if (SaveImageAs != null) {
            BufferedImage imres = new BufferedImage(width, height, 5);
            WritableRaster wrres = imres.getRaster();
            WritableRaster wrgt = GroundTruth.getRaster();
            WritableRaster wrpred = Prediction.getRaster();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (TPs[wrgt.getSample(x, y, 0)]) {
                        wrres.setSample(x, y, 0, 255);
                        wrres.setSample(x, y, 1, 255);
                        wrres.setSample(x, y, 2, 255);
                        continue;
                    }
                    if (FNs[wrgt.getSample(x, y, 0)]) {
                        wrres.setSample(x, y, 1, 255);
                        continue;
                    }
                    if (!FPs[wrpred.getSample(x, y, 0)]) continue;
                    wrres.setSample(x, y, 0, 255);
                }
            }
            ImageIO.Write(imres, SaveImageAs, 6);
        }
        return new DetectionResults(Acc, Sensitivity, Precision);
    }

    public static double Dice(BufferedImage Prediction, BufferedImage GroundTruth) {
        double eps = 1.0E-4;
        BufferedImage binpred = ImageNew.Same((BufferedImage)Prediction);
        ImageComparator.Compare((BufferedImage)Prediction, (String)"!=", (int)0, (int)1, (int)0, (BufferedImage)binpred);
        BufferedImage bingt = ImageNew.Same((BufferedImage)Prediction);
        ImageComparator.Compare((BufferedImage)GroundTruth, (String)"!=", (int)0, (int)1, (int)0, (BufferedImage)bingt);
        BufferedImage union = ImageNew.Same((BufferedImage)Prediction);
        ImageComparator.Compare((BufferedImage)binpred, (String)"!=", (int)0, (BufferedImage)binpred, (BufferedImage)bingt, (BufferedImage)union);
        BufferedImage inter = ImageArithmetic.Multiply(binpred, bingt);
        ImageFeatures IF = new ImageFeatures();
        double unionvalue = IF.Integral(union, 0);
        double intervalue = IF.Integral(inter, 0);
        IF = null;
        Allocator alloc = Allocator.Instance();
        binpred = alloc.Release(binpred);
        bingt = alloc.Release(bingt);
        union = alloc.Release(union);
        inter = alloc.Release(inter);
        return intervalue / (unionvalue + 1.0E-4);
    }

    public static class DetectionResults {
        public final float Accuracy;
        public final float Sensitivity;
        public final float Precision;

        public DetectionResults(float Accuracy, float Sensitivity, float Precision) {
            this.Accuracy = Accuracy;
            this.Sensitivity = Sensitivity;
            this.Precision = Precision;
        }
    }
}

