/*
 * Decompiled with CFR 0.152.
 */
package measures;

import dv.DV;
import java.util.ArrayList;
import mathematics.primitives.Box3D;
import mathematics.primitives.pointsTiTi.Coordinate;
import mathematics.primitives.pointsTiTi.CoordinatesManager;

public class BasicMeasures3D {
    private int Volume = 0;
    private int Surface = 0;
    public Box3D BoundingBox = null;
    public CoordinatesManager Boundary = null;
    public Coordinate Centroid = null;
    private int SizeX = -1;
    private int SizeY = -1;
    private int SizeZ = -1;
    protected boolean Last26 = false;

    public void Compute(DV dv, boolean TwentySixConnexe) {
        if (dv.Channel != 1) {
            throw new IllegalArgumentException("Single channel DV required.");
        }
        this.SizeX = dv.SizeX;
        this.SizeY = dv.SizeY;
        this.SizeZ = dv.SizeZ;
        int top = this.SizeX;
        int bottom = -this.SizeX;
        int left = -1;
        int right = 1;
        int front = dv.LayerSize;
        int back = -dv.LayerSize;
        int topleft = top + left;
        int topright = top + right;
        int bottomleft = bottom + left;
        int bottomright = bottom + right;
        int fronttopleft = front + top + left;
        int fronttop = front + top;
        int fronttopright = front + top + right;
        int frontright = front + right;
        int frontbottomright = front + bottom + right;
        int frontbottom = front + bottom;
        int frontbottomleft = front + bottom + left;
        int frontleft = front + left;
        int backtopleft = back + top + left;
        int backtop = back + top;
        int backtopright = back + top + right;
        int backright = back + right;
        int backbottomright = back + bottom + right;
        int backbottom = back + bottom;
        int backbottomleft = back + bottom + left;
        int backleft = back + left;
        if (this.Centroid == null) {
            this.Centroid = new Coordinate(0.0, 0.0, 0.0);
        }
        if (this.BoundingBox == null) {
            this.BoundingBox = new Box3D();
        }
        this.BoundingBox.setAll(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        if (this.Boundary == null) {
            this.Boundary = new CoordinatesManager((ArrayList)null);
        } else {
            this.Boundary.RemoveAll();
            this.Boundary.CatchingArea(0);
        }
        this.Volume = 0;
        int minx = this.SizeX;
        int miny = this.SizeY;
        int minz = this.SizeZ;
        int maxz = 0;
        int maxy = 0;
        int maxx = 0;
        int baryz = 0;
        int baryy = 0;
        int baryx = 0;
        switch (dv.Type) {
            case 8: {
                byte[] bb = dv.getDataBufferByte(0);
                int pos = 0;
                for (int z = 0; z < this.SizeZ; ++z) {
                    for (int y = 0; y < this.SizeY; ++y) {
                        int x = 0;
                        while (x < this.SizeX) {
                            if (0 != bb[pos]) {
                                boolean add = false;
                                ++this.Volume;
                                baryx += x;
                                baryy += y;
                                baryz += z;
                                if (x < minx) {
                                    minx = x;
                                }
                                if (y < miny) {
                                    miny = y;
                                }
                                if (z < minz) {
                                    minz = z;
                                }
                                if (x > maxx) {
                                    maxx = x;
                                }
                                if (y > maxy) {
                                    maxy = y;
                                }
                                if (z > maxz) {
                                    maxz = z;
                                }
                                if (z == 0 || y == 0 || x == 0 || z == this.SizeZ - 1 || y == this.SizeY - 1 || x == this.SizeX - 1) {
                                    add = true;
                                } else {
                                    if (bb[pos + top] == 0) {
                                        add = true;
                                    } else if (bb[pos + right] == 0) {
                                        add = true;
                                    } else if (bb[pos + bottom] == 0) {
                                        add = true;
                                    } else if (bb[pos + left] == 0) {
                                        add = true;
                                    } else if (bb[pos + front] == 0) {
                                        add = true;
                                    } else if (bb[pos + back] == 0) {
                                        add = true;
                                    }
                                    if (!TwentySixConnexe && !add) {
                                        if (bb[pos + topright] == 0) {
                                            add = true;
                                        } else if (bb[pos + topleft] == 0) {
                                            add = true;
                                        } else if (bb[pos + bottomleft] == 0) {
                                            add = true;
                                        } else if (bb[pos + bottomright] == 0) {
                                            add = true;
                                        } else if (bb[pos + backtopright] == 0) {
                                            add = true;
                                        } else if (bb[pos + backtop] == 0) {
                                            add = true;
                                        } else if (bb[pos + backtopleft] == 0) {
                                            add = true;
                                        } else if (bb[pos + backleft] == 0) {
                                            add = true;
                                        } else if (bb[pos + backbottomleft] == 0) {
                                            add = true;
                                        } else if (bb[pos + backbottom] == 0) {
                                            add = true;
                                        } else if (bb[pos + backbottomright] == 0) {
                                            add = true;
                                        } else if (bb[pos + backright] == 0) {
                                            add = true;
                                        } else if (bb[pos + fronttopright] == 0) {
                                            add = true;
                                        } else if (bb[pos + fronttop] == 0) {
                                            add = true;
                                        } else if (bb[pos + fronttopleft] == 0) {
                                            add = true;
                                        } else if (bb[pos + frontleft] == 0) {
                                            add = true;
                                        } else if (bb[pos + frontbottomleft] == 0) {
                                            add = true;
                                        } else if (bb[pos + frontbottom] == 0) {
                                            add = true;
                                        } else if (bb[pos + frontbottomright] == 0) {
                                            add = true;
                                        } else if (bb[pos + frontright] == 0) {
                                            add = true;
                                        }
                                    }
                                }
                                if (add) {
                                    this.Boundary.Add(x, y, z, pos);
                                }
                            }
                            ++x;
                            ++pos;
                        }
                    }
                }
                bb = null;
                break;
            }
            case 16: {
                short[] sb = dv.getDataBufferShort(0);
                int pos = 0;
                for (int z = 0; z < this.SizeZ; ++z) {
                    for (int y = 0; y < this.SizeY; ++y) {
                        int x = 0;
                        while (x < this.SizeX) {
                            if (0 != sb[pos]) {
                                boolean add = false;
                                ++this.Volume;
                                baryx += x;
                                baryy += y;
                                baryz += z;
                                if (x < minx) {
                                    minx = x;
                                }
                                if (y < miny) {
                                    miny = y;
                                }
                                if (z < minz) {
                                    minz = z;
                                }
                                if (x > maxx) {
                                    maxx = x;
                                }
                                if (y > maxy) {
                                    maxy = y;
                                }
                                if (z > maxz) {
                                    maxz = z;
                                }
                                if (z == 0 || y == 0 || x == 0 || z == this.SizeZ - 1 || y == this.SizeY - 1 || x == this.SizeX - 1) {
                                    add = true;
                                } else {
                                    if (sb[pos + top] == 0) {
                                        add = true;
                                    } else if (sb[pos + right] == 0) {
                                        add = true;
                                    } else if (sb[pos + bottom] == 0) {
                                        add = true;
                                    } else if (sb[pos + left] == 0) {
                                        add = true;
                                    } else if (sb[pos + front] == 0) {
                                        add = true;
                                    } else if (sb[pos + back] == 0) {
                                        add = true;
                                    }
                                    if (!TwentySixConnexe && !add) {
                                        if (sb[pos + topright] == 0) {
                                            add = true;
                                        } else if (sb[pos + topleft] == 0) {
                                            add = true;
                                        } else if (sb[pos + bottomleft] == 0) {
                                            add = true;
                                        } else if (sb[pos + bottomright] == 0) {
                                            add = true;
                                        } else if (sb[pos + backtopright] == 0) {
                                            add = true;
                                        } else if (sb[pos + backtop] == 0) {
                                            add = true;
                                        } else if (sb[pos + backtopleft] == 0) {
                                            add = true;
                                        } else if (sb[pos + backleft] == 0) {
                                            add = true;
                                        } else if (sb[pos + backbottomleft] == 0) {
                                            add = true;
                                        } else if (sb[pos + backbottom] == 0) {
                                            add = true;
                                        } else if (sb[pos + backbottomright] == 0) {
                                            add = true;
                                        } else if (sb[pos + backright] == 0) {
                                            add = true;
                                        } else if (sb[pos + fronttopright] == 0) {
                                            add = true;
                                        } else if (sb[pos + fronttop] == 0) {
                                            add = true;
                                        } else if (sb[pos + fronttopleft] == 0) {
                                            add = true;
                                        } else if (sb[pos + frontleft] == 0) {
                                            add = true;
                                        } else if (sb[pos + frontbottomleft] == 0) {
                                            add = true;
                                        } else if (sb[pos + frontbottom] == 0) {
                                            add = true;
                                        } else if (sb[pos + frontbottomright] == 0) {
                                            add = true;
                                        } else if (sb[pos + frontright] == 0) {
                                            add = true;
                                        }
                                    }
                                }
                                if (add) {
                                    this.Boundary.Add(x, y, pos);
                                }
                            }
                            ++x;
                            ++pos;
                        }
                    }
                }
                sb = null;
                break;
            }
            case 32: {
                int[] ib = dv.getDataBufferInt(0);
                int pos = 0;
                for (int z = 0; z < this.SizeZ; ++z) {
                    for (int y = 0; y < this.SizeY; ++y) {
                        int x = 0;
                        while (x < this.SizeX) {
                            if (0 != ib[pos]) {
                                boolean add = false;
                                ++this.Volume;
                                baryx += x;
                                baryy += y;
                                baryz += z;
                                if (x < minx) {
                                    minx = x;
                                }
                                if (y < miny) {
                                    miny = y;
                                }
                                if (z < minz) {
                                    minz = z;
                                }
                                if (x > maxx) {
                                    maxx = x;
                                }
                                if (y > maxy) {
                                    maxy = y;
                                }
                                if (z > maxz) {
                                    maxz = z;
                                }
                                if (z == 0 || y == 0 || x == 0 || z == this.SizeZ - 1 || y == this.SizeY - 1 || x == this.SizeX - 1) {
                                    add = true;
                                } else {
                                    if (ib[pos + top] == 0) {
                                        add = true;
                                    } else if (ib[pos + right] == 0) {
                                        add = true;
                                    } else if (ib[pos + bottom] == 0) {
                                        add = true;
                                    } else if (ib[pos + left] == 0) {
                                        add = true;
                                    } else if (ib[pos + front] == 0) {
                                        add = true;
                                    } else if (ib[pos + back] == 0) {
                                        add = true;
                                    }
                                    if (!TwentySixConnexe && !add) {
                                        if (ib[pos + topright] == 0) {
                                            add = true;
                                        } else if (ib[pos + topleft] == 0) {
                                            add = true;
                                        } else if (ib[pos + bottomleft] == 0) {
                                            add = true;
                                        } else if (ib[pos + bottomright] == 0) {
                                            add = true;
                                        } else if (ib[pos + backtopright] == 0) {
                                            add = true;
                                        } else if (ib[pos + backtop] == 0) {
                                            add = true;
                                        } else if (ib[pos + backtopleft] == 0) {
                                            add = true;
                                        } else if (ib[pos + backleft] == 0) {
                                            add = true;
                                        } else if (ib[pos + backbottomleft] == 0) {
                                            add = true;
                                        } else if (ib[pos + backbottom] == 0) {
                                            add = true;
                                        } else if (ib[pos + backbottomright] == 0) {
                                            add = true;
                                        } else if (ib[pos + backright] == 0) {
                                            add = true;
                                        } else if (ib[pos + fronttopright] == 0) {
                                            add = true;
                                        } else if (ib[pos + fronttop] == 0) {
                                            add = true;
                                        } else if (ib[pos + fronttopleft] == 0) {
                                            add = true;
                                        } else if (ib[pos + frontleft] == 0) {
                                            add = true;
                                        } else if (ib[pos + frontbottomleft] == 0) {
                                            add = true;
                                        } else if (ib[pos + frontbottom] == 0) {
                                            add = true;
                                        } else if (ib[pos + frontbottomright] == 0) {
                                            add = true;
                                        } else if (ib[pos + frontright] == 0) {
                                            add = true;
                                        }
                                    }
                                }
                                if (add) {
                                    this.Boundary.Add(x, y, pos);
                                }
                            }
                            ++x;
                            ++pos;
                        }
                    }
                }
                ib = null;
                break;
            }
            case -32: {
                float[] fb = dv.getDataBufferFloat(0);
                int pos = 0;
                for (int z = 0; z < this.SizeZ; ++z) {
                    for (int y = 0; y < this.SizeY; ++y) {
                        int x = 0;
                        while (x < this.SizeX) {
                            if (0.0f != fb[pos]) {
                                boolean add = false;
                                ++this.Volume;
                                baryx += x;
                                baryy += y;
                                baryz += z;
                                if (x < minx) {
                                    minx = x;
                                }
                                if (y < miny) {
                                    miny = y;
                                }
                                if (z < minz) {
                                    minz = z;
                                }
                                if (x > maxx) {
                                    maxx = x;
                                }
                                if (y > maxy) {
                                    maxy = y;
                                }
                                if (z > maxz) {
                                    maxz = z;
                                }
                                if (z == 0 || y == 0 || x == 0 || z == this.SizeZ - 1 || y == this.SizeY - 1 || x == this.SizeX - 1) {
                                    add = true;
                                } else {
                                    if (fb[pos + top] == 0.0f) {
                                        add = true;
                                    } else if (fb[pos + right] == 0.0f) {
                                        add = true;
                                    } else if (fb[pos + bottom] == 0.0f) {
                                        add = true;
                                    } else if (fb[pos + left] == 0.0f) {
                                        add = true;
                                    } else if (fb[pos + front] == 0.0f) {
                                        add = true;
                                    } else if (fb[pos + back] == 0.0f) {
                                        add = true;
                                    }
                                    if (!TwentySixConnexe && !add) {
                                        if (fb[pos + topright] == 0.0f) {
                                            add = true;
                                        } else if (fb[pos + topleft] == 0.0f) {
                                            add = true;
                                        } else if (fb[pos + bottomleft] == 0.0f) {
                                            add = true;
                                        } else if (fb[pos + bottomright] == 0.0f) {
                                            add = true;
                                        } else if (fb[pos + backtopright] == 0.0f) {
                                            add = true;
                                        } else if (fb[pos + backtop] == 0.0f) {
                                            add = true;
                                        } else if (fb[pos + backtopleft] == 0.0f) {
                                            add = true;
                                        } else if (fb[pos + backleft] == 0.0f) {
                                            add = true;
                                        } else if (fb[pos + backbottomleft] == 0.0f) {
                                            add = true;
                                        } else if (fb[pos + backbottom] == 0.0f) {
                                            add = true;
                                        } else if (fb[pos + backbottomright] == 0.0f) {
                                            add = true;
                                        } else if (fb[pos + backright] == 0.0f) {
                                            add = true;
                                        } else if (fb[pos + fronttopright] == 0.0f) {
                                            add = true;
                                        } else if (fb[pos + fronttop] == 0.0f) {
                                            add = true;
                                        } else if (fb[pos + fronttopleft] == 0.0f) {
                                            add = true;
                                        } else if (fb[pos + frontleft] == 0.0f) {
                                            add = true;
                                        } else if (fb[pos + frontbottomleft] == 0.0f) {
                                            add = true;
                                        } else if (fb[pos + frontbottom] == 0.0f) {
                                            add = true;
                                        } else if (fb[pos + frontbottomright] == 0.0f) {
                                            add = true;
                                        } else if (fb[pos + frontright] == 0.0f) {
                                            add = true;
                                        }
                                    }
                                }
                                if (add) {
                                    this.Boundary.Add(x, y, pos);
                                }
                            }
                            ++x;
                            ++pos;
                        }
                    }
                }
                Object bb = null;
                break;
            }
            case 64: {
                double[] db = dv.getDataBufferDouble(0);
                int pos = 0;
                for (int z = 0; z < this.SizeZ; ++z) {
                    for (int y = 0; y < this.SizeY; ++y) {
                        int x = 0;
                        while (x < this.SizeX) {
                            if (0.0 != db[pos]) {
                                boolean add = false;
                                ++this.Volume;
                                baryx += x;
                                baryy += y;
                                baryz += z;
                                if (x < minx) {
                                    minx = x;
                                }
                                if (y < miny) {
                                    miny = y;
                                }
                                if (z < minz) {
                                    minz = z;
                                }
                                if (x > maxx) {
                                    maxx = x;
                                }
                                if (y > maxy) {
                                    maxy = y;
                                }
                                if (z > maxz) {
                                    maxz = z;
                                }
                                if (z == 0 || y == 0 || x == 0 || z == this.SizeZ - 1 || y == this.SizeY - 1 || x == this.SizeX - 1) {
                                    add = true;
                                } else {
                                    if (db[pos + top] == 0.0) {
                                        add = true;
                                    } else if (db[pos + right] == 0.0) {
                                        add = true;
                                    } else if (db[pos + bottom] == 0.0) {
                                        add = true;
                                    } else if (db[pos + left] == 0.0) {
                                        add = true;
                                    } else if (db[pos + front] == 0.0) {
                                        add = true;
                                    } else if (db[pos + back] == 0.0) {
                                        add = true;
                                    }
                                    if (!TwentySixConnexe && !add) {
                                        if (db[pos + topright] == 0.0) {
                                            add = true;
                                        } else if (db[pos + topleft] == 0.0) {
                                            add = true;
                                        } else if (db[pos + bottomleft] == 0.0) {
                                            add = true;
                                        } else if (db[pos + bottomright] == 0.0) {
                                            add = true;
                                        } else if (db[pos + backtopright] == 0.0) {
                                            add = true;
                                        } else if (db[pos + backtop] == 0.0) {
                                            add = true;
                                        } else if (db[pos + backtopleft] == 0.0) {
                                            add = true;
                                        } else if (db[pos + backleft] == 0.0) {
                                            add = true;
                                        } else if (db[pos + backbottomleft] == 0.0) {
                                            add = true;
                                        } else if (db[pos + backbottom] == 0.0) {
                                            add = true;
                                        } else if (db[pos + backbottomright] == 0.0) {
                                            add = true;
                                        } else if (db[pos + backright] == 0.0) {
                                            add = true;
                                        } else if (db[pos + fronttopright] == 0.0) {
                                            add = true;
                                        } else if (db[pos + fronttop] == 0.0) {
                                            add = true;
                                        } else if (db[pos + fronttopleft] == 0.0) {
                                            add = true;
                                        } else if (db[pos + frontleft] == 0.0) {
                                            add = true;
                                        } else if (db[pos + frontbottomleft] == 0.0) {
                                            add = true;
                                        } else if (db[pos + frontbottom] == 0.0) {
                                            add = true;
                                        } else if (db[pos + frontbottomright] == 0.0) {
                                            add = true;
                                        } else if (db[pos + frontright] == 0.0) {
                                            add = true;
                                        }
                                    }
                                }
                                if (add) {
                                    this.Boundary.Add(x, y, pos);
                                }
                            }
                            ++x;
                            ++pos;
                        }
                    }
                }
                db = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.Surface = this.Boundary.NbPoints();
        this.Centroid.X = (double)baryx / (double)this.Volume;
        this.Centroid.Y = (double)baryy / (double)this.Volume;
        this.Centroid.Z = (double)baryz / (double)this.Volume;
        this.BoundingBox.setAll(minx, miny, minz, maxx, maxy, maxz);
        this.Last26 = TwentySixConnexe;
    }

    public int getVolume() {
        return this.Volume;
    }

    public int getSurface() {
        return this.Surface;
    }
}

