/*
 * Decompiled with CFR 0.152.
 */
package measures;

import arrayTiTi.ArrayOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Iterator;
import mathematics.primitives.Box;
import mathematics.primitives.pointsTiTi.Coordinate;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.CoordinatesManager;

public class BasicMeasures {
    private int Perimeter = 0;
    private int Surface = 0;
    public Box BoundingBox = null;
    public CoordinatesManager Boundary = null;
    public CoordinatesManager ClockWiseBoundary = null;
    public Coordinate Centroid = null;
    protected int SizeX = -1;
    protected int SizeY = -1;
    protected boolean LastEight = false;

    public void Kill() {
        if (this.Boundary != null) {
            this.Boundary.Kill();
        }
        this.Boundary = null;
        if (this.ClockWiseBoundary != null) {
            this.ClockWiseBoundary.Kill();
        }
        this.ClockWiseBoundary = null;
        this.BoundingBox = null;
        this.Centroid = null;
    }

    public void Compute(BufferedImage image, boolean EightConnexe) {
        if (!ImageTools.isGrayLevel((BufferedImage)image) && image.getType() != 12) {
            throw new IllegalArgumentException("Only gray level or binary images supported.");
        }
        int largeur = image.getWidth();
        int hauteur = image.getHeight();
        int top = largeur;
        int bottom = -largeur;
        int left = -1;
        int right = 1;
        int topleft = top + left;
        int topright = top + right;
        int bottomleft = bottom + left;
        int bottomright = bottom + right;
        if (this.Centroid == null) {
            this.Centroid = new Coordinate(0.0, 0.0);
        }
        if (this.BoundingBox == null) {
            this.BoundingBox = new Box();
        }
        this.BoundingBox.SetAll(0, 0, 0, 0);
        if (this.Boundary == null) {
            this.Boundary = new CoordinatesManager((ArrayList)null);
        } else {
            this.Boundary.RemoveAll();
            this.Boundary.CatchingArea(0);
        }
        this.Surface = 0;
        int minx = largeur;
        int miny = hauteur;
        int maxy = 0;
        int maxx = 0;
        int baryy = 0;
        int baryx = 0;
        block0 : switch (image.getType()) {
            case 12: {
                WritableRaster wr = image.getRaster();
                int pos = 0;
                for (int y = 0; y < hauteur; ++y) {
                    int x = 0;
                    while (x < largeur) {
                        if (wr.getSample(x, y, 0) > 0) {
                            boolean add = false;
                            ++this.Surface;
                            baryx += x;
                            baryy += y;
                            if (y < miny) {
                                miny = y;
                            }
                            if (x < minx) {
                                minx = x;
                            }
                            if (y > maxy) {
                                maxy = y;
                            }
                            if (x > maxx) {
                                maxx = x;
                            }
                            if (y == 0 || x == 0 || y == hauteur - 1 || x == largeur - 1) {
                                add = true;
                            } else {
                                if (wr.getSample(x, y + 1, 0) == 0) {
                                    add = true;
                                } else if (wr.getSample(x + 1, y, 0) == 0) {
                                    add = true;
                                } else if (wr.getSample(x, y - 1, 0) == 0) {
                                    add = true;
                                } else if (wr.getSample(x - 1, y, 0) == 0) {
                                    add = true;
                                }
                                if (!EightConnexe && !add) {
                                    if (wr.getSample(x + 1, y + 1, 0) == 0) {
                                        add = true;
                                    } else if (wr.getSample(x + 1, y - 1, 0) == 0) {
                                        add = true;
                                    } else if (wr.getSample(x - 1, y - 1, 0) == 0) {
                                        add = true;
                                    } else if (wr.getSample(x - 1, y + 1, 0) == 0) {
                                        add = true;
                                    }
                                }
                            }
                            if (add) {
                                this.Boundary.Add(x, y, 0, pos);
                            }
                        }
                        ++x;
                        ++pos;
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < hauteur; ++y) {
                    int x = 0;
                    while (x < largeur) {
                        if (bb[pos] != 0) {
                            boolean add = false;
                            ++this.Surface;
                            baryx += x;
                            baryy += y;
                            if (y < miny) {
                                miny = y;
                            }
                            if (x < minx) {
                                minx = x;
                            }
                            if (y > maxy) {
                                maxy = y;
                            }
                            if (x > maxx) {
                                maxx = x;
                            }
                            if (y == 0 || x == 0 || y == hauteur - 1 || x == largeur - 1) {
                                add = true;
                            } else {
                                if (bb[pos + top] == 0) {
                                    add = true;
                                } else if (bb[pos + right] == 0) {
                                    add = true;
                                } else if (bb[pos + bottom] == 0) {
                                    add = true;
                                } else if (bb[pos + left] == 0) {
                                    add = true;
                                }
                                if (!EightConnexe && !add) {
                                    if (bb[pos + topright] == 0) {
                                        add = true;
                                    } else if (bb[pos + topleft] == 0) {
                                        add = true;
                                    } else if (bb[pos + bottomleft] == 0) {
                                        add = true;
                                    } else if (bb[pos + bottomright] == 0) {
                                        add = true;
                                    }
                                }
                            }
                            if (add) {
                                this.Boundary.Add(x, y, 0, pos);
                            }
                        }
                        ++x;
                        ++pos;
                    }
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < hauteur; ++y) {
                    int x = 0;
                    while (x < largeur) {
                        if (sb[pos] != 0) {
                            boolean add = false;
                            ++this.Surface;
                            baryx += x;
                            baryy += y;
                            if (y < miny) {
                                miny = y;
                            }
                            if (x < minx) {
                                minx = x;
                            }
                            if (y > maxy) {
                                maxy = y;
                            }
                            if (x > maxx) {
                                maxx = x;
                            }
                            if (y == 0 || x == 0 || y == hauteur - 1 || x == largeur - 1) {
                                add = true;
                            } else {
                                if (sb[pos + top] == 0) {
                                    add = true;
                                } else if (sb[pos + right] == 0) {
                                    add = true;
                                } else if (sb[pos + bottom] == 0) {
                                    add = true;
                                } else if (sb[pos + left] == 0) {
                                    add = true;
                                }
                                if (!EightConnexe && !add) {
                                    if (sb[pos + topright] == 0) {
                                        add = true;
                                    } else if (sb[pos + topleft] == 0) {
                                        add = true;
                                    } else if (sb[pos + bottomleft] == 0) {
                                        add = true;
                                    } else if (sb[pos + bottomright] == 0) {
                                        add = true;
                                    }
                                }
                            }
                            if (add) {
                                this.Boundary.Add(x, y, 0, pos);
                            }
                        }
                        ++x;
                        ++pos;
                    }
                }
                sb = null;
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int[] ib = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        for (int y = 0; y < hauteur; ++y) {
                            int x = 0;
                            while (x < largeur) {
                                if (ib[pos] != 0) {
                                    boolean add = false;
                                    ++this.Surface;
                                    baryx += x;
                                    baryy += y;
                                    if (y < miny) {
                                        miny = y;
                                    }
                                    if (x < minx) {
                                        minx = x;
                                    }
                                    if (y > maxy) {
                                        maxy = y;
                                    }
                                    if (x > maxx) {
                                        maxx = x;
                                    }
                                    if (y == 0 || x == 0 || y == hauteur - 1 || x == largeur - 1) {
                                        add = true;
                                    } else {
                                        if (ib[pos + top] == 0) {
                                            add = true;
                                        } else if (ib[pos + right] == 0) {
                                            add = true;
                                        } else if (ib[pos + bottom] == 0) {
                                            add = true;
                                        } else if (ib[pos + left] == 0) {
                                            add = true;
                                        }
                                        if (!EightConnexe && !add) {
                                            if (ib[pos + topright] == 0) {
                                                add = true;
                                            } else if (ib[pos + topleft] == 0) {
                                                add = true;
                                            } else if (ib[pos + bottomleft] == 0) {
                                                add = true;
                                            } else if (ib[pos + bottomright] == 0) {
                                                add = true;
                                            }
                                        }
                                    }
                                    if (add) {
                                        this.Boundary.Add(x, y, 0, pos);
                                    }
                                }
                                ++x;
                                ++pos;
                            }
                        }
                        ib = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Custom image type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.Perimeter = this.Boundary.NbPoints();
        this.Centroid.X = (double)baryx / (double)this.Surface;
        this.Centroid.Y = (double)baryy / (double)this.Surface;
        this.BoundingBox.SetAll(minx, miny, maxx, maxy);
        this.LastEight = EightConnexe;
        this.SizeX = image.getWidth();
        this.SizeY = image.getHeight();
    }

    public void ComputeClockWiseBoundary() {
        if (this.Boundary == null) {
            throw new Error("The classical computation must be performed beforehand.");
        }
        boolean[][] Tab = new boolean[this.SizeY][this.SizeX];
        Coordinates p = null;
        Iterator<Coordinates> iter = this.Boundary.Points().iterator();
        if (this.ClockWiseBoundary != null) {
            this.ClockWiseBoundary.RemoveAll();
        }
        this.ClockWiseBoundary = null;
        this.ClockWiseBoundary = new CoordinatesManager((ArrayList)null);
        ArrayOperations.Fill((boolean[][])Tab, (boolean)false);
        while (iter.hasNext()) {
            p = iter.next();
            Tab[p.Y][p.X] = true;
        }
        p = this.Boundary.Point(0);
        int x = p.X;
        int y = p.Y;
        this.ClockWiseBoundary.Add(p);
        Tab[y][x] = false;
        if (x + 1 < Tab[0].length && Tab[y][x + 1]) {
            this.ClockWiseBoundary.Add(x + 1, y, 0, x + 1 + y * this.SizeX);
            Tab[y][x + 1] = false;
            this.Function(Tab, x + 1, y);
        }
        if (this.LastEight && y - 1 > 0 && x + 1 < Tab[0].length && Tab[y - 1][x + 1]) {
            this.ClockWiseBoundary.Add(x + 1, y - 1, 0, x + 1 + (y - 1) * this.SizeX);
            Tab[y - 1][x + 1] = false;
            this.Function(Tab, x + 1, y - 1);
        }
        if (y - 1 > 0 && Tab[y - 1][x]) {
            this.ClockWiseBoundary.Add(x, y - 1, 0, x + (y - 1) * this.SizeX);
            Tab[y - 1][x] = false;
            this.Function(Tab, x, y - 1);
        }
        if (this.LastEight && y - 1 > 0 && x - 1 > 0 && Tab[y - 1][x - 1]) {
            this.ClockWiseBoundary.Add(x - 1, y - 1, 0, x - 1 + (y - 1) * this.SizeX);
            Tab[y - 1][x - 1] = false;
            this.Function(Tab, x - 1, y - 1);
        }
        Tab = null;
    }

    private void Function(boolean[][] Tab, int x, int y) {
        int old;
        do {
            old = this.ClockWiseBoundary.Size();
            if (Tab[y][x - 1]) {
                this.ClockWiseBoundary.Add(x - 1, y, 0, x - 1 + y * this.SizeX);
                Tab[y][--x] = false;
            }
            if (Tab[y][x + 1]) {
                this.ClockWiseBoundary.Add(x + 1, y, 0, x + 1 + y * this.SizeX);
                Tab[y][++x] = false;
            }
            if (Tab[y - 1][x]) {
                this.ClockWiseBoundary.Add(x, y - 1, 0, x + (y - 1) * this.SizeX);
                Tab[--y][x] = false;
            }
            if (Tab[y + 1][x]) {
                this.ClockWiseBoundary.Add(x, y + 1, 0, x + (y + 1) * this.SizeX);
                Tab[++y][x] = false;
            }
            if (!this.LastEight) continue;
            if (Tab[y - 1][x - 1]) {
                this.ClockWiseBoundary.Add(x - 1, y - 1, 0, x - 1 + (y - 1) * this.SizeX);
                Tab[--y][--x] = false;
            }
            if (Tab[y - 1][x + 1]) {
                this.ClockWiseBoundary.Add(x + 1, y - 1, 0, x + 1 + (y - 1) * this.SizeX);
                Tab[--y][++x] = false;
            }
            if (Tab[y + 1][x + 1]) {
                this.ClockWiseBoundary.Add(x + 1, y + 1, 0, x + 1 + (y + 1) * this.SizeX);
                Tab[++y][++x] = false;
            }
            if (!Tab[y + 1][x - 1]) continue;
            this.ClockWiseBoundary.Add(x - 1, y + 1, 0, x - 1 + (y + 1) * this.SizeX);
            Tab[++y][--x] = false;
        } while (old != this.ClockWiseBoundary.Size());
    }

    public int getPerimeter() {
        return this.Perimeter;
    }

    public int getSurface() {
        return this.Surface;
    }
}

