/*
 * Decompiled with CFR 0.152.
 */
package mathematics.statistics;

import java.util.Random;

public class RandomVariates
extends Random {
    private static final long serialVersionUID = 653931303788345831L;

    public RandomVariates() {
    }

    public RandomVariates(long seed) {
        super(seed);
    }

    @Override
    protected int next(int bits) {
        return super.next(bits);
    }

    @Override
    public double nextExponential() {
        return -Math.log(1.0 - super.nextDouble());
    }

    public double nextErlang(int a) {
        if (a < 1) {
            throw new IllegalArgumentException("Shape parameter of Erlang distribution must be greater than 1!");
        }
        double product = 1.0;
        for (int i2 = 1; i2 <= a; ++i2) {
            product *= super.nextDouble();
        }
        return -Math.log(product);
    }

    public double nextGamma(double a) {
        double f1;
        double xl;
        double x2;
        double x1;
        double D1;
        if (a <= 0.0) {
            throw new IllegalArgumentException("Shape parameter of Gamma distribution must be greater than 0!");
        }
        if (a == 1.0) {
            return this.nextExponential();
        }
        if (a < 1.0) {
            double x;
            double condition;
            double b = 1.0 + Math.exp(-1.0) * a;
            do {
                double p;
                if ((p = b * super.nextDouble()) < 1.0) {
                    condition = x = Math.exp(Math.log(p) / a);
                    continue;
                }
                x = -Math.log((b - p) / a);
                condition = (1.0 - a) * Math.log(x);
            } while (this.nextExponential() < condition);
            return x;
        }
        double b = a - 1.0;
        double D = Math.sqrt(b);
        if (a <= 2.0) {
            D1 = b / 2.0;
            x1 = 0.0;
            x2 = D1;
            xl = -1.0;
            f1 = 0.0;
        } else {
            D1 = D - 0.5;
            x2 = b - D1;
            x1 = x2 - D1;
            xl = 1.0 - b / x1;
            f1 = Math.exp(b * Math.log(x1 / b) + 2.0 * D1);
        }
        double f2 = Math.exp(b * Math.log(x2 / b) + D1);
        double x4 = b + D;
        double x5 = x4 + D;
        double xr = 1.0 - b / x5;
        double f4 = Math.exp(b * Math.log(x4 / b) - D);
        double f5 = Math.exp(b * Math.log(x5 / b) - 2.0 * D);
        double p1 = 2.0 * f4 * D;
        double p2 = 2.0 * f2 * D1 + p1;
        double p3 = f5 / xr + p2;
        double p4 = -f1 / xl + p3;
        double w = Double.MAX_VALUE;
        double x = b;
        while (Math.log(w) > b * Math.log(x / b) + b - x) {
            double xp;
            double v;
            double u = super.nextDouble() * p4;
            if (u <= p1) {
                w = u / D - f4;
                if (w <= 0.0) {
                    return b + u / f4;
                }
                if (w <= f5) {
                    return x4 + w * D / f5;
                }
                v = super.nextDouble();
                x = x4 + v * D;
                xp = 2.0 * x4 - x;
                if (w >= f4 + (f4 - 1.0) * (x - x4) / (x4 - b)) {
                    return xp;
                }
                if (w <= f4 + (b / x4 - 1.0) * f4 * (x - x4)) {
                    return x;
                }
                if (w < 2.0 * f4 - 1.0 || w < 2.0 * f4 - Math.exp(b * Math.log(xp / b) + b - xp)) continue;
                return xp;
            }
            if (u <= p2) {
                w = (u - p1) / D1 - f2;
                if (w <= 0.0) {
                    return b - (u - p1) / f2;
                }
                if (w <= f1) {
                    return x1 + w * D1 / f1;
                }
                v = super.nextDouble();
                x = x1 + v * D1;
                xp = 2.0 * x2 - x;
                if (w >= f2 + (f2 - 1.0) * (x - x2) / (x2 - b)) {
                    return xp;
                }
                if (w <= f2 * (x - x1) / D1) {
                    return x;
                }
                if (w < 2.0 * f2 - 1.0 || w < 2.0 * f2 - Math.exp(b * Math.log(xp / b) + b - xp)) continue;
                return xp;
            }
            if (u < p3) {
                w = super.nextDouble();
                if (w <= (xr * (x5 - (x = x5 - Math.log(u = (p3 - u) / (p3 - p2)) / xr)) + 1.0) / u) {
                    return x;
                }
                w = w * f5 * u;
                continue;
            }
            w = super.nextDouble();
            x = x1 - Math.log(u = (p4 - u) / (p4 - p3)) / xl;
            if (x < 0.0) continue;
            if (w <= (xl * (x1 - x) + 1.0) / u) {
                return x;
            }
            w = w * f1 * u;
        }
        return x;
    }
}

