/*
 * Decompiled with CFR 0.152.
 */
package mathematics.statistics;

import displays.Colors;
import filesAndFolders.fichiersTabules.FichierTabule;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageOperations;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import utils.sorts.QuickSort;

public class ROC {
    private int tp;
    private int tn;
    private int fp;
    private int fn;
    private final int colThresh = 0;
    private final int colAcc = 1;
    private final int colSens0 = 2;
    private final int colSpec0 = 3;
    private final int col1mSpec0 = 4;
    private final int colSens1 = 5;
    private final int colSpec1 = 6;
    private final int col1mSpec1 = 7;
    private final int colTP = 8;
    private final int colTN = 9;
    private final int colFP = 10;
    private final int colFN = 11;

    public FichierTabule Compute(FichierTabule file, String class0, String class1) {
        if (file.getWidth() != 2) {
            throw new IllegalArgumentException("The input file must have two columns/attributes: Prediction and Class");
        }
        if (file.ColumnType(0) != 1) {
            throw new IllegalArgumentException("The input file first column must be Double");
        }
        if (file.ColumnType(1) != 2) {
            throw new IllegalArgumentException("The input file last column must be String");
        }
        double[] predictions = (double[])file.getColumnDouble(0).clone();
        String[] classes = (String[])file.getColumnString(1).clone();
        int[] gt = new int[classes.length];
        for (int i2 = 0; i2 < classes.length; ++i2) {
            if (classes[i2].equals(class0)) {
                gt[i2] = 0;
                continue;
            }
            if (classes[i2].equals(class1)) {
                gt[i2] = 1;
                continue;
            }
            throw new IllegalArgumentException("Unknown class: " + classes[i2]);
        }
        QuickSort.Sort(predictions, gt, 0, gt.length - 1);
        String[] colnames = new String[]{"Threshold", "Accuracy", "Sensitivity_" + class1, "Specificity_" + class1, "1-Specificity_" + class1, "Sensitivity_" + class0, "Specificity_" + class0, "1-Specificity_" + class0, "TP", "TN", "FP", "FN"};
        int[] types = new int[12];
        Arrays.fill(types, 0);
        Arrays.fill(types, 0, 8, 1);
        FichierTabule result = new FichierTabule(file.Height() + 1, types, "");
        result.setColumnsNames(colnames);
        int nb = 0;
        for (int i3 = 1; i3 < predictions.length; ++i3) {
            if (predictions[i3 - 1] != predictions[i3]) continue;
            ++nb;
        }
        double[] thresholds = new double[predictions.length + 1 - nb];
        thresholds[0] = predictions[0] - 0.1;
        nb = 1;
        for (int i4 = 1; i4 < predictions.length; ++i4) {
            if (predictions[i4 - 1] == predictions[i4]) continue;
            thresholds[nb++] = (predictions[i4 - 1] + predictions[i4]) / 2.0;
        }
        thresholds[nb] = predictions[predictions.length - 1] + 0.1;
        for (int t = 0; t < thresholds.length; ++t) {
            result.setValue(t, 0, thresholds[t]);
            this.Count(thresholds[t], predictions, gt);
            result.setValue(t, 1, (double)(this.tp + this.tn) / (double)predictions.length);
            result.setValue(t, 2, (double)this.tp / (double)(this.tp + this.fn));
            result.setValue(t, 3, (double)this.tn / (double)(this.tn + this.fp));
            result.setValue(t, 4, 1.0 - result.getValueDouble(t, 3));
            result.setValue(t, 5, (double)this.tn / (double)(this.tn + this.fp));
            result.setValue(t, 6, (double)this.tp / (double)(this.tp + this.fn));
            result.setValue(t, 7, 1.0 - result.getValueDouble(t, 6));
            result.setValue(t, 8, this.tp);
            result.setValue(t, 9, this.tn);
            result.setValue(t, 10, this.fp);
            result.setValue(t, 11, this.fn);
        }
        return result;
    }

    private void Count(double threshold, double[] predictions, int[] classes) {
        this.fn = 0;
        this.fp = 0;
        this.tn = 0;
        this.tp = 0;
        for (int i2 = 0; i2 < predictions.length; ++i2) {
            if (predictions[i2] < threshold) {
                if (classes[i2] == 0) {
                    ++this.tn;
                    continue;
                }
                ++this.fn;
                continue;
            }
            if (classes[i2] == 1) {
                ++this.tp;
                continue;
            }
            ++this.fp;
        }
    }

    public double AUROC(FichierTabule file, int nummclass) {
        int end;
        int start;
        int colspec;
        int colsens;
        if (file.getWidth() != 12) {
            throw new IllegalArgumentException("The file must contains 12 columns/attributes.");
        }
        switch (nummclass) {
            case 0: {
                colsens = 2;
                colspec = 4;
                break;
            }
            case 1: {
                colsens = 5;
                colspec = 7;
                break;
            }
            default: {
                throw new IllegalArgumentException("The class number must be 0 or 1.");
            }
        }
        for (start = 0; start < file.Height() && file.getValueDouble(start, colspec) == 1.0; ++start) {
        }
        if (0 < start) {
            --start;
        }
        for (end = file.Height() - 1; 0 <= end && file.getValueDouble(end, colspec) == 0.0; --end) {
        }
        if (end < file.Height() - 1) {
            ++end;
        }
        if (start == end) {
            return 1.0;
        }
        double area = 0.0;
        for (int t = start + 1; t <= end; ++t) {
            double sens0 = file.getValueDouble(t - 1, colsens);
            double spec0 = file.getValueDouble(t - 1, colspec);
            double sens1 = file.getValueDouble(t, colsens);
            double spec1 = file.getValueDouble(t, colspec);
            area += sens1 * Math.abs(spec0 - spec1);
            area += Math.abs(sens0 - sens1) * Math.abs(spec0 - spec1) / 2.0;
        }
        return area;
    }

    public BufferedImage DrawROC(FichierTabule file, int nummclass, int size, int margin) {
        int colspec;
        int colsens;
        if (file.getWidth() != 12) {
            throw new IllegalArgumentException("The file must contains 12 columns/attributes.");
        }
        if (margin < 0) {
            throw new IllegalArgumentException("The margin must be positive.");
        }
        switch (nummclass) {
            case 0: {
                colsens = 2;
                colspec = 4;
                break;
            }
            case 1: {
                colsens = 5;
                colspec = 7;
                break;
            }
            default: {
                throw new IllegalArgumentException("The class number must be 0 or 1.");
            }
        }
        int marge = 2 * margin;
        int window = size - marge;
        BufferedImage roc = new BufferedImage(marge + 100, marge + 100, 10);
        ImageOperations.Fill((BufferedImage)roc, (int)255, (int)255, (int)255);
        ImageDrawer.Line(roc, margin, margin, roc.getWidth() - margin, margin, 0, Colors.BLACK);
        ImageDrawer.Line(roc, margin, margin, margin, roc.getHeight() - margin, 0, Colors.BLACK);
        for (int t = 1; t < file.Height(); ++t) {
            int x0 = margin + (int)(file.getValueDouble(t - 1, colspec) * (double)window + 0.5);
            int y0 = margin + (int)(file.getValueDouble(t - 1, colsens) * (double)window + 0.5);
            int x1 = margin + (int)(file.getValueDouble(t, colspec) * (double)window + 0.5);
            int y1 = margin + (int)(file.getValueDouble(t, colsens) * (double)window + 0.5);
            ImageDrawer.Line(roc, x0, y0, x1, y1, marge, Colors.BLUE);
        }
        return roc;
    }
}

