/*
 * Decompiled with CFR 0.152.
 */
package mathematics.statistics;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayComparator;
import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayIO;
import arrayTiTi.ArrayOperations;
import flanagan.analysis.Outliers;
import java.util.ArrayList;
import java.util.Arrays;
import mathematics.statistics.Normality;
import mathematics.statistics.ToNormality;
import utils.sorts.QuickSort;

public final class OutliersDetectors {
    public static String separator = null;
    public static double[][] DixonCriticalValues = new double[][]{{0.886, 0.679, 0.557, 0.482, 0.434, 0.479, 0.441, 0.409, 0.517, 0.49, 0.467, 0.492, 0.472, 0.454, 0.438, 0.424, 0.412, 0.401, 0.391, 0.382, 0.374, 0.367, 0.36}, {0.941, 0.765, 0.642, 0.56, 0.507, 0.554, 0.512, 0.477, 0.576, 0.546, 0.521, 0.546, 0.525, 0.507, 0.49, 0.475, 0.462, 0.45, 0.44, 0.43, 0.421, 0.413, 0.406}, {0.988, 0.889, 0.78, 0.698, 0.637, 0.683, 0.635, 0.597, 0.679, 0.642, 0.615, 0.641, 0.616, 0.595, 0.577, 0.561, 0.547, 0.535, 0.524, 0.514, 0.505, 0.497, 0.489}};
    public static double[][] DiscordanceCriticalValues = new double[][]{{1.155, 1.492, 1.749, 1.944, 2.097, 2.221, 2.323, 2.41, 2.485, 2.55, 2.607, 2.659, 2.705, 2.747, 2.785, 2.821, 2.854, 2.884, 2.912, 2.939, 2.963, 2.987, 3.009, 3.029, 3.049, 3.068, 3.085, 3.103, 3.119, 3.135, 3.15, 3.164, 3.178, 3.191, 3.204, 3.216, 3.228, 3.24, 3.251, 3.261, 3.271, 3.282, 3.292, 3.302, 3.31, 3.319, 3.329, 3.336}, {1.153, 1.463, 1.672, 1.822, 1.938, 2.032, 2.11, 2.176, 2.234, 2.285, 2.331, 2.371, 2.409, 2.443, 2.475, 2.504, 2.532, 2.557, 2.58, 2.603, 2.624, 2.644, 2.663, 2.681, 2.698, 2.714, 2.73, 2.745, 2.759, 2.773, 2.786, 2.799, 2.811, 2.823, 2.835, 2.846, 2.857, 2.866, 2.877, 2.887, 2.896, 2.905, 2.914, 2.923, 2.931, 2.94, 2.948, 2.956}};
    public static double[][][] RosnerCriticalValues = new double[][][]{new double[][]{{2.82, 2.8, 2.78, 2.76, 2.73, 2.59}, {3.14, 3.11, 3.09, 3.06, 3.03, 2.85}}, new double[][]{{2.84, 2.82, 2.8, 2.78, 2.76, 2.62}, {3.16, 3.14, 3.11, 3.09, 3.06, 2.89}}, new double[][]{{2.86, 2.84, 2.82, 2.8, 2.78, 2.65}, {3.18, 3.16, 3.14, 3.11, 3.09, 2.93}}, new double[][]{{2.88, 2.86, 2.84, 2.82, 2.8, 2.68}, {3.2, 3.18, 3.16, 3.14, 3.11, 2.97}}, new double[][]{{2.89, 2.88, 2.86, 2.84, 2.82, 2.71}, {3.22, 3.2, 3.18, 3.16, 3.14, 3.0}}, new double[][]{{2.91, 2.89, 2.88, 2.86, 2.84, 2.73}, {3.24, 3.22, 3.2, 3.18, 3.16, 3.03}}, new double[][]{{2.92, 2.91, 2.89, 2.88, 2.86, 2.76}, {3.25, 3.24, 3.22, 3.2, 3.18, 3.06}}, new double[][]{{2.94, 2.92, 2.91, 2.89, 2.88, 2.78}, {3.27, 3.25, 3.24, 3.22, 3.2, 3.09}}, new double[][]{{2.95, 2.94, 2.92, 2.91, 2.89, 2.8}, {3.29, 3.27, 3.25, 3.24, 3.22, 3.11}}, new double[][]{{2.97, 2.95, 2.94, 2.92, 2.91, 2.82}, {3.3, 3.29, 3.27, 3.25, 3.24, 3.14}}, new double[][]{{2.98, 2.97, 2.95, 2.94, 2.92, 2.84}, {3.32, 3.3, 3.29, 3.27, 3.25, 3.16}}, new double[][]{{2.99, 2.98, 2.97, 2.95, 2.94, 2.86}, {3.33, 3.32, 3.3, 3.29, 3.27, 3.18}}, new double[][]{{3.0, 2.99, 2.98, 2.97, 2.95, 2.88}, {3.34, 3.33, 3.32, 3.3, 3.29, 3.2}}, new double[][]{{3.01, 3.0, 2.99, 2.98, 2.97, 2.91}, {3.36, 3.34, 3.33, 3.32, 3.3, 3.22}}, new double[][]{{3.03, 3.01, 3.0, 2.99, 2.98, 2.91}, {3.37, 3.36, 3.34, 3.33, 3.32, 3.24}}, new double[][]{{3.04, 3.03, 3.01, 3.0, 2.99, 2.92}, {3.38, 3.37, 3.36, 3.34, 3.33, 3.25}}, new double[][]{{3.05, 3.04, 3.03, 3.01, 3.0, 2.94}, {3.39, 3.38, 3.37, 3.36, 3.34, 3.27}}, new double[][]{{3.06, 3.05, 3.04, 3.03, 3.01, 2.95}, {3.4, 3.39, 3.38, 3.37, 3.36, 3.29}}, new double[][]{{3.07, 3.06, 3.05, 3.04, 3.03, 2.97}, {3.41, 3.4, 3.39, 3.38, 3.37, 3.3}}, new double[][]{{3.08, 3.07, 3.06, 3.05, 3.04, 2.98}, {3.43, 3.41, 3.4, 3.39, 3.38, 3.32}}, new double[][]{{3.09, 3.08, 3.07, 3.06, 3.05, 2.99}, {3.44, 3.43, 3.41, 3.4, 3.39, 3.33}}, new double[][]{{3.09, 3.09, 3.08, 3.07, 3.06, 3.0}, {3.45, 3.44, 3.43, 3.41, 3.4, 3.34}}, new double[][]{{3.1, 3.09, 3.09, 3.08, 3.07, 3.01}, {3.46, 3.45, 3.44, 3.43, 3.41, 3.36}}, new double[][]{{3.11, 3.1, 3.09, 3.09, 3.08, 3.03}, {3.46, 3.46, 3.45, 3.44, 3.43, 3.37}}, new double[][]{{3.12, 3.11, 3.1, 3.09, 3.09, 3.04}, {3.47, 3.46, 3.46, 3.45, 3.44, 3.38}}, new double[][]{{3.13, 3.12, 3.11, 3.1, 3.09, 3.05}, {3.48, 3.47, 3.46, 3.46, 3.45, 3.39}}, new double[][]{{3.2, 3.19, 3.19, 3.18, 3.17, 3.14}, {3.56, 3.55, 3.55, 3.54, 3.53, 3.49}}, new double[][]{{3.26, 3.25, 3.25, 3.24, 3.24, 3.21}, {3.62, 3.62, 3.61, 3.6, 3.6, 3.57}}, new double[][]{{3.31, 3.3, 3.3, 3.29, 3.29, 3.26}, {3.67, 3.67, 3.66, 3.66, 3.65, 3.63}}, new double[][]{{3.35, 3.34, 3.34, 3.34, 3.33, 3.31}, {3.72, 3.71, 3.71, 3.7, 3.7, 3.68}}, new double[][]{{3.38, 3.38, 3.38, 3.37, 3.37, 3.35}, {3.75, 3.75, 3.75, 3.74, 3.74, 3.72}}, new double[][]{{3.52, 3.51, 3.51, 3.51, 3.51, 3.5}, {3.89, 3.89, 3.89, 3.88, 3.88, 3.87}}, new double[][]{{3.61, 3.6, 3.6, 3.6, 3.6, 3.59}, {3.98, 3.98, 3.97, 3.97, 3.97, 3.96}}, new double[][]{{3.67, 3.67, 3.67, 3.67, 3.67, 3.66}, {4.04, 4.04, 4.04, 4.04, 4.04, 4.03}}, new double[][]{{3.72, 3.72, 3.72, 3.72, 3.72, 3.71}, {4.09, 4.09, 4.09, 4.09, 4.09, 4.09}}, new double[][]{{3.77, 3.76, 3.76, 3.76, 3.76, 3.76}, {4.14, 4.13, 4.13, 4.13, 4.13, 4.13}}, new double[][]{{3.8, 3.8, 3.8, 3.8, 3.8, 3.8}, {4.17, 4.17, 4.17, 4.17, 4.17, 4.16}}, new double[][]{{3.84, 3.83, 3.83, 3.83, 3.83, 3.83}, {4.2, 4.2, 4.2, 4.2, 4.2, 4.2}}, new double[][]{{3.86, 3.86, 3.86, 3.86, 3.86, 3.86}, {4.23, 4.23, 4.23, 4.23, 4.23, 4.22}}};

    public static void Detection(double[] values, int MaxOutliers, double alpha, boolean fastmode, int percentage, boolean[] outliers) {
        int threshold;
        if (values.length != outliers.length) {
            throw new IllegalArgumentException("values.length != outliers.length");
        }
        if (percentage <= 0 || 100 < percentage) {
            throw new IllegalArgumentException("Wrong value for the percentage.");
        }
        int N = values.length;
        int[] votes = new int[N];
        int nbtests = OutliersDetectors.Detection(values, MaxOutliers, alpha, fastmode, votes);
        switch (nbtests) {
            case 1: 
            case 2: {
                threshold = nbtests;
                break;
            }
            default: {
                threshold = (int)((double)percentage / 100.0 * (double)nbtests + 0.999);
            }
        }
        ArrayComparator.Compare((int[])votes, (String)">=", (int)threshold, (boolean)true, (boolean)false, (boolean[])outliers);
        if (separator != null) {
            ArrayIO.Display(outliers, "Outliers     ", separator);
        }
        votes = null;
    }

    public static int Detection(double[] values, int MaxOutliers, double alpha, boolean fastmode, int[] votes) {
        if (values.length != votes.length) {
            throw new IllegalArgumentException("values.length != votes.length");
        }
        int N = values.length;
        boolean[] outliers = new boolean[N];
        Arrays.fill(votes, 0);
        OutliersDetectors.BoxPlot(values, MaxOutliers, outliers);
        ArrayArithmetic.Add((int[])votes, (boolean[])outliers, (int[])votes);
        if (separator != null) {
            ArrayIO.Display(outliers, "Box-Plot     ", separator);
        }
        int count = 1;
        if (OutliersDetectors.Discordance(values, MaxOutliers, alpha, outliers)) {
            ArrayArithmetic.Add((int[])votes, (boolean[])outliers, (int[])votes);
            ++count;
            if (separator != null) {
                ArrayIO.Display(outliers, "Discordance  ", separator);
            }
        }
        if (OutliersDetectors.Dixon(values, MaxOutliers, alpha, outliers)) {
            ArrayArithmetic.Add((int[])votes, (boolean[])outliers, (int[])votes);
            ++count;
            if (separator != null) {
                ArrayIO.Display(outliers, "Dixon        ", separator);
            }
        }
        if (!fastmode && OutliersDetectors.DixonQ(values, MaxOutliers, outliers)) {
            ArrayArithmetic.Add((int[])votes, (boolean[])outliers, (int[])votes);
            if (separator != null) {
                ArrayIO.Display(outliers, "Dixon-Q      ", separator);
            }
        }
        if (!fastmode && OutliersDetectors.ESD(values, MaxOutliers, outliers)) {
            ArrayArithmetic.Add((int[])votes, (boolean[])outliers, (int[])votes);
            ++count;
            if (separator != null) {
                ArrayIO.Display(outliers, "ESD          ", separator);
            }
        }
        if (!fastmode && OutliersDetectors.Grubbs(values, MaxOutliers, outliers)) {
            ArrayArithmetic.Add((int[])votes, (boolean[])outliers, (int[])votes);
            ++count;
            if (separator != null) {
                ArrayIO.Display(outliers, "Grubbs       ", separator);
            }
        }
        if (OutliersDetectors.Rosner(values, MaxOutliers, alpha, outliers)) {
            ArrayArithmetic.Add((int[])votes, (boolean[])outliers, (int[])votes);
            ++count;
            if (separator != null) {
                ArrayIO.Display(outliers, "Rosner       ", separator);
            }
        }
        if (!fastmode && OutliersDetectors.TietjenMoore(values, MaxOutliers, outliers)) {
            ArrayArithmetic.Add((int[])votes, (boolean[])outliers, (int[])votes);
            ++count;
            if (separator != null) {
                ArrayIO.Display(outliers, "Tietjen-Moore", separator);
            }
        }
        if (OutliersDetectors.Walsh(values, MaxOutliers, alpha, outliers)) {
            ArrayArithmetic.Add((int[])votes, (boolean[])outliers, (int[])votes);
            ++count;
            if (separator != null) {
                ArrayIO.Display(outliers, "Walsh        ", separator);
            }
        }
        if (separator != null) {
            ArrayIO.Display(votes, "Votes        ", separator);
        }
        outliers = null;
        return count;
    }

    public static void BoxPlot(double[] values, int MaxOutliers, boolean[] outliers) {
        OutliersDetectors.BoxPlot(values, MaxOutliers, 1.5, outliers);
    }

    public static void BoxPlot(double[] values, int MaxOutliers, double alpha, boolean[] outliers) {
        if (alpha < 0.0) {
            throw new IllegalArgumentException("alpha < 0");
        }
        if (values.length != outliers.length) {
            throw new IllegalArgumentException("values.length != outliers.length");
        }
        ArrayFeatures AF = new ArrayFeatures();
        AF.Ranks(values);
        double Q1 = AF.Rank25();
        double Q3 = AF.Rank75();
        double QI = Q3 - Q1;
        double min = Q1 - alpha * QI;
        double max = Q3 + alpha * QI;
        Arrays.fill(outliers, false);
        for (int v = 0; v < values.length; ++v) {
            if (!(values[v] < min) && !(max < values[v])) continue;
            outliers[v] = true;
        }
        int nb = AF.Integral(outliers);
        if (0 < MaxOutliers && MaxOutliers < nb) {
            double[] distances = new double[nb];
            int[] indexes = new int[nb];
            int pos = 0;
            for (int i2 = 0; i2 < values.length; ++i2) {
                if (!outliers[i2]) continue;
                distances[pos] = values[i2] < min ? Math.abs(values[i2] - min) : Math.abs(values[i2] - max);
                indexes[pos] = i2;
                ++pos;
            }
            do {
                int index = AF.MinimumIndex(distances);
                distances[index] = Double.MAX_VALUE;
                outliers[indexes[index]] = false;
            } while (MaxOutliers < --nb);
            distances = null;
            indexes = null;
        }
        AF = null;
    }

    public static void BoxPlot(float[] values, int MaxOutliers, boolean[] outliers) {
        OutliersDetectors.BoxPlot(values, MaxOutliers, 1.5, outliers);
    }

    public static void BoxPlot(float[] values, int MaxOutliers, double alpha, boolean[] outliers) {
        if (alpha < 0.0) {
            throw new IllegalArgumentException("alpha < 0");
        }
        if (values.length != outliers.length) {
            throw new IllegalArgumentException("values.length != outliers.length");
        }
        ArrayFeatures AF = new ArrayFeatures();
        AF.Ranks(values);
        double Q1 = AF.Rank25();
        double Q3 = AF.Rank75();
        double QI = Q3 - Q1;
        float min = (float)(Q1 - alpha * QI);
        float max = (float)(Q3 + alpha * QI);
        Arrays.fill(outliers, false);
        for (int v = 0; v < values.length; ++v) {
            if (!(values[v] < min) && !(max < values[v])) continue;
            outliers[v] = true;
        }
        int nb = AF.Integral(outliers);
        if (0 < MaxOutliers && MaxOutliers < nb) {
            double[] distances = new double[nb];
            int[] indexes = new int[nb];
            int pos = 0;
            for (int i2 = 0; i2 < values.length; ++i2) {
                if (!outliers[i2]) continue;
                distances[pos] = values[i2] < min ? (double)Math.abs(values[i2] - min) : (double)Math.abs(values[i2] - max);
                indexes[pos] = i2;
                ++pos;
            }
            do {
                int index = AF.MinimumIndex(distances);
                distances[index] = Double.MAX_VALUE;
                outliers[indexes[index]] = false;
            } while (MaxOutliers < --nb);
            distances = null;
            indexes = null;
        }
        AF = null;
    }

    public static void BoxPlot(int[] values, int MaxOutliers, boolean[] outliers) {
        OutliersDetectors.BoxPlot(values, MaxOutliers, 1.5, outliers);
    }

    public static void BoxPlot(int[] values, int MaxOutliers, double alpha, boolean[] outliers) {
        if (alpha < 0.0) {
            throw new IllegalArgumentException("alpha < 0");
        }
        if (values.length != outliers.length) {
            throw new IllegalArgumentException("values.length != outliers.length");
        }
        ArrayFeatures AF = new ArrayFeatures();
        AF.Ranks(values);
        double Q1 = AF.Rank25();
        double Q3 = AF.Rank75();
        double QI = Q3 - Q1;
        int min = (int)Math.round(Q1 - alpha * QI);
        int max = (int)Math.round(Q3 + alpha * QI);
        Arrays.fill(outliers, false);
        for (int v = 0; v < values.length; ++v) {
            if (values[v] >= min && max >= values[v]) continue;
            outliers[v] = true;
        }
        int nb = AF.Integral(outliers);
        if (0 < MaxOutliers && MaxOutliers < nb) {
            double[] distances = new double[nb];
            int[] indexes = new int[nb];
            int pos = 0;
            for (int i2 = 0; i2 < values.length; ++i2) {
                if (!outliers[i2]) continue;
                distances[pos] = values[i2] < min ? Math.abs((double)values[i2] - (double)min) : Math.abs((double)values[i2] - (double)max);
                indexes[pos] = i2;
                ++pos;
            }
            do {
                int index = AF.MinimumIndex(distances);
                distances[index] = Double.MAX_VALUE;
                outliers[indexes[index]] = false;
            } while (MaxOutliers < --nb);
            distances = null;
            indexes = null;
        }
        AF = null;
    }

    public static boolean Dixon(double[] values, int MaxOutliers, double alpha, boolean[] outliers) {
        boolean res;
        if (values.length != outliers.length) {
            throw new IllegalArgumentException("values.length != outliers.length");
        }
        if (MaxOutliers <= 0) {
            throw new IllegalArgumentException("MaxOutliers <= 0");
        }
        if (values.length < 3 || 25 < values.length) {
            return false;
        }
        double[] clone = (double[])values.clone();
        int[] positions = new int[clone.length];
        ArrayOperations.FillIncreasingly((int[])positions);
        QuickSort.Sort(clone, positions, 0, clone.length - 1);
        Arrays.fill(outliers, false);
        int N = values.length;
        int from = 0;
        int to = N;
        int iter = 0;
        do {
            res = OutliersDetectors.DixonTest(clone, from, to, alpha, outliers);
            ++iter;
            if (outliers[from]) {
                ++from;
            }
            if (!outliers[to - 1]) continue;
            --to;
        } while (res && iter < MaxOutliers);
        ArrayFeatures AF = new ArrayFeatures();
        int nbout = AF.Integral(outliers);
        double[] array = new double[N - nbout];
        int nb = 0;
        for (int v = 0; v < N; ++v) {
            if (outliers[v]) continue;
            array[nb++] = clone[v];
        }
        if (!Normality.Normality(array, alpha)) {
            double[] normal = ToNormality.BoxCox(clone, true);
            Arrays.fill(outliers, false);
            from = 0;
            iter = 0;
            to = N;
            do {
                res = OutliersDetectors.DixonTest(normal, from, to, alpha, outliers);
                ++iter;
                if (outliers[from]) {
                    ++from;
                }
                if (!outliers[to - 1]) continue;
                --to;
            } while (res && iter < MaxOutliers);
            nbout = AF.Integral(outliers);
            array = null;
            array = new double[N - nbout];
            int nb2 = 0;
            for (int v = 0; v < N; ++v) {
                if (outliers[v]) continue;
                array[nb2++] = normal[v];
            }
            normal = null;
            if (!Normality.Normality(array, alpha)) {
                return false;
            }
        }
        QuickSort.Sort(positions, outliers, 0, clone.length - 1);
        clone = null;
        array = null;
        AF = null;
        return true;
    }

    private static boolean DixonTest(double[] clone, int from, int to, double alpha, boolean[] outliers) {
        int N = to - from;
        double Cmax = 0.0;
        double Cmin = 0.0;
        if (3 <= N && N <= 7) {
            Cmin = (clone[from + 1] - clone[from]) / (clone[N - 1] - clone[from]);
        } else if (8 <= N && N <= 10) {
            Cmin = (clone[from + 1] - clone[from]) / (clone[N - 2] - clone[from]);
        } else if (11 <= N && N <= 13) {
            Cmin = (clone[from + 2] - clone[from]) / (clone[N - 2] - clone[from]);
        } else if (14 <= N && N <= 25) {
            Cmin = (clone[from + 2] - clone[from]) / (clone[N - 3] - clone[from]);
        } else {
            throw new IllegalArgumentException("Must not occur.");
        }
        if (3 <= N && N <= 7) {
            Cmax = (clone[to - 1] - clone[to - 2]) / (clone[N - 1] - clone[from]);
        } else if (8 <= N && N <= 10) {
            Cmax = (clone[to - 1] - clone[to - 2]) / (clone[N - 1] - clone[from + 1]);
        } else if (11 <= N && N <= 13) {
            Cmax = (clone[to - 1] - clone[to - 3]) / (clone[N - 1] - clone[from + 1]);
        } else if (14 <= N && N <= 25) {
            Cmax = (clone[to - 1] - clone[to - 3]) / (clone[N - 1] - clone[from + 2]);
        }
        int row = 0;
        if (alpha == 0.1) {
            row = 0;
        } else if (alpha == 0.05) {
            row = 1;
        } else if (alpha == 0.01) {
            row = 2;
        } else {
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        outliers[from] = DixonCriticalValues[row][N - 3] < Cmin;
        boolean bl = outliers[to - 1] = DixonCriticalValues[row][N - 3] < Cmax;
        if (!outliers[from] && !outliers[to - 1]) {
            return false;
        }
        if (outliers[from] && outliers[to - 1]) {
            if (Cmin < Cmax) {
                outliers[to - 1] = false;
            } else {
                outliers[from] = false;
            }
        }
        return true;
    }

    public static boolean Discordance(double[] values, int MaxOutliers, double alpha, boolean[] outliers) {
        boolean res;
        if (values.length != outliers.length) {
            throw new IllegalArgumentException("values.length != outliers.length");
        }
        if (50 < values.length) {
            return false;
        }
        if (MaxOutliers <= 0) {
            throw new IllegalArgumentException("MaxOutliers <= 0");
        }
        double[] clone = Normality.Normality(values, alpha) ? (double[])values.clone() : ToNormality.BoxCox(values, true);
        int[] positions = new int[clone.length];
        ArrayOperations.FillIncreasingly((int[])positions);
        QuickSort.Sort(clone, positions, 0, clone.length - 1);
        if (!Normality.Normality(clone, alpha)) {
            clone = null;
            positions = null;
            return false;
        }
        Arrays.fill(outliers, false);
        int N = values.length;
        int from = 0;
        int to = N;
        int iter = 0;
        do {
            res = OutliersDetectors.DiscordanceTest(clone, from, to, alpha, outliers);
            ++iter;
            if (outliers[from]) {
                ++from;
            }
            if (!outliers[to - 1]) continue;
            --to;
        } while (res && iter < MaxOutliers);
        QuickSort.Sort(positions, outliers, 0, clone.length - 1);
        clone = null;
        positions = null;
        return true;
    }

    private static boolean DiscordanceTest(double[] clone, int from, int to, double alpha, boolean[] outliers) {
        int N = to - from;
        ArrayFeatures AF = new ArrayFeatures();
        AF.Moments(clone, from, to);
        double Dmin = (AF.Average() - clone[from]) / AF.SampleStandardDeviation();
        double Dmax = (AF.Average() - clone[to - 1]) / AF.SampleStandardDeviation();
        int row = 0;
        if (alpha == 0.01) {
            row = 0;
        } else if (alpha == 0.05) {
            row = 1;
        } else {
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        outliers[from] = DiscordanceCriticalValues[row][N - 3] < Dmin;
        boolean bl = outliers[to - 1] = DiscordanceCriticalValues[row][N - 3] < Dmax;
        if (!outliers[from] && !outliers[to - 1]) {
            return false;
        }
        if (outliers[from] && outliers[to - 1]) {
            if (Dmin < Dmax) {
                outliers[to - 1] = false;
            } else {
                outliers[from] = false;
            }
        }
        AF = null;
        return true;
    }

    public static boolean Rosner(double[] values, int MaxOutliers, double alpha, boolean[] outliers) {
        int r;
        if (values.length != outliers.length) {
            throw new IllegalArgumentException("values.length != outliers.length");
        }
        if (values.length < 25) {
            return false;
        }
        if (MaxOutliers <= 0 || 10 < MaxOutliers) {
            throw new IllegalArgumentException("MaxOutliers <= 0 || 10 < MaxOutliers");
        }
        Arrays.fill(outliers, false);
        double[] clone = (double[])values.clone();
        int[] positions = new int[clone.length];
        ArrayOperations.FillIncreasingly((int[])positions);
        QuickSort.Sort(clone, positions, 0, clone.length - 1);
        ArrayFeatures AF = new ArrayFeatures();
        int from = 0;
        int to = clone.length;
        double[] X = new double[MaxOutliers];
        double[] S = new double[MaxOutliers];
        int[] Y = new int[MaxOutliers];
        for (r = 0; r < MaxOutliers; ++r) {
            AF.Moments(clone, from, to);
            double ave = X[r] = AF.Average();
            S[r] = AF.StandardDeviation();
            Y[r] = Math.abs(ave - clone[from]) < Math.abs(ave - clone[to - 1]) ? --to : from++;
        }
        for (r = MaxOutliers - 1; r >= 0; --r) {
            if (!OutliersDetectors.RosnerTest(Math.abs(clone[Y[r]] - X[r]) / S[r], values.length, r + 1, alpha)) continue;
            for (int i2 = r; i2 >= 0; --i2) {
                outliers[Y[i2]] = true;
            }
            break;
        }
        QuickSort.Sort(positions, outliers, 0, clone.length - 1);
        S = null;
        X = null;
        clone = null;
        Y = null;
        positions = null;
        AF = null;
        return true;
    }

    private static boolean RosnerTest(double R, int N, int r, double alpha) {
        int Npos;
        int apos;
        int rpos;
        switch (r) {
            case 1: {
                rpos = 0;
                break;
            }
            case 2: {
                rpos = 1;
                break;
            }
            case 3: {
                rpos = 2;
                break;
            }
            case 4: {
                rpos = 3;
                break;
            }
            case 5: {
                rpos = 4;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                rpos = 5;
                break;
            }
            default: {
                throw new IllegalArgumentException("r value not supported.");
            }
        }
        if (alpha == 0.01) {
            apos = 0;
        } else if (alpha == 0.05) {
            apos = 1;
        } else {
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        switch (N) {
            case 60: {
                Npos = 26;
                break;
            }
            case 70: {
                Npos = 27;
                break;
            }
            case 80: {
                Npos = 28;
                break;
            }
            case 90: {
                Npos = 29;
                break;
            }
            case 100: {
                Npos = 30;
                break;
            }
            case 150: {
                Npos = 31;
                break;
            }
            case 200: {
                Npos = 32;
                break;
            }
            case 250: {
                Npos = 33;
                break;
            }
            case 300: {
                Npos = 34;
                break;
            }
            case 350: {
                Npos = 35;
                break;
            }
            case 400: {
                Npos = 36;
                break;
            }
            case 450: {
                Npos = 37;
                break;
            }
            default: {
                Npos = N <= 50 ? N - 25 : 38;
            }
        }
        return RosnerCriticalValues[Npos][apos][rpos] < R;
    }

    public static boolean Walsh(double[] values, int MaxOutliers, double alpha, boolean[] outliers) {
        double s;
        int k;
        int r;
        if (values.length != outliers.length) {
            throw new IllegalArgumentException("values.length != outliers.length");
        }
        if (MaxOutliers <= 0) {
            throw new IllegalArgumentException("MaxOutliers <= 0");
        }
        if (values.length <= 60) {
            return false;
        }
        if (alpha == 0.1 && 220 < values.length) {
            return false;
        }
        if (alpha == 0.05 && values.length <= 220) {
            return false;
        }
        Arrays.fill(outliers, false);
        int N = values.length;
        double[] clone = (double[])values.clone();
        int[] positions = new int[N];
        ArrayOperations.FillIncreasingly((int[])positions);
        QuickSort.Sort(clone, positions, 0, N);
        int c = (int)Math.sqrt(N << 1) + 1;
        double b2 = 1.0 / alpha;
        double a = (1.0 + Math.sqrt(((double)c - b2) / ((double)c - 1.0) * b2)) / ((double)c - b2 - 1.0);
        for (r = MaxOutliers; r >= 1; --r) {
            k = r + c;
            s = clone[r - 1] - (1.0 + a) * clone[r] + a * clone[k];
            if (!(s < 0.0)) continue;
            Arrays.fill(outliers, 0, r, true);
            break;
        }
        for (r = 1; r <= MaxOutliers; ++r) {
            k = r + c;
            s = clone[N - r] - (1.0 + a) * clone[N - r - 1] + a * clone[N - k];
            if (!(s < 0.0)) continue;
            Arrays.fill(outliers, N - r, N, true);
            break;
        }
        QuickSort.Sort(positions, outliers, 0, clone.length - 1);
        clone = null;
        positions = null;
        return true;
    }

    public static boolean Grubbs(double[] values, int MaxOutliers, boolean[] outliers) {
        boolean resup;
        boolean reslow;
        if (values.length != outliers.length) {
            throw new IllegalArgumentException("values.length != outliers.length");
        }
        if (MaxOutliers <= 0) {
            throw new IllegalArgumentException("MaxOutliers <= 0");
        }
        Arrays.fill(outliers, false);
        double[] clone = (double[])values.clone();
        int[] positions = new int[clone.length];
        ArrayOperations.FillIncreasingly((int[])positions);
        QuickSort.Sort(clone, positions, 0, clone.length - 1);
        double[] pointer = clone;
        int outlierscount = 0;
        int from = 0;
        int to = values.length;
        do {
            Outliers out = new Outliers(pointer);
            out.suppressDisplay();
            ArrayList resultlow = out.lowerOutlierGrubbs();
            reslow = (Boolean)resultlow.get(0);
            if (reslow) {
                int index = (Integer)resultlow.get(2);
                if (index != 0) {
                    throw new Error("Souci");
                }
                outliers[from++] = true;
                pointer = (double[])resultlow.get(3);
                ++outlierscount;
            }
            resultlow.clear();
            resultlow = null;
            out = null;
            out = new Outliers(pointer);
            out.suppressDisplay();
            ArrayList resultup = out.upperOutlierGrubbs();
            resup = (Boolean)resultup.get(0);
            if (resup) {
                int index = (Integer)resultup.get(2);
                if (index != pointer.length - 1) {
                    throw new Error("Souci");
                }
                outliers[to-- - 1] = true;
                pointer = (double[])resultup.get(3);
                ++outlierscount;
            }
            resultup.clear();
            resultup = null;
            out = null;
        } while (outlierscount < MaxOutliers && (reslow || resup));
        QuickSort.Sort(positions, outliers, 0, clone.length - 1);
        clone = null;
        pointer = null;
        positions = null;
        return true;
    }

    public static boolean TietjenMoore(double[] values, int MaxOutliers, boolean[] outliers) {
        if (values.length != outliers.length) {
            throw new IllegalArgumentException("values.length != outliers.length");
        }
        if (MaxOutliers <= 0) {
            throw new IllegalArgumentException("MaxOutliers <= 0");
        }
        Arrays.fill(outliers, false);
        double[] clone = (double[])values.clone();
        int[] positions = new int[clone.length];
        ArrayOperations.FillIncreasingly((int[])positions);
        QuickSort.Sort(clone, positions, 0, clone.length - 1);
        Outliers out = new Outliers(clone);
        out.suppressDisplay();
        ArrayList result = out.outliersTietjenMoore(MaxOutliers);
        boolean res = (Boolean)result.get(0);
        if (res) {
            int[] indexes = (int[])result.get(2);
            for (int i2 = 0; i2 < indexes.length; ++i2) {
                outliers[indexes[i2]] = true;
            }
        }
        result.clear();
        result = null;
        QuickSort.Sort(positions, outliers, 0, clone.length - 1);
        out = null;
        clone = null;
        positions = null;
        return true;
    }

    public static boolean ESD(double[] values, int MaxOutliers, boolean[] outliers) {
        if (values.length != outliers.length) {
            throw new IllegalArgumentException("values.length != outliers.length");
        }
        if (MaxOutliers <= 0) {
            throw new IllegalArgumentException("MaxOutliers <= 0");
        }
        Arrays.fill(outliers, false);
        double[] clone = (double[])values.clone();
        int[] positions = new int[clone.length];
        ArrayOperations.FillIncreasingly((int[])positions);
        QuickSort.Sort(clone, positions, 0, clone.length - 1);
        Outliers out = new Outliers(clone);
        out.suppressDisplay();
        ArrayList result = out.outliersESD(MaxOutliers);
        boolean res = (Boolean)result.get(0);
        if (res) {
            int[] indexes = (int[])result.get(2);
            for (int i2 = 0; i2 < indexes.length; ++i2) {
                outliers[indexes[i2]] = true;
            }
        }
        result.clear();
        result = null;
        QuickSort.Sort(positions, outliers, 0, clone.length - 1);
        out = null;
        clone = null;
        positions = null;
        return true;
    }

    public static boolean DixonQ(double[] values, int MaxOutliers, boolean[] outliers) {
        boolean res;
        if (values.length != outliers.length) {
            throw new IllegalArgumentException("values.length != outliers.length");
        }
        if (MaxOutliers <= 0) {
            throw new IllegalArgumentException("MaxOutliers <= 0");
        }
        Arrays.fill(outliers, false);
        double[] clone = (double[])values.clone();
        int[] positions = new int[clone.length];
        ArrayOperations.FillIncreasingly((int[])positions);
        QuickSort.Sort(clone, positions, 0, clone.length - 1);
        double[] pointer = clone;
        int outlierscount = 0;
        int from = 0;
        int to = values.length;
        do {
            Outliers out = new Outliers(pointer);
            out.suppressDisplay();
            ArrayList result = out.outlierDixon();
            res = (Boolean)result.get(0);
            if (res) {
                int index = (Integer)result.get(2);
                if (index == 0) {
                    outliers[from++] = true;
                } else if (index == pointer.length - 1) {
                    outliers[to-- - 1] = true;
                } else {
                    throw new Error("Souci");
                }
                pointer = (double[])result.get(3);
                ++outlierscount;
            }
            result.clear();
            result = null;
            out = null;
        } while (outlierscount < MaxOutliers && res);
        QuickSort.Sort(positions, outliers, 0, clone.length - 1);
        clone = null;
        pointer = null;
        positions = null;
        return true;
    }
}

