/*
 * Decompiled with CFR 0.152.
 */
package mathematics.statistics;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayConverter;
import arrayTiTi.ArrayFeatures;
import filesAndFolders.fichiersTabules.FichierTabule;

public class NormalizeBySum {
    public double Epsilon = 1.0E-6;
    private final ArrayFeatures AF = new ArrayFeatures();

    public FichierTabule Compute(FichierTabule fichier) {
        int x;
        int Largeur = fichier.Width();
        int Hauteur = fichier.Height();
        FichierTabule res = null;
        int[] TypeColonnes = new int[Largeur];
        double[] colonne = null;
        for (x = 0; x < Largeur; ++x) {
            TypeColonnes[x] = !fichier.isExcludedColumn(x) && fichier.ColumnType(x) == 0 ? 1 : fichier.ColumnType(x);
        }
        res = new FichierTabule(Hauteur, TypeColonnes, fichier.Name() + "_Normalized");
        block10: for (x = 0; x < Largeur; ++x) {
            if (!fichier.isExcludedColumn(x)) {
                switch (fichier.ColumnType(x)) {
                    case 1: {
                        colonne = (double[])fichier.getColumnDouble(x).clone();
                        this.Compute(colonne);
                        res.setColumn(fichier.getColumnName(x), colonne);
                        continue block10;
                    }
                    case 0: {
                        colonne = ArrayConverter.IntToDouble((int[])fichier.getColumnInt(x));
                        this.Compute(colonne);
                        res.setColumn(fichier.getColumnName(x), colonne);
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Default: All not excluded columns must be Integer or Double.");
                    }
                }
            }
            switch (fichier.ColumnType(x)) {
                case 1: {
                    res.setColumn(fichier.getColumnName(x), fichier.getColumnDouble(x));
                    continue block10;
                }
                case 0: {
                    res.setColumn(fichier.getColumnName(x), fichier.getColumnInt(x));
                    continue block10;
                }
                case 2: {
                    res.setColumn(fichier.getColumnName(x), fichier.getColumnString(x));
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Default: type column.");
                }
            }
        }
        colonne = null;
        res.setExcluded(fichier.getExcluded());
        res.setExcludedColumn(fichier.getExcludedColumn());
        res.setNominal(fichier.getNominal());
        return res;
    }

    public void ComputeDouble(FichierTabule fichier) {
        for (int x = 0; x < fichier.Width(); ++x) {
            if (fichier.isExcludedColumn(x)) continue;
            switch (fichier.ColumnType(x)) {
                case 1: {
                    this.Compute(fichier.getColumnDouble(x));
                }
            }
        }
    }

    public void Compute(double[] array) {
        this.Compute(array, this.AF.Integral(array));
    }

    public void Compute(double[] array, double normalizer) {
        if (Double.isNaN(normalizer)) {
            throw new IllegalArgumentException("Can't normalize the array. Sum is NaN.");
        }
        if (Math.abs(normalizer) < this.Epsilon) {
            throw new IllegalArgumentException("Can't normalize the array. Normalizer is zero.");
        }
        ArrayArithmetic.Divide((double[])array, (double)normalizer, (double[])array);
    }
}

