/*
 * Decompiled with CFR 0.152.
 */
package mathematics.statistics;

import arrayTiTi.ArrayComparator;
import arrayTiTi.ArrayConverter;
import arrayTiTi.ArrayFeatures;
import filesAndFolders.fichiersTabules.FichierTabule;

public class Normalize {
    public double Epsilon = 1.0E-6;
    private double[] minima = null;
    private double min;
    private double[] maxima = null;
    private double max;
    private final ArrayFeatures AF = new ArrayFeatures();

    public FichierTabule Compute(FichierTabule file) {
        int x;
        int Largeur = file.Width();
        int Hauteur = file.Height();
        FichierTabule res = null;
        int[] TypeColonnes = (int[])file.ColumnType().clone();
        ArrayComparator.Compare((int[])TypeColonnes, (String)"!=", (int)0, (int[])TypeColonnes, (int)1, (int[])TypeColonnes);
        res = new FichierTabule(Hauteur, TypeColonnes, file.Name() + "_Normalized");
        int nb = 0;
        for (x = 0; x < Largeur; ++x) {
            if (res.ColumnType(x) != 1) continue;
            ++nb;
        }
        this.Allocation(nb);
        nb = 0;
        block10: for (x = 0; x < Largeur; ++x) {
            if (!file.isExcludedColumn(x)) {
                switch (file.ColumnType(x)) {
                    case 1: {
                        System.arraycopy(file.getColumnDouble(x), 0, res.getColumnDouble(x), 0, Hauteur);
                        this.Compute(res.getColumnDouble(x));
                        this.minima[nb] = this.min;
                        this.maxima[nb] = this.max;
                        ++nb;
                        continue block10;
                    }
                    case 0: {
                        ArrayConverter.IntToDouble((int[])file.getColumnInt(x), (double[])res.getColumnDouble(x));
                        this.Compute(res.getColumnDouble(x));
                        this.minima[nb] = this.min;
                        this.maxima[nb] = this.max;
                        ++nb;
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Default: All not excluded columns must be Integer or Double.");
                    }
                }
            }
            switch (file.ColumnType(x)) {
                case 1: {
                    System.arraycopy(file.getColumnDouble(x), 0, res.getColumnDouble(x), 0, Hauteur);
                    continue block10;
                }
                case 0: {
                    System.arraycopy(file.getColumnInt(x), 0, res.getColumnInt(x), 0, Hauteur);
                    continue block10;
                }
                case 2: {
                    System.arraycopy(file.getColumnString(x), 0, res.getColumnString(x), 0, Hauteur);
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Default: type column.");
                }
            }
        }
        res.setExcluded(file.getExcluded());
        res.setExcludedColumn(file.getExcludedColumn());
        res.setNominal(file.getNominal());
        return res;
    }

    public FichierTabule Compute(FichierTabule file, double[] minima, double[] maxima) {
        int Largeur = file.Width();
        int Hauteur = file.Height();
        FichierTabule res = null;
        int[] TypeColonnes = (int[])file.ColumnType().clone();
        ArrayComparator.Compare((int[])TypeColonnes, (String)"!=", (int)0, (int[])TypeColonnes, (int)1, (int[])TypeColonnes);
        System.arraycopy(minima, 0, this.minima, 0, minima.length);
        System.arraycopy(maxima, 0, this.maxima, 0, maxima.length);
        res = new FichierTabule(Hauteur, TypeColonnes, file.Name() + "_Normalized");
        int nb = 0;
        block9: for (int x = 0; x < Largeur; ++x) {
            if (!file.isExcludedColumn(x)) {
                switch (file.ColumnType(x)) {
                    case 1: {
                        System.arraycopy(file.getColumnDouble(x), 0, res.getColumnDouble(x), 0, Hauteur);
                        this.Compute(res.getColumnDouble(x), minima[nb], maxima[nb]);
                        ++nb;
                        continue block9;
                    }
                    case 0: {
                        ArrayConverter.IntToDouble((int[])file.getColumnInt(x), (double[])res.getColumnDouble(x));
                        this.Compute(res.getColumnDouble(x), minima[nb], maxima[nb]);
                        ++nb;
                        continue block9;
                    }
                    default: {
                        throw new IllegalArgumentException("Default: All not excluded columns must be Integer or Double.");
                    }
                }
            }
            switch (file.ColumnType(x)) {
                case 1: {
                    System.arraycopy(file.getColumnDouble(x), 0, res.getColumnDouble(x), 0, Hauteur);
                    continue block9;
                }
                case 0: {
                    System.arraycopy(file.getColumnInt(x), 0, res.getColumnInt(x), 0, Hauteur);
                    continue block9;
                }
                case 2: {
                    System.arraycopy(file.getColumnString(x), 0, res.getColumnString(x), 0, Hauteur);
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Default: type column.");
                }
            }
        }
        res.setExcluded(file.getExcluded());
        res.setExcludedColumn(file.getExcludedColumn());
        res.setNominal(file.getNominal());
        return res;
    }

    public void ComputeDouble(FichierTabule file) {
        int x;
        int nb = 0;
        for (x = 0; x < file.Width(); ++x) {
            if (file.ColumnType(x) != 1) continue;
            ++nb;
        }
        this.Allocation(nb);
        nb = 0;
        for (x = 0; x < file.Width(); ++x) {
            if (file.isExcludedColumn(x) || file.ColumnType(x) != 1) continue;
            this.Compute(file.getColumnDouble(x));
            this.minima[nb] = this.min;
            this.maxima[nb] = this.max;
            ++nb;
        }
    }

    public void ComputeDouble(FichierTabule file, double[] minima, double[] maxima) {
        int nb = 0;
        for (int i2 = 0; i2 < file.Width(); ++i2) {
            if (file.ColumnType(i2) != 1) continue;
            ++nb;
        }
        if (minima.length != maxima.length) {
            throw new IllegalArgumentException("minima.length != maxima.length");
        }
        if (nb != minima.length) {
            throw new IllegalArgumentException("The number of Double columns into the file is different from the arrays length.");
        }
        System.arraycopy(minima, 0, this.minima, 0, minima.length);
        System.arraycopy(maxima, 0, this.maxima, 0, maxima.length);
        this.Allocation(nb);
        nb = 0;
        for (int x = 0; x < file.Width(); ++x) {
            if (file.isExcludedColumn(x)) continue;
            switch (file.ColumnType(x)) {
                case 1: {
                    this.Compute(file.getColumnDouble(x), minima[nb], maxima[nb]);
                    ++nb;
                }
            }
        }
    }

    public void Compute(double[] Tab) {
        this.Compute(Tab, this.AF.Minimum(Tab), this.AF.Maximum(Tab));
    }

    public void Compute(double[] Tab, double min, double max) {
        this.min = min;
        this.max = max;
        for (int i2 = 0; i2 < Tab.length; ++i2) {
            Tab[i2] = (Tab[i2] - min) / max;
        }
    }

    private void Allocation(int length) {
        if (this.minima != null && this.minima.length == length) {
            return;
        }
        this.minima = null;
        this.minima = new double[length];
        this.maxima = null;
        this.maxima = new double[length];
    }

    public double[] Minima() {
        return this.minima;
    }

    public double[] Maxima() {
        return this.maxima;
    }
}

