/*
 * Decompiled with CFR 0.152.
 */
package mathematics.statistics;

import arrayTiTi.ArrayFeatures;
import java.util.Arrays;
import mathematics.Maths;
import mathematics.statistics.CenterReduce;

public final class Normality {
    public static final double[][] JarqueBeraCriticalValues = new double[][]{{15.345, 46.996, 66.612, 71.734, 69.91, 68.032, 60.632, 54.736, 47.572, 38.847, 33.247, 31.213, 26.956, 24.249, 19.94}, {12.444, 31.159, 40.759, 43.256, 41.909, 40.43, 37.229, 34.33, 30.561, 26.27, 23.045, 21.979, 19.76, 18.366, 16.052}, {10.995, 24.97, 31.969, 33.753, 32.738, 31.84, 29.547, 27.551, 24.83, 21.812, 19.521, 18.736, 17.15, 16.083, 14.397}, {7.3004, 13.471, 16.414, 17.281, 17.305, 16.959, 16.257, 15.638, 14.669, 13.583, 12.726, 12.366, 11.762, 11.384, 10.792}, {5.7029, 9.7182, 11.736, 12.392, 12.586, 12.491, 12.185, 11.882, 11.358, 10.778, 10.299, 10.117, 9.8095, 9.6084, 9.3128}, {2.5247, 3.7954, 4.5929, 4.9757, 5.2777, 5.43, 5.5984, 5.6758, 5.7732, 5.8551, 5.9103, 5.9242, 5.9569, 5.9671, 5.9857}, {1.6232, 2.347, 2.8814, 3.1834, 3.4862, 3.6734, 3.9041, 4.0327, 4.1891, 4.3317, 4.4274, 4.4568, 4.5132, 4.5424, 4.5888}};
    public static final double[][] AdjustedJarqueBeraCriticalValues = new double[][]{{51.6, 91.217, 99.883, 96.158, 85.696, 79.523, 67.685, 59.6, 50.53, 40.472, 34.231, 31.993, 27.454, 24.575, 20.04}, {41.502, 60.508, 60.927, 58.013, 51.413, 47.444, 41.713, 37.524, 32.579, 27.431, 23.751, 22.545, 20.128, 18.621, 16.114}, {36.538, 48.399, 47.78, 45.318, 40.266, 37.414, 33.106, 30.158, 26.498, 22.785, 20.147, 19.244, 17.474, 16.314, 14.457}, {23.831, 25.963, 24.569, 23.229, 21.334, 19.986, 18.285, 17.156, 15.689, 14.211, 13.129, 12.694, 11.971, 11.525, 10.827}, {18.374, 18.643, 17.54, 16.659, 15.506, 14.719, 13.707, 13.042, 12.149, 11.271, 10.616, 10.372, 9.9667, 9.7158, 9.3386}, {7.4161, 6.9317, 6.6788, 6.5533, 6.4144, 6.3192, 6.2182, 6.1493, 6.0925, 6.0497, 6.0309, 6.0218, 6.0182, 6.0077, 5.9961}, {4.1769, 3.9657, 3.9612, 3.9977, 4.0664, 4.1256, 4.218, 4.2718, 4.3547, 4.4336, 4.4923, 4.5095, 4.5462, 4.565, 4.5941}};
    public static final double[][] LillieforsCriticalValues = new double[][]{{0.3027, 0.3216, 0.3456, 0.3754, 0.4129}, {0.2893, 0.3027, 0.3188, 0.3427, 0.3959}, {0.2694, 0.2816, 0.2982, 0.3245, 0.3728}, {0.2521, 0.2641, 0.2802, 0.3041, 0.3504}, {0.2387, 0.2502, 0.2649, 0.2875, 0.3331}, {0.2273, 0.2382, 0.2522, 0.2744, 0.3162}, {0.2171, 0.2273, 0.241, 0.2616, 0.3037}, {0.208, 0.2179, 0.2306, 0.2506, 0.2905}, {0.2004, 0.2101, 0.2228, 0.2426, 0.2812}, {0.1932, 0.2025, 0.2147, 0.2337, 0.2714}, {0.1869, 0.1959, 0.2077, 0.2257, 0.2627}, {0.1811, 0.1899, 0.2016, 0.2196, 0.2545}, {0.1758, 0.1843, 0.1956, 0.2128, 0.2477}, {0.1711, 0.1794, 0.1902, 0.2071, 0.2408}, {0.1666, 0.1747, 0.1852, 0.2018, 0.2345}, {0.1624, 0.17, 0.1803, 0.1965, 0.2285}, {0.1589, 0.1666, 0.1764, 0.192, 0.2226}, {0.1553, 0.1629, 0.1726, 0.1881, 0.219}, {0.1517, 0.1592, 0.169, 0.184, 0.2141}, {0.1484, 0.1555, 0.165, 0.1798, 0.209}, {0.1458, 0.1527, 0.1619, 0.1766, 0.2053}, {0.1429, 0.1498, 0.1589, 0.1726, 0.201}, {0.1406, 0.1472, 0.1562, 0.1699, 0.1985}, {0.1381, 0.1448, 0.1533, 0.1665, 0.1941}, {0.1358, 0.1423, 0.1509, 0.1641, 0.1911}, {0.1334, 0.1398, 0.1483, 0.1614, 0.1886}, {0.1315, 0.1378, 0.146, 0.159, 0.1848}, {0.1291, 0.1353, 0.1432, 0.1559, 0.182}, {0.1274, 0.1336, 0.1415, 0.1542, 0.1798}, {0.1254, 0.1314, 0.1392, 0.1518, 0.177}, {0.1236, 0.1295, 0.1373, 0.1497, 0.1747}, {0.122, 0.1278, 0.1356, 0.1478, 0.172}, {0.1203, 0.126, 0.1336, 0.1454, 0.1695}, {0.1188, 0.1245, 0.132, 0.1436, 0.1677}, {0.1174, 0.123, 0.1303, 0.1421, 0.1653}, {0.1159, 0.1214, 0.1288, 0.1402, 0.1634}, {0.1147, 0.1204, 0.1275, 0.1386, 0.1616}, {0.1131, 0.1186, 0.1258, 0.1373, 0.1599}, {0.1119, 0.1172, 0.1244, 0.1353, 0.1573}, {0.1106, 0.1159, 0.1228, 0.1339, 0.1556}, {0.1095, 0.1148, 0.1216, 0.1322, 0.1542}, {0.1083, 0.1134, 0.1204, 0.1309, 0.1525}, {0.1071, 0.1123, 0.1189, 0.1293, 0.1512}, {0.1062, 0.1113, 0.118, 0.1282, 0.1499}, {0.1047, 0.1098, 0.1165, 0.1269, 0.1476}, {0.104, 0.1089, 0.1153, 0.1256, 0.1463}, {0.103, 0.1079, 0.1142, 0.1246, 0.1457}};
    public static double[][] AndersonDarlingCriticalValues = new double[][]{{0.514, 0.578, 0.683, 0.779, 0.926}, {0.528, 0.591, 0.704, 0.815, 0.969}, {0.546, 0.616, 0.735, 0.861, 1.021}, {0.559, 0.631, 0.754, 0.884, 1.047}, {0.576, 0.656, 0.787, 0.918, 1.092}};
    public static double[][] ShapiroWilkCriticalValues = new double[][]{{0.676, 0.748}, {0.686, 0.762}, {0.713, 0.788}, {0.73, 0.803}, {0.749, 0.818}, {0.764, 0.829}, {0.781, 0.842}, {0.792, 0.85}, {0.805, 0.859}, {0.814, 0.866}, {0.825, 0.874}, {0.835, 0.881}, {0.844, 0.887}, {0.851, 0.892}, {0.858, 0.897}, {0.863, 0.901}, {0.863, 0.901}, {0.868, 0.905}, {0.888, 0.918}, {0.9, 0.927}, {0.91, 0.934}, {0.919, 0.94}, {0.93, 0.947}};
    public static final double[][] Normal = new double[][]{{0.5, 0.5398, 0.5793, 0.6179, 0.6554, 0.6915, 0.7257, 0.758, 0.7881, 0.8159, 0.8413, 0.8643, 0.8849, 0.9032, 0.9192, 0.9332, 0.9452, 0.9554, 0.9641, 0.9713, 0.9772, 0.9821, 0.9861, 0.9893, 0.9918, 0.9938, 0.9953, 0.9965, 0.9974, 0.9981, 0.99865, 0.99903, 0.99931, 0.99952, 0.99966, 0.99977, 0.99984, 0.99989, 0.99993, 0.99995, 0.99997}, {0.504, 0.5438, 0.5832, 0.6217, 0.6591, 0.695, 0.7291, 0.7611, 0.791, 0.8186, 0.8438, 0.8665, 0.8869, 0.9049, 0.9207, 0.9345, 0.9463, 0.9564, 0.9649, 0.9719, 0.9778, 0.9826, 0.9864, 0.9896, 0.992, 0.994, 0.9955, 0.9966, 0.9975, 0.9982, 0.99869, 0.99906, 0.99934, 0.99953, 0.99968, 0.99978, 0.99985, 0.9999, 0.99993, 0.99995, 0.99997}, {0.508, 0.5478, 0.5871, 0.6255, 0.6628, 0.6985, 0.7324, 0.7642, 0.7939, 0.8212, 0.8461, 0.8686, 0.8888, 0.9066, 0.9222, 0.9357, 0.9474, 0.9573, 0.9656, 0.9726, 0.9783, 0.983, 0.9868, 0.9898, 0.9922, 0.9941, 0.9956, 0.9967, 0.9976, 0.9982, 0.99874, 0.9991, 0.99936, 0.99955, 0.99969, 0.99978, 0.99985, 0.9999, 0.99993, 0.99996, 0.99997}, {0.512, 0.5517, 0.591, 0.6293, 0.6664, 0.7019, 0.7357, 0.7673, 0.7967, 0.8238, 0.8485, 0.8708, 0.8907, 0.9082, 0.9236, 0.937, 0.9484, 0.9582, 0.9664, 0.9732, 0.9788, 0.9834, 0.9871, 0.9901, 0.9925, 0.9943, 0.9957, 0.9968, 0.9977, 0.9983, 0.99878, 0.99913, 0.99938, 0.99957, 0.9997, 0.99979, 0.99986, 0.9999, 0.99994, 0.99996, 0.99997}, {0.516, 0.5557, 0.5948, 0.6331, 0.67, 0.7054, 0.7389, 0.7704, 0.7995, 0.8264, 0.8508, 0.8729, 0.8925, 0.9099, 0.9251, 0.9382, 0.9495, 0.9591, 0.9671, 0.9738, 0.9793, 0.9838, 0.9875, 0.9904, 0.9927, 0.9945, 0.9959, 0.9969, 0.9977, 0.9984, 0.99882, 0.99916, 0.9994, 0.99958, 0.99971, 0.9998, 0.99986, 0.99991, 0.99994, 0.99996, 0.99997}, {0.5199, 0.5596, 0.5987, 0.6368, 0.6736, 0.7088, 0.7422, 0.7734, 0.8023, 0.8289, 0.8531, 0.8749, 0.8944, 0.9115, 0.9265, 0.9394, 0.9505, 0.9599, 0.9678, 0.9744, 0.9798, 0.9842, 0.9878, 0.9906, 0.9929, 0.9946, 0.996, 0.997, 0.9978, 0.9984, 0.99886, 0.99918, 0.99942, 0.9996, 0.99972, 0.99981, 0.99987, 0.99991, 0.99994, 0.99996, 0.99997}, {0.5239, 0.5636, 0.6026, 0.6406, 0.6772, 0.7123, 0.7454, 0.7764, 0.8051, 0.8315, 0.8554, 0.877, 0.8962, 0.9131, 0.9279, 0.9406, 0.9515, 0.9608, 0.9686, 0.975, 0.9803, 0.9846, 0.9881, 0.9909, 0.9931, 0.9948, 0.9961, 0.9971, 0.9979, 0.9985, 0.99889, 0.99921, 0.99944, 0.99961, 0.99973, 0.99981, 0.99987, 0.99992, 0.99994, 0.99996, 0.99998}, {0.5279, 0.5675, 0.6064, 0.6443, 0.6808, 0.7157, 0.7486, 0.7794, 0.8078, 0.834, 0.8577, 0.879, 0.898, 0.9147, 0.9292, 0.9418, 0.9525, 0.9616, 0.9693, 0.9756, 0.9808, 0.985, 0.9884, 0.9911, 0.9932, 0.9949, 0.9962, 0.9972, 0.9979, 0.9985, 0.99893, 0.99924, 0.99946, 0.99962, 0.99974, 0.99982, 0.99988, 0.99992, 0.99995, 0.99996, 0.99998}, {0.5319, 0.5714, 0.6103, 0.648, 0.6844, 0.719, 0.7517, 0.7823, 0.8106, 0.8365, 0.8599, 0.881, 0.8997, 0.9162, 0.9306, 0.9429, 0.9535, 0.9625, 0.9699, 0.9761, 0.9812, 0.9854, 0.9887, 0.9913, 0.9934, 0.9951, 0.9963, 0.9973, 0.998, 0.9986, 0.99896, 0.99926, 0.99948, 0.99964, 0.99975, 0.99983, 0.99988, 0.99992, 0.99995, 0.99997, 0.99998}, {0.5359, 0.5753, 0.6141, 0.6517, 0.6879, 0.7224, 0.7549, 0.7852, 0.8133, 0.8389, 0.8621, 0.883, 0.9015, 0.9177, 0.9319, 0.9441, 0.9545, 0.9633, 0.9706, 0.9767, 0.9817, 0.9857, 0.989, 0.9916, 0.9936, 0.9952, 0.9964, 0.9974, 0.9981, 0.9986, 0.999, 0.99929, 0.9995, 0.99965, 0.99976, 0.99983, 0.99989, 0.99992, 0.99995, 0.99997, 0.99998}};

    public static boolean Normality(double[] values, double alpha) {
        int win = 0;
        if (Normality.ShapiroWilk(values, alpha)) {
            ++win;
        }
        if (alpha == 0.05) {
            if (Normality.AgostinoPearsonOmnibus(values, alpha)) {
                ++win;
            }
            if (values.length < 150 && win != 1) {
                return win == 2;
            }
            if (values.length <= 75) {
                return Normality.Lilliefors(values, alpha);
            }
            if (values.length < 110) {
                if (Normality.JarqueBera(values, alpha)) {
                    ++win;
                }
                if (Normality.Lilliefors(values, alpha)) {
                    ++win;
                }
                return win == 3;
            }
            if (values.length < 150) {
                return Normality.JarqueBera(values, alpha);
            }
            if (Normality.JarqueBera(values, alpha)) {
                ++win;
            }
            if (Normality.Lilliefors(values, alpha)) {
                ++win;
            }
            return 3 <= win;
        }
        if (values.length < 150) {
            throw new IllegalArgumentException("When values.length < 150, the precision must be 0.05");
        }
        if (Normality.JarqueBera(values, alpha)) {
            ++win;
        }
        if (Normality.Lilliefors(values, alpha)) {
            ++win;
        }
        return 2 <= win;
    }

    public static boolean JarqueBera(float[] values, float alpha) {
        return Normality.JarqueBeraSuccess(Normality.JarqueBera(values), values.length, alpha);
    }

    public static double JarqueBera(float[] values) {
        if (values.length < 5) {
            throw new IllegalArgumentException("values.length < 5");
        }
        ArrayFeatures AF = new ArrayFeatures();
        AF.Moments(values);
        return (double)values.length / 6.0 * (AF.SampleSkewness() * AF.SampleSkewness() + AF.ExcessKurtosis() * AF.ExcessKurtosis() / 4.0);
    }

    public static boolean JarqueBera(double[] values, double alpha) {
        return Normality.JarqueBeraSuccess(Normality.JarqueBera(values), values.length, alpha);
    }

    public static double JarqueBera(double[] values) {
        if (values.length < 5) {
            throw new IllegalArgumentException("values.length < 5");
        }
        ArrayFeatures AF = new ArrayFeatures();
        AF.Moments(values);
        return (double)values.length / 6.0 * (AF.SampleSkewness() * AF.SampleSkewness() + AF.ExcessKurtosis() * AF.ExcessKurtosis() / 4.0);
    }

    public static boolean JarqueBera(int[] values, double alpha) {
        return Normality.JarqueBeraSuccess(Normality.JarqueBera(values), values.length, alpha);
    }

    public static double JarqueBera(int[] values) {
        if (values.length < 5) {
            throw new IllegalArgumentException("values.length < 5");
        }
        ArrayFeatures AF = new ArrayFeatures();
        AF.Moments(values);
        return (double)values.length / 6.0 * (AF.SampleSkewness() * AF.SampleSkewness() + AF.ExcessKurtosis() * AF.ExcessKurtosis() / 4.0);
    }

    private static boolean JarqueBeraSuccess(double JB, int N, double alpha) {
        if (N <= 10) {
            if (alpha == 1.0E-4) {
                return JB <= JarqueBeraCriticalValues[0][0];
            }
            if (alpha == 5.0E-4) {
                return JB <= JarqueBeraCriticalValues[1][0];
            }
            if (alpha == 0.001) {
                return JB <= JarqueBeraCriticalValues[2][0];
            }
            if (alpha == 0.005) {
                return JB <= JarqueBeraCriticalValues[3][0];
            }
            if (alpha == 0.01) {
                return JB <= JarqueBeraCriticalValues[4][0];
            }
            if (alpha == 0.05) {
                return JB <= JarqueBeraCriticalValues[5][0];
            }
            if (alpha == 0.1) {
                return JB <= JarqueBeraCriticalValues[6][0];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 20) {
            if (alpha == 1.0E-4) {
                return JB <= JarqueBeraCriticalValues[0][1];
            }
            if (alpha == 5.0E-4) {
                return JB <= JarqueBeraCriticalValues[1][1];
            }
            if (alpha == 0.001) {
                return JB <= JarqueBeraCriticalValues[2][1];
            }
            if (alpha == 0.005) {
                return JB <= JarqueBeraCriticalValues[3][1];
            }
            if (alpha == 0.01) {
                return JB <= JarqueBeraCriticalValues[4][1];
            }
            if (alpha == 0.05) {
                return JB <= JarqueBeraCriticalValues[5][1];
            }
            if (alpha == 0.1) {
                return JB <= JarqueBeraCriticalValues[6][1];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 35) {
            if (alpha == 1.0E-4) {
                return JB <= JarqueBeraCriticalValues[0][2];
            }
            if (alpha == 5.0E-4) {
                return JB <= JarqueBeraCriticalValues[1][2];
            }
            if (alpha == 0.001) {
                return JB <= JarqueBeraCriticalValues[2][2];
            }
            if (alpha == 0.005) {
                return JB <= JarqueBeraCriticalValues[3][2];
            }
            if (alpha == 0.01) {
                return JB <= JarqueBeraCriticalValues[4][2];
            }
            if (alpha == 0.05) {
                return JB <= JarqueBeraCriticalValues[5][2];
            }
            if (alpha == 0.1) {
                return JB <= JarqueBeraCriticalValues[6][2];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 50) {
            if (alpha == 1.0E-4) {
                return JB <= JarqueBeraCriticalValues[0][3];
            }
            if (alpha == 5.0E-4) {
                return JB <= JarqueBeraCriticalValues[1][3];
            }
            if (alpha == 0.001) {
                return JB <= JarqueBeraCriticalValues[2][3];
            }
            if (alpha == 0.005) {
                return JB <= JarqueBeraCriticalValues[3][3];
            }
            if (alpha == 0.01) {
                return JB <= JarqueBeraCriticalValues[4][3];
            }
            if (alpha == 0.05) {
                return JB <= JarqueBeraCriticalValues[5][3];
            }
            if (alpha == 0.1) {
                return JB <= JarqueBeraCriticalValues[6][3];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 75) {
            if (alpha == 1.0E-4) {
                return JB <= JarqueBeraCriticalValues[0][4];
            }
            if (alpha == 5.0E-4) {
                return JB <= JarqueBeraCriticalValues[1][4];
            }
            if (alpha == 0.001) {
                return JB <= JarqueBeraCriticalValues[2][4];
            }
            if (alpha == 0.005) {
                return JB <= JarqueBeraCriticalValues[3][4];
            }
            if (alpha == 0.01) {
                return JB <= JarqueBeraCriticalValues[4][4];
            }
            if (alpha == 0.05) {
                return JB <= JarqueBeraCriticalValues[5][4];
            }
            if (alpha == 0.1) {
                return JB <= JarqueBeraCriticalValues[6][4];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 100) {
            if (alpha == 1.0E-4) {
                return JB <= JarqueBeraCriticalValues[0][5];
            }
            if (alpha == 5.0E-4) {
                return JB <= JarqueBeraCriticalValues[1][5];
            }
            if (alpha == 0.001) {
                return JB <= JarqueBeraCriticalValues[2][5];
            }
            if (alpha == 0.005) {
                return JB <= JarqueBeraCriticalValues[3][5];
            }
            if (alpha == 0.01) {
                return JB <= JarqueBeraCriticalValues[4][5];
            }
            if (alpha == 0.05) {
                return JB <= JarqueBeraCriticalValues[5][5];
            }
            if (alpha == 0.1) {
                return JB <= JarqueBeraCriticalValues[6][5];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 150) {
            if (alpha == 1.0E-4) {
                return JB <= JarqueBeraCriticalValues[0][6];
            }
            if (alpha == 5.0E-4) {
                return JB <= JarqueBeraCriticalValues[1][6];
            }
            if (alpha == 0.001) {
                return JB <= JarqueBeraCriticalValues[2][6];
            }
            if (alpha == 0.005) {
                return JB <= JarqueBeraCriticalValues[3][6];
            }
            if (alpha == 0.01) {
                return JB <= JarqueBeraCriticalValues[4][6];
            }
            if (alpha == 0.05) {
                return JB <= JarqueBeraCriticalValues[5][6];
            }
            if (alpha == 0.1) {
                return JB <= JarqueBeraCriticalValues[6][6];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 200) {
            if (alpha == 1.0E-4) {
                return JB <= JarqueBeraCriticalValues[0][7];
            }
            if (alpha == 5.0E-4) {
                return JB <= JarqueBeraCriticalValues[1][7];
            }
            if (alpha == 0.001) {
                return JB <= JarqueBeraCriticalValues[2][7];
            }
            if (alpha == 0.005) {
                return JB <= JarqueBeraCriticalValues[3][7];
            }
            if (alpha == 0.01) {
                return JB <= JarqueBeraCriticalValues[4][7];
            }
            if (alpha == 0.05) {
                return JB <= JarqueBeraCriticalValues[5][7];
            }
            if (alpha == 0.1) {
                return JB <= JarqueBeraCriticalValues[6][7];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 300) {
            if (alpha == 1.0E-4) {
                return JB <= JarqueBeraCriticalValues[0][8];
            }
            if (alpha == 5.0E-4) {
                return JB <= JarqueBeraCriticalValues[1][8];
            }
            if (alpha == 0.001) {
                return JB <= JarqueBeraCriticalValues[2][8];
            }
            if (alpha == 0.005) {
                return JB <= JarqueBeraCriticalValues[3][8];
            }
            if (alpha == 0.01) {
                return JB <= JarqueBeraCriticalValues[4][8];
            }
            if (alpha == 0.05) {
                return JB <= JarqueBeraCriticalValues[5][8];
            }
            if (alpha == 0.1) {
                return JB <= JarqueBeraCriticalValues[6][8];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 500) {
            if (alpha == 1.0E-4) {
                return JB <= JarqueBeraCriticalValues[0][9];
            }
            if (alpha == 5.0E-4) {
                return JB <= JarqueBeraCriticalValues[1][9];
            }
            if (alpha == 0.001) {
                return JB <= JarqueBeraCriticalValues[2][9];
            }
            if (alpha == 0.005) {
                return JB <= JarqueBeraCriticalValues[3][9];
            }
            if (alpha == 0.01) {
                return JB <= JarqueBeraCriticalValues[4][9];
            }
            if (alpha == 0.05) {
                return JB <= JarqueBeraCriticalValues[5][9];
            }
            if (alpha == 0.1) {
                return JB <= JarqueBeraCriticalValues[6][9];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 800) {
            if (alpha == 1.0E-4) {
                return JB <= JarqueBeraCriticalValues[0][10];
            }
            if (alpha == 5.0E-4) {
                return JB <= JarqueBeraCriticalValues[1][10];
            }
            if (alpha == 0.001) {
                return JB <= JarqueBeraCriticalValues[2][10];
            }
            if (alpha == 0.005) {
                return JB <= JarqueBeraCriticalValues[3][10];
            }
            if (alpha == 0.01) {
                return JB <= JarqueBeraCriticalValues[4][10];
            }
            if (alpha == 0.05) {
                return JB <= JarqueBeraCriticalValues[5][10];
            }
            if (alpha == 0.1) {
                return JB <= JarqueBeraCriticalValues[6][10];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 1000) {
            if (alpha == 1.0E-4) {
                return JB <= JarqueBeraCriticalValues[0][11];
            }
            if (alpha == 5.0E-4) {
                return JB <= JarqueBeraCriticalValues[1][11];
            }
            if (alpha == 0.001) {
                return JB <= JarqueBeraCriticalValues[2][11];
            }
            if (alpha == 0.005) {
                return JB <= JarqueBeraCriticalValues[3][11];
            }
            if (alpha == 0.01) {
                return JB <= JarqueBeraCriticalValues[4][11];
            }
            if (alpha == 0.05) {
                return JB <= JarqueBeraCriticalValues[5][11];
            }
            if (alpha == 0.1) {
                return JB <= JarqueBeraCriticalValues[6][11];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 1600) {
            if (alpha == 1.0E-4) {
                return JB <= JarqueBeraCriticalValues[0][12];
            }
            if (alpha == 5.0E-4) {
                return JB <= JarqueBeraCriticalValues[1][12];
            }
            if (alpha == 0.001) {
                return JB <= JarqueBeraCriticalValues[2][12];
            }
            if (alpha == 0.005) {
                return JB <= JarqueBeraCriticalValues[3][12];
            }
            if (alpha == 0.01) {
                return JB <= JarqueBeraCriticalValues[4][12];
            }
            if (alpha == 0.05) {
                return JB <= JarqueBeraCriticalValues[5][12];
            }
            if (alpha == 0.1) {
                return JB <= JarqueBeraCriticalValues[6][12];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 2400) {
            if (alpha == 1.0E-4) {
                return JB <= JarqueBeraCriticalValues[0][13];
            }
            if (alpha == 5.0E-4) {
                return JB <= JarqueBeraCriticalValues[1][13];
            }
            if (alpha == 0.001) {
                return JB <= JarqueBeraCriticalValues[2][13];
            }
            if (alpha == 0.005) {
                return JB <= JarqueBeraCriticalValues[3][13];
            }
            if (alpha == 0.01) {
                return JB <= JarqueBeraCriticalValues[4][13];
            }
            if (alpha == 0.05) {
                return JB <= JarqueBeraCriticalValues[5][13];
            }
            if (alpha == 0.1) {
                return JB <= JarqueBeraCriticalValues[6][13];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 10000) {
            if (alpha == 1.0E-4) {
                return JB <= JarqueBeraCriticalValues[0][14];
            }
            if (alpha == 5.0E-4) {
                return JB <= JarqueBeraCriticalValues[1][14];
            }
            if (alpha == 0.001) {
                return JB <= JarqueBeraCriticalValues[2][14];
            }
            if (alpha == 0.005) {
                return JB <= JarqueBeraCriticalValues[3][14];
            }
            if (alpha == 0.01) {
                return JB <= JarqueBeraCriticalValues[4][14];
            }
            if (alpha == 0.05) {
                return JB <= JarqueBeraCriticalValues[5][14];
            }
            if (alpha == 0.1) {
                return JB <= JarqueBeraCriticalValues[6][14];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        throw new IllegalArgumentException("N value not supported. Must be less or equal than 100.");
    }

    public static boolean AdjustedJarqueBera(double[] values, double alpha) {
        return Normality.AdjustedJarqueBeraSuccess(Normality.AdjustedJarqueBera(values), values.length, alpha);
    }

    public static double AdjustedJarqueBera(double[] values) {
        if (values.length < 5) {
            throw new IllegalArgumentException("values.length < 5");
        }
        ArrayFeatures AF = new ArrayFeatures();
        AF.Moments(values);
        int N = values.length;
        double c1 = 6.0 * (double)(N - 2) / (double)((N + 1) * (N + 3));
        double c2 = 3.0 * (double)(N - 1) / (double)(N + 1);
        double c3 = 24.0 * (double)N / (double)((N + 1) * (N + 1)) * (double)(N - 2) / (double)(N + 3) * (double)(N - 3) / (double)(N + 5);
        return (double)N * (AF.SampleSkewness() * AF.SampleSkewness() / c1 + Maths.Power((double)(AF.Kurtosis() - c2), (int)2) / c3);
    }

    public static boolean AdjustedJarqueBera(float[] values, double alpha) {
        return Normality.AdjustedJarqueBeraSuccess(Normality.AdjustedJarqueBera(values), values.length, alpha);
    }

    public static double AdjustedJarqueBera(float[] values) {
        if (values.length < 5) {
            throw new IllegalArgumentException("values.length < 5");
        }
        ArrayFeatures AF = new ArrayFeatures();
        AF.Moments(values);
        int N = values.length;
        double c1 = 6.0 * (double)(N - 2) / (double)((N + 1) * (N + 3));
        double c2 = 3.0 * (double)(N - 1) / (double)(N + 1);
        double c3 = 24.0 * (double)N / (double)((N + 1) * (N + 1)) * (double)(N - 2) / (double)(N + 3) * (double)(N - 3) / (double)(N + 5);
        return (double)N * (AF.SampleSkewness() * AF.SampleSkewness() / c1 + Maths.Power((double)(AF.Kurtosis() - c2), (int)2) / c3);
    }

    public static boolean AdjustedJarqueBera(int[] values, double alpha) {
        return Normality.AdjustedJarqueBeraSuccess(Normality.AdjustedJarqueBera(values), values.length, alpha);
    }

    public static double AdjustedJarqueBera(int[] values) {
        if (values.length < 5) {
            throw new IllegalArgumentException("values.length < 5");
        }
        ArrayFeatures AF = new ArrayFeatures();
        AF.Moments(values);
        int N = values.length;
        double c1 = 6.0 * (double)(N - 2) / (double)((N + 1) * (N + 3));
        double c2 = 3.0 * (double)(N - 1) / (double)(N + 1);
        double c3 = 24.0 * (double)N / (double)((N + 1) * (N + 1)) * (double)(N - 2) / (double)(N + 3) * (double)(N - 3) / (double)(N + 5);
        return (double)N * (AF.SampleSkewness() * AF.SampleSkewness() / c1 + Maths.Power((double)(AF.Kurtosis() - c2), (int)2) / c3);
    }

    private static boolean AdjustedJarqueBeraSuccess(double JB, int N, double alpha) {
        if (N <= 10) {
            if (alpha == 1.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[0][0];
            }
            if (alpha == 5.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[1][0];
            }
            if (alpha == 0.001) {
                return JB <= AdjustedJarqueBeraCriticalValues[2][0];
            }
            if (alpha == 0.005) {
                return JB <= AdjustedJarqueBeraCriticalValues[3][0];
            }
            if (alpha == 0.01) {
                return JB <= AdjustedJarqueBeraCriticalValues[4][0];
            }
            if (alpha == 0.05) {
                return JB <= AdjustedJarqueBeraCriticalValues[5][0];
            }
            if (alpha == 0.1) {
                return JB <= AdjustedJarqueBeraCriticalValues[6][0];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 20) {
            if (alpha == 1.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[0][1];
            }
            if (alpha == 5.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[1][1];
            }
            if (alpha == 0.001) {
                return JB <= AdjustedJarqueBeraCriticalValues[2][1];
            }
            if (alpha == 0.005) {
                return JB <= AdjustedJarqueBeraCriticalValues[3][1];
            }
            if (alpha == 0.01) {
                return JB <= AdjustedJarqueBeraCriticalValues[4][1];
            }
            if (alpha == 0.05) {
                return JB <= AdjustedJarqueBeraCriticalValues[5][1];
            }
            if (alpha == 0.1) {
                return JB <= AdjustedJarqueBeraCriticalValues[6][1];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 35) {
            if (alpha == 1.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[0][2];
            }
            if (alpha == 5.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[1][2];
            }
            if (alpha == 0.001) {
                return JB <= AdjustedJarqueBeraCriticalValues[2][2];
            }
            if (alpha == 0.005) {
                return JB <= AdjustedJarqueBeraCriticalValues[3][2];
            }
            if (alpha == 0.01) {
                return JB <= AdjustedJarqueBeraCriticalValues[4][2];
            }
            if (alpha == 0.05) {
                return JB <= AdjustedJarqueBeraCriticalValues[5][2];
            }
            if (alpha == 0.1) {
                return JB <= AdjustedJarqueBeraCriticalValues[6][2];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 50) {
            if (alpha == 1.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[0][3];
            }
            if (alpha == 5.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[1][3];
            }
            if (alpha == 0.001) {
                return JB <= AdjustedJarqueBeraCriticalValues[2][3];
            }
            if (alpha == 0.005) {
                return JB <= AdjustedJarqueBeraCriticalValues[3][3];
            }
            if (alpha == 0.01) {
                return JB <= AdjustedJarqueBeraCriticalValues[4][3];
            }
            if (alpha == 0.05) {
                return JB <= AdjustedJarqueBeraCriticalValues[5][3];
            }
            if (alpha == 0.1) {
                return JB <= AdjustedJarqueBeraCriticalValues[6][3];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 75) {
            if (alpha == 1.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[0][4];
            }
            if (alpha == 5.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[1][4];
            }
            if (alpha == 0.001) {
                return JB <= AdjustedJarqueBeraCriticalValues[2][4];
            }
            if (alpha == 0.005) {
                return JB <= AdjustedJarqueBeraCriticalValues[3][4];
            }
            if (alpha == 0.01) {
                return JB <= AdjustedJarqueBeraCriticalValues[4][4];
            }
            if (alpha == 0.05) {
                return JB <= AdjustedJarqueBeraCriticalValues[5][4];
            }
            if (alpha == 0.1) {
                return JB <= AdjustedJarqueBeraCriticalValues[6][4];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 100) {
            if (alpha == 1.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[0][5];
            }
            if (alpha == 5.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[1][5];
            }
            if (alpha == 0.001) {
                return JB <= AdjustedJarqueBeraCriticalValues[2][5];
            }
            if (alpha == 0.005) {
                return JB <= AdjustedJarqueBeraCriticalValues[3][5];
            }
            if (alpha == 0.01) {
                return JB <= AdjustedJarqueBeraCriticalValues[4][5];
            }
            if (alpha == 0.05) {
                return JB <= AdjustedJarqueBeraCriticalValues[5][5];
            }
            if (alpha == 0.1) {
                return JB <= AdjustedJarqueBeraCriticalValues[6][5];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 150) {
            if (alpha == 1.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[0][6];
            }
            if (alpha == 5.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[1][6];
            }
            if (alpha == 0.001) {
                return JB <= AdjustedJarqueBeraCriticalValues[2][6];
            }
            if (alpha == 0.005) {
                return JB <= AdjustedJarqueBeraCriticalValues[3][6];
            }
            if (alpha == 0.01) {
                return JB <= AdjustedJarqueBeraCriticalValues[4][6];
            }
            if (alpha == 0.05) {
                return JB <= AdjustedJarqueBeraCriticalValues[5][6];
            }
            if (alpha == 0.1) {
                return JB <= AdjustedJarqueBeraCriticalValues[6][6];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 200) {
            if (alpha == 1.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[0][7];
            }
            if (alpha == 5.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[1][7];
            }
            if (alpha == 0.001) {
                return JB <= AdjustedJarqueBeraCriticalValues[2][7];
            }
            if (alpha == 0.005) {
                return JB <= AdjustedJarqueBeraCriticalValues[3][7];
            }
            if (alpha == 0.01) {
                return JB <= AdjustedJarqueBeraCriticalValues[4][7];
            }
            if (alpha == 0.05) {
                return JB <= AdjustedJarqueBeraCriticalValues[5][7];
            }
            if (alpha == 0.1) {
                return JB <= AdjustedJarqueBeraCriticalValues[6][7];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 300) {
            if (alpha == 1.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[0][8];
            }
            if (alpha == 5.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[1][8];
            }
            if (alpha == 0.001) {
                return JB <= AdjustedJarqueBeraCriticalValues[2][8];
            }
            if (alpha == 0.005) {
                return JB <= AdjustedJarqueBeraCriticalValues[3][8];
            }
            if (alpha == 0.01) {
                return JB <= AdjustedJarqueBeraCriticalValues[4][8];
            }
            if (alpha == 0.05) {
                return JB <= AdjustedJarqueBeraCriticalValues[5][8];
            }
            if (alpha == 0.1) {
                return JB <= AdjustedJarqueBeraCriticalValues[6][8];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 500) {
            if (alpha == 1.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[0][9];
            }
            if (alpha == 5.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[1][9];
            }
            if (alpha == 0.001) {
                return JB <= AdjustedJarqueBeraCriticalValues[2][9];
            }
            if (alpha == 0.005) {
                return JB <= AdjustedJarqueBeraCriticalValues[3][9];
            }
            if (alpha == 0.01) {
                return JB <= AdjustedJarqueBeraCriticalValues[4][9];
            }
            if (alpha == 0.05) {
                return JB <= AdjustedJarqueBeraCriticalValues[5][9];
            }
            if (alpha == 0.1) {
                return JB <= AdjustedJarqueBeraCriticalValues[6][9];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 800) {
            if (alpha == 1.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[0][10];
            }
            if (alpha == 5.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[1][10];
            }
            if (alpha == 0.001) {
                return JB <= AdjustedJarqueBeraCriticalValues[2][10];
            }
            if (alpha == 0.005) {
                return JB <= AdjustedJarqueBeraCriticalValues[3][10];
            }
            if (alpha == 0.01) {
                return JB <= AdjustedJarqueBeraCriticalValues[4][10];
            }
            if (alpha == 0.05) {
                return JB <= AdjustedJarqueBeraCriticalValues[5][10];
            }
            if (alpha == 0.1) {
                return JB <= AdjustedJarqueBeraCriticalValues[6][10];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 1000) {
            if (alpha == 1.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[0][11];
            }
            if (alpha == 5.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[1][11];
            }
            if (alpha == 0.001) {
                return JB <= AdjustedJarqueBeraCriticalValues[2][11];
            }
            if (alpha == 0.005) {
                return JB <= AdjustedJarqueBeraCriticalValues[3][11];
            }
            if (alpha == 0.01) {
                return JB <= AdjustedJarqueBeraCriticalValues[4][11];
            }
            if (alpha == 0.05) {
                return JB <= AdjustedJarqueBeraCriticalValues[5][11];
            }
            if (alpha == 0.1) {
                return JB <= AdjustedJarqueBeraCriticalValues[6][11];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 1600) {
            if (alpha == 1.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[0][12];
            }
            if (alpha == 5.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[1][12];
            }
            if (alpha == 0.001) {
                return JB <= AdjustedJarqueBeraCriticalValues[2][12];
            }
            if (alpha == 0.005) {
                return JB <= AdjustedJarqueBeraCriticalValues[3][12];
            }
            if (alpha == 0.01) {
                return JB <= AdjustedJarqueBeraCriticalValues[4][12];
            }
            if (alpha == 0.05) {
                return JB <= AdjustedJarqueBeraCriticalValues[5][12];
            }
            if (alpha == 0.1) {
                return JB <= AdjustedJarqueBeraCriticalValues[6][12];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 2400) {
            if (alpha == 1.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[0][13];
            }
            if (alpha == 5.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[1][13];
            }
            if (alpha == 0.001) {
                return JB <= AdjustedJarqueBeraCriticalValues[2][13];
            }
            if (alpha == 0.005) {
                return JB <= AdjustedJarqueBeraCriticalValues[3][13];
            }
            if (alpha == 0.01) {
                return JB <= AdjustedJarqueBeraCriticalValues[4][13];
            }
            if (alpha == 0.05) {
                return JB <= AdjustedJarqueBeraCriticalValues[5][13];
            }
            if (alpha == 0.1) {
                return JB <= AdjustedJarqueBeraCriticalValues[6][13];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 10000) {
            if (alpha == 1.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[0][14];
            }
            if (alpha == 5.0E-4) {
                return JB <= AdjustedJarqueBeraCriticalValues[1][14];
            }
            if (alpha == 0.001) {
                return JB <= AdjustedJarqueBeraCriticalValues[2][14];
            }
            if (alpha == 0.005) {
                return JB <= AdjustedJarqueBeraCriticalValues[3][14];
            }
            if (alpha == 0.01) {
                return JB <= AdjustedJarqueBeraCriticalValues[4][14];
            }
            if (alpha == 0.05) {
                return JB <= AdjustedJarqueBeraCriticalValues[5][14];
            }
            if (alpha == 0.1) {
                return JB <= AdjustedJarqueBeraCriticalValues[6][14];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        throw new IllegalArgumentException("N value not supported. Must be less or equal than 100.");
    }

    public static boolean Lilliefors(double[] values, double alpha) {
        return Normality.Lilliefors(values) <= Normality.LillieforsCriticalValues(values.length, alpha);
    }

    public static double Lilliefors(double[] values) {
        double[] sorted = (double[])values.clone();
        Arrays.sort(sorted);
        CenterReduce.Compute(sorted);
        double pvalue = 0.0;
        for (int v = 0; v < values.length; ++v) {
            double v2;
            double F = Normality.NormalCumulatedProbability(sorted[v]);
            double v1 = Math.abs(F - (double)v / (double)values.length);
            double max = Math.max(v1, v2 = Math.abs(F - (double)(v + 1) / (double)values.length));
            if (!(pvalue < max)) continue;
            pvalue = max;
        }
        sorted = null;
        return pvalue;
    }

    public static boolean Lilliefors(float[] values, double alpha) {
        return Normality.Lilliefors(values) <= Normality.LillieforsCriticalValues(values.length, alpha);
    }

    public static double Lilliefors(float[] values) {
        float[] sorted = (float[])values.clone();
        Arrays.sort(sorted);
        CenterReduce.Compute(sorted);
        double pvalue = 0.0;
        for (int v = 0; v < values.length; ++v) {
            double v2;
            double F = Normality.NormalCumulatedProbability(sorted[v]);
            double v1 = Math.abs(F - (double)v / (double)values.length);
            double max = Math.max(v1, v2 = Math.abs(F - (double)(v + 1) / (double)values.length));
            if (!(pvalue < max)) continue;
            pvalue = max;
        }
        sorted = null;
        return pvalue;
    }

    public static boolean Lilliefors(int[] values, double alpha) {
        return Normality.Lilliefors(values) <= Normality.LillieforsCriticalValues(values.length, alpha);
    }

    public static double Lilliefors(int[] values) {
        int[] sorted = (int[])values.clone();
        Arrays.sort(sorted);
        double[] cr = new double[sorted.length];
        CenterReduce.Compute(sorted, cr);
        double pvalue = 0.0;
        for (int v = 0; v < values.length; ++v) {
            double v2;
            double F = Normality.NormalCumulatedProbability(cr[v]);
            double v1 = Math.abs(F - (double)v / (double)values.length);
            double max = Math.max(v1, v2 = Math.abs(F - (double)(v + 1) / (double)values.length));
            if (!(pvalue < max)) continue;
            pvalue = max;
        }
        sorted = null;
        cr = null;
        return pvalue;
    }

    public static double LillieforsCriticalValues(int N, double alpha) {
        if (N < 4) {
            throw new IllegalArgumentException("N < 4");
        }
        if (N <= 50) {
            if (alpha == 0.2) {
                return LillieforsCriticalValues[N - 4][0];
            }
            if (alpha == 0.15) {
                return LillieforsCriticalValues[N - 4][1];
            }
            if (alpha == 0.1) {
                return LillieforsCriticalValues[N - 4][2];
            }
            if (alpha == 0.05) {
                return LillieforsCriticalValues[N - 4][3];
            }
            if (alpha == 0.01) {
                return LillieforsCriticalValues[N - 4][4];
            }
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        double fN = (0.83 + (double)N) / Math.sqrt(N) - 0.01;
        if (alpha == 0.2) {
            return 0.741 / fN;
        }
        if (alpha == 0.15) {
            return 0.775 / fN;
        }
        if (alpha == 0.1) {
            return 0.819 / fN;
        }
        if (alpha == 0.05) {
            return 0.895 / fN;
        }
        if (alpha == 0.01) {
            return 1.035 / fN;
        }
        throw new IllegalArgumentException("Alpha value not supported.");
    }

    public static boolean AgostinoPearsonOmnibus(double[] values, double alpha) {
        return Normality.AgostinoSuccess(Normality.AgostinoPearsonOmnibus(values), values.length, alpha);
    }

    public static double AgostinoPearsonOmnibus(double[] values) {
        int N = values.length;
        ArrayFeatures AF = new ArrayFeatures();
        AF.Moments(values);
        double average = AF.Average(values);
        double x2 = 0.0;
        double x3 = 0.0;
        double x4 = 0.0;
        for (int i2 = 0; i2 < N; ++i2) {
            double v = values[i2] - average;
            double v2 = v * v;
            x2 += v2;
            x3 += v2 * v;
            x4 += v2 * v2;
        }
        x4 /= (double)N;
        double g1 = (x3 /= (double)N) / Math.pow(x2 /= (double)N, 1.5);
        double A = g1 * Math.sqrt((double)((N + 1) * (N + 3)) / (double)(6 * (N - 2)));
        double B = 3.0 * ((double)(N * N + 27 * N - 70) * (double)(N + 1) / (double)((N - 2) * (N + 5))) * ((double)(N + 3) / (double)((N + 7) * (N + 9)));
        double C = Math.sqrt(2.0 * (B - 1.0)) - 1.0;
        double D = Math.sqrt(C);
        double E = 1.0 / Math.sqrt(Math.log(D));
        double F = A / Math.sqrt(2.0 / (C - 1.0));
        double z1 = E * Math.log(F + Math.sqrt(F * F + 1.0));
        double b2 = x4 / (x2 * x2);
        double Eb2 = 3.0 * (double)(N - 1) / (double)(N + 1);
        double varb2 = 24.0 * (double)N / (double)((N + 1) * (N + 1)) * (double)((N - 2) * (N - 3)) / (double)((N + 3) * (N + 5));
        double x = (b2 - Eb2) / Math.sqrt(varb2);
        double beta1b2 = 6.0 * ((double)(N * N - 5 * N + 2) / (double)((N + 7) * (N + 9))) * Math.sqrt(6.0 * (double)((N + 3) * (N + 5)) / (double)(N * (N - 2) * (N - 3)));
        A = 6.0 + 8.0 / beta1b2 * (2.0 / beta1b2 + Math.sqrt(1.0 + 4.0 / (beta1b2 * beta1b2)));
        double z2 = (1.0 - 2.0 / (9.0 * A) - Math.pow((1.0 - 2.0 / A) / (1.0 + x * Math.sqrt(2.0 / (A - 4.0))), 0.3333333333333333)) / Math.sqrt(2.0 / (9.0 * A));
        return z1 * z1 + z2 * z2;
    }

    public static boolean AgostinoPearsonOmnibus(float[] values, double alpha) {
        return Normality.AgostinoSuccess(Normality.AgostinoPearsonOmnibus(values), values.length, alpha);
    }

    public static double AgostinoPearsonOmnibus(float[] values) {
        int N = values.length;
        ArrayFeatures AF = new ArrayFeatures();
        AF.Moments(values);
        double average = AF.Average(values);
        double x2 = 0.0;
        double x3 = 0.0;
        double x4 = 0.0;
        for (int i2 = 0; i2 < N; ++i2) {
            double v = (double)values[i2] - average;
            double v2 = v * v;
            x2 += v2;
            x3 += v2 * v;
            x4 += v2 * v2;
        }
        x4 /= (double)N;
        double g1 = (x3 /= (double)N) / Math.pow(x2 /= (double)N, 1.5);
        double A = g1 * Math.sqrt((double)((N + 1) * (N + 3)) / (double)(6 * (N - 2)));
        double B = 3.0 * ((double)(N * N + 27 * N - 70) * (double)(N + 1) / (double)((N - 2) * (N + 5))) * ((double)(N + 3) / (double)((N + 7) * (N + 9)));
        double C = Math.sqrt(2.0 * (B - 1.0)) - 1.0;
        double D = Math.sqrt(C);
        double E = 1.0 / Math.sqrt(Math.log(D));
        double F = A / Math.sqrt(2.0 / (C - 1.0));
        double z1 = E * Math.log(F + Math.sqrt(F * F + 1.0));
        double b2 = x4 / (x2 * x2);
        double Eb2 = 3.0 * (double)(N - 1) / (double)(N + 1);
        double varb2 = 24.0 * (double)N / (double)((N + 1) * (N + 1)) * (double)((N - 2) * (N - 3)) / (double)((N + 3) * (N + 5));
        double x = (b2 - Eb2) / Math.sqrt(varb2);
        double beta1b2 = 6.0 * ((double)(N * N - 5 * N + 2) / (double)((N + 7) * (N + 9))) * Math.sqrt(6.0 * (double)((N + 3) * (N + 5)) / (double)(N * (N - 2) * (N - 3)));
        A = 6.0 + 8.0 / beta1b2 * (2.0 / beta1b2 + Math.sqrt(1.0 + 4.0 / (beta1b2 * beta1b2)));
        double z2 = (1.0 - 2.0 / (9.0 * A) - Math.pow((1.0 - 2.0 / A) / (1.0 + x * Math.sqrt(2.0 / (A - 4.0))), 0.3333333333333333)) / Math.sqrt(2.0 / (9.0 * A));
        return z1 * z1 + z2 * z2;
    }

    public static boolean AgostinoPearsonOmnibus(int[] values, double alpha) {
        return Normality.AgostinoSuccess(Normality.AgostinoPearsonOmnibus(values), values.length, alpha);
    }

    public static double AgostinoPearsonOmnibus(int[] values) {
        int N = values.length;
        ArrayFeatures AF = new ArrayFeatures();
        AF.Moments(values);
        double average = AF.Average(values);
        double x2 = 0.0;
        double x3 = 0.0;
        double x4 = 0.0;
        for (int i2 = 0; i2 < N; ++i2) {
            double v = (double)values[i2] - average;
            double v2 = v * v;
            x2 += v2;
            x3 += v2 * v;
            x4 += v2 * v2;
        }
        x4 /= (double)N;
        double g1 = (x3 /= (double)N) / Math.pow(x2 /= (double)N, 1.5);
        double A = g1 * Math.sqrt((double)((N + 1) * (N + 3)) / (double)(6 * (N - 2)));
        double B = 3.0 * ((double)(N * N + 27 * N - 70) * (double)(N + 1) / (double)((N - 2) * (N + 5))) * ((double)(N + 3) / (double)((N + 7) * (N + 9)));
        double C = Math.sqrt(2.0 * (B - 1.0)) - 1.0;
        double D = Math.sqrt(C);
        double E = 1.0 / Math.sqrt(Math.log(D));
        double F = A / Math.sqrt(2.0 / (C - 1.0));
        double z1 = E * Math.log(F + Math.sqrt(F * F + 1.0));
        double b2 = x4 / (x2 * x2);
        double Eb2 = 3.0 * (double)(N - 1) / (double)(N + 1);
        double varb2 = 24.0 * (double)N / (double)((N + 1) * (N + 1)) * (double)((N - 2) * (N - 3)) / (double)((N + 3) * (N + 5));
        double x = (b2 - Eb2) / Math.sqrt(varb2);
        double beta1b2 = 6.0 * ((double)(N * N - 5 * N + 2) / (double)((N + 7) * (N + 9))) * Math.sqrt(6.0 * (double)((N + 3) * (N + 5)) / (double)(N * (N - 2) * (N - 3)));
        A = 6.0 + 8.0 / beta1b2 * (2.0 / beta1b2 + Math.sqrt(1.0 + 4.0 / (beta1b2 * beta1b2)));
        double z2 = (1.0 - 2.0 / (9.0 * A) - Math.pow((1.0 - 2.0 / A) / (1.0 + x * Math.sqrt(2.0 / (A - 4.0))), 0.3333333333333333)) / Math.sqrt(2.0 / (9.0 * A));
        return z1 * z1 + z2 * z2;
    }

    private static boolean AgostinoSuccess(double Z, int N, double alpha) {
        if (alpha != 0.05) {
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 20) {
            return Z <= 6.373;
        }
        if (N <= 50) {
            return Z <= 6.339;
        }
        if (N <= 100) {
            return Z <= 6.271;
        }
        if (N <= 250) {
            return Z <= 6.129;
        }
        if (N <= 500) {
            return Z <= 6.063;
        }
        return Z <= 6.038;
    }

    public static boolean AndersonDarling(double[] values, double alpha) {
        return Normality.AndersonDarlingSuccess(Normality.AndersonDarling(values), values.length, alpha);
    }

    public static double AndersonDarling(double[] values) {
        int N = values.length;
        double S = 0.0;
        double[] clone = (double[])values.clone();
        Arrays.sort(clone);
        CenterReduce.Compute(clone);
        for (int v = 0; v < N; ++v) {
            S += (double)((v + 1 << 1) - 1) / (double)N * (Math.log(Normality.NormalCumulatedProbability(clone[v])) + Math.log(Normality.NormalCumulatedProbability(clone[N - 1 - v])));
        }
        clone = null;
        return ((double)(-N) - S) * (1.0 + 4.0 / (double)N - 25.0 / (double)(N * N));
    }

    public static boolean AndersonDarling(float[] values, double alpha) {
        return Normality.AndersonDarlingSuccess(Normality.AndersonDarling(values), values.length, alpha);
    }

    public static double AndersonDarling(float[] values) {
        int N = values.length;
        double S = 0.0;
        float[] clone = (float[])values.clone();
        Arrays.sort(clone);
        CenterReduce.Compute(clone);
        for (int v = 0; v < N; ++v) {
            S += (double)((v + 1 << 1) - 1) / (double)N * (Math.log(Normality.NormalCumulatedProbability(clone[v])) + Math.log(Normality.NormalCumulatedProbability(clone[N - 1 - v])));
        }
        clone = null;
        return ((double)(-N) - S) * (1.0 + 4.0 / (double)N - 25.0 / (double)(N * N));
    }

    public static boolean AndersonDarling(int[] values, double alpha) {
        return Normality.AndersonDarlingSuccess(Normality.AndersonDarling(values), values.length, alpha);
    }

    public static double AndersonDarling(int[] values) {
        int N = values.length;
        double S = 0.0;
        int[] clone = (int[])values.clone();
        Arrays.sort(clone);
        double[] array = new double[clone.length];
        CenterReduce.Compute(clone, array);
        for (int v = 0; v < N; ++v) {
            S += (double)((v + 1 << 1) - 1) / (double)N * (Math.log(Normality.NormalCumulatedProbability(array[v])) + Math.log(Normality.NormalCumulatedProbability(array[N - 1 - v])));
        }
        clone = null;
        return ((double)(-N) - S) * (1.0 + 4.0 / (double)N - 25.0 / (double)(N * N));
    }

    private static boolean AndersonDarlingSuccess(double A2, int N, double alpha) {
        int column;
        if (alpha == 0.15) {
            column = 0;
        } else if (alpha == 0.1) {
            column = 1;
        } else if (alpha == 0.05) {
            column = 2;
        } else if (alpha == 0.025) {
            column = 3;
        } else if (alpha == 0.01) {
            column = 4;
        } else {
            throw new IllegalArgumentException("Alpha value not supported");
        }
        if (5 <= N && N <= 10) {
            return A2 <= AndersonDarlingCriticalValues[0][column];
        }
        if (N <= 20) {
            return A2 <= AndersonDarlingCriticalValues[1][column];
        }
        if (N <= 50) {
            return A2 <= AndersonDarlingCriticalValues[2][column];
        }
        if (N <= 100) {
            return A2 <= AndersonDarlingCriticalValues[3][column];
        }
        return A2 <= AndersonDarlingCriticalValues[4][column];
    }

    public static boolean ShapiroWilk(double[] values, double alpha) {
        return Normality.ShapiroWilkSuccess(Normality.ShapiroWilk(values), values.length, alpha);
    }

    public static double ShapiroWilk(double[] values) {
        double s;
        double m;
        double xx;
        int i2;
        int N = values.length;
        if (N < 3 || 5000 < N) {
            throw new IllegalArgumentException("N < 3 || 5000 < N");
        }
        double[] clone = (double[])values.clone();
        Arrays.sort(clone);
        int nn2 = N >> 1;
        double[] a = new double[nn2 + 1];
        double small = 1.0E-19;
        double[] g = new double[]{-2.273, 0.459};
        double[] c1 = new double[]{0.0, 0.221157, -0.147981, -2.07119, 4.434685, -2.706056};
        double[] c2 = new double[]{0.0, 0.042981, -0.293762, -1.752461, 5.682633, -3.582633};
        double[] c3 = new double[]{0.544, -0.39978, 0.025054, -6.714E-4};
        double[] c4 = new double[]{1.3822, -0.77857, 0.062767, -0.0020322};
        double[] c5 = new double[]{-1.5861, -0.31082, -0.083751, 0.0038915};
        double[] c6 = new double[]{-0.4803, -0.082676, 0.0030302};
        double pw = 1.0;
        double an = N;
        if (N == 3) {
            a[1] = 0.70710678;
        } else {
            double fac;
            int i1;
            double an25 = an + 0.25;
            double summ2 = 0.0;
            for (i2 = 1; i2 <= nn2; ++i2) {
                a[i2] = Normality.ShapiroWilkNormalQuantile(((double)i2 - 0.375) / an25, 0.0, 1.0);
                summ2 += a[i2] * a[i2];
            }
            double ssumm2 = Math.sqrt(summ2 *= 2.0);
            double rsn = 1.0 / Math.sqrt(an);
            double a1 = Normality.ShapiroWilkPolynomial(c1, 6, rsn) - a[1] / ssumm2;
            if (5 < N) {
                i1 = 3;
                double a2 = -a[2] / ssumm2 + Normality.ShapiroWilkPolynomial(c2, 6, rsn);
                fac = Math.sqrt((summ2 - 2.0 * a[1] * a[1] - 2.0 * a[2] * a[2]) / (1.0 - 2.0 * a1 * a1 - 2.0 * a2 * a2));
                a[2] = a2;
            } else {
                i1 = 2;
                fac = Math.sqrt((summ2 - 2.0 * a[1] * a[1]) / (1.0 - 2.0 * a1 * a1));
            }
            a[1] = a1;
            i2 = i1;
            while (i2 <= nn2) {
                int n = i2++;
                a[n] = a[n] / -fac;
            }
        }
        double range = clone[N - 1] - clone[0];
        if (range < small) {
            return Double.MAX_VALUE;
        }
        double sx = xx = clone[0] / range;
        double sa = -a[1];
        i2 = 1;
        int j = N - 1;
        while (i2 < N) {
            double xi = clone[i2] / range;
            if (xx - xi > small) {
                throw new IllegalArgumentException("xx - xi > small");
            }
            sx += xi;
            if (++i2 != j) {
                sa += (double)Math.signum(i2 - j) * a[Math.min(i2, j)];
            }
            xx = xi;
            --j;
        }
        sa /= (double)N;
        sx /= (double)N;
        double sax = 0.0;
        double ssx = 0.0;
        double ssa = 0.0;
        i2 = 0;
        j = N - 1;
        while (i2 < N) {
            double asa = i2 != j ? (double)Math.signum(i2 - j) * a[1 + Math.min(i2, j)] - sa : -sa;
            double xsx = clone[i2] / range - sx;
            ssa += asa * asa;
            ssx += xsx * xsx;
            sax += asa * xsx;
            ++i2;
            --j;
        }
        double ssassx = Math.sqrt(ssa * ssx);
        double w1 = (ssassx - sax) * (ssassx + sax) / (ssa * ssx);
        double w = 1.0 - w1;
        if (N == 3) {
            double pi6 = 1.90985931710274;
            double stqr = 1.0471975511966;
            pw = pi6 * Math.asin(Math.sqrt(w)) - stqr;
            if (pw < 0.0) {
                pw = 0.0;
            }
            return pw;
        }
        double y = Math.log(w1);
        xx = Math.log(an);
        if (N <= 11) {
            double gamma = Normality.ShapiroWilkPolynomial(g, 2, an);
            if (gamma <= y) {
                pw = 1.0E-99;
                return pw;
            }
            y = -Math.log(gamma - y);
            m = Normality.ShapiroWilkPolynomial(c3, 4, an);
            s = Math.exp(Normality.ShapiroWilkPolynomial(c4, 4, an));
        } else {
            m = Normality.ShapiroWilkPolynomial(c5, 4, xx);
            s = Math.exp(Normality.ShapiroWilkPolynomial(c6, 3, xx));
        }
        clone = null;
        return Normality.ShapiroWilkGaussCdf((y - m) / s);
    }

    private static double ShapiroWilkPolynomial(double[] cc, int order, double x) {
        double ret_val = cc[0];
        if (order > 1) {
            double p = x * cc[order - 1];
            for (int j = order - 2; j > 0; --j) {
                p = (p + cc[j]) * x;
            }
            ret_val += p;
        }
        return ret_val;
    }

    public static double ShapiroWilkNormalQuantile(double p, double mu, double sigma) {
        if (sigma < 0.0) {
            throw new IllegalArgumentException("sigma < 0.0");
        }
        if (sigma == 0.0) {
            return mu;
        }
        double r = 0.0;
        double val = 0.0;
        double q = p - 0.5;
        if (0.075 <= p && p <= 0.925) {
            r = 0.180625 - q * q;
            val = q * (((((((r * 2509.0809287301227 + 33430.57558358813) * r + 67265.7709270087) * r + 45921.95393154987) * r + 13731.69376550946) * r + 1971.5909503065513) * r + 133.14166789178438) * r + 3.3871328727963665) / (((((((r * 5226.495278852854 + 28729.085735721943) * r + 39307.89580009271) * r + 21213.794301586597) * r + 5394.196021424751) * r + 687.1870074920579) * r + 42.31333070160091) * r + 1.0);
        } else {
            r = 0.0 < q ? 1.0 - p : p;
            r = Math.sqrt(-Math.log(r));
            val = r <= 5.0 ? ((((((((r += -1.6) * 7.745450142783414E-4 + 0.022723844989269184) * r + 0.2417807251774506) * r + 1.2704582524523684) * r + 3.6478483247632045) * r + 5.769497221460691) * r + 4.630337846156546) * r + 1.4234371107496835) / (((((((r * 1.0507500716444169E-9 + 5.475938084995345E-4) * r + 0.015198666563616457) * r + 0.14810397642748008) * r + 0.6897673349851) * r + 1.6763848301838038) * r + 2.053191626637759) * r + 1.0) : ((((((((r += -5.0) * 2.0103343992922881E-7 + 2.7115555687434876E-5) * r + 0.0012426609473880784) * r + 0.026532189526576124) * r + 0.29656057182850487) * r + 1.7848265399172913) * r + 5.463784911164114) * r + 6.657904643501103) / (((((((r * 2.0442631033899397E-15 + 1.421511758316446E-7) * r + 1.8463183175100548E-5) * r + 7.868691311456133E-4) * r + 0.014875361290850615) * r + 0.1369298809227358) * r + 0.599832206555888) * r + 1.0);
            if (q < 0.0) {
                val = -val;
            }
        }
        return mu + sigma * val;
    }

    public static double ShapiroWilkGaussCdf(double z) {
        double p;
        if (z == 0.0) {
            p = 0.0;
        } else {
            double y = Math.abs(z) / 2.0;
            if (3.0 <= y) {
                p = 1.0;
            } else if (y < 1.0) {
                double w = y * y;
                p = ((((((((1.24818987E-4 * w - 0.001075204047) * w + 0.005198775019) * w - 0.019198292004) * w + 0.059054035642) * w - 0.151968751364) * w + 0.319152932694) * w - 0.5319230073) * w + 0.797884560593) * y * 2.0;
            } else {
                p = (((((((((((((-4.5255659E-5 * (y -= 2.0) + 1.5252929E-4) * y - 1.9538132E-5) * y - 6.76904986E-4) * y + 0.001390604284) * y - 7.9462082E-4) * y - 0.002034254874) * y + 0.006549791214) * y - 0.010557625006) * y + 0.011630447319) * y - 0.009279453341) * y + 0.005353579108) * y - 0.002141268741) * y + 5.35310849E-4) * y + 0.999936657524;
            }
        }
        if (0.0 < z) {
            return (p + 1.0) / 2.0;
        }
        return (1.0 - p) / 2.0;
    }

    private static boolean ShapiroWilkSuccess(double W, int N, double alpha) {
        int column = 0;
        if (alpha == 0.01) {
            column = 0;
        } else if (alpha == 0.05) {
            column = 1;
        } else {
            throw new IllegalArgumentException("Alpha value not supported.");
        }
        if (N <= 20) {
            return W <= ShapiroWilkCriticalValues[N - 4][column];
        }
        if (N <= 25) {
            return W <= ShapiroWilkCriticalValues[17][column];
        }
        if (N <= 30) {
            return W <= ShapiroWilkCriticalValues[18][column];
        }
        if (N <= 35) {
            return W <= ShapiroWilkCriticalValues[19][column];
        }
        if (N <= 40) {
            return W <= ShapiroWilkCriticalValues[20][column];
        }
        if (N <= 45) {
            return W <= ShapiroWilkCriticalValues[21][column];
        }
        return W <= ShapiroWilkCriticalValues[22][column];
    }

    public static double NormalCumulatedProbability(double value) {
        if (value < 0.0) {
            return 1.0 - Normality.NormalLawProbability(Math.abs(value));
        }
        return Normality.NormalLawProbability(value);
    }

    public static double NormalLawProbability(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("Positive of null value required.");
        }
        int v = (int)(100.0 * value + 0.5);
        if (410 <= v) {
            return 1.0;
        }
        int centaine = v / 100;
        int reste = v - centaine * 100;
        int decimale = reste / 10;
        int unite = reste - decimale * 10;
        return Normal[unite][10 * centaine + decimale];
    }
}

