/*
 * Decompiled with CFR 0.152.
 */
package mathematics.statistics;

import arrayTiTi.ArrayStatistics;
import filesAndFolders.fichiersTabules.FichierTabule;

public class Correlations {
    public static double[][] Pearson(FichierTabule fichier) {
        int x;
        int height = fichier.Height() - fichier.getNbExcluded();
        int width = 0;
        for (x = 0; x < fichier.Width(); ++x) {
            if (fichier.isExcludedColumn(x) || fichier.ColumnType(x) != 1 && fichier.ColumnType(x) != 0) continue;
            ++width;
        }
        double[][] Corre = new double[width][width];
        for (x = 0; x < width; ++x) {
            Corre[x][x] = 1.0;
        }
        int[] icol1 = height == fichier.Height() ? null : new int[height];
        int[] icol2 = height == fichier.Height() ? null : new int[height];
        double[] dcol1 = height == fichier.Height() ? null : new double[height];
        double[] dcol2 = height == fichier.Height() ? null : new double[height];
        int nb1 = 0;
        for (x = 0; x < fichier.Width(); ++x) {
            int y;
            int nb;
            if (fichier.isExcludedColumn(x) || fichier.ColumnType(x) != 1 && fichier.ColumnType(x) != 0) continue;
            boolean[] excluded = fichier.getExcluded();
            switch (fichier.ColumnType(x)) {
                case 1: {
                    if (height == fichier.Height()) {
                        dcol1 = fichier.getColumnDouble(x);
                        break;
                    }
                    nb = 0;
                    for (y = 0; y < fichier.Height(); ++y) {
                        if (excluded[y]) continue;
                        dcol1[nb++] = fichier.getValueDouble(y, x);
                    }
                    break;
                }
                case 0: {
                    if (height == fichier.Height()) {
                        icol1 = fichier.getColumnInt(x);
                        break;
                    }
                    nb = 0;
                    for (y = 0; y < fichier.Height(); ++y) {
                        if (excluded[y]) continue;
                        icol1[nb++] = fichier.getValueInt(y, x);
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Must not occur.");
                }
            }
            int nb2 = nb1 + 1;
            for (int i2 = x + 1; i2 < fichier.Width(); ++i2) {
                if (fichier.isExcludedColumn(i2) || fichier.ColumnType(i2) != 1 && fichier.ColumnType(i2) != 0) continue;
                switch (fichier.ColumnType(i2)) {
                    case 1: {
                        if (height == fichier.Height()) {
                            dcol2 = fichier.getColumnDouble(i2);
                            break;
                        }
                        nb = 0;
                        for (y = 0; y < fichier.Height(); ++y) {
                            if (excluded[y]) continue;
                            dcol2[nb++] = fichier.getValueDouble(y, i2);
                        }
                        break;
                    }
                    case 0: {
                        nb = 0;
                        if (height == fichier.Height()) {
                            icol2 = fichier.getColumnInt(i2);
                            break;
                        }
                        nb = 0;
                        for (y = 0; y < fichier.Height(); ++y) {
                            if (excluded[y]) continue;
                            icol2[nb++] = fichier.getValueInt(y, i2);
                        }
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Must not occur.");
                    }
                }
                if (fichier.ColumnType(x) == 1) {
                    if (fichier.ColumnType(i2) == 1) {
                        double d = ArrayStatistics.Correlation(dcol1, dcol2);
                        Corre[nb2][nb1] = d;
                        Corre[nb1][nb2] = d;
                    } else {
                        double d = ArrayStatistics.Correlation(icol2, dcol1);
                        Corre[nb2][nb1] = d;
                        Corre[nb1][nb2] = d;
                    }
                } else if (fichier.ColumnType(i2) == 1) {
                    double d = ArrayStatistics.Correlation(icol1, dcol2);
                    Corre[nb2][nb1] = d;
                    Corre[nb1][nb2] = d;
                } else {
                    double d = ArrayStatistics.Correlation(icol1, icol2);
                    Corre[nb2][nb1] = d;
                    Corre[nb1][nb2] = d;
                }
                ++nb2;
            }
            ++nb1;
        }
        icol2 = null;
        icol1 = null;
        dcol2 = null;
        dcol1 = null;
        return Corre;
    }
}

