/*
 * Decompiled with CFR 0.152.
 */
package mathematics.statistics;

import Jama.Matrix;
import dv.DV;
import filesAndFolders.fichiersTabules.FichierTabule;
import java.awt.image.BufferedImage;

public class CorrelationMatrix {
    protected Matrix Correlation = null;
    protected double[] Averages = null;
    protected double[] StandardDeviation = null;

    public Matrix Compute(FichierTabule F) {
        int y;
        int x;
        int hauteur = F.Height();
        int largeur = F.Width();
        int nbc = 0;
        for (x = 0; x < largeur; ++x) {
            if (!F.isExcludedColumn(x) && F.ColumnType(x) != 0 && F.ColumnType(x) != 1) {
                throw new Error("Toutes les colonnes valides (non exclues) doivent etre de type Int ou Double.");
            }
            ++nbc;
        }
        this.Averages = null;
        this.Averages = new double[nbc];
        this.StandardDeviation = null;
        this.StandardDeviation = new double[nbc];
        Matrix mT = null;
        Matrix m = new Matrix(F.Height() - F.getNbExcluded(), nbc);
        double[][] Tab = m.getArray();
        int nbl = 0;
        nbc = 0;
        block5: for (x = 0; x < largeur; ++x) {
            if (F.isExcludedColumn(x)) continue;
            switch (F.ColumnType(x)) {
                case 0: {
                    this.StandardDeviation[nbc] = 0.0;
                    this.Averages[nbc] = 0.0;
                    nbl = 0;
                    for (y = 0; y < hauteur; ++y) {
                        if (F.isExcluded(y)) continue;
                        int n = nbc;
                        this.Averages[n] = this.Averages[n] + (double)F.getValueInt(y, x);
                        Tab[nbl++][nbc] = F.getValueInt(y, x);
                    }
                    ++nbc;
                    continue block5;
                }
                case 1: {
                    this.StandardDeviation[nbc] = 0.0;
                    this.Averages[nbc] = 0.0;
                    nbl = 0;
                    for (y = 0; y < hauteur; ++y) {
                        if (F.isExcluded(y)) continue;
                        int n = nbc;
                        this.Averages[n] = this.Averages[n] + F.getValueDouble(y, x);
                        Tab[nbl++][nbc] = F.getValueDouble(y, x);
                    }
                    ++nbc;
                    continue block5;
                }
                default: {
                    throw new Error("Default : " + F.ColumnType(x));
                }
            }
        }
        largeur = nbc;
        hauteur = nbl;
        x = 0;
        while (x < largeur) {
            int n = x++;
            this.Averages[n] = this.Averages[n] / (double)m.getRowDimension();
        }
        for (y = 0; y < hauteur; ++y) {
            for (x = 0; x < largeur; ++x) {
                int n = x;
                this.StandardDeviation[n] = this.StandardDeviation[n] + Math.pow(Tab[y][x] - this.Averages[x], 2.0);
            }
        }
        for (x = 0; x < largeur; ++x) {
            this.StandardDeviation[x] = Math.sqrt(this.StandardDeviation[x] / (double)m.getRowDimension());
        }
        for (y = 0; y < hauteur; ++y) {
            for (x = 0; x < largeur; ++x) {
                Tab[y][x] = (Tab[y][x] - this.Averages[x]) / this.StandardDeviation[x];
            }
        }
        mT = m.transpose();
        this.Correlation = null;
        this.Correlation = mT.times(m);
        m = null;
        mT = null;
        this.Averages = null;
        this.StandardDeviation = null;
        Tab = null;
        return this.Correlation;
    }

    public void Compute(BufferedImage Source2) {
        throw new Error("Methode non implementee");
    }

    public void Compute(DV dv) {
        throw new Error("Methode non implementee");
    }

    public Matrix getMatrix() {
        return this.Correlation;
    }

    public double[] getAverages() {
        return this.Averages;
    }

    public double[] getStandardDeviation() {
        return this.StandardDeviation;
    }
}

